/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.source;

import com.ibm.iseries.debug.PgmDescriptor;
import com.ibm.iseries.debug.event.ContextEvent;
import com.ibm.iseries.debug.event.SettingsEvent;
import com.ibm.iseries.debug.event.SourceViewEvent;
import com.ibm.iseries.debug.listener.ContextListener;
import com.ibm.iseries.debug.listener.SettingsListener;
import com.ibm.iseries.debug.manager.ContextManager;
import com.ibm.iseries.debug.manager.PgmManager;
import com.ibm.iseries.debug.memory.MemoryAddress;
import com.ibm.iseries.debug.source.SourcePane;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.DebugSource;
import com.ibm.iseries.debug.util.MRI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class DisassemblyPane
implements DebugSource,
ContextListener,
SettingsListener {
    private static final String UP_GIF = "/com/ibm/iseries/debug/dbg079.gif";
    private static final String DOWN_GIF = "/com/ibm/iseries/debug/dbg080.gif";
    private static final String HIDE_GIF = "/com/ibm/iseries/debug/dbg083.gif";
    private DebugContext m_ctxt;
    private JPanel m_panel;
    private TitleBar m_titleBar;
    private SourcePane m_srcPane;
    private boolean m_isActive;
    private boolean m_isLtoR = MRI.isLtoR();
    private ImageIcon m_upIcon = MRI.getIcon(0, "/com/ibm/iseries/debug/dbg079.gif");
    private ImageIcon m_downIcon = MRI.getIcon(0, "/com/ibm/iseries/debug/dbg080.gif");

    public DisassemblyPane(DebugContext debugContext) {
        ContextManager contextManager = (ContextManager)debugContext.getManager("ctxtmgr");
        this.m_ctxt = debugContext;
        this.m_panel = new JPanel(new BorderLayout());
        this.m_srcPane = new SourcePane(this.m_ctxt, contextManager.getAsmContextViewId(), true);
        this.m_titleBar = new TitleBar();
        this.m_srcPane.setFollowContext(true);
        contextManager.removeListener(this.m_srcPane);
        contextManager.addListener(this);
        this.m_panel.add((Component)this.m_titleBar, "North");
        this.m_panel.add((Component)this.m_srcPane.getComponent(), "Center");
        this.m_ctxt.getManager("settmgr").addListener(this);
    }

    public void clear() {
        this.m_srcPane.clearSourceCode();
        this.m_titleBar.setTitle();
    }

    public void cleanUp() {
        this.m_ctxt.getManager("ctxtmgr").removeListener(this);
        this.m_ctxt.getManager("settmgr").removeListener(this);
        if (this.m_ctxt.getActiveSource() == this) {
            this.m_ctxt.setActiveSource((DebugSource)null);
        }
        this.m_titleBar.cleanUp();
        this.m_srcPane.cleanUp();
        this.m_ctxt = null;
        this.m_panel = null;
        this.m_titleBar = null;
        this.m_srcPane = null;
        this.m_upIcon = null;
        this.m_downIcon = null;
    }

    public void lookAndFeelModifications() {
        this.m_srcPane.lookAndFeelModifications();
    }

    public void settingsChanged(int n) {
        this.m_srcPane.settingsChanged(n);
    }

    public JComponent getComponent() {
        return this.m_panel;
    }

    public JComponent getViewComponent() {
        return this.m_srcPane.getViewComponent();
    }

    public void setViewId(String string) {
        this.m_srcPane.clearSourceCode();
        this.m_srcPane.setViewId(string);
    }

    public String getViewId() {
        return this.m_srcPane.getViewId();
    }

    public String getCompletePath() {
        return "";
    }

    public void setSourceCode(SourceViewEvent sourceViewEvent) {
        this.m_srcPane.setSourceCode(sourceViewEvent);
        this.m_titleBar.setTitle(sourceViewEvent);
    }

    public int getStartLineNum() {
        return this.m_srcPane.getStartLineNum();
    }

    public int getEndLineNum() {
        return this.m_srcPane.getEndLineNum();
    }

    public int getTotalLineCount() {
        return this.m_srcPane.getTotalLineCount();
    }

    public boolean isFullSource() {
        return this.m_srcPane.getStartLineNum() == 1 && this.m_srcPane.getEndLineNum() == this.m_srcPane.getTotalLineCount();
    }

    public boolean isAssembler() {
        return this.m_srcPane.isAssembler();
    }

    public boolean containsLineNum(int n) {
        return n >= this.m_srcPane.getStartLineNum() && n <= this.m_srcPane.getEndLineNum();
    }

    public boolean isLineNumVisible(int n) {
        return this.m_srcPane.isLineNumVisible(n);
    }

    public int getCursorLineNum() {
        return this.m_srcPane.getCursorLineNum();
    }

    public void setActiveLineNum(int n) {
        this.m_srcPane.setActiveLineNum(n);
    }

    public void resetActiveLineNum() {
        this.m_srcPane.resetActiveLineNum();
    }

    public void scrollToLineNum(int n) {
        this.m_srcPane.scrollToLineNum(n);
    }

    public void scrollToLineNum(int n, boolean bl) {
        this.m_srcPane.scrollToLineNum(n, bl);
    }

    public String getSelectedText() {
        return this.m_srcPane.getSelectedText();
    }

    public int findText(String string, int n, boolean bl, boolean bl2) {
        return this.m_srcPane.findText(string, n, bl, bl2);
    }

    public int findTextInLine(String string, int n, boolean bl, boolean bl2) {
        return this.m_srcPane.findTextInLine(string, n, bl, bl2);
    }

    public void gotoLine(int n) {
        this.m_srcPane.gotoLine(n);
    }

    public void copy() {
        this.m_srcPane.copy();
    }

    public void displayAutoEvalTooltip(String string) {
        this.m_srcPane.displayAutoEvalTooltip(string);
    }

    public boolean viewHasFocus() {
        return this.m_srcPane.viewHasFocus();
    }

    public void viewRequestFocus() {
        this.m_srcPane.viewRequestFocus();
    }

    public void setActiveSource(boolean bl) {
        if (bl != this.m_isActive) {
            this.m_isActive = bl;
            this.m_titleBar.setActive(this.m_isActive);
            if (this.m_isActive) {
                this.m_srcPane.viewRequestFocus();
            }
        }
    }

    public boolean isActiveSource() {
        return this.m_isActive;
    }

    public void contextChanged(ContextEvent contextEvent) {
        this.m_srcPane.contextChanged(contextEvent);
        switch (contextEvent.getType()) {
            case 0: 
            case 2: {
                break;
            }
            case 4: {
                this.clear();
            }
        }
    }

    public void settingsChanged(SettingsEvent settingsEvent) {
        if (settingsEvent.generalChanged() || settingsEvent.colorsChanged() || settingsEvent.fontsChanged()) {
            this.m_srcPane.settingsChanged(settingsEvent.getType());
        }
    }

    protected class TitleBarButton
    extends JButton {
        public TitleBarButton(Icon icon) {
            super(null, icon);
            this.setFocusPainted(false);
            this.setMargin(new Insets(0, 0, 0, 0));
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void requestFocus() {
        }

        public boolean isOpaque() {
            return true;
        }
    }

    protected class TitleBar
    extends JPanel
    implements LayoutManager,
    MouseListener {
        private String m_title = "";
        private TitleBarButton m_hide = null;
        private TitleBarButton m_sync = null;

        public TitleBar() {
            super(null);
            this.setLayout(this);
            this.setFont(UIManager.getFont("InternalFrame.titleFont"));
            this.setBackground(UIManager.getColor("InternalFrame.inactiveTitleBackground"));
            this.setForeground(UIManager.getColor("InternalFrame.inactiveTitleForeground"));
            this.m_hide = new TitleBarButton((Icon)MRI.getIcon(0, DisassemblyPane.HIDE_GIF));
            this.m_hide.setToolTipText(MRI.get("DBG_HIDE_DISASSEMBLY"));
            this.m_hide.addActionListener(DisassemblyPane.this.m_ctxt.getAction("hidedsm"));
            this.m_sync = new TitleBarButton((Icon)DisassemblyPane.this.m_downIcon);
            this.m_sync.setMargin(new Insets(0, 0, 0, 0));
            this.m_sync.addActionListener(DisassemblyPane.this.m_ctxt.getAction("syncsrc"));
            this.m_sync.setToolTipText(MRI.get("DBG_SYNC_DISASSEMBLY_WITH_SRC"));
            this.add(this.m_hide);
            this.add(this.m_sync);
            this.setTitle();
            this.addMouseListener(this);
        }

        public void cleanUp() {
            this.removeMouseListener(this);
            this.m_hide = null;
            this.m_sync = null;
            this.m_title = null;
        }

        public void setTitle() {
            this.m_title = MRI.get("DBG_DISASSEMBLY_LABEL");
            this.repaint(this.getVisibleRect());
        }

        public void setTitle(SourceViewEvent sourceViewEvent) {
            PgmManager pgmManager = (PgmManager)DisassemblyPane.this.m_ctxt.getManager("pgmmgr");
            PgmDescriptor pgmDescriptor = pgmManager.getProgram(sourceViewEvent.getViewId());
            MemoryAddress memoryAddress = sourceViewEvent.getStartAddress();
            Object[] objectArray = new Object[]{pgmDescriptor.getPgmPath(), memoryAddress.toString(), memoryAddress.add((DisassemblyPane.this.m_srcPane.getEndLineNum() - DisassemblyPane.this.m_srcPane.getStartLineNum()) * 4).toString()};
            this.m_title = MessageFormat.format(MRI.get("DBG_DISASSEMBLY_TITLE_FMT"), objectArray);
            this.repaint(this.getVisibleRect());
        }

        public void setActive(boolean bl) {
            if (DisassemblyPane.this.m_isActive) {
                this.setBackground(UIManager.getColor("InternalFrame.activeTitleBackground"));
                this.setForeground(UIManager.getColor("InternalFrame.activeTitleForeground"));
                this.m_sync.setIcon(DisassemblyPane.this.m_upIcon);
                this.m_sync.setToolTipText(MRI.get("DBG_SYNC_SRC_WITH_DISASSEMBLY"));
                if (DisassemblyPane.this.m_srcPane.getTotalLineCount() == 0) {
                    this.m_sync.setEnabled(false);
                }
            } else {
                this.setBackground(UIManager.getColor("InternalFrame.inactiveTitleBackground"));
                this.setForeground(UIManager.getColor("InternalFrame.inactiveTitleForeground"));
                this.m_sync.setIcon(DisassemblyPane.this.m_downIcon);
                this.m_sync.setToolTipText(MRI.get("DBG_SYNC_DISASSEMBLY_WITH_SRC"));
                this.m_sync.setEnabled(true);
            }
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = fontMetrics.getHeight() - fontMetrics.getLeading();
            int n2 = (18 - n) / 2 + fontMetrics.getAscent() + fontMetrics.getLeading();
            int n3 = DisassemblyPane.this.m_isLtoR ? 2 : this.getWidth() - 2 - SwingUtilities.computeStringWidth(fontMetrics, this.m_title);
            graphics.drawString(this.m_title, n3, n2);
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return new Dimension(100, 18);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public void layoutContainer(Container container) {
            int n = DisassemblyPane.this.m_isLtoR ? this.getWidth() - 16 - 2 : 2;
            this.m_hide.setBounds(n, 2, 16, 14);
            this.m_sync.setBounds(n += DisassemblyPane.this.m_isLtoR ? -18 : 18, 2, 16, 14);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 1) {
                DisassemblyPane.this.m_ctxt.setActiveSource(DisassemblyPane.this);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

