/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.register;

import com.ibm.iseries.debug.DebugConstants;

public class RegisterDefinition
implements DebugConstants {
    private static final int I_AM_A_PARENT = -100;
    private int m_id;
    private int m_parentId;
    private String m_label;
    private int m_bits;
    private int m_startBit;
    private int m_endBit;
    private int m_displayMode;
    private int m_displayGap;

    public RegisterDefinition(int n, String string, int n2, int n3, boolean bl) {
        this.m_id = n;
        this.m_parentId = bl ? -100 : -1;
        this.m_label = string;
        this.m_bits = n2;
        this.m_startBit = 0;
        this.m_endBit = n2 - 1;
        this.m_displayMode = 0;
        this.m_displayGap = n3;
    }

    public RegisterDefinition(int n, int n2, String string, int n3, int n4, int n5, int n6) {
        this.m_id = n;
        this.m_parentId = n2;
        this.m_label = string;
        this.m_bits = n4 - n3 + 1;
        this.m_startBit = n3;
        this.m_endBit = n4;
        this.m_displayMode = n5;
        this.m_displayGap = n6;
    }

    public int getId() {
        return this.m_id;
    }

    public String getLabel() {
        return this.m_label;
    }

    public int getSizeInBits() {
        return this.m_bits;
    }

    public int getSizeInNibbles() {
        return this.m_bits % 4 == 0 ? this.m_bits / 4 : this.m_bits / 4 + 1;
    }

    public int getSizeInBytes() {
        return this.m_bits % 8 == 0 ? this.m_bits / 8 : this.m_bits / 8 + 1;
    }

    public int getDisplayGap() {
        return this.m_displayGap;
    }

    public int getDisplayMode() {
        return this.m_displayMode;
    }

    public boolean isBitRegister() {
        return this.m_displayMode == 3;
    }

    public boolean isChildRegister() {
        return this.m_parentId >= 0;
    }

    public boolean isParentRegister() {
        return this.m_parentId == -100;
    }

    public int getParentId() {
        return this.m_parentId;
    }

    public int getStartBit() {
        return this.m_startBit;
    }

    public int getEndBit() {
        return this.m_endBit;
    }
}

