/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.panel;

import com.ibm.iseries.debug.event.LAFEvent;
import com.ibm.iseries.debug.listener.LAFListener;
import com.ibm.iseries.debug.manager.LAFManager;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeTablePane
extends JScrollPane
implements LAFListener,
TreeSelectionListener,
TreeExpansionListener,
ListSelectionListener {
    protected TreeHeader m_treeHeader;
    protected Tree m_tree;
    protected TreeModel m_treeModel;
    protected Table m_table;
    protected TableModel m_tableModel;
    protected boolean m_ignore;
    protected String m_paneText;
    protected int m_paneTextWidth;

    public TreeTablePane() {
    }

    public TreeTablePane(String string, TreeModel treeModel, TableModel tableModel) {
        this.m_tableModel = tableModel;
        this.m_table = new Table(tableModel);
        this.m_treeHeader = new TreeHeader(string);
        this.m_treeModel = treeModel;
        this.m_tree = new Tree(this.m_treeModel, this.m_treeHeader);
        Util.setOrientation(this);
        Util.setOrientation(this.m_tree);
        this.setViewportView(this.m_table);
        this.setRowHeaderView(this.m_tree);
        this.setCorner(MRI.isLtoR() ? "UPPER_LEFT_CORNER" : "UPPER_RIGHT_CORNER", this.m_treeHeader);
        this.m_table.getTableHeader().setReorderingAllowed(false);
        this.m_tree.addTreeSelectionListener(this);
        this.m_tree.addTreeExpansionListener(this);
        this.m_table.getSelectionModel().addListSelectionListener(this);
        this.lookAndFeelModifications();
        LAFManager.instance().addListener(this);
    }

    public JComponent getComponent() {
        return this;
    }

    public void cleanUp() {
        LAFManager.instance().removeListener(this);
        this.m_tree.removeTreeSelectionListener(this);
        this.m_tree.removeTreeExpansionListener(this);
        this.m_table.getSelectionModel().removeListSelectionListener(this);
        this.m_treeHeader = null;
        this.m_tree = null;
        this.m_treeModel = null;
        this.m_table = null;
        this.m_tableModel = null;
        this.m_paneText = null;
    }

    public void lookAndFeelModifications() {
        this.getViewport().setBackground(this.m_table.getBackground());
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.m_paneText != null) {
            int n = (this.getWidth() - this.m_paneTextWidth) / 2;
            int n2 = this.getHeight() / 2;
            graphics.drawString(this.m_paneText, n, n2);
        }
    }

    public void setPaneText(String string) {
        this.m_paneText = string;
        if (this.m_paneText != null) {
            this.m_paneTextWidth = ((Component)this).getFontMetrics(this.getFont()).stringWidth(this.m_paneText);
        }
    }

    public JTree getTree() {
        return this.m_tree;
    }

    public TreeModel getTreeModel() {
        return this.m_treeModel;
    }

    public JTable getTable() {
        return this.m_table;
    }

    public TableModel getTableModel() {
        return this.m_tableModel;
    }

    public void refreshTreeAndTable() {
        this.m_tree.repaint(this.m_tree.getVisibleRect());
        this.m_table.repaint(this.m_table.getVisibleRect());
    }

    protected void ignoreSelectionListeners(boolean bl) {
        this.m_ignore = bl;
    }

    public void lookAndFeelChanged(LAFEvent lAFEvent) {
        this.m_table.lookAndFeelModifications();
        this.m_tree.lookAndFeelModifications();
        this.m_treeHeader.lookAndFeelModifications();
        this.lookAndFeelModifications();
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        this.m_tree.repaint();
        this.m_table.revalidate();
        this.m_table.repaint();
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        this.m_tree.repaint();
        this.m_table.revalidate();
        this.m_table.repaint();
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.m_ignore) {
            return;
        }
        this.ignoreSelectionListeners(true);
        TreePath treePath = treeSelectionEvent.getPath();
        int n = this.m_tree.getRowForPath(treePath);
        if (treeSelectionEvent.isAddedPath()) {
            this.m_table.setRowSelectionInterval(n, n);
        } else {
            this.m_table.clearSelection();
        }
        this.ignoreSelectionListeners(false);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.m_ignore) {
            return;
        }
        this.ignoreSelectionListeners(true);
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (!listSelectionModel.isSelectionEmpty()) {
            this.m_tree.setSelectionRow(listSelectionModel.getMinSelectionIndex());
        } else {
            this.m_tree.clearSelection();
        }
        this.ignoreSelectionListeners(false);
    }

    protected class Table
    extends JTable {
        public Table(TableModel tableModel) {
            super(tableModel);
            this.setSelectionMode(0);
            if (this.getRowHeight() < 18) {
                this.setRowHeight(18);
            }
            this.lookAndFeelModifications();
        }

        public void lookAndFeelModifications() {
        }

        public boolean isFocusTraversable() {
            return this.getRowCount() > 0;
        }

        protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
            boolean bl2 = super.processKeyBinding(keyStroke, keyEvent, n, bl);
            return bl2 || bl && this.getEditingRow() >= 0 && Character.isLetterOrDigit(keyEvent.getKeyChar());
        }
    }

    protected class TreeHeader
    extends JLabel {
        public TreeHeader(String string) {
            super(string, 0);
            this.setOpaque(true);
            this.lookAndFeelModifications();
        }

        public void lookAndFeelModifications() {
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setForeground(UIManager.getColor("TableHeader.foreground"));
            this.setBackground(UIManager.getColor("TableHeader.background"));
            this.setFont(UIManager.getFont("TableHeader.font"));
        }
    }

    protected class Tree
    extends JTree {
        private boolean m_paintRightEdge = true;
        private int m_minWidth = 0;

        public Tree(TreeModel treeModel, TreeHeader treeHeader) {
            super(treeModel);
            this.m_minWidth = ((Component)treeHeader).getFontMetrics(treeHeader.getFont()).stringWidth(treeHeader.getText()) + 20;
            this.getSelectionModel().setSelectionMode(1);
            this.setRootVisible(false);
            this.setShowsRootHandles(true);
            this.setScrollsOnExpand(false);
            this.lookAndFeelModifications();
        }

        public void lookAndFeelModifications() {
            int n = TreeTablePane.this.m_table.getRowHeight();
            this.setRowHeight(n);
            this.m_paintRightEdge = true;
            String string = LAFManager.instance().getLookAndFeel();
            if (string.equals("javax.swing.plaf.metal.MetalLookAndFeel")) {
                this.putClientProperty("JTree.lineStyle", "Angled");
            } else if (string.equals("com.sun.java.swing.plaf.motif.MotifLookAndFeel")) {
                this.m_paintRightEdge = false;
                this.setBackground(UIManager.getColor("Table.background"));
            }
        }

        public boolean isFocusTraversable() {
            return this.getRowCount() > 0;
        }

        public int getWidth() {
            int n = super.getWidth();
            if (n < this.m_minWidth) {
                n = this.m_minWidth;
            }
            return n;
        }

        public Dimension getPreferredScrollableViewportSize() {
            Dimension dimension = super.getPreferredScrollableViewportSize();
            if (dimension.width < this.m_minWidth) {
                dimension.width = this.m_minWidth;
            }
            return dimension;
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            Color color = graphics.getColor();
            graphics.setColor(TreeTablePane.this.m_table.getGridColor());
            int n = this.getRowCount() * this.getRowHeight() - 1;
            int n2 = this.getWidth() - 1;
            graphics.drawLine(0, n, n2, n);
            if (this.m_paintRightEdge) {
                graphics.drawLine(n2, 0, n2, n);
            }
            graphics.setColor(color);
            if (this.hasFocus()) {
                Rectangle rectangle = TreeTablePane.this.m_tree.getVisibleRect();
                Rectangle rectangle2 = TreeTablePane.this.m_table.getVisibleRect();
                if (rectangle.y != rectangle2.y) {
                    rectangle2.y = rectangle.y;
                    TreeTablePane.this.m_table.scrollRectToVisible(rectangle2);
                }
            }
        }
    }
}

