/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.packet;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.event.ContextEvent;
import com.ibm.iseries.debug.manager.ContextManager;
import com.ibm.iseries.debug.packet.DebuggerPacket;
import com.ibm.iseries.debug.request.EndDebugRequest;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Util;
import java.io.IOException;
import java.text.MessageFormat;

public class PgmCompletedPacket
extends DebuggerPacket
implements DebugConstants {
    private boolean m_jobTerminated;

    public PgmCompletedPacket() {
        super(1516);
    }

    public void read(CommLink commLink, int n) throws IOException {
        this.m_jobTerminated = commLink.readInt() == 1;
    }

    public void run() {
        String string;
        Object[] objectArray;
        if (this.m_ctxt.isClosed()) {
            return;
        }
        ContextManager contextManager = (ContextManager)this.m_ctxt.getManager("ctxtmgr");
        if (contextManager == null) {
            return;
        }
        contextManager.fireContextEvent(new ContextEvent(this, 4));
        if (this.m_ctxt.getPgmPath().length() > 0) {
            objectArray = new Object[]{this.m_ctxt.getPgmPath()};
            string = MessageFormat.format(MRI.get("DBG_PGM_COMPLETED_FMT"), objectArray);
        } else {
            objectArray = new Object[]{this.m_ctxt.getJobId()};
            string = MessageFormat.format(MRI.get("DBG_PROCESS_COMPLETED_FMT"), objectArray);
        }
        if (this.m_jobTerminated) {
            this.m_ctxt.getDesktop().clear();
        }
        this.m_ctxt.stopAnimation();
        this.m_ctxt.setDebugIcon(6);
        this.m_ctxt.setMessage(string);
        boolean bl = this.m_ctxt.getUserConfig().getBool("ackPgmCompletion", true);
        if (this.m_ctxt.hasPartnerContext()) {
            if (this.m_ctxt.isMasterContext()) {
                this.m_ctxt.getPartnerContext().stopAnimation();
                this.m_ctxt.getPartnerContext().setDebugIcon(6);
                if (bl) {
                    Util.infoMessage(this.m_ctxt.getJFrame(), MRI.get("DBG_ATTENTION"), string);
                }
                if (this.m_jobTerminated && bl) {
                    this.m_ctxt.removePartnerContext();
                }
            } else if (this.m_ctxt.isSlaveContext()) {
                this.m_ctxt.getPartnerContext().allowRunAction(false);
                this.m_ctxt.getPartnerContext().postClock();
            }
            if (this.m_jobTerminated && bl) {
                this.m_ctxt.getPgmEnv().autoSave();
                this.m_ctxt.sendRequest(new EndDebugRequest());
            }
        } else {
            if (bl) {
                Util.infoMessage(this.m_ctxt.getJFrame(), MRI.get("DBG_ATTENTION"), string);
            }
            if (this.m_jobTerminated && bl) {
                this.m_ctxt.getPgmEnv().autoSave();
                this.m_ctxt.sendRequest(new EndDebugRequest());
            }
        }
    }
}

