/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.packet;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.ISeriesMessage;
import com.ibm.iseries.debug.VariableDescriptor;
import com.ibm.iseries.debug.event.VariableEvent;
import com.ibm.iseries.debug.manager.VariableManager;
import com.ibm.iseries.debug.packet.DebuggerPacket;
import com.ibm.iseries.debug.util.CommLink;
import java.io.IOException;

public class ModifyVarPacket
extends DebuggerPacket
implements DebugConstants {
    private int m_panelId;
    private int m_varMask;
    private VariableDescriptor m_descriptor;
    private ISeriesMessage m_msgObj;

    public ModifyVarPacket() {
        super(1513);
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_descriptor = null;
        this.m_msgObj = null;
    }

    public void read(CommLink commLink, int n) throws IOException {
        this.m_panelId = commLink.readInt();
        this.m_varMask = commLink.readInt();
        this.m_descriptor = new VariableDescriptor();
        this.m_descriptor.read(commLink);
        int n2 = commLink.readInt();
        if (n2 == 1) {
            this.m_msgObj = new ISeriesMessage();
            this.m_msgObj.read(commLink);
        }
    }

    public void run() {
        if (this.m_msgObj != null) {
            this.displayMessage(this.m_msgObj);
        }
        VariableManager variableManager = (VariableManager)this.m_ctxt.getManager("varmgr");
        variableManager.fireVariableEvent(new VariableEvent(this, 2, this.m_panelId, this.m_descriptor));
        this.cleanUp();
    }
}

