/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.packet;

import com.ibm.iseries.debug.packet.AddPgmPacket;
import com.ibm.iseries.debug.packet.AssemblerViewPacket;
import com.ibm.iseries.debug.packet.AutoEvalPacket;
import com.ibm.iseries.debug.packet.CallStackPacket;
import com.ibm.iseries.debug.packet.ClearPgmPacket;
import com.ibm.iseries.debug.packet.ClearWatchAllPacket;
import com.ibm.iseries.debug.packet.ConsolePacket;
import com.ibm.iseries.debug.packet.ContextPacket;
import com.ibm.iseries.debug.packet.DebuggerPacket;
import com.ibm.iseries.debug.packet.DspmodsrcPacket;
import com.ibm.iseries.debug.packet.EndDebugPacket;
import com.ibm.iseries.debug.packet.EvalVarPacket;
import com.ibm.iseries.debug.packet.FindPacket;
import com.ibm.iseries.debug.packet.InfoPacket;
import com.ibm.iseries.debug.packet.ListJobPacket;
import com.ibm.iseries.debug.packet.LnBrkPacket;
import com.ibm.iseries.debug.packet.LocalsPacket;
import com.ibm.iseries.debug.packet.MemoryAddrPacket;
import com.ibm.iseries.debug.packet.MemoryExpPacket;
import com.ibm.iseries.debug.packet.ModifyThreadPacket;
import com.ibm.iseries.debug.packet.ModifyVarPacket;
import com.ibm.iseries.debug.packet.MonitorsPacket;
import com.ibm.iseries.debug.packet.OperationProgressPacket;
import com.ibm.iseries.debug.packet.PgmCompletedPacket;
import com.ibm.iseries.debug.packet.RedirectIOPacket;
import com.ibm.iseries.debug.packet.RegistersPacket;
import com.ibm.iseries.debug.packet.RemoteAttachPacket;
import com.ibm.iseries.debug.packet.RmvPgmPacket;
import com.ibm.iseries.debug.packet.SetOptionsPacket;
import com.ibm.iseries.debug.packet.SourceViewPacket;
import com.ibm.iseries.debug.packet.StartDebugPacket;
import com.ibm.iseries.debug.packet.ThreadsPacket;
import com.ibm.iseries.debug.packet.TranslatePidPacket;
import com.ibm.iseries.debug.packet.WatchPacket;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.Packet;
import com.ibm.iseries.debug.util.PacketInflater;
import java.io.IOException;

public class DebuggerPacketInflater
implements PacketInflater {
    protected DebugContext m_ctxt = null;

    public DebuggerPacketInflater(DebugContext debugContext) {
        this.m_ctxt = debugContext;
    }

    public Packet inflatePacket(CommLink commLink, int n, int n2) {
        DebuggerPacket debuggerPacket = null;
        switch (n) {
            case 1500: {
                debuggerPacket = new StartDebugPacket();
                break;
            }
            case 1501: {
                debuggerPacket = new EndDebugPacket();
                break;
            }
            case 1502: {
                debuggerPacket = new AddPgmPacket();
                break;
            }
            case 1503: {
                debuggerPacket = new RmvPgmPacket();
                break;
            }
            case 1504: {
                debuggerPacket = new SourceViewPacket();
                break;
            }
            case 1505: {
                debuggerPacket = new LnBrkPacket();
                break;
            }
            case 1506: {
                debuggerPacket = new ContextPacket();
                break;
            }
            case 1507: {
                debuggerPacket = new ConsolePacket();
                break;
            }
            case 1508: {
                debuggerPacket = new LocalsPacket();
                break;
            }
            case 1509: {
                debuggerPacket = new CallStackPacket();
                break;
            }
            case 1510: {
                debuggerPacket = new ThreadsPacket();
                break;
            }
            case 1511: {
                debuggerPacket = new MonitorsPacket();
                break;
            }
            case 1512: {
                debuggerPacket = new DspmodsrcPacket();
                break;
            }
            case 1513: {
                debuggerPacket = new ModifyVarPacket();
                break;
            }
            case 1514: {
                debuggerPacket = new EvalVarPacket();
                break;
            }
            case 1515: {
                debuggerPacket = new ModifyThreadPacket();
                break;
            }
            case 1516: {
                debuggerPacket = new PgmCompletedPacket();
                break;
            }
            case 1517: {
                debuggerPacket = new WatchPacket();
                break;
            }
            case 1518: {
                debuggerPacket = new AutoEvalPacket();
                break;
            }
            case 1519: {
                debuggerPacket = new ClearPgmPacket();
                break;
            }
            case 1520: {
                debuggerPacket = new ClearWatchAllPacket();
                break;
            }
            case 1521: {
                debuggerPacket = new InfoPacket();
                break;
            }
            case 1522: {
                debuggerPacket = new ListJobPacket();
                break;
            }
            case 1523: {
                debuggerPacket = new FindPacket();
                break;
            }
            case 1525: {
                debuggerPacket = new MemoryAddrPacket();
                break;
            }
            case 1528: {
                debuggerPacket = new MemoryExpPacket();
                break;
            }
            case 1526: {
                debuggerPacket = new RegistersPacket();
                break;
            }
            case 1527: {
                debuggerPacket = new AssemblerViewPacket();
                break;
            }
            case 1529: {
                debuggerPacket = new RemoteAttachPacket();
                break;
            }
            case 1530: {
                debuggerPacket = new OperationProgressPacket();
                break;
            }
            case 1531: {
                debuggerPacket = new SetOptionsPacket();
                break;
            }
            case 1532: {
                debuggerPacket = new RedirectIOPacket();
                break;
            }
            case 1533: {
                debuggerPacket = new TranslatePidPacket();
                break;
            }
            default: {
                System.out.println("DebuggerPacketInflater.inflatePacket()  received unrecognized packet type=" + n);
                try {
                    byte[] byArray = new byte[n2];
                    commLink.readBytes(byArray);
                    break;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
        if (debuggerPacket != null) {
            try {
                debuggerPacket.setContext(this.m_ctxt);
                debuggerPacket.read(commLink, n2);
            }
            catch (IOException iOException) {
                System.out.println("DebuggerPacketInflater.inflatePacket  caught exception: " + iOException.toString());
            }
        }
        return debuggerPacket;
    }
}

