/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.packet;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.ISeriesMessage;
import com.ibm.iseries.debug.event.ContextEvent;
import com.ibm.iseries.debug.manager.ContextManager;
import com.ibm.iseries.debug.packet.DebuggerPacket;
import com.ibm.iseries.debug.util.CommLink;
import java.io.IOException;

public class ContextPacket
extends DebuggerPacket
implements DebugConstants {
    private String m_viewId;
    private int m_lineNum;
    private int m_mask;
    private int m_watchNum;
    private ISeriesMessage m_msgObj;

    public ContextPacket() {
        super(1506);
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_viewId = null;
    }

    public void read(CommLink commLink, int n) throws IOException {
        this.m_viewId = commLink.readString();
        this.m_lineNum = commLink.readInt();
        this.m_mask = commLink.readInt();
        this.m_watchNum = commLink.readInt();
        int n2 = commLink.readInt();
        if (n2 == 1) {
            this.m_msgObj = new ISeriesMessage();
            this.m_msgObj.read(commLink);
        }
    }

    public void run() {
        if (!this.m_ctxt.isClosed()) {
            this.m_ctxt.stopAnimation();
            ContextEvent contextEvent = new ContextEvent((Object)this, this.m_viewId, this.m_lineNum, this.m_mask, this.m_watchNum, this.m_msgObj);
            ContextManager contextManager = (ContextManager)this.m_ctxt.getManager("ctxtmgr");
            contextManager.fireContextEvent(contextEvent);
            contextEvent.cleanUp();
        }
        this.cleanUp();
    }
}

