/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.packet;

import com.ibm.iseries.debug.ISeriesMessage;
import com.ibm.iseries.debug.VariableDescriptor;
import com.ibm.iseries.debug.packet.DebuggerPacket;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Toolbox;
import java.io.IOException;
import java.text.MessageFormat;

public class AutoEvalPacket
extends DebuggerPacket {
    private static final int FROM_FLYOVER = Integer.MIN_VALUE;
    private static final String IGNORE_IDS = "CPF7E12 CPF7E15 CPF7E27 CPF7E10 CPF9897";
    private int m_varMask;
    private VariableDescriptor m_descriptor;
    private ISeriesMessage m_msgObj;

    public AutoEvalPacket() {
        super(1518);
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_descriptor = null;
        this.m_msgObj = null;
    }

    public void read(CommLink commLink, int n) throws IOException {
        this.m_varMask = commLink.readInt();
        this.m_descriptor = new VariableDescriptor();
        this.m_descriptor.read(commLink);
        int n2 = commLink.readInt();
        if (n2 == 1) {
            this.m_msgObj = new ISeriesMessage();
            this.m_msgObj.read(commLink);
        }
    }

    public void run() {
        if (this.m_msgObj != null) {
            Object object;
            if ((this.m_varMask & Integer.MIN_VALUE) != 0) {
                object = this.m_msgObj.getMsgId();
                if (IGNORE_IDS.indexOf((String)object) == -1) {
                    String string = Toolbox.instance().getMsgText(this.m_ctxt, this.m_msgObj);
                    Object[] objectArray = new Object[]{this.m_descriptor.getName(), string};
                    String string2 = MessageFormat.format(MRI.get("DBG_AUTO_EVAL_ERROR_FMT"), objectArray);
                    this.m_ctxt.setMessage(string2);
                } else {
                    this.m_ctxt.clearMessage();
                }
            } else {
                object = Toolbox.instance().getMsgText(this.m_ctxt, this.m_msgObj);
                Object[] objectArray = new Object[]{this.m_descriptor.getName(), object};
                String string = MessageFormat.format(MRI.get("DBG_AUTO_EVAL_ERROR_FMT"), objectArray);
                this.m_ctxt.setMessage(string);
            }
            object = this.m_ctxt.getDesktop().getSource(this.m_descriptor.getViewId());
            if (object != null) {
                object.displayAutoEvalTooltip(null);
            }
        } else {
            Object object;
            String string = null;
            int n = this.m_descriptor.getType();
            switch (n) {
                case 10: 
                case 12: {
                    if (!this.m_descriptor.hasChildren()) break;
                    object = this.m_descriptor.getChild(0);
                    switch (((VariableDescriptor)object).getType()) {
                        case 16: 
                        case 31: 
                        case 32: 
                        case 33: {
                            String string3 = ((VariableDescriptor)object).getValue();
                            int n2 = this.m_ctxt.getUserConfig().getInt("autoEvalMaxLength", 32);
                            if (string3.length() > n2) {
                                string3 = string3.substring(0, n2 + 1) + "...\"";
                            }
                            Object[] objectArray = new Object[]{this.m_descriptor.getName(), string3, this.m_descriptor.getValue()};
                            string = MessageFormat.format(MRI.get("DBG_AUTO_EVAL_STRING_FMT"), objectArray);
                        }
                    }
                    break;
                }
                case 13: {
                    object = new Object[]{this.m_descriptor.getName()};
                    string = MessageFormat.format(MRI.get("DBG_AUTO_EVAL_STRUCTURE"), (Object[])object);
                    break;
                }
                case 14: {
                    object = new Object[]{this.m_descriptor.getName()};
                    string = MessageFormat.format(MRI.get("DBG_AUTO_EVAL_ARRAY"), (Object[])object);
                }
            }
            if (string == null) {
                object = new Object[]{this.m_descriptor.getName(), this.m_descriptor.getValue()};
                string = MessageFormat.format(MRI.get("DBG_AUTO_EVAL_FMT"), (Object[])object);
            }
            this.m_ctxt.setMessage(string);
            object = this.m_ctxt.getDesktop().getSource(this.m_descriptor.getViewId());
            if (object != null) {
                object.displayAutoEvalTooltip(string);
            }
        }
        this.cleanUp();
    }
}

