/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.memory;

import com.ibm.iseries.debug.listener.CursorListener;
import com.ibm.iseries.debug.memory.MemoryAddress;
import com.ibm.iseries.debug.memory.MemoryEditListener;
import com.ibm.iseries.debug.memory.MemoryRowHeader;
import com.ibm.iseries.debug.memory.MemoryView;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

public class MemoryPane
extends JScrollPane
implements CursorListener {
    private DebugContext m_ctxt;
    private MemoryRowHeader m_header;
    private MemoryView m_view;
    private int m_bytesPerLine;
    private String m_paneText;
    private int m_paneTextWidth;

    public MemoryPane(DebugContext debugContext, int n) {
        this.m_ctxt = debugContext;
        Settings settings = this.m_ctxt.getConfig();
        Settings settings2 = this.m_ctxt.getUserConfig();
        this.m_header = (MemoryRowHeader)Util.loadObject(settings.getString("memRowHeader", "MemoryAddrHeader"));
        this.m_view = (MemoryView)Util.loadObject(settings.getString("memView", "MemoryHexView"));
        this.m_header.init(this.m_ctxt);
        this.m_view.init(this.m_ctxt, n);
        this.m_bytesPerLine = settings2.getInt("memBPL", 16);
        this.setViewportView(this.m_view.getComponent());
        this.setRowHeaderView(this.m_header.getComponent());
        this.m_ctxt.getManager("cursormgr").addListener(this);
    }

    public void cleanUp() {
        this.m_ctxt.getManager("cursormgr").removeListener(this);
        this.m_header.cleanUp();
        this.m_view.cleanUp();
        this.m_ctxt = null;
        this.m_header = null;
        this.m_view = null;
        this.m_paneText = null;
    }

    public JComponent getComponent() {
        return this;
    }

    public MemoryRowHeader getHeader() {
        return this.m_header;
    }

    public MemoryView getView() {
        return this.m_view;
    }

    public void clear() {
        if (this.m_paneText != null) {
            this.setPaneText(null);
        }
        this.m_header.clear();
        this.m_view.clear();
    }

    public void setPaneText(String string) {
        this.m_paneText = string;
        if (this.m_paneText != null) {
            this.m_paneTextWidth = ((Component)this).getFontMetrics(this.getFont()).stringWidth(this.m_paneText);
            this.setViewportView(null);
            this.setRowHeaderView(null);
            this.m_header.clear();
            this.m_view.clear();
        } else {
            this.setViewportView(this.m_view.getComponent());
            this.setRowHeaderView(this.m_header.getComponent());
        }
    }

    public void setSuspended(boolean bl) {
        this.setPaneText(bl ? MRI.get("DBG_SUSPENDED") : null);
        this.requestFocus();
    }

    public void setEnabled(boolean bl) {
        this.m_header.setEnabled(bl);
        this.m_view.setEnabled(bl);
    }

    public void setEditable(boolean bl) {
        this.m_view.setEditable(bl);
    }

    public void setTagsReadOnly(boolean bl) {
        this.m_view.setTagsReadOnly(bl);
    }

    public boolean isEditable() {
        return this.m_view.isEditable();
    }

    public boolean isEditing() {
        return this.m_view.isEditing();
    }

    public void acceptEdit() {
        this.m_view.acceptEdit();
    }

    public void cancelEdit() {
        this.m_view.cancelEdit();
    }

    public boolean find(String string) {
        return this.m_view.find(string);
    }

    public MemoryAddress getAddress() {
        return this.m_view.getAddress();
    }

    public MemoryAddress getAddressAtCursor() {
        return this.m_view.getAddressAtCursor();
    }

    public String getHexData() {
        return this.m_view.getHexData();
    }

    public String getHexDataAtCursor(int n) {
        return this.m_view.getHexDataAtCursor(n);
    }

    public String getTags() {
        return this.m_view.getTags();
    }

    public int getByteCount() {
        return this.m_view.getByteCount();
    }

    public int getCharacterMode() {
        return this.m_view.getCharacterMode();
    }

    public int getBytesPerLine() {
        return this.m_bytesPerLine;
    }

    public void setCharacterMode(int n, boolean bl) {
        if (this.m_view.getCharacterMode() != n) {
            this.m_view.setCharacterMode(n, bl);
        }
    }

    public void setBytesPerLine(int n, boolean bl) {
        if (this.m_bytesPerLine != n) {
            if (bl && this.m_view.getByteCount() > 0) {
                this.m_header.setAddress(this.m_view.getAddress(), this.m_view.getByteCount(), n);
            }
            this.m_view.setBytesPerLine(n, bl);
            this.m_bytesPerLine = n;
        }
    }

    public void setHexData(MemoryAddress memoryAddress, String string, String string2, boolean bl) {
        int n;
        if (this.m_paneText != null) {
            this.setPaneText(null);
        }
        int n2 = n = string != null ? string.length() / 2 : 0;
        if (string != null) {
            this.m_header.setAddress(memoryAddress, n, this.m_bytesPerLine);
            this.m_view.setHexData(memoryAddress, string, string2, this.m_bytesPerLine, bl);
        } else {
            this.m_header.clear();
            this.m_view.clear();
        }
    }

    public void mergeHexData(MemoryAddress memoryAddress, String string, String string2) {
        this.m_view.mergeHexData(memoryAddress, string, string2);
    }

    public void highlightPos(int n) {
        this.m_view.highlightPos(n);
    }

    public void setEditListener(MemoryEditListener memoryEditListener) {
        this.m_view.setEditListener(memoryEditListener);
    }

    public void copyAll() {
        this.m_view.copyAll();
    }

    public void addMouseListener(MouseListener mouseListener) {
        super.addMouseListener(mouseListener);
        if (this.m_header != null) {
            this.m_header.addMouseListener(mouseListener);
        }
        if (this.m_view != null) {
            this.m_view.addMouseListener(mouseListener);
        }
    }

    public void removeMouseListener(MouseListener mouseListener) {
        super.removeMouseListener(mouseListener);
        if (this.m_header != null) {
            this.m_header.removeMouseListener(mouseListener);
        }
        if (this.m_view != null) {
            this.m_view.removeMouseListener(mouseListener);
        }
    }

    public void addFocusListener(FocusListener focusListener) {
        super.addFocusListener(focusListener);
        if (this.m_header != null) {
            this.m_header.addFocusListener(focusListener);
        }
        if (this.m_view != null) {
            this.m_view.addFocusListener(focusListener);
        }
    }

    public void removeFocusListener(FocusListener focusListener) {
        super.removeFocusListener(focusListener);
        if (this.m_header != null) {
            this.m_header.removeFocusListener(focusListener);
        }
        if (this.m_view != null) {
            this.m_view.removeFocusListener(focusListener);
        }
    }

    public void updateUI() {
        super.updateUI();
        this.setBackground(UIManager.getColor("TextArea.background"));
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.m_paneText != null) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            int n3 = (n - this.m_paneTextWidth) / 2;
            int n4 = n2 / 2;
            Color color = graphics.getColor();
            graphics.setColor(this.m_view.getComponent().getBackground());
            graphics.fillRect(0, 0, n, n2);
            graphics.setColor(color);
            graphics.drawString(this.m_paneText, n3, n4);
        }
    }

    public void postCursor(int n) {
        switch (n) {
            case 2: {
                Cursor cursor = Cursor.getPredefinedCursor(3);
                this.setCursor(cursor);
                this.m_header.setCursor(cursor);
                this.m_view.setCursor(cursor);
                break;
            }
            case 1: {
                Cursor cursor = Cursor.getPredefinedCursor(0);
                this.setCursor(cursor);
                this.m_view.setCursor(cursor);
                this.m_header.setCursor(cursor);
                this.m_view.setCursor(cursor);
            }
        }
    }
}

