/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.memory;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.manager.SettingsManager;
import com.ibm.iseries.debug.memory.MemoryOffsetEditListener;
import com.ibm.iseries.debug.util.Util;
import java.awt.Color;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class MemoryOffsetControl
extends JTextField
implements DebugConstants,
CaretListener {
    private static Color s_fg = UIManager.getColor("TextField.foreground");
    private static Color s_bg = UIManager.getColor("TextField.background");
    private static Color s_caret = UIManager.getColor("TextField.caretForeground");
    private String m_offset;
    private boolean m_editing;
    private MemoryOffsetEditListener m_listener;

    public MemoryOffsetControl(int n) {
        super(n / 4 + 1);
        this.setOffset("0000000000000000000000000000000000000000000000000000000000000000".substring(0, n / 4));
        this.addCaretListener(this);
    }

    public void cleanUp() {
        this.m_offset = null;
        this.m_listener = null;
    }

    public int getOffsetSizeInBits() {
        return this.m_offset.length() * 4;
    }

    public int getOffset() {
        return Integer.parseInt(this.m_offset, 16);
    }

    public String getHexOffset() {
        return this.m_offset;
    }

    public void setOffset(int n) {
        int n2;
        String string;
        int n3;
        if (n < 0) {
            n = -1;
        }
        if ((n3 = (string = Integer.toHexString(n).toUpperCase()).length()) < (n2 = this.m_offset.length())) {
            string = "0000000000000000000000000000000000000000000000000000000000000000".substring(0, this.m_offset.length() - string.length()) + string;
        } else if (n3 > n2) {
            string = string.substring(n3 - n2);
        }
        this.setOffset(string);
    }

    public void setOffset(String string) {
        if (this.m_offset != null && string.length() < this.m_offset.length()) {
            string = "0000000000000000000000000000000000000000000000000000000000000000".substring(0, this.m_offset.length() - string.length()) + string;
        }
        this.m_offset = string;
        this.setText(this.m_offset);
    }

    public void setEditListener(MemoryOffsetEditListener memoryOffsetEditListener) {
        this.m_listener = memoryOffsetEditListener;
    }

    public boolean isEditing() {
        return this.m_editing;
    }

    protected void setEditColors(boolean bl) {
        if (bl) {
            this.setBackground(s_fg);
            this.setForeground(s_bg);
            this.setCaretColor(s_bg);
        } else {
            this.setBackground(s_bg);
            this.setForeground(s_fg);
            this.setCaretColor(s_caret);
        }
    }

    public void initiateEdit() {
        if (!this.m_editing) {
            this.m_editing = true;
            this.setEditColors(true);
            if (this.m_listener != null) {
                this.m_listener.offsetEditInitiated(this);
            }
        }
    }

    public void acceptEdit() {
        if (this.m_editing) {
            this.m_editing = false;
            this.setEditColors(false);
            this.m_offset = this.getText();
            if (this.m_listener != null) {
                this.m_listener.offsetEditCommitted(this);
            }
        }
    }

    public void cancelEdit() {
        if (this.m_editing) {
            this.m_editing = false;
            this.setEditColors(false);
            this.setText(this.m_offset);
            if (this.m_listener != null) {
                this.m_listener.offsetEditAborted(this);
            }
        }
    }

    public void caretUpdate(CaretEvent caretEvent) {
        try {
            int n = this.getDocument().getLength();
            int n2 = caretEvent.getDot();
            if (n > 0 && !this.hasSelection() && n2 >= n) {
                this.setCaretPosition(0);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void updateUI() {
        super.updateUI();
        this.setFont(SettingsManager.getFixedPitchFont());
    }

    protected boolean hasSelection() {
        return this.getSelectionStart() != this.getSelectionEnd();
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        boolean bl = keyEvent.getID() == 401;
        switch (keyEvent.getKeyCode()) {
            case 8: 
            case 37: 
            case 226: {
                if (bl) {
                    int n = this.getCaretPosition();
                    if (n == 0) {
                        this.setCaretPosition(this.getDocument().getLength() - 1);
                    } else {
                        this.setCaretPosition(n - 1);
                    }
                }
                keyEvent.consume();
                break;
            }
            case 36: {
                if (bl) {
                    this.setCaretPosition(0);
                }
                keyEvent.consume();
                break;
            }
            case 35: {
                if (bl) {
                    this.setCaretPosition(this.getDocument().getLength() - 1);
                }
                keyEvent.consume();
                break;
            }
            case 127: {
                if (bl) {
                    this.getToolkit().beep();
                }
                keyEvent.consume();
                break;
            }
            case 27: {
                if (bl && this.m_editing) {
                    this.cancelEdit();
                }
                keyEvent.consume();
                break;
            }
            case 10: {
                if (bl && this.m_editing) {
                    this.acceptEdit();
                }
                keyEvent.consume();
            }
        }
        super.processKeyEvent(keyEvent);
    }

    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (keyEvent.getKeyChar() == '\b') {
            return true;
        }
        boolean bl2 = super.processKeyBinding(keyStroke, keyEvent, n, bl);
        boolean bl3 = Character.digit(keyEvent.getKeyChar(), 16) >= 0;
        return bl2 || bl && bl3;
    }

    public void cut() {
    }

    public void replaceSelection(String string) {
        int n = this.getCaretPosition();
        int n2 = string.length();
        if (n2 == 0 || n >= this.getDocument().getLength()) {
            this.getToolkit().beep();
            return;
        }
        if ((string = Util.validateHexData(string)) == null) {
            return;
        }
        n2 = string.length();
        if (n2 > 1 && n + n2 > this.getDocument().getLength()) {
            string = string.substring(0, this.getDocument().getLength() - n);
        }
        if (this.hasSelection()) {
            this.setCaretPosition(this.getSelectionEnd());
            n = this.getCaretPosition();
        }
        try {
            if (n2 == 1) {
                this.getDocument().remove(n, n2);
                this.getDocument().insertString(n, string, null);
            } else {
                String string2 = this.getText();
                StringBuffer stringBuffer = new StringBuffer(string2);
                if (n + n2 > string2.length()) {
                    n2 = string2.length() - n;
                    string = string.substring(0, n2);
                }
                stringBuffer.replace(n, n + n2, string);
                this.setText(stringBuffer.toString());
            }
            if (!this.m_editing) {
                this.initiateEdit();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

