/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.memory;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.manager.MemoryManager;
import com.ibm.iseries.debug.memory.MemoryAddrControl;
import com.ibm.iseries.debug.memory.MemoryAddrCtrlView;
import com.ibm.iseries.debug.memory.MemoryAddrEditListener;
import com.ibm.iseries.debug.memory.MemoryAddress;
import com.ibm.iseries.debug.memory.MemoryOffsetControl;
import com.ibm.iseries.debug.memory.MemoryOffsetEditListener;
import com.ibm.iseries.debug.memory.MemoryPane;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MemoryAddrCtrls
extends JPanel
implements MemoryAddrCtrlView,
MemoryAddrEditListener,
MemoryOffsetEditListener,
DebugConstants,
ActionListener {
    protected static final String BYTES = "bytes";
    protected static final String BYTES_PER = "bytesper";
    protected static final String MODE = "mode";
    protected static final String OFFSET_OP = "offsetop";
    protected static final String ALIGN_ON = "alignon";
    protected Settings m_userCfg;
    protected MemoryManager m_memMgr;
    protected MemoryPane m_memory;
    protected MemoryAddrControl m_addrCtrl;
    protected MemoryOffsetControl m_offsetCtrl;
    protected JComboBox m_bytesCtrl;
    protected JComboBox m_modeCtrl;
    protected JComboBox m_bytesPerCtrl;
    protected JComboBox m_plusMinus;
    protected String m_oper;
    protected JCheckBox m_alignCtrl;
    protected boolean m_alignOn;

    public MemoryAddrCtrls() {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
    }

    public void init(DebugContext debugContext, MemoryPane memoryPane) {
        this.m_userCfg = debugContext.getUserConfig();
        this.m_memMgr = (MemoryManager)debugContext.getManager("memmgr");
        this.m_memory = memoryPane;
        this.add((Component)this.createAddrComponents(debugContext), MRI.isLtoR() ? "West" : "East");
        this.add((Component)this.createFmtComponents(debugContext), MRI.isLtoR() ? "East" : "West");
    }

    public void cleanUp() {
        this.m_addrCtrl.cleanUp();
        this.m_offsetCtrl.cleanUp();
        this.m_userCfg = null;
        this.m_memMgr = null;
        this.m_memory = null;
        this.m_addrCtrl = null;
        this.m_offsetCtrl = null;
        this.m_bytesCtrl = null;
        this.m_modeCtrl = null;
        this.m_bytesPerCtrl = null;
        this.m_plusMinus = null;
        this.m_oper = "+";
        this.m_alignCtrl = null;
        this.m_alignOn = false;
    }

    public JComponent getComponent() {
        return this;
    }

    public int getAddressSizeInBits() {
        return this.m_addrCtrl.getAddressSizeInBits();
    }

    public MemoryAddress getAddress() {
        return this.m_addrCtrl.getAddress();
    }

    public MemoryAddress getEditAddress() {
        return this.m_addrCtrl.getEditAddress();
    }

    public void setAddress(MemoryAddress memoryAddress) {
        this.m_addrCtrl.setAddress(memoryAddress);
    }

    public void insertAddress(MemoryAddress memoryAddress) {
        this.m_addrCtrl.insertAddress(memoryAddress);
    }

    public void clearAddressHistory() {
        this.m_addrCtrl.clearAddressHistory();
    }

    public void resetAddressSize(int n, int n2) {
        this.m_addrCtrl.resetAddressSize(n, n2);
    }

    public boolean isAddressMatch(MemoryAddress memoryAddress, int n) {
        return this.getAddress().equals(memoryAddress) && this.getByteCount() == n;
    }

    public boolean isAddressInRange(MemoryAddress memoryAddress, int n) {
        MemoryAddress memoryAddress2 = memoryAddress;
        MemoryAddress memoryAddress3 = memoryAddress2.add(n - 1);
        MemoryAddress memoryAddress4 = this.getAddress();
        MemoryAddress memoryAddress5 = memoryAddress4.add(this.getByteCount() - 1);
        int n2 = memoryAddress2.compareTo(memoryAddress4);
        int n3 = memoryAddress2.compareTo(memoryAddress5);
        int n4 = memoryAddress3.compareTo(memoryAddress4);
        int n5 = memoryAddress3.compareTo(memoryAddress5);
        return n2 >= 0 && n3 <= 0 || n4 >= 0 && n5 <= 0 || n2 <= 0 && n5 >= 0;
    }

    public int getAddressOffset() {
        return this.m_offsetCtrl.getOffset();
    }

    public boolean find(String string) {
        return this.m_memory.find(string);
    }

    protected void validateCharacterMode(int n) {
        String string = (String)this.m_bytesPerCtrl.getItemAt(0);
        switch (n) {
            case 0: 
            case 1: {
                if (Integer.parseInt(string) == 1) break;
                this.m_bytesPerCtrl.insertItemAt(String.valueOf(1), 0);
                break;
            }
            case 2: {
                if (Integer.parseInt(string) != 1) break;
                this.m_bytesPerCtrl.removeItemAt(0);
            }
        }
    }

    public void setCharacterMode(int n) {
        this.validateCharacterMode(n);
        this.m_modeCtrl.removeActionListener(this);
        this.m_modeCtrl.setSelectedIndex(n);
        this.m_modeCtrl.addActionListener(this);
        this.m_userCfg.setInt("memCharMode", n);
    }

    public int getCharacterMode() {
        return this.m_modeCtrl.getSelectedIndex();
    }

    public void setByteCount(int n) {
        this.m_bytesCtrl.removeActionListener(this);
        this.m_bytesCtrl.setSelectedItem(String.valueOf(n));
        this.m_bytesCtrl.addActionListener(this);
        this.m_userCfg.setInt("memBytes", n);
    }

    public int getByteCount() {
        return Integer.parseInt((String)this.m_bytesCtrl.getSelectedItem());
    }

    protected void validateBytesPerLine(int n) {
        if (n == 1) {
            if (this.m_modeCtrl.getItemCount() >= 2) {
                this.m_modeCtrl.removeItemAt(2);
            }
        } else if (this.m_modeCtrl.getItemCount() <= 2) {
            this.m_modeCtrl.addItem(MRI.get("DBG_UNICODE"));
        }
    }

    public void setBytesPerLine(int n) {
        this.validateBytesPerLine(n);
        this.m_bytesPerCtrl.removeActionListener(this);
        this.m_bytesPerCtrl.setSelectedItem(String.valueOf(n));
        this.m_bytesPerCtrl.addActionListener(this);
        this.m_userCfg.getInt("memBPL", n);
    }

    public int getBytesPerLine() {
        return Integer.parseInt((String)this.m_bytesPerCtrl.getSelectedItem());
    }

    public String getOffsetOperation() {
        return (String)this.m_plusMinus.getSelectedItem();
    }

    public void enableAddressControls(boolean bl) {
        this.m_addrCtrl.setEnabled(bl);
        this.m_bytesCtrl.setEnabled(bl);
    }

    protected JPanel createAddrComponents(DebugContext debugContext) {
        boolean bl = MRI.isLtoR();
        JLabel jLabel = Util.getAccessibleLabel(MRI.get("DBG_ADDRESS_LABEL"));
        JLabel jLabel2 = Util.getAccessibleLabel(MRI.get("DBG_BYTES_LABEL"));
        this.m_plusMinus = new JComboBox();
        this.m_plusMinus.setRenderer(new DummyRenderer());
        this.m_plusMinus.addItem("+");
        this.m_plusMinus.addItem("-");
        this.m_plusMinus.setSelectedItem("+");
        this.m_plusMinus.setActionCommand(OFFSET_OP);
        this.m_plusMinus.addActionListener(this);
        this.m_oper = "+";
        this.m_plusMinus.addActionListener(this);
        this.m_addrCtrl = new MemoryAddrControl(debugContext.getAddrSizeInBits(), debugContext.getAddrOffsetSizeInBits());
        this.m_addrCtrl.setEditListener(this);
        this.m_offsetCtrl = new MemoryOffsetControl(32);
        this.m_offsetCtrl.setEditListener(this);
        int n = this.m_userCfg.getInt("memBytes", 128);
        this.m_bytesCtrl = new JComboBox();
        this.m_bytesCtrl.setRenderer(new DummyRenderer());
        this.m_bytesCtrl.addItem(String.valueOf(32));
        this.m_bytesCtrl.addItem(String.valueOf(64));
        this.m_bytesCtrl.addItem(String.valueOf(128));
        this.m_bytesCtrl.addItem(String.valueOf(256));
        this.m_bytesCtrl.addItem(String.valueOf(512));
        this.m_bytesCtrl.addItem(String.valueOf(1024));
        this.m_bytesCtrl.addItem(String.valueOf(2048));
        this.m_bytesCtrl.addItem(String.valueOf(4096));
        this.m_bytesCtrl.setSelectedItem(String.valueOf(n));
        this.m_bytesCtrl.setActionCommand(BYTES);
        this.m_bytesCtrl.addActionListener(this);
        String string = MRI.get("DBG2_ALIGN_LABEL");
        this.m_alignCtrl = new JCheckBox(string, this.m_alignOn);
        this.m_alignCtrl.setActionCommand(ALIGN_ON);
        this.m_alignCtrl.addActionListener(this);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 3));
        JPanel jPanel3 = new JPanel(new GridLayout(0, 1, 0, 3));
        JPanel jPanel4 = new JPanel(new FlowLayout(bl ? 0 : 2, 0, 0));
        JPanel jPanel5 = new JPanel(new GridLayout(0, 1, 0, 3));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        jPanel2.add(jLabel);
        jPanel2.add(jLabel2);
        jPanel3.add(this.m_addrCtrl);
        jPanel3.add(this.m_bytesCtrl);
        jPanel4.add(this.m_plusMinus);
        jPanel4.add(this.m_offsetCtrl);
        jPanel4.add(this.m_alignCtrl);
        jPanel5.add(jPanel4);
        jPanel5.add(new JLabel(" "));
        jPanel.add((Component)jPanel2, bl ? "West" : "East");
        jPanel.add((Component)jPanel3, "Center");
        jPanel.add((Component)jPanel5, bl ? "East" : "West");
        Util.setAccessible((Accessible)this.m_addrCtrl, jLabel);
        Util.setAccessible((Accessible)this.m_bytesCtrl, jLabel2);
        Util.setOrientation(this.m_addrCtrl, jLabel);
        Util.setOrientation(this.m_bytesCtrl, jLabel2);
        Util.setOrientation(jPanel4);
        return jPanel;
    }

    protected JPanel createFmtComponents(DebugContext debugContext) {
        boolean bl = MRI.isLtoR();
        JLabel jLabel = Util.getAccessibleLabel(MRI.get("DBG_FORMAT_LABEL"));
        JLabel jLabel2 = Util.getAccessibleLabel(MRI.get("DBG_BYTES_PER_LINE_LABEL"));
        int n = this.m_userCfg.getInt("memCharMode", 1);
        this.m_modeCtrl = new JComboBox();
        this.m_modeCtrl.setRenderer(new DummyRenderer());
        this.m_modeCtrl.addItem(MRI.get("DBG_EBCDIC"));
        this.m_modeCtrl.addItem(MRI.get("DBG_ASCII"));
        this.m_modeCtrl.addItem(MRI.get("DBG_UNICODE"));
        this.m_modeCtrl.setSelectedIndex(n);
        this.m_modeCtrl.setActionCommand(MODE);
        this.m_modeCtrl.addActionListener(this);
        Dimension dimension = this.m_modeCtrl.getPreferredSize();
        dimension.width += 5;
        this.m_modeCtrl.setPreferredSize(dimension);
        int n2 = this.m_userCfg.getInt("memBPL", 16);
        this.m_bytesPerCtrl = new JComboBox();
        this.m_bytesPerCtrl.setRenderer(new DummyRenderer());
        this.m_bytesPerCtrl.addItem(String.valueOf(1));
        this.m_bytesPerCtrl.addItem(String.valueOf(2));
        this.m_bytesPerCtrl.addItem(String.valueOf(4));
        this.m_bytesPerCtrl.addItem(String.valueOf(8));
        this.m_bytesPerCtrl.addItem(String.valueOf(16));
        this.m_bytesPerCtrl.addItem(String.valueOf(32));
        this.m_bytesPerCtrl.setSelectedItem(String.valueOf(n2));
        this.m_bytesPerCtrl.setActionCommand(BYTES_PER);
        this.m_bytesPerCtrl.addActionListener(this);
        Util.setAccessible((Accessible)this.m_modeCtrl, jLabel);
        Util.setAccessible((Accessible)this.m_bytesPerCtrl, jLabel2);
        Util.setOrientation(this.m_modeCtrl, jLabel);
        Util.setOrientation(this.m_bytesPerCtrl, jLabel2);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 3));
        JPanel jPanel3 = new JPanel(new GridLayout(0, 1, 0, 3));
        if (bl) {
            jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        } else {
            jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        }
        jPanel2.add(jLabel);
        jPanel2.add(jLabel2);
        jPanel3.add(this.m_modeCtrl);
        jPanel3.add(this.m_bytesPerCtrl);
        jPanel.add((Component)jPanel2, bl ? "West" : "East");
        jPanel.add((Component)jPanel3, "Center");
        return jPanel;
    }

    protected void requestMemory() {
        if (this.m_addrCtrl.isEditing()) {
            this.m_addrCtrl.acceptEdit();
        }
        this.m_memory.setEnabled(true);
        MemoryAddress memoryAddress = this.getAddress();
        int n = this.getByteCount();
        this.m_userCfg.setInt("memBytes", n);
        if (!memoryAddress.canAdd(n)) {
            memoryAddress = memoryAddress.setMax().subtract(n - 1);
            this.setAddress(memoryAddress);
        }
        if (this.m_alignOn) {
            this.m_memMgr.requestMemoryRead(memoryAddress.align(this.getBytesPerLine()), n);
        } else {
            this.m_memMgr.requestMemoryRead(memoryAddress, n);
        }
    }

    public void addressEditInitiated(MemoryAddrControl memoryAddrControl) {
        this.m_memory.setEnabled(false);
    }

    public void addressEditCommitted(MemoryAddrControl memoryAddrControl) {
        this.requestMemory();
    }

    public void addressEditAborted(MemoryAddrControl memoryAddrControl) {
        this.m_memory.setEnabled(true);
    }

    public void offsetEditInitiated(MemoryOffsetControl memoryOffsetControl) {
        this.m_memory.setEnabled(false);
    }

    public void offsetEditCommitted(MemoryOffsetControl memoryOffsetControl) {
        if (this.m_addrCtrl.isEditing()) {
            this.m_addrCtrl.acceptEdit();
        }
        this.m_offsetCtrl.acceptEdit();
        String string = this.m_offsetCtrl.getHexOffset();
        if (!string.equals("0000000000000000000000000000000000000000000000000000000000000000".substring(0, string.length()))) {
            MemoryAddress memoryAddress = this.m_addrCtrl.getAddress();
            memoryAddress = this.m_oper == "+" ? memoryAddress.addWrap(string) : memoryAddress.subtractWrap(string);
            this.m_addrCtrl.insertAddress(memoryAddress);
            this.m_offsetCtrl.setOffset(0);
        }
        this.requestMemory();
    }

    public void offsetEditAborted(MemoryOffsetControl memoryOffsetControl) {
        this.m_memory.setEnabled(true);
    }

    public void refreshMemory() {
        String string = this.m_offsetCtrl.getHexOffset();
        MemoryAddress memoryAddress = new MemoryAddress(this.m_addrCtrl.unFormatAddress());
        if (!(memoryAddress.isZero() & string.equals("0000000000000000000000000000000000000000000000000000000000000000".substring(0, string.length())))) {
            memoryAddress = this.m_oper == "+" ? memoryAddress.addWrap(string) : memoryAddress.subtractWrap(string);
            this.m_addrCtrl.insertAddress(memoryAddress);
            this.m_offsetCtrl.setOffset(0);
            this.requestMemory();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(BYTES)) {
            this.requestMemory();
        } else if (string.equals(MODE)) {
            int n = this.getCharacterMode();
            this.validateCharacterMode(n);
            this.m_memory.setCharacterMode(n, true);
            this.m_userCfg.setInt("memCharMode", n);
        } else if (string.equals(BYTES_PER)) {
            int n = this.getBytesPerLine();
            this.validateBytesPerLine(n);
            this.m_memory.setBytesPerLine(n, true);
            this.m_userCfg.setInt("memBPL", n);
        } else if (string.equals(OFFSET_OP)) {
            this.m_oper = this.getOffsetOperation();
            this.refreshMemory();
        } else if (string.equals(ALIGN_ON)) {
            this.m_alignOn = this.m_alignCtrl.isSelected();
            this.refreshMemory();
        }
    }

    public void clearAlignment() {
        this.m_alignCtrl.setSelected(false);
        this.m_alignOn = this.m_alignCtrl.isSelected();
    }

    protected class DummyRenderer
    extends DefaultListCellRenderer {
    }
}

