/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.manager;

import com.ibm.iseries.debug.VariableDescriptor;
import com.ibm.iseries.debug.event.MemoryEvent;
import com.ibm.iseries.debug.event.VariableEvent;
import com.ibm.iseries.debug.event.WatchEvent;
import com.ibm.iseries.debug.listener.VariableListener;
import com.ibm.iseries.debug.manager.MemoryManager;
import com.ibm.iseries.debug.request.EvalVarRequest;
import com.ibm.iseries.debug.request.LocalsRequest;
import com.ibm.iseries.debug.request.ModifyVarRequest;
import com.ibm.iseries.debug.request.MonitorsRequest;
import com.ibm.iseries.debug.request.WatchRequest;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.Manager;
import java.util.ArrayList;

public class VariableManager
extends Manager {
    public static final String KEY = "varmgr";
    protected DebugContext m_ctxt;

    public VariableManager(DebugContext debugContext) {
        this.m_ctxt = debugContext;
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_ctxt = null;
    }

    public String getKey() {
        return KEY;
    }

    public void requestLocals(String string, int n, int n2) {
        LocalsRequest localsRequest = new LocalsRequest(string, n, n2);
        this.m_ctxt.sendRequest(localsRequest);
    }

    public void requestMonitors(ArrayList arrayList, int n) {
        MonitorsRequest monitorsRequest = new MonitorsRequest(1, n, arrayList);
        this.m_ctxt.sendRequest(monitorsRequest);
    }

    public void requestEval(int n, VariableDescriptor variableDescriptor, int n2) {
        EvalVarRequest evalVarRequest = new EvalVarRequest(n, n2, variableDescriptor);
        this.m_ctxt.sendRequest(evalVarRequest);
    }

    public void requestEvals(int n, ArrayList arrayList, int n2) {
        EvalVarRequest evalVarRequest = new EvalVarRequest(n, n2, arrayList);
        this.m_ctxt.sendRequest(evalVarRequest);
    }

    public void requestModify(int n, VariableDescriptor variableDescriptor, String string, int n2) {
        ModifyVarRequest modifyVarRequest = new ModifyVarRequest(n, n2, variableDescriptor, string);
        this.m_ctxt.sendRequest(modifyVarRequest);
    }

    public void requestWatchAdd(VariableDescriptor variableDescriptor, int n) {
        WatchRequest watchRequest = new WatchRequest(1, variableDescriptor, n);
        this.m_ctxt.sendRequest(watchRequest);
    }

    public void requestWatchRmv(VariableDescriptor variableDescriptor, int n) {
        WatchRequest watchRequest = new WatchRequest(0, variableDescriptor, n);
        this.m_ctxt.sendRequest(watchRequest);
    }

    public void fireVariableEvent(VariableEvent variableEvent) {
        Object object;
        int n = this.m_listeners.size();
        int n2 = 0;
        while (n2 < n) {
            object = (VariableListener)this.m_listeners.get(n2);
            switch (variableEvent.getType()) {
                case 0: {
                    if (object.getId() != variableEvent.getRequesterId()) break;
                    object.variablesAvailable(variableEvent);
                    return;
                }
                case 1: {
                    if (object.getId() != variableEvent.getRequesterId()) break;
                    object.variablesEvaled(variableEvent);
                    return;
                }
                case 2: {
                    object.variableModified(variableEvent);
                    break;
                }
                case 3: {
                    if (object.getId() != variableEvent.getRequesterId()) break;
                    object.monitorCreated(variableEvent);
                    return;
                }
                case 4: {
                    object.variablesRefresh(variableEvent);
                    break;
                }
                case 5: {
                    object.displayMaskChanged(variableEvent);
                }
            }
            ++n2;
        }
        if (variableEvent.getType() == 2) {
            object = (MemoryManager)this.m_ctxt.getManager("memmgr");
            ((MemoryManager)object).fireMemoryEvent(new MemoryEvent(this, 5));
        }
    }

    public void fireWatchEvent(WatchEvent watchEvent) {
        int n = this.m_listeners.size();
        int n2 = 0;
        while (n2 < n) {
            VariableListener variableListener = (VariableListener)this.m_listeners.get(n2);
            switch (watchEvent.getType()) {
                case 0: {
                    if (variableListener.getId() != watchEvent.getRequesterId()) break;
                    variableListener.watchAdded(watchEvent);
                    return;
                }
                case 1: {
                    if (variableListener.getId() != watchEvent.getRequesterId()) break;
                    variableListener.watchRemoved(watchEvent);
                    return;
                }
                case 2: {
                    if (variableListener.getId() != watchEvent.getRequesterId()) break;
                    variableListener.watchError(watchEvent);
                    return;
                }
                case 3: {
                    variableListener.allWatchesRemoved(watchEvent);
                }
            }
            ++n2;
        }
    }
}

