/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.event;

import com.ibm.iseries.debug.event.DebuggerEvent;
import com.ibm.iseries.debug.memory.MemoryAddress;

public class MemoryEvent
extends DebuggerEvent {
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int READ_ERROR = 3;
    public static final int WRITE_ERROR = 4;
    public static final int REFRESH = 5;
    public static final int READ_ONLY = 1;
    private MemoryAddress m_addr;
    private String m_exp;
    private String m_viewId;
    private int m_lineNum;
    private int m_byteCount;
    private String m_hexData;
    private String m_tags;
    private int m_dataFlags;
    private String m_errorMsg;

    public MemoryEvent(Object object, int n) {
        super(object, n);
    }

    public MemoryEvent(Object object, int n, MemoryAddress memoryAddress, String string, String string2, int n2) {
        super(object, n);
        this.m_addr = memoryAddress;
        this.m_byteCount = string.length() / 2;
        this.m_hexData = string;
        this.m_tags = string2;
        this.m_dataFlags = n2;
    }

    public MemoryEvent(Object object, int n, MemoryAddress memoryAddress, int n2) {
        super(object, n);
        this.m_addr = memoryAddress;
        this.m_byteCount = n2;
    }

    public MemoryEvent(Object object, int n, String string, String string2, int n2, String string3, String string4, int n3) {
        super(object, n);
        this.m_exp = string;
        this.m_viewId = string2;
        this.m_lineNum = n2;
        this.m_byteCount = string3.length() / 2;
        this.m_hexData = string3;
        this.m_tags = string4;
        this.m_dataFlags = n3;
    }

    public MemoryEvent(Object object, int n, String string, String string2, int n2, int n3) {
        super(object, n);
        this.m_exp = string;
        this.m_viewId = string2;
        this.m_lineNum = n2;
        this.m_byteCount = n3;
    }

    public boolean isHexAddress() {
        return this.m_exp == null;
    }

    public boolean isExpression() {
        return this.m_addr == null;
    }

    public MemoryAddress getAddress() {
        return this.m_addr;
    }

    public String getExpression() {
        return this.m_exp;
    }

    public String getViewId() {
        return this.m_viewId;
    }

    public int getLineNum() {
        return this.m_lineNum;
    }

    public String getHexData() {
        return this.m_hexData;
    }

    public int getByteCount() {
        return this.m_byteCount;
    }

    public String getTags() {
        return this.m_tags;
    }

    public int getDataFlags() {
        return this.m_dataFlags;
    }

    public boolean dataReadOnly() {
        return (this.m_dataFlags & 1) != 0;
    }

    public void setErrorMessage(String string) {
        this.m_errorMsg = string;
    }

    public String getErrorMessage() {
        return this.m_errorMsg;
    }

    public void cleanUp() {
        this.m_addr = null;
        this.m_exp = null;
        this.m_hexData = null;
        this.m_tags = null;
        this.m_errorMsg = null;
    }
}

