/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.dialog;

import com.ibm.iseries.debug.BreakpointSwatchIcon;
import com.ibm.iseries.debug.util.DialogTabPanel;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.accessibility.Accessible;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.plaf.ColorUIResource;

public class PreferencesColorsPage
extends DialogTabPanel
implements ActionListener {
    private static HashMap s_color = null;
    private static String[] s_colorName = null;
    private static String[] s_colorCategory = null;
    private static String[] s_colorAttribute = null;
    private static ColorUIResource[] s_fgDefault = null;
    private static ColorUIResource[] s_bgDefault = null;
    private static String[] s_fgDefaultName = null;
    private static String[] s_bgDefaultName = null;
    private Settings m_userCfg;
    private JPanel m_panel;
    private JPanel m_basePanel;
    private JComboBox m_category;
    private JComboBox m_fg;
    private JComboBox m_bg;
    private JLabel m_preview;
    private ColorUIResource[] m_fgColor;
    private ColorUIResource[] m_bgColor;
    private JButton m_restoreButton;
    private boolean m_modified;

    public PreferencesColorsPage(Settings settings) {
        super(MRI.get("DBG_COLORS"), 2);
        this.m_userCfg = settings;
        this.m_panel = new JPanel(new BorderLayout());
        this.m_panel.setBorder(this.getEmptyBorder(5, 5, 5, 5));
        this.m_fgColor = new ColorUIResource[s_fgDefault.length];
        this.m_bgColor = new ColorUIResource[s_bgDefault.length];
        int n = 0;
        while (n < s_colorAttribute.length) {
            this.m_fgColor[n] = this.m_userCfg.getColor(s_colorAttribute[n] + "Foreground", s_fgDefault[n]);
            this.m_bgColor[n] = this.m_userCfg.getColor(s_colorAttribute[n] + "Background", s_bgDefault[n]);
            ++n;
        }
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 3));
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 3));
        this.m_basePanel = new JPanel(new BorderLayout());
        this.m_basePanel.add((Component)jPanel, this.m_isLtoR ? "West" : "East");
        this.m_basePanel.add((Component)jPanel2, "Center");
        this.m_panel.add((Component)this.m_basePanel, "North");
        JLabel jLabel = Util.getAccessibleLabel(MRI.get("DBG_CATEGORY_LABEL"));
        JLabel jLabel2 = Util.getAccessibleLabel(MRI.get("DBG_FOREGROUND_LABEL"));
        JLabel jLabel3 = Util.getAccessibleLabel(MRI.get("DBG_BACKGROUND_LABEL"));
        JLabel jLabel4 = Util.getAccessibleLabel(MRI.get("DBG_PREVIEW_LABEL"));
        jPanel.setBorder(this.getEmptyBorder(0, 0, 0, 10));
        jPanel.add(jLabel);
        jPanel.add(new JLabel());
        jPanel.add(jLabel2);
        jPanel.add(jLabel3);
        jPanel.add(new JLabel());
        jPanel.add(jLabel4);
        this.m_category = new JComboBox();
        this.m_fg = new JComboBox();
        this.m_bg = new JComboBox();
        this.m_preview = Util.getAccessibleLabel(MRI.get("DBG_SAMPLE_TEXT"));
        this.m_preview.setOpaque(true);
        this.m_preview.setHorizontalAlignment(0);
        jPanel2.setBorder(this.getEmptyBorder(0, 10, 0, 0));
        jPanel2.add(this.m_category);
        jPanel2.add(new JLabel());
        jPanel2.add(this.m_fg);
        jPanel2.add(this.m_bg);
        jPanel2.add(new JLabel());
        jPanel2.add(this.m_preview);
        int n2 = 0;
        while (n2 < s_colorName.length) {
            this.m_fg.addItem(s_colorName[n2]);
            this.m_bg.addItem(s_colorName[n2]);
            ++n2;
        }
        this.m_category.setRenderer(new DummyRenderer());
        this.m_fg.setRenderer(new ComboRenderer());
        this.m_bg.setRenderer(new ComboRenderer());
        this.m_fg.setMaximumRowCount(s_colorName.length);
        this.m_bg.setMaximumRowCount(s_colorName.length);
        int n3 = 0;
        while (n3 < s_colorCategory.length) {
            this.m_category.addItem(s_colorCategory[n3]);
            ++n3;
        }
        this.m_category.setMaximumRowCount(s_colorCategory.length);
        this.m_category.addActionListener(this);
        this.m_category.setSelectedIndex(0);
        JPanel jPanel3 = new JPanel();
        String string = MRI.get("DBG_RESTORE_DEFAULTS");
        this.m_restoreButton = new JButton(string);
        this.m_restoreButton.addActionListener(this);
        jPanel3.setBorder(this.getEmptyBorder(40, 0, 0, 0));
        jPanel3.add(this.m_restoreButton);
        this.m_basePanel.add((Component)jPanel3, "South");
        Util.setAccessible((Accessible)this.m_category, jLabel);
        Util.setAccessible((Accessible)this.m_fg, jLabel2);
        Util.setAccessible((Accessible)this.m_bg, jLabel3);
        Util.setAccessible((Accessible)this.m_preview, jLabel4);
        Util.setAccessible((Accessible)this.m_restoreButton, string);
        Util.setOrientation(this.m_category, jLabel);
        Util.setOrientation(this.m_fg, jLabel2);
        Util.setOrientation(this.m_bg, jLabel3);
        Util.setOrientation(this.m_preview, jLabel4);
        Util.setOrientation(this.m_restoreButton);
    }

    public JComponent getComponent() {
        return this.m_panel;
    }

    public void cleanUp() {
        this.m_panel = null;
        this.m_basePanel = null;
        this.m_category = null;
        this.m_fg = null;
        this.m_bg = null;
        this.m_preview = null;
        this.m_fgColor = null;
        this.m_bgColor = null;
        this.m_restoreButton = null;
    }

    public boolean doOk() {
        if (this.m_modified) {
            int n = 0;
            while (n < s_colorAttribute.length) {
                if (!this.m_fgColor[n].equals(s_fgDefault[n])) {
                    this.m_userCfg.setColor(s_colorAttribute[n] + "Foreground", this.m_fgColor[n]);
                } else {
                    this.m_userCfg.remove(s_colorAttribute[n] + "Foreground");
                }
                if (!this.m_bgColor[n].equals(s_bgDefault[n])) {
                    this.m_userCfg.setColor(s_colorAttribute[n] + "Background", this.m_bgColor[n]);
                } else {
                    this.m_userCfg.remove(s_colorAttribute[n] + "Background");
                }
                ++n;
            }
        }
        return this.m_modified;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_category) {
            int n = this.m_category.getSelectedIndex();
            int n2 = 0;
            while (n2 < s_colorName.length) {
                ColorUIResource colorUIResource = (ColorUIResource)s_color.get(s_colorName[n2]);
                if (colorUIResource.equals(this.m_fgColor[n])) {
                    this.m_fg.removeActionListener(this);
                    this.m_fg.setSelectedIndex(n2);
                    this.m_fg.addActionListener(this);
                    this.m_preview.setForeground(colorUIResource);
                    break;
                }
                ++n2;
            }
            int n3 = 0;
            while (n3 < s_colorName.length) {
                ColorUIResource colorUIResource = (ColorUIResource)s_color.get(s_colorName[n3]);
                if (colorUIResource.equals(this.m_bgColor[n])) {
                    this.m_bg.removeActionListener(this);
                    this.m_bg.setSelectedIndex(n3);
                    this.m_bg.addActionListener(this);
                    this.m_preview.setBackground(colorUIResource);
                    break;
                }
                ++n3;
            }
        } else if (object == this.m_fg) {
            int n = this.m_category.getSelectedIndex();
            String string = (String)this.m_fg.getSelectedItem();
            this.m_fgColor[n] = (ColorUIResource)s_color.get(string);
            this.m_preview.setForeground(this.m_fgColor[n]);
            this.m_modified = true;
        } else if (object == this.m_bg) {
            int n = this.m_category.getSelectedIndex();
            String string = (String)this.m_bg.getSelectedItem();
            this.m_bgColor[n] = (ColorUIResource)s_color.get(string);
            this.m_preview.setBackground(this.m_bgColor[n]);
            this.m_modified = true;
        } else if (object == this.m_restoreButton) {
            int n = this.m_category.getSelectedIndex();
            this.m_fgColor[n] = s_fgDefault[n];
            this.m_bgColor[n] = s_bgDefault[n];
            this.m_fg.setSelectedItem(s_fgDefaultName[n]);
            this.m_bg.setSelectedItem(s_bgDefaultName[n]);
            this.m_preview.setForeground(this.m_fgColor[n]);
            this.m_preview.setBackground(this.m_bgColor[n]);
            this.m_modified = true;
        }
    }

    static {
        s_colorName = new String[13];
        PreferencesColorsPage.s_colorName[0] = MRI.get("DBG_BLACK");
        PreferencesColorsPage.s_colorName[1] = MRI.get("DBG_BLUE");
        PreferencesColorsPage.s_colorName[2] = MRI.get("DBG_CYAN");
        PreferencesColorsPage.s_colorName[3] = MRI.get("DBG_DARKGRAY");
        PreferencesColorsPage.s_colorName[4] = MRI.get("DBG_GRAY");
        PreferencesColorsPage.s_colorName[5] = MRI.get("DBG_GREEN");
        PreferencesColorsPage.s_colorName[6] = MRI.get("DBG_LIGHTGRAY");
        PreferencesColorsPage.s_colorName[7] = MRI.get("DBG_MAGENTA");
        PreferencesColorsPage.s_colorName[8] = MRI.get("DBG_ORANGE");
        PreferencesColorsPage.s_colorName[9] = MRI.get("DBG_PINK");
        PreferencesColorsPage.s_colorName[10] = MRI.get("DBG_RED");
        PreferencesColorsPage.s_colorName[11] = MRI.get("DBG_WHITE");
        PreferencesColorsPage.s_colorName[12] = MRI.get("DBG_YELLOW");
        s_color = new HashMap();
        s_color.put(s_colorName[0], new ColorUIResource(Color.black));
        s_color.put(s_colorName[1], new ColorUIResource(Color.blue));
        s_color.put(s_colorName[2], new ColorUIResource(Color.cyan));
        s_color.put(s_colorName[3], new ColorUIResource(Color.darkGray));
        s_color.put(s_colorName[4], new ColorUIResource(Color.gray));
        s_color.put(s_colorName[5], new ColorUIResource(Color.green));
        s_color.put(s_colorName[6], new ColorUIResource(Color.lightGray));
        s_color.put(s_colorName[7], new ColorUIResource(Color.magenta));
        s_color.put(s_colorName[8], new ColorUIResource(Color.orange));
        s_color.put(s_colorName[9], new ColorUIResource(Color.pink));
        s_color.put(s_colorName[10], new ColorUIResource(Color.red));
        s_color.put(s_colorName[11], new ColorUIResource(Color.white));
        s_color.put(s_colorName[12], new ColorUIResource(Color.yellow));
        s_colorCategory = new String[1];
        PreferencesColorsPage.s_colorCategory[0] = MRI.get("DBG_PGM_STOP_POSITION");
        s_colorAttribute = new String[1];
        PreferencesColorsPage.s_colorAttribute[0] = "srcStopPos";
        s_fgDefault = new ColorUIResource[1];
        s_fgDefaultName = new String[1];
        PreferencesColorsPage.s_fgDefault[0] = new ColorUIResource(Color.black);
        PreferencesColorsPage.s_fgDefaultName[0] = MRI.get("DBG_BLACK");
        s_bgDefault = new ColorUIResource[1];
        s_bgDefaultName = new String[1];
        PreferencesColorsPage.s_bgDefault[0] = new ColorUIResource(Color.yellow);
        PreferencesColorsPage.s_bgDefaultName[0] = MRI.get("DBG_YELLOW");
    }

    private class ComboRenderer
    extends DefaultListCellRenderer {
        private BreakpointSwatchIcon m_icon = null;

        public ComboRenderer() {
            int n = ((Component)PreferencesColorsPage.this.m_fg).getFontMetrics(PreferencesColorsPage.this.m_fg.getFont()).getHeight() - 4;
            this.m_icon = new BreakpointSwatchIcon(n);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object != null) {
                this.m_icon.setColor((ColorUIResource)s_color.get((String)object));
            }
            this.setIcon(this.m_icon);
            return this;
        }
    }

    private class DummyRenderer
    extends DefaultListCellRenderer {
    }
}

