/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.dialog;

import com.ibm.iseries.debug.util.Dialog;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.TabPanel;
import com.ibm.iseries.debug.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ColumnsDialog
extends Dialog
implements ListSelectionListener {
    private static final String BEFORE = "before";
    private static final String AFTER = "after";
    private static final String REMOVE = "remove";
    private TabPanel m_dbgPanel;
    private JPanel m_panel;
    private JPanel m_availablePanel;
    private JPanel m_buttonPanel;
    private JPanel m_selectedPanel;
    private JList m_availableList;
    private JList m_selectedList;
    private JButton m_addBefore;
    private JButton m_addAfter;
    private JButton m_remove;
    private ArrayList m_available;
    private ArrayList m_selected;
    private boolean m_modified;

    public ColumnsDialog(TabPanel tabPanel) {
        super(tabPanel.getContext().getJFrame(), MRI.get("DBG_COLUMNS_DIALOG_TITLE"), true, "dbgcolumns");
        this.m_dbgPanel = tabPanel;
        this.m_panel = new JPanel(new BorderLayout());
        this.m_availablePanel = new JPanel();
        this.m_buttonPanel = new JPanel();
        this.m_selectedPanel = new JPanel();
        this.m_availablePanel.setLayout(new BoxLayout(this.m_availablePanel, 1));
        this.m_buttonPanel.setLayout(new BoxLayout(this.m_buttonPanel, 1));
        this.m_selectedPanel.setLayout(new BoxLayout(this.m_selectedPanel, 1));
        this.m_panel.setBorder(this.getEmptyBorder(15, 15, 15, 15));
        this.m_availablePanel.setBorder(this.getEmptyBorder(10, 10, 10, 10));
        this.m_buttonPanel.setBorder(this.getEmptyBorder(50, 10, 10, 10));
        this.m_selectedPanel.setBorder(this.getEmptyBorder(10, 10, 10, 10));
        this.m_panel.add((Component)this.m_availablePanel, this.m_isLtoR ? "West" : "East");
        this.m_panel.add((Component)this.m_buttonPanel, "Center");
        this.m_panel.add((Component)this.m_selectedPanel, this.m_isLtoR ? "East" : "West");
        this.m_panel.add((Component)this.defaultButtons(MRI.get("DBG_OK")), "South");
        this.setContentPane(this.m_panel);
        this.addComponents();
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_dbgPanel = null;
        this.m_panel = null;
        this.m_availablePanel = null;
        this.m_buttonPanel = null;
        this.m_selectedPanel = null;
        this.m_availableList = null;
        this.m_selectedList = null;
        this.m_addBefore = null;
        this.m_addAfter = null;
        this.m_remove = null;
        this.m_available = null;
        this.m_selected = null;
    }

    private void addComponents() {
        this.listenForEscape(this.m_panel);
        this.m_available = this.m_dbgPanel.getAvailableColumns();
        Collections.sort(this.m_available);
        JLabel jLabel = Util.getAccessibleLabel(MRI.get("DBG_COLUMNS_AVAILABLE_LABEL"));
        this.m_availableList = new JList(new Vector(this.m_available));
        this.m_availableList.setSelectionMode(0);
        this.m_availableList.getSelectionModel().addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.m_availableList);
        jScrollPane.setPreferredSize(new Dimension(200, 250));
        jScrollPane.setMinimumSize(new Dimension(200, 250));
        jScrollPane.setAlignmentX(this.m_isLtoR ? 0.0f : 1.0f);
        jLabel.setAlignmentX(this.m_isLtoR ? 0.0f : 1.0f);
        this.m_availablePanel.add(jLabel);
        this.m_availablePanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.m_availablePanel.add(jScrollPane);
        JLabel jLabel2 = Util.getAccessibleLabel(MRI.get("DBG_COLUMNS_SELECTED_LABEL"));
        this.m_selected = this.m_dbgPanel.getCurrentColumns();
        this.m_selectedList = new JList(new Vector(this.m_selected));
        this.m_selectedList.setSelectionMode(0);
        this.m_selectedList.getSelectionModel().addListSelectionListener(this);
        JScrollPane jScrollPane2 = new JScrollPane(this.m_selectedList);
        jScrollPane2.setPreferredSize(new Dimension(200, 250));
        jScrollPane2.setMinimumSize(new Dimension(200, 250));
        jScrollPane2.setAlignmentX(this.m_isLtoR ? 0.0f : 1.0f);
        jLabel2.setAlignmentX(this.m_isLtoR ? 0.0f : 1.0f);
        this.m_selectedPanel.add(jLabel2);
        this.m_selectedPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.m_selectedPanel.add(jScrollPane2);
        String string = MRI.get("DBG_ADD_BEFORE_BUTTON");
        String string2 = MRI.get("DBG_ADD_AFTER_BUTTON");
        String string3 = MRI.get("DBG_REMOVE_BUTTON");
        this.m_addBefore = new JButton(string);
        this.m_addBefore.setEnabled(false);
        this.m_addBefore.setActionCommand(BEFORE);
        this.m_addBefore.addActionListener(this);
        this.m_addAfter = new JButton(string2);
        this.m_addAfter.setEnabled(false);
        this.m_addAfter.setActionCommand(AFTER);
        this.m_addAfter.addActionListener(this);
        this.m_remove = new JButton(string3);
        this.m_remove.setEnabled(false);
        this.m_remove.setActionCommand(REMOVE);
        this.m_remove.addActionListener(this);
        Dimension dimension = this.m_addBefore.getMaximumSize();
        Dimension dimension2 = this.m_addAfter.getMaximumSize();
        Dimension dimension3 = this.m_remove.getMaximumSize();
        if (dimension.width < dimension2.width) {
            dimension.width = dimension2.width;
        }
        if (dimension.width < dimension3.width) {
            dimension.width = dimension3.width;
        }
        this.m_addBefore.setMaximumSize(dimension);
        this.m_addAfter.setMaximumSize(dimension);
        this.m_remove.setMaximumSize(dimension);
        this.m_buttonPanel.add(this.m_addBefore);
        this.m_buttonPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.m_buttonPanel.add(this.m_addAfter);
        this.m_buttonPanel.add(Box.createRigidArea(new Dimension(0, 20)));
        this.m_buttonPanel.add(this.m_remove);
        Util.setAccessible((Accessible)this.m_availableList, jLabel);
        Util.setAccessible((Accessible)this.m_selectedList, jLabel2);
        Util.setAccessible((Accessible)this.m_addAfter, string2);
        Util.setAccessible((Accessible)this.m_addBefore, string);
        Util.setAccessible((Accessible)this.m_remove, string3);
        Util.setOrientation(this.m_availableList, jLabel);
        Util.setOrientation(this.m_selectedList, jLabel2);
        Util.setOrientation(this.m_addAfter);
        Util.setOrientation(this.m_addBefore);
        Util.setOrientation(this.m_remove);
    }

    public void doOk() {
        if (this.m_selected.size() == 0) {
            this.getToolkit().beep();
            Util.errorMessage(this, MRI.get("DBG_ERROR"), MRI.get("DBG_NO_ITEMS_SELECTED_ERROR"));
            return;
        }
        if (this.m_modified) {
            this.m_dbgPanel.setCurrentColumns(this.m_selected);
        }
        this.setCanceled(false);
        this.dispose();
    }

    private void doAddBefore(int n) {
        int n2 = this.m_availableList.getSelectedIndex();
        int n3 = this.m_selectedList.getSelectedIndex();
        if (n2 >= 0) {
            String string = (String)this.m_available.get(n2);
            this.m_available.remove(n2);
            this.m_availableList.setListData(new Vector(this.m_available));
            int n4 = this.m_availableList.getModel().getSize();
            if (n4 > 0) {
                if (n2 < n4) {
                    this.m_availableList.setSelectedIndex(n2);
                } else {
                    this.m_availableList.setSelectedIndex(n2 - 1);
                }
            }
            if (n3 >= 0) {
                this.m_selected.add(n3 + n, string);
                this.m_selectedList.setListData(new Vector(this.m_selected));
                this.m_selectedList.setSelectedIndex(n3 + n);
            } else {
                this.m_selected.add(string);
                this.m_selectedList.setListData(new Vector(this.m_selected));
                this.m_selectedList.setSelectedValue(string, true);
            }
            this.m_availableList.repaint(this.m_availableList.getVisibleRect());
            this.m_selectedList.repaint(this.m_selectedList.getVisibleRect());
            this.redoButtonEnablement();
            this.m_modified = true;
        }
    }

    private void doAddAfter() {
        this.doAddBefore(1);
    }

    private void doRemove() {
        int n = this.m_selectedList.getSelectedIndex();
        if (n >= 0) {
            String string = (String)this.m_selected.get(n);
            this.m_selected.remove(n);
            this.m_selectedList.setListData(new Vector(this.m_selected));
            int n2 = Collections.binarySearch(this.m_available, string);
            if (n2 < 0) {
                n2 = n2 * -1 - 1;
            }
            this.m_available.add(n2, string);
            this.m_availableList.setListData(new Vector(this.m_available));
            this.m_availableList.setSelectedIndex(n2);
            int n3 = this.m_selectedList.getModel().getSize();
            if (n3 > 0) {
                if (n < n3) {
                    this.m_selectedList.setSelectedIndex(n);
                } else {
                    this.m_selectedList.setSelectedIndex(n - 1);
                }
            }
            this.m_availableList.repaint(this.m_availableList.getVisibleRect());
            this.m_selectedList.repaint(this.m_selectedList.getVisibleRect());
            this.redoButtonEnablement();
            this.m_modified = true;
        }
    }

    private void redoButtonEnablement() {
        boolean bl = this.m_availableList.getModel().getSize() > 0 && this.m_availableList.getSelectedIndex() >= 0;
        this.m_addBefore.setEnabled(bl);
        this.m_addAfter.setEnabled(bl);
        bl = this.m_selectedList.getModel().getSize() > 0 && this.m_selectedList.getSelectedIndex() >= 0;
        this.m_remove.setEnabled(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        String string = actionEvent.getActionCommand();
        if (string.equals("doit")) {
            this.doOk();
        } else if (string.equals(BEFORE)) {
            this.doAddBefore(0);
        } else if (string.equals(AFTER)) {
            this.doAddAfter();
        } else if (string.equals(REMOVE)) {
            this.doRemove();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.redoButtonEnablement();
    }
}

