/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.dialog;

import com.ibm.iseries.debug.BreakpointDescriptor;
import com.ibm.iseries.debug.BreakpointGroup;
import com.ibm.iseries.debug.BreakpointSwatchIcon;
import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.PgmDescriptor;
import com.ibm.iseries.debug.manager.BreakpointGroupManager;
import com.ibm.iseries.debug.manager.PgmManager;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.Dialog;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.accessibility.Accessible;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class BreakpointDialog
extends Dialog
implements DebugConstants {
    private static final String CONDITION = "cond";
    private static final String USER = "user";
    private static final String STYLE = "style";
    private DebugContext m_ctxt;
    private JPanel m_panel;
    private JPanel m_basePanel;
    private JPanel m_labelPanel;
    private JPanel m_ctrlPanel;
    private JLabel m_styleLabel;
    private JComboBox m_styleCtrl;
    private JComboBox m_groupCtrl;
    private JLabel m_conditionLabel;
    private JTextField m_conditionCtrl;
    private JLabel m_threadLabel;
    private JComboBox m_threadCtrl;
    private JLabel m_userLabel;
    private JTextField m_userCtrl;
    private BreakpointDescriptor m_descriptor;
    private boolean m_svcEntryPtSupported;
    private int m_origStyle;
    private int m_style;

    public BreakpointDialog(DebugContext debugContext, String string, BreakpointDescriptor breakpointDescriptor) {
        super(debugContext.getJFrame(), string, true, "dbgbrkprop");
        this.m_ctxt = debugContext;
        this.m_descriptor = breakpointDescriptor;
        this.m_style = this.m_origStyle = this.m_descriptor.getStyle();
        this.m_panel = new JPanel(new BorderLayout());
        this.m_basePanel = new JPanel(new BorderLayout());
        this.m_labelPanel = new JPanel(new GridLayout(0, 1, 0, 3));
        this.m_ctrlPanel = new JPanel(new GridLayout(0, 1, 0, 3));
        this.m_panel.setBorder(this.getEmptyBorder(15, 15, 15, 15));
        this.m_labelPanel.setBorder(this.getEmptyBorder(10, 10, 10, 10));
        this.m_ctrlPanel.setBorder(this.getEmptyBorder(10, 10, 10, 10));
        this.m_basePanel.add((Component)this.m_labelPanel, this.m_isLtoR ? "West" : "East");
        this.m_basePanel.add((Component)this.m_ctrlPanel, "Center");
        this.m_panel.add((Component)this.m_basePanel, "North");
        this.m_panel.add((Component)this.defaultButtons(MRI.get("DBG_OK")), "South");
        this.setContentPane(this.m_panel);
        this.m_svcEntryPtSupported = this.m_ctxt.isSupported(5, this.m_ctxt.getSystemVersion());
        this.addComponents();
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_ctxt = null;
        this.m_panel = null;
        this.m_basePanel = null;
        this.m_labelPanel = null;
        this.m_ctrlPanel = null;
        this.m_styleLabel = null;
        this.m_styleCtrl = null;
        this.m_groupCtrl = null;
        this.m_conditionLabel = null;
        this.m_conditionCtrl = null;
        this.m_threadLabel = null;
        this.m_threadCtrl = null;
        this.m_userLabel = null;
        this.m_userCtrl = null;
        this.m_descriptor = null;
    }

    private void addComponents() {
        Object object;
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        JLabel jLabel4;
        this.listenForEscape(this.m_panel);
        PgmManager pgmManager = (PgmManager)this.m_ctxt.getManager("pgmmgr");
        PgmDescriptor pgmDescriptor = pgmManager.getProgram(this.m_descriptor.getViewId());
        JLabel jLabel5 = Util.getAccessibleLabel(MRI.get("DBG_BREAKPOINT_LABEL"));
        JLabel jLabel6 = Util.getAccessibleLabel(MRI.get("DBG_BREAKPOINT_GROUP_LABEL"));
        this.m_conditionLabel = Util.getAccessibleLabel(MRI.get("DBG_CONDITION_LABEL"));
        this.m_threadLabel = Util.getAccessibleLabel(MRI.get("DBG_THREAD_LABEL"));
        if (this.m_svcEntryPtSupported) {
            this.m_styleLabel = Util.getAccessibleLabel(MRI.get("DBG_BREAKPOINT_STYLE_LABEL"));
            this.m_userLabel = Util.getAccessibleLabel(MRI.get("DBG_USER_LABEL"));
        }
        if (!pgmDescriptor.isJavaClass()) {
            jLabel4 = Util.getAccessibleLabel(MRI.get("DBG_PROGRAM_LABEL"));
            jLabel3 = Util.getAccessibleLabel(MRI.get("DBG_MODULE_LABEL"));
            jLabel2 = Util.getAccessibleLabel(pgmDescriptor.getPgmPath());
            jLabel = Util.getAccessibleLabel(pgmManager.getModuleName(this.m_descriptor.getViewId()));
        } else {
            jLabel4 = Util.getAccessibleLabel(MRI.get("DBG_PACKAGE_LABEL"));
            jLabel3 = Util.getAccessibleLabel(MRI.get("DBG_CLASS_NAME_LABEL"));
            jLabel2 = Util.getAccessibleLabel(pgmDescriptor.getPgmLibrary());
            jLabel = Util.getAccessibleLabel(pgmDescriptor.getPgmName());
        }
        this.m_labelPanel.add(jLabel4);
        this.m_labelPanel.add(jLabel3);
        this.m_labelPanel.add(jLabel5);
        this.m_labelPanel.add(jLabel6);
        if (this.m_svcEntryPtSupported) {
            this.m_labelPanel.add(this.m_styleLabel);
            if (this.m_descriptor.isDefaultStyle()) {
                this.m_labelPanel.add(this.m_conditionLabel);
                this.m_labelPanel.add(this.m_threadLabel);
            } else {
                this.m_labelPanel.add(this.m_userLabel);
            }
        } else {
            this.m_labelPanel.add(this.m_conditionLabel);
            this.m_labelPanel.add(this.m_threadLabel);
        }
        BreakpointGroupManager breakpointGroupManager = (BreakpointGroupManager)this.m_ctxt.getManager("brkgrpmgr");
        BreakpointGroup breakpointGroup = breakpointGroupManager.getGroup(this.m_descriptor.getGroupId());
        ArrayList arrayList = breakpointGroupManager.getGroups();
        int n = arrayList.size();
        JLabel jLabel7 = Util.getAccessibleLabel(this.m_descriptor.toString());
        if (this.m_svcEntryPtSupported) {
            this.m_styleCtrl = new JComboBox();
            this.m_styleCtrl.setRenderer(new DummyRenderer());
            this.m_styleCtrl.addItem(MRI.get("DBG_DEFAULT"));
            this.m_styleCtrl.addItem(MRI.get("DBG_SERVICE_ENTRY_POINT"));
            this.m_styleCtrl.setSelectedIndex(this.m_style);
            this.m_styleCtrl.setActionCommand(STYLE);
            this.m_styleCtrl.addActionListener(this);
            this.m_userCtrl = new JTextField(this.m_style == 1 ? this.m_descriptor.getUser() : Util.firstUpper(this.m_ctxt.getUser()));
            this.m_userCtrl.setActionCommand(USER);
            this.m_userCtrl.addActionListener(this);
        }
        this.m_groupCtrl = new JComboBox();
        this.m_groupCtrl.setRenderer(new ComboRenderer());
        this.m_groupCtrl.setMaximumRowCount(n > 20 ? 20 : n);
        int n2 = 0;
        while (n2 < n) {
            object = (BreakpointGroup)arrayList.get(n2);
            this.m_groupCtrl.addItem(((BreakpointGroup)object).getGroupName());
            ++n2;
        }
        this.m_groupCtrl.setSelectedItem(breakpointGroup.getGroupName());
        this.m_conditionCtrl = new JTextField(this.m_descriptor.getCondition());
        this.m_conditionCtrl.setActionCommand(CONDITION);
        this.m_conditionCtrl.addActionListener(this);
        object = this.m_descriptor.getThreadId();
        this.m_threadCtrl = new JComboBox();
        this.m_threadCtrl.setRenderer(new DummyRenderer());
        this.m_threadCtrl.addItem(MRI.get("DBG_APPLY_TO_ALL_THREADS"));
        this.m_threadCtrl.addItem(MRI.get("DBG_APPLY_TO_CURRENT_THREAD"));
        if (((String)object).length() > 0) {
            Object[] objectArray = new Object[]{object};
            String string = MessageFormat.format(MRI.get("DBG_APPLY_TO_THREAD_FMT"), objectArray);
            this.m_threadCtrl.addItem(string);
            this.m_threadCtrl.setSelectedIndex(2);
        } else {
            this.m_threadCtrl.setSelectedIndex(0);
        }
        this.m_ctrlPanel.add(jLabel2);
        this.m_ctrlPanel.add(jLabel);
        this.m_ctrlPanel.add(jLabel7);
        this.m_ctrlPanel.add(this.m_groupCtrl);
        if (this.m_svcEntryPtSupported) {
            this.m_ctrlPanel.add(this.m_styleCtrl);
            if (this.m_descriptor.isDefaultStyle()) {
                this.m_ctrlPanel.add(this.m_conditionCtrl);
                this.m_ctrlPanel.add(this.m_threadCtrl);
            } else {
                this.m_ctrlPanel.add(this.m_userCtrl);
            }
        } else {
            this.m_ctrlPanel.add(this.m_conditionCtrl);
            this.m_ctrlPanel.add(this.m_threadCtrl);
        }
        Util.setAccessible((Accessible)jLabel2, jLabel4);
        Util.setAccessible((Accessible)jLabel, jLabel3);
        Util.setAccessible((Accessible)jLabel7, jLabel5);
        Util.setAccessible((Accessible)this.m_groupCtrl, jLabel6);
        Util.setAccessible((Accessible)this.m_conditionCtrl, this.m_conditionLabel);
        Util.setAccessible((Accessible)this.m_threadCtrl, this.m_threadLabel);
        if (this.m_svcEntryPtSupported) {
            Util.setAccessible((Accessible)this.m_styleCtrl, this.m_styleLabel);
            Util.setAccessible((Accessible)this.m_userCtrl, this.m_userLabel);
        }
        Util.setOrientation(jLabel2, jLabel4);
        Util.setOrientation(jLabel, jLabel3);
        Util.setOrientation(jLabel7, jLabel5);
        Util.setOrientation(this.m_groupCtrl, jLabel6);
        Util.setOrientation(this.m_conditionCtrl, this.m_conditionLabel);
        Util.setOrientation(this.m_threadCtrl, this.m_threadLabel);
        if (this.m_svcEntryPtSupported) {
            Util.setOrientation(this.m_styleCtrl, this.m_styleLabel);
            Util.setOrientation(this.m_userCtrl, this.m_userLabel);
        }
    }

    public void doOk() {
        Object object;
        BreakpointGroupManager breakpointGroupManager = (BreakpointGroupManager)this.m_ctxt.getManager("brkgrpmgr");
        BreakpointGroup breakpointGroup = breakpointGroupManager.getGroup(this.m_descriptor.getGroupId());
        String string = (String)this.m_groupCtrl.getSelectedItem();
        String string2 = this.m_conditionCtrl.getText().trim();
        int n = this.m_threadCtrl.getSelectedIndex();
        String string3 = null;
        BreakpointDescriptor breakpointDescriptor = null;
        if (!string.equals(breakpointGroup.getGroupName())) {
            BreakpointGroup breakpointGroup2 = breakpointGroupManager.getGroup(string);
            object = new ArrayList<BreakpointDescriptor>();
            ((ArrayList)object).add(this.m_descriptor);
            breakpointGroupManager.moveBreakpoints(breakpointGroup.getGroupId(), breakpointGroup2.getGroupId(), (ArrayList)object);
        }
        switch (n) {
            case 0: {
                string3 = "";
                break;
            }
            case 1: {
                string3 = "*CURRENT";
                break;
            }
            case 2: {
                string3 = this.m_descriptor.getThreadId();
            }
        }
        boolean bl = true;
        switch (this.m_style) {
            case 0: {
                if (this.m_style != this.m_origStyle) {
                    breakpointDescriptor = new BreakpointDescriptor(this.m_descriptor);
                    breakpointDescriptor.setStyle(this.m_style);
                    breakpointDescriptor.setCondition(string2);
                    breakpointDescriptor.setThreadId(string3);
                    breakpointDescriptor.setUser("");
                    break;
                }
                if (!string2.equals(this.m_descriptor.getCondition()) || !string3.equals(this.m_descriptor.getThreadId())) {
                    breakpointDescriptor = new BreakpointDescriptor(this.m_descriptor);
                    breakpointDescriptor.setCondition(string2);
                    breakpointDescriptor.setThreadId(string3);
                    break;
                }
                bl = false;
                break;
            }
            case 1: {
                object = this.m_userCtrl.getText().trim();
                if (((String)object).length() == 0) {
                    object = this.m_ctxt.getUser();
                }
                if (this.m_style != this.m_origStyle) {
                    breakpointDescriptor = new BreakpointDescriptor(this.m_descriptor);
                    breakpointDescriptor.setStyle(this.m_style);
                    breakpointDescriptor.setCondition("");
                    breakpointDescriptor.setThreadId("");
                    breakpointDescriptor.setUser((String)object);
                    break;
                }
                if (!((String)object).equals(this.m_descriptor.getUser())) {
                    breakpointDescriptor = new BreakpointDescriptor(this.m_descriptor);
                    breakpointDescriptor.setUser((String)object);
                    break;
                }
                bl = false;
            }
        }
        if (bl) {
            this.m_ctxt.getActionGroup().setLnBrkContext(breakpointDescriptor.getViewId(), breakpointDescriptor.getLineNum(), breakpointDescriptor);
            switch (this.m_descriptor.getState()) {
                case 1: {
                    this.m_ctxt.getAction("ebrk").run();
                    break;
                }
                case 2: {
                    this.m_ctxt.getAction("dbrk").run();
                }
            }
        }
        this.setCanceled(false);
        this.dispose();
    }

    private void doStyle() {
        int n = this.m_styleCtrl.getSelectedIndex();
        if (this.m_style != n) {
            this.m_style = n;
            switch (this.m_style) {
                case 0: {
                    this.m_labelPanel.remove(this.m_userLabel);
                    this.m_ctrlPanel.remove(this.m_userCtrl);
                    this.m_labelPanel.add(this.m_conditionLabel);
                    this.m_labelPanel.add(this.m_threadLabel);
                    this.m_ctrlPanel.add(this.m_conditionCtrl);
                    this.m_ctrlPanel.add(this.m_threadCtrl);
                    this.m_conditionCtrl.requestFocus();
                    break;
                }
                case 1: {
                    this.m_labelPanel.remove(this.m_conditionLabel);
                    this.m_labelPanel.remove(this.m_threadLabel);
                    this.m_ctrlPanel.remove(this.m_conditionCtrl);
                    this.m_ctrlPanel.remove(this.m_threadCtrl);
                    this.m_labelPanel.add(this.m_userLabel);
                    this.m_ctrlPanel.add(this.m_userCtrl);
                    this.m_userCtrl.requestFocus();
                }
            }
            this.pack();
            this.m_panel.repaint(this.m_panel.getVisibleRect());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        String string = actionEvent.getActionCommand();
        if (string.equals("doit") || string.equals(CONDITION) || string.equals(USER)) {
            this.doOk();
        } else if (string.equals(STYLE)) {
            this.doStyle();
        }
    }

    private class ComboRenderer
    extends DefaultListCellRenderer {
        private BreakpointSwatchIcon m_icon = null;

        public ComboRenderer() {
            int n = ((Component)BreakpointDialog.this.m_groupCtrl).getFontMetrics(BreakpointDialog.this.m_groupCtrl.getFont()).getHeight() - 4;
            this.m_icon = new BreakpointSwatchIcon(n);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object != null) {
                BreakpointGroupManager breakpointGroupManager = (BreakpointGroupManager)BreakpointDialog.this.m_ctxt.getManager("brkgrpmgr");
                this.m_icon.setColor(breakpointGroupManager.getGroupColor((String)object));
            }
            this.setIcon(this.m_icon);
            return this;
        }
    }

    private class DummyRenderer
    extends DefaultListCellRenderer {
    }
}

