/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.action;

import com.ibm.iseries.debug.VariableDescriptor;
import com.ibm.iseries.debug.ViewDescriptor;
import com.ibm.iseries.debug.manager.PgmManager;
import com.ibm.iseries.debug.memory.MemoryAddress;
import com.ibm.iseries.debug.panel.MemoryAddrPanel;
import com.ibm.iseries.debug.panel.MemoryExpPanel;
import com.ibm.iseries.debug.util.Action;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.TabPanel;

public class GotoMemAction
extends Action {
    public GotoMemAction() {
        super("gotomem", MRI.get("DBG_GOTO_MEMORY_MENU"), 72, 2, false);
    }

    public boolean isSupported(double d) {
        return this.m_ctxt.isSupported(2, d);
    }

    public void setSupported(double d) {
        this.setSupported(this.isSupported(d));
        this.setEnabled(this.isDefaultEnabled());
    }

    public void run() {
        TabPanel tabPanel = this.m_ctxt.getActivePanel();
        if (tabPanel != null) {
            String string = tabPanel.getKey();
            if (string.equals("locals") || string.equals("monitors")) {
                this.GotoMemoryFromVariable();
            } else if (tabPanel instanceof MemoryAddrPanel) {
                this.GotoMemoryFromMemory((MemoryAddrPanel)tabPanel);
            } else {
                this.GotoMemoryFromAddress();
            }
        }
    }

    protected void GotoMemoryFromVariable() {
        VariableDescriptor variableDescriptor = (VariableDescriptor)this.m_ctxt.getActionGroup().m_var;
        if (variableDescriptor != null) {
            PgmManager pgmManager;
            ViewDescriptor viewDescriptor;
            MemoryExpPanel memoryExpPanel = (MemoryExpPanel)this.m_ctxt.getPanel("memory");
            memoryExpPanel.expose();
            String string = variableDescriptor.getEvalName();
            if ((variableDescriptor.isValidPtr() || variableDescriptor.isStringPtr()) && (viewDescriptor = (pgmManager = (PgmManager)this.m_ctxt.getManager("pgmmgr")).getView(variableDescriptor.getViewId())).isCorCPP()) {
                string = "*(" + string + ")";
            }
            memoryExpPanel.insertExpression(string, variableDescriptor.getViewId(), variableDescriptor.getLineNum());
            memoryExpPanel.requestMemory();
        }
    }

    protected void GotoMemoryFromMemory(MemoryAddrPanel memoryAddrPanel) {
        String string = memoryAddrPanel.getHexDataAtCursor(this.m_ctxt.getAddrSizeInBits() / 8);
        if (memoryAddrPanel != null && string != null) {
            MemoryAddress memoryAddress = new MemoryAddress(string);
            if (!memoryAddress.canAdd(memoryAddrPanel.getByteCount())) {
                memoryAddress = memoryAddress.setMax().subtract(memoryAddrPanel.getByteCount() - 1);
            }
            memoryAddrPanel.insertAddress(memoryAddress);
            memoryAddrPanel.requestMemory();
        }
    }

    protected void GotoMemoryFromAddress() {
        String string = this.m_ctxt.getActionGroup().m_address;
        if (string != null) {
            MemoryAddrPanel memoryAddrPanel = (MemoryAddrPanel)this.m_ctxt.getPanel("memory");
            memoryAddrPanel.expose();
            MemoryAddress memoryAddress = new MemoryAddress(string);
            if (!memoryAddress.canAdd(memoryAddrPanel.getByteCount())) {
                memoryAddress = memoryAddress.setMax().subtract(memoryAddrPanel.getByteCount() - 1);
            }
            memoryAddrPanel.insertAddress(memoryAddress);
            memoryAddrPanel.requestMemory();
        }
    }
}

