/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.ModuleDescriptor;
import com.ibm.iseries.debug.memory.MemoryAddress;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.RequestPacketElement;
import com.ibm.iseries.debug.util.Util;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;

public class PgmDescriptor
implements RequestPacketElement,
DebugConstants,
Comparable {
    private static final String UPPER_SLASH_QSYS_LIB_SLASH = "/QSYS.LIB/";
    private static final String FIRST_UPPER_SLASH_QSYS_LIB_SLASH = "/Qsys.lib/";
    private static final String UPPER_LIB_SLASH = ".LIB/";
    private static final String LOWER_LIB_SLASH = ".lib/";
    private static final String UPPER_QSYS = "QSYS";
    private static final String FIRST_UPPER_QSYS = "Qsys";
    private static final String UPPER_DOT_PGM = ".PGM";
    private static final String LOWER_DOT_PGM = ".pgm";
    private static final String UPPER_DOT_SRVPGM = ".SRVPGM";
    private static final String LOWER_DOT_SRVPGM = ".srvpgm";
    private String m_pgmPath;
    private String m_pgmLib;
    private String m_pgmName;
    private int m_pgmType;
    private String m_pgmParms;
    private MemoryAddress m_textAddr;
    private int m_textSize;
    private MemoryAddress m_dataAddr;
    private int m_dataSize;
    private ModuleDescriptor[] m_modules;

    public PgmDescriptor() {
        this("", "", -1, "");
    }

    public PgmDescriptor(String string, String string2, int n) {
        this(string, string2, n, "");
    }

    public PgmDescriptor(String string, String string2, int n, String string3) {
        this.m_pgmLib = string;
        this.m_pgmName = string2;
        this.m_pgmType = n;
        this.m_pgmPath = PgmDescriptor.getPgmPath(this.m_pgmLib, this.m_pgmName, this.m_pgmType);
        this.m_pgmParms = string3;
        this.m_modules = new ModuleDescriptor[0];
    }

    public PgmDescriptor(String string) {
        this(string, "");
    }

    public PgmDescriptor(String string, String string2) {
        if (string == null || string.length() == 0) {
            this.m_pgmLib = "";
            this.m_pgmName = "";
            this.m_pgmType = -1;
            this.m_pgmPath = "";
            this.m_pgmParms = string2;
            this.m_modules = new ModuleDescriptor[0];
            return;
        }
        String string3 = Util.upper(string);
        if (string3.startsWith(UPPER_SLASH_QSYS_LIB_SLASH)) {
            int n = string3.indexOf(UPPER_LIB_SLASH, 10);
            this.m_pgmLib = n > 10 ? Util.firstUpper(string3.substring(10, n)) : FIRST_UPPER_QSYS;
            int n2 = string.lastIndexOf(47);
            int n3 = string.lastIndexOf(46);
            this.m_pgmName = n2 > 0 && n3 > 0 ? Util.firstUpper(string3.substring(n2 + 1, n3)) : "";
            if (string3.endsWith(UPPER_DOT_PGM)) {
                this.m_pgmType = 0;
            } else if (string3.endsWith(UPPER_DOT_SRVPGM)) {
                this.m_pgmType = 1;
            }
        } else {
            int n = string.lastIndexOf(47);
            if (n == -1) {
                this.m_pgmType = 2;
                int n4 = string.lastIndexOf(46);
                if (n4 >= 0) {
                    this.m_pgmLib = string.substring(0, n4);
                    this.m_pgmName = string.substring(n4 + 1);
                } else {
                    this.m_pgmLib = "";
                    this.m_pgmName = string;
                }
            } else {
                this.m_pgmType = 10;
                this.m_pgmLib = string.substring(0, n);
                this.m_pgmName = string.substring(n + 1);
            }
        }
        this.m_pgmPath = PgmDescriptor.getPgmPath(this.m_pgmLib, this.m_pgmName, this.m_pgmType);
        this.m_pgmParms = string2;
        this.m_modules = new ModuleDescriptor[0];
    }

    public String toString() {
        return this.m_pgmPath;
    }

    public String toAddressBoundsString() {
        Object[] objectArray = new Object[]{this.m_pgmPath, this.m_textAddr.toString(), this.m_textAddr.add((this.m_textSize - 1) * 4).toString(), this.m_dataAddr.toString(), this.m_dataAddr.add((this.m_dataSize - 1) * 4).toString()};
        return MessageFormat.format(MRI.get("DBG_ADDR_BOUNDS_FMT"), objectArray);
    }

    public String getPgmPath() {
        return this.m_pgmPath;
    }

    public String getPgmLibrary() {
        return this.m_pgmLib;
    }

    public String getPgmName() {
        return this.m_pgmName;
    }

    public int getPgmType() {
        return this.m_pgmType;
    }

    public boolean isILE() {
        return this.m_pgmType == 0 || this.m_pgmType == 1 || this.m_pgmType == 2;
    }

    public boolean isPgm() {
        return this.m_pgmType == 0;
    }

    public boolean isSrvpgm() {
        return this.m_pgmType == 1;
    }

    public boolean isJavaClass() {
        return this.m_pgmType == 2;
    }

    public boolean isUnix() {
        return this.m_pgmType >= 10 && this.m_pgmType <= 19;
    }

    public boolean isUnixMainPgm() {
        return this.m_pgmType == 10;
    }

    public boolean isUnixSharedPgm() {
        return this.m_pgmType == 12;
    }

    public boolean isUnixPrivatePgm() {
        return this.m_pgmType == 11;
    }

    public String getPgmParms() {
        return this.m_pgmParms;
    }

    public void setPgmParms(String string) {
        this.m_pgmParms = string;
    }

    public boolean hasMain() {
        int n = 0;
        while (n < this.m_modules.length) {
            if (this.m_modules[n].hasMain()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public int getModuleCount() {
        return this.m_modules.length;
    }

    public ModuleDescriptor getModuleAt(int n) {
        return this.m_modules[n];
    }

    public PgmDescriptor merge(PgmDescriptor pgmDescriptor) {
        ArrayList<ModuleDescriptor> arrayList = new ArrayList<ModuleDescriptor>();
        int n = 0;
        while (n < this.m_modules.length) {
            arrayList.add(this.m_modules[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < pgmDescriptor.m_modules.length) {
            arrayList.add(pgmDescriptor.m_modules[n2]);
            ++n2;
        }
        Collections.sort(arrayList);
        int n3 = arrayList.size();
        this.m_modules = new ModuleDescriptor[n3];
        int n4 = 0;
        while (n4 < n3) {
            this.m_modules[n4] = (ModuleDescriptor)arrayList.get(n4);
            ++n4;
        }
        return this;
    }

    public static boolean isILEPgm(int n) {
        return n == 0 || n == 1 || n == 2;
    }

    public static boolean isUnixPgm(int n) {
        return n >= 10 && n <= 19;
    }

    public static String getPgmPath(String string, String string2, int n) {
        StringBuffer stringBuffer = new StringBuffer(100);
        if (n == 0 || n == 1) {
            stringBuffer.append(FIRST_UPPER_SLASH_QSYS_LIB_SLASH);
            if (!Util.upper(string).equals(UPPER_QSYS)) {
                stringBuffer.append(string + LOWER_LIB_SLASH);
            }
            stringBuffer.append(string2);
        }
        switch (n) {
            case 0: {
                stringBuffer.append(LOWER_DOT_PGM);
                break;
            }
            case 1: {
                stringBuffer.append(LOWER_DOT_SRVPGM);
                break;
            }
            case 2: {
                if (string.length() > 0) {
                    stringBuffer.append(string);
                    if (!string.endsWith(".")) {
                        stringBuffer.append('.');
                    }
                }
                stringBuffer.append(string2);
                break;
            }
            default: {
                if (string.length() > 0) {
                    stringBuffer.append(string);
                    if (!string.endsWith("/")) {
                        stringBuffer.append('/');
                    }
                }
                stringBuffer.append(string2);
            }
        }
        return stringBuffer.toString();
    }

    public static String getCompletePath(String string, String string2, int n, String string3) {
        StringBuffer stringBuffer = new StringBuffer(100);
        if (n == 0 || n == 1) {
            stringBuffer.append(FIRST_UPPER_SLASH_QSYS_LIB_SLASH);
            if (!Util.upper(string).equals(UPPER_QSYS)) {
                stringBuffer.append(string + LOWER_LIB_SLASH);
            }
            stringBuffer.append(string2);
        }
        switch (n) {
            case 0: {
                stringBuffer.append(LOWER_DOT_PGM);
                stringBuffer.append('/');
                stringBuffer.append(string3);
                break;
            }
            case 1: {
                stringBuffer.append(LOWER_DOT_SRVPGM);
                stringBuffer.append('/');
                stringBuffer.append(string3);
                break;
            }
            case 2: {
                if (string.length() > 0) {
                    stringBuffer.append(string);
                    if (!string.endsWith(".")) {
                        stringBuffer.append('.');
                    }
                }
                stringBuffer.append(string2);
                break;
            }
            default: {
                if (string.length() > 0) {
                    stringBuffer.append(string);
                    if (!string.endsWith("/")) {
                        stringBuffer.append('/');
                    }
                }
                stringBuffer.append(string2);
                if (string3 == null) break;
                stringBuffer.append(" - ");
                stringBuffer.append(string3);
            }
        }
        return stringBuffer.toString();
    }

    public void read(CommLink commLink) throws IOException {
        this.m_pgmLib = commLink.readString();
        this.m_pgmName = commLink.readString();
        this.m_pgmType = commLink.readInt();
        if (this.m_pgmType == 0 || this.m_pgmType == 1) {
            this.m_pgmLib = Util.firstUpper(this.m_pgmLib);
            this.m_pgmName = Util.firstUpper(this.m_pgmName);
        }
        this.m_pgmPath = PgmDescriptor.getPgmPath(this.m_pgmLib, this.m_pgmName, this.m_pgmType);
        if (this.isUnix()) {
            this.m_textAddr = new MemoryAddress(commLink.readString());
            this.m_textSize = commLink.readInt();
            this.m_dataAddr = new MemoryAddress(commLink.readString());
            this.m_dataSize = commLink.readInt();
        }
        int n = commLink.readInt();
        ArrayList<ModuleDescriptor> arrayList = new ArrayList<ModuleDescriptor>(n);
        int n2 = 0;
        while (n2 < n) {
            ModuleDescriptor moduleDescriptor = new ModuleDescriptor(this.m_pgmType);
            moduleDescriptor.read(commLink);
            arrayList.add(moduleDescriptor);
            ++n2;
        }
        Collections.sort(arrayList);
        this.m_modules = new ModuleDescriptor[n];
        int n3 = 0;
        while (n3 < n) {
            this.m_modules[n3] = (ModuleDescriptor)arrayList.get(n3);
            ++n3;
        }
        arrayList.clear();
    }

    public int writeSize(CommLink commLink) {
        int n = 0;
        n += commLink.writeSize(this.m_pgmLib);
        n += commLink.writeSize(this.m_pgmName);
        n += 4;
        if (this.isUnix()) {
            n += commLink.writeSize(this.m_textAddr.toString());
            n += 4;
            n += commLink.writeSize(this.m_dataAddr.toString());
            n += 4;
        }
        n += 4;
        int n2 = 0;
        while (n2 < this.m_modules.length) {
            n += this.m_modules[n2].writeSize(commLink);
            ++n2;
        }
        return n;
    }

    public void write(CommLink commLink) throws IOException {
        boolean bl = this.m_pgmType == 0 || this.m_pgmType == 1;
        commLink.writeString(bl ? Util.upper(this.m_pgmLib) : this.m_pgmLib);
        commLink.writeString(bl ? Util.upper(this.m_pgmName) : this.m_pgmName);
        commLink.writeInt(this.m_pgmType);
        if (this.isUnix()) {
            commLink.writeString(this.m_textAddr.toString());
            commLink.writeInt(this.m_textSize);
            commLink.writeString(this.m_dataAddr.toString());
            commLink.writeInt(this.m_dataSize);
        }
        commLink.writeInt(this.m_modules.length);
        int n = 0;
        while (n < this.m_modules.length) {
            this.m_modules[n].write(commLink);
            ++n;
        }
    }

    public int compareTo(Object object) {
        return this.m_pgmPath.compareTo(object.toString());
    }
}

