/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.PgmDescriptor;
import com.ibm.iseries.debug.ViewDescriptor;
import com.ibm.iseries.debug.memory.MemoryAddress;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.RequestPacketElement;
import com.ibm.iseries.debug.util.Util;
import java.io.IOException;
import java.text.MessageFormat;

public class ModuleDescriptor
implements RequestPacketElement,
DebugConstants,
Comparable {
    private String m_moduleName;
    private String m_moduleNameOverride;
    private ViewDescriptor[] m_views;
    private int m_currentView;
    private int m_parentPgmType;
    private boolean m_hasMain;
    private MemoryAddress m_textAddr;
    private int m_textSize;
    private MemoryAddress m_dataAddr;
    private int m_dataSize;

    public ModuleDescriptor(int n) {
        this.m_parentPgmType = n;
    }

    public String toString() {
        return this.m_moduleNameOverride != null ? this.m_moduleNameOverride : this.m_moduleName;
    }

    public String toAddressBoundsString() {
        Object[] objectArray = new Object[]{this.getModuleName(), this.m_textAddr.toString(), this.m_textAddr.add((this.m_textSize - 1) * 4).toString(), this.m_dataAddr.toString(), this.m_dataAddr.add((this.m_dataSize - 1) * 4).toString()};
        return MessageFormat.format(MRI.get("DBG_ADDR_BOUNDS_FMT"), objectArray);
    }

    public String getModuleName() {
        return this.m_moduleNameOverride != null ? this.m_moduleNameOverride : this.m_moduleName;
    }

    public String getTrueModuleName() {
        return this.m_moduleName;
    }

    public String getModuleNameOverride() {
        return this.m_moduleNameOverride;
    }

    public boolean hasMain() {
        return this.m_hasMain;
    }

    public boolean hasMain(int n) {
        if (n >= 0 && n < this.m_views.length) {
            return this.m_views[n].hasMain();
        }
        return false;
    }

    public MemoryAddress getStartAddress() {
        return this.m_textAddr;
    }

    public MemoryAddress getEndAddress() {
        return this.m_textAddr.add((this.m_textSize - 1) * 4);
    }

    public int getViewCount() {
        return this.m_views.length;
    }

    public int getCurrentViewIndex() {
        return this.m_currentView;
    }

    public ViewDescriptor getCurrentView() {
        return this.m_views[this.m_currentView];
    }

    public void setCurrentViewIndex(int n) {
        if (n >= 0 && n < this.m_views.length) {
            this.m_currentView = n;
        }
    }

    public void setCurrentView(String string) {
        int n = 0;
        while (n < this.m_views.length) {
            if (this.m_views[n].getViewId().equals(string)) {
                this.m_currentView = n;
                break;
            }
            ++n;
        }
    }

    public ViewDescriptor getViewAt(int n) {
        return this.m_views[n];
    }

    public ViewDescriptor getViewOfType(int n) {
        ViewDescriptor viewDescriptor = null;
        int n2 = 0;
        while (n2 < this.m_views.length) {
            if (this.m_views[n2].getViewType() == n) {
                viewDescriptor = this.m_views[n2];
                break;
            }
            ++n2;
        }
        return viewDescriptor;
    }

    public String getViewId() {
        return this.m_views[this.m_currentView].getViewId();
    }

    public String getViewId(int n) {
        return this.m_views[n].getViewId();
    }

    public int getViewType() {
        return this.m_views[this.m_currentView].getViewType();
    }

    public int getViewType(int n) {
        return this.m_views[n].getViewType();
    }

    public int getViewIndex(String string) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.m_views.length) {
            if (string.equals(this.m_views[n2].getViewId())) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    public void read(CommLink commLink) throws IOException {
        this.m_moduleName = commLink.readString();
        if (this.m_parentPgmType == 0 || this.m_parentPgmType == 1) {
            this.m_moduleName = Util.firstUpper(this.m_moduleName);
        }
        if (PgmDescriptor.isUnixPgm(this.m_parentPgmType)) {
            this.m_textAddr = new MemoryAddress(commLink.readString());
            this.m_textSize = commLink.readInt();
            this.m_dataAddr = new MemoryAddress(commLink.readString());
            this.m_dataSize = commLink.readInt();
            this.m_moduleNameOverride = commLink.readString();
        }
        int n = commLink.readInt();
        this.m_views = new ViewDescriptor[n];
        int n2 = 0;
        while (n2 < n) {
            this.m_views[n2] = new ViewDescriptor();
            this.m_views[n2].read(commLink);
            if (this.m_views[n2].hasMain()) {
                this.m_hasMain = true;
            }
            ++n2;
        }
    }

    public int writeSize(CommLink commLink) {
        int n = 0;
        n += commLink.writeSize(this.m_moduleName);
        if (PgmDescriptor.isUnixPgm(this.m_parentPgmType)) {
            n += commLink.writeSize(this.m_textAddr.toString());
            n += 4;
            n += commLink.writeSize(this.m_dataAddr.toString());
            n += 4;
            n += commLink.writeSize(this.m_moduleNameOverride == null ? "" : this.m_moduleNameOverride);
        }
        n += 4;
        int n2 = 0;
        while (n2 < this.m_views.length) {
            n += this.m_views[n2].writeSize(commLink);
            ++n2;
        }
        return n;
    }

    public void write(CommLink commLink) throws IOException {
        boolean bl = this.m_parentPgmType == 0 || this.m_parentPgmType == 1;
        commLink.writeString(bl ? Util.upper(this.m_moduleName) : this.m_moduleName);
        if (PgmDescriptor.isUnixPgm(this.m_parentPgmType)) {
            commLink.writeString(this.m_textAddr.toString());
            commLink.writeInt(this.m_textSize);
            commLink.writeString(this.m_dataAddr.toString());
            commLink.writeInt(this.m_dataSize);
            commLink.writeString(this.m_moduleNameOverride == null ? "" : this.m_moduleNameOverride);
        }
        commLink.writeInt(this.m_views.length);
        int n = 0;
        while (n < this.m_views.length) {
            this.m_views[n].write(commLink);
            ++n;
        }
    }

    public int compareTo(Object object) {
        return this.getModuleName().compareTo(object.toString());
    }
}

