/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;

public class BreakpointSwatchIcon
implements Icon {
    private int m_size = 0;
    private Color m_color = null;
    private boolean m_gradient = false;

    public BreakpointSwatchIcon(int n) {
        this.m_size = n;
    }

    public BreakpointSwatchIcon(int n, boolean bl) {
        this.m_size = n;
        this.m_gradient = bl;
    }

    public void setColor(Color color) {
        this.m_color = color;
    }

    public Color getColor() {
        return this.m_color;
    }

    public void setGradient(boolean bl) {
        this.m_gradient = bl;
    }

    public int getIconHeight() {
        return this.m_size;
    }

    public int getIconWidth() {
        return this.m_size;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.m_gradient) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Paint paint = graphics2D.getPaint();
            GradientPaint gradientPaint = new GradientPaint(n, n2, this.m_color, n + this.m_size, n2, Color.white);
            Rectangle2D.Double double_ = new Rectangle2D.Double(n, n2, this.m_size, this.m_size);
            graphics2D.setPaint(gradientPaint);
            graphics2D.fill(double_);
            graphics2D.setPaint(Color.darkGray);
            graphics2D.draw(double_);
            graphics2D.setPaint(paint);
        } else {
            Color color = graphics.getColor();
            graphics.setColor(this.m_color);
            graphics.fillRect(n, n2, this.m_size, this.m_size);
            graphics.setColor(Color.darkGray);
            graphics.drawRect(n, n2, this.m_size, this.m_size);
            graphics.setColor(color);
        }
    }
}

