/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.micro;

import com.ibm.as400.micro.JdbcMeException;
import com.ibm.as400.micro.JdbcMeOfflineData;
import com.ibm.as400.micro.JdbcMeResultSetMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;

public class JdbcMeOfflineResultSet
implements ResultSet {
    static final int dbEyeCatcher_ = 1245987395;
    private static final String hexDigits = "0123456789ABCDEF";
    private boolean imported_ = false;
    private int numColumns_ = 0;
    private int[] columnTypes_ = null;
    public static final int BEFORE_FIRST_ROW = -1;
    public static final int AFTER_LAST_ROW = -2;
    private int currentRSRow_ = -1;
    private int firstRowMIDPDBIndex_ = -1;
    private int lastRowMIDPDBIndex_ = -1;
    private JdbcMeOfflineData DB_;
    private String dbName_ = null;
    private int dbCreator_ = 0;
    private int dbType_ = 0;

    public JdbcMeOfflineResultSet(String string, int n, int n2) throws JdbcMeException {
        this.completeInitialization(string, n, n2);
    }

    public JdbcMeOfflineResultSet(String string, int n, int n2, int n3, int[] nArray) throws JdbcMeException {
        this.imported_ = true;
        this.numColumns_ = n3;
        this.columnTypes_ = new int[n3];
        System.arraycopy(this.columnTypes_, 0, this.columnTypes_, 0, this.numColumns_);
        this.completeInitialization(string, n, n2);
    }

    private void completeInitialization(String string, int n, int n2) throws JdbcMeException {
        this.dbName_ = string;
        this.dbCreator_ = n;
        this.dbType_ = n2;
        this.DB_ = JdbcMeOfflineData.open(string, n, n2, false);
        int n3 = this.DB_.size();
        if (this.imported_) {
            if (n3 % this.numColumns_ != 0) {
                throw new JdbcMeException("Offline DB NumRecords % numColumns != 0", null);
            }
            this.firstRowMIDPDBIndex_ = 0;
            this.lastRowMIDPDBIndex_ = n3 - 1;
            return;
        }
        byte[] byArray = null;
        if (n3 < 4) {
            throw new JdbcMeException("Invalid Offline DB, number of rows=" + n3, null);
        }
        byArray = this.DB_.getRecord(0);
        int n4 = 0;
        n4 |= byArray[0] << 24 & 0xFF000000;
        n4 |= byArray[1] << 16 & 0xFF0000;
        n4 |= byArray[2] << 8 & 0xFF00;
        if ((n4 |= byArray[3] << 0 & 0xFF) != 1245987395) {
            throw new JdbcMeException("Offline DB eyecatcher invalid:" + n4, null);
        }
        byArray = this.DB_.getRecord(1);
        n4 = 0;
        n4 |= byArray[0] << 24 & 0xFF000000;
        n4 |= byArray[1] << 16 & 0xFF0000;
        n4 |= byArray[2] << 8 & 0xFF00;
        int n5 = n4 |= byArray[3] << 0 & 0xFF;
        if (n5 != 1) {
            throw new JdbcMeException("Offline DB version " + n5 + "not supported", null);
        }
        byArray = this.DB_.getRecord(2);
        n4 = 0;
        n4 |= byArray[0] << 24 & 0xFF000000;
        n4 |= byArray[1] << 16 & 0xFF0000;
        n4 |= byArray[2] << 8 & 0xFF00;
        this.numColumns_ = n4 |= byArray[3] << 0 & 0xFF;
        this.columnTypes_ = new int[this.numColumns_];
        byArray = this.DB_.getRecord(3);
        for (int i = 0; i < this.numColumns_; ++i) {
            this.columnTypes_[i] = 0;
            int n6 = i;
            this.columnTypes_[n6] = this.columnTypes_[n6] | byArray[i * 4 + 0] << 24 & 0xFF000000;
            int n7 = i;
            this.columnTypes_[n7] = this.columnTypes_[n7] | byArray[i * 4 + 1] << 16 & 0xFF0000;
            int n8 = i;
            this.columnTypes_[n8] = this.columnTypes_[n8] | byArray[i * 4 + 2] << 8 & 0xFF00;
            int n9 = i;
            this.columnTypes_[n9] = this.columnTypes_[n9] | byArray[i * 4 + 3] << 0 & 0xFF;
        }
        this.firstRowMIDPDBIndex_ = 4;
        this.lastRowMIDPDBIndex_ = n3 - 1;
        if ((n3 - 4) % this.numColumns_ != 0) {
            throw new JdbcMeException("Offline DB DataRecords % numColumns != 0", null);
        }
    }

    public void close() throws JdbcMeException {
        this.columnTypes_ = null;
        this.currentRSRow_ = -1;
        if (this.DB_ != null) {
            this.DB_.close();
            this.DB_ = null;
        }
    }

    public void deleteRow() throws JdbcMeException {
        if (this.currentRSRow_ < 0) {
            throw new JdbcMeException("Not positioned on a row", null);
        }
        int n = this.firstRowMIDPDBIndex_ + this.numColumns_ * this.currentRSRow_;
        for (int i = 0; i < this.numColumns_; ++i) {
            this.DB_.deleteRecord(n);
        }
    }

    public String getString(int n) throws JdbcMeException {
        if (this.currentRSRow_ < 0) {
            throw new JdbcMeException("Not positioned on a row", null);
        }
        if (n < 1 || n > this.numColumns_) {
            throw new JdbcMeException("RS bad column " + n, null);
        }
        int n2 = this.firstRowMIDPDBIndex_ + this.numColumns_ * this.currentRSRow_;
        byte[] byArray = this.DB_.getRecord(n2 + (n - 1));
        String string = new String(byArray);
        return string;
    }

    public int getInt(int n) throws JdbcMeException {
        String string = this.getString(n);
        try {
            int n2 = Integer.parseInt(string);
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            throw new JdbcMeException("Incorrect conversion to int: " + string, null);
        }
    }

    public void insertRow() throws JdbcMeException {
        throw new JdbcMeException("unimplemented", null);
    }

    public void moveToInsertRow() throws JdbcMeException {
        throw new JdbcMeException("unimplemented", null);
    }

    public void moveToCurrentRow() throws JdbcMeException {
        throw new JdbcMeException("unimplemented", null);
    }

    public boolean next() throws JdbcMeException {
        return this.relative(1);
    }

    public boolean previous() throws JdbcMeException {
        return this.relative(-1);
    }

    public boolean relative(int n) throws JdbcMeException {
        int n2 = 0;
        if (this.lastRowMIDPDBIndex_ < this.firstRowMIDPDBIndex_) {
            return false;
        }
        if (this.currentRSRow_ == -1) {
            if (n <= 0) {
                return false;
            }
            if (this.firstRowMIDPDBIndex_ + (n2 = --n) * this.numColumns_ > this.lastRowMIDPDBIndex_) {
                this.currentRSRow_ = -2;
                return false;
            }
            this.currentRSRow_ = n2;
            return true;
        }
        if (this.currentRSRow_ == -2) {
            if (n >= 0) {
                return false;
            }
            if ((n2 = (this.lastRowMIDPDBIndex_ - this.firstRowMIDPDBIndex_) / this.numColumns_ + ++n) < 0) {
                this.currentRSRow_ = -1;
                return false;
            }
            this.currentRSRow_ = n2;
            return true;
        }
        n2 = this.currentRSRow_ + n;
        if (n2 < 0) {
            this.currentRSRow_ = -1;
            return false;
        }
        if (this.firstRowMIDPDBIndex_ + n2 * this.numColumns_ > this.lastRowMIDPDBIndex_) {
            this.currentRSRow_ = -2;
            return false;
        }
        this.currentRSRow_ = n2;
        return true;
    }

    public boolean first() throws JdbcMeException {
        return this.absolute(1);
    }

    public boolean last() throws JdbcMeException {
        return this.absolute(-1);
    }

    public boolean absolute(int n) throws JdbcMeException {
        int n2 = 0;
        if (n > 0) {
            if (this.firstRowMIDPDBIndex_ + (n2 = --n) * this.numColumns_ > this.lastRowMIDPDBIndex_) {
                this.currentRSRow_ = -2;
                return false;
            }
            this.currentRSRow_ = n2;
            return true;
        }
        if (n < 0) {
            if ((n2 = (this.lastRowMIDPDBIndex_ - this.firstRowMIDPDBIndex_) / this.numColumns_ + ++n) < 0) {
                this.currentRSRow_ = -1;
                return false;
            }
            this.currentRSRow_ = n2;
            return true;
        }
        throw new JdbcMeException("ResultSet position absolute 0", null);
    }

    public void updateString(int n, String string) throws JdbcMeException {
        if (this.currentRSRow_ < 0) {
            throw new JdbcMeException("Not positioned on a row", null);
        }
        if (n < 1 || n > this.numColumns_) {
            throw new JdbcMeException("RS bad column " + n, null);
        }
        int n2 = this.firstRowMIDPDBIndex_ + this.numColumns_ * this.currentRSRow_;
        byte[] byArray = string.getBytes();
        this.DB_.setRecord(n2 + (n - 1), byArray, 0, byArray.length);
        this.DB_.close();
        this.DB_ = null;
        this.DB_ = JdbcMeOfflineData.open(this.dbName_, this.dbCreator_, this.dbType_, false);
    }

    public void updateInt(int n, int n2) throws JdbcMeException {
        this.updateString(n, Integer.toString(n2));
    }

    public void updateRow() throws JdbcMeException {
    }

    public ResultSetMetaData getMetaData() throws JdbcMeException {
        return new JdbcMeResultSetMetaData(this.numColumns_, this.columnTypes_);
    }

    public Statement getStatement() throws JdbcMeException {
        return null;
    }

    public void dumpDB(boolean bl) throws JdbcMeException {
        this.dumpDB(null, bl);
    }

    public void dumpDB(JdbcMeOfflineData jdbcMeOfflineData, boolean bl) throws JdbcMeException {
        if (jdbcMeOfflineData == null) {
            jdbcMeOfflineData = this.DB_;
        }
        int n = jdbcMeOfflineData.size();
        byte[] byArray = null;
        for (int i = 0; i < n; ++i) {
            byArray = jdbcMeOfflineData.getRecord(i);
            this.dumpBytes(i, byArray);
            if (!bl || jdbcMeOfflineData == this.DB_ && !this.imported_ && i < 4) continue;
            System.out.println("     " + new String(byArray));
        }
    }

    public int numberOfRows() {
        return (this.lastRowMIDPDBIndex_ - this.firstRowMIDPDBIndex_) / this.numColumns_;
    }

    public int getCurrentRow() {
        return this.currentRSRow_ + 1;
    }

    private void dumpBytes(int n, byte[] byArray) {
        System.out.print("#" + n + " : 0x ");
        for (int i = 0; i < byArray.length; ++i) {
            int n2 = (byArray[i] & 0xF0) >> 4;
            System.out.print(hexDigits.charAt(n2));
            n2 = (byArray[i] & 0xF) >> 0;
            System.out.print(hexDigits.charAt(n2));
            if ((i + 1) % 4 != 0) continue;
            System.out.print(" ");
        }
        System.out.println();
    }

    public int getType() throws JdbcMeException {
        return 1005;
    }

    public int getConcurrency() throws JdbcMeException {
        return 1008;
    }
}

