/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.micro;

import com.ibm.as400.micro.JdbcMeConnection;
import com.ibm.as400.micro.JdbcMeDriver;
import com.ibm.as400.micro.JdbcMeException;
import com.ibm.as400.micro.JdbcMeResultSetMetaData;
import com.ibm.as400.micro.JdbcMeStatement;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;

public class JdbcMeLiveResultSet
implements ResultSet {
    private JdbcMeConnection connection_ = null;
    private JdbcMeStatement stmt_ = null;
    private int rsId_ = -1;
    private byte onWhichRow_ = 0;
    private Object[] currentRow_ = null;
    private Object[] modifiedRowBuffer_ = null;
    public static final byte ROW_CURRENT = 0;
    public static final byte ROW_INSERT = 1;
    public static final byte ROW_UPDATE = 2;

    private JdbcMeLiveResultSet() {
    }

    JdbcMeLiveResultSet(JdbcMeStatement jdbcMeStatement, int n) throws JdbcMeException {
        this.rsId_ = n;
        this.stmt_ = jdbcMeStatement;
        this.connection_ = jdbcMeStatement.connection_;
    }

    public void close() throws JdbcMeException {
        try {
            this.connection_.system_.toServer_.writeInt(4737);
            this.connection_.system_.toServer_.writeInt(this.rsId_);
            this.connection_.system_.toServer_.flush();
            this.closeHard();
            return;
        }
        catch (IOException iOException) {
            this.connection_.disconnected();
            throw new JdbcMeException(iOException.toString(), null);
        }
    }

    void closeHard() {
        this.rsId_ = -1;
        this.stmt_ = null;
        this.currentRow_ = null;
        this.modifiedRowBuffer_ = null;
    }

    public void deleteRow() throws JdbcMeException {
        try {
            this.connection_.system_.toServer_.writeInt(4738);
            this.connection_.system_.toServer_.writeInt(this.rsId_);
            this.connection_.system_.toServer_.flush();
            int n = this.connection_.system_.fromServer_.readInt();
            if (n == -1) {
                JdbcMeDriver.processException(this.connection_);
            }
        }
        catch (IOException iOException) {
            this.connection_.disconnected();
            throw new JdbcMeException(iOException.toString(), null);
        }
    }

    public String getString(int n) throws JdbcMeException {
        if (this.currentRow_ == null) {
            throw new JdbcMeException("RS Position", null);
        }
        if (n < 1 || n > this.currentRow_.length) {
            throw new JdbcMeException("RS Column " + n, null);
        }
        if (this.onWhichRow_ == 1) {
            return this.modifiedRowBuffer_[n - 1].toString();
        }
        return this.currentRow_[n - 1].toString();
    }

    public int getInt(int n) throws JdbcMeException {
        if (this.currentRow_ == null) {
            throw new JdbcMeException("RS Position", null);
        }
        if (n < 1 || n > this.currentRow_.length) {
            throw new JdbcMeException("RS Column " + n, null);
        }
        if (this.onWhichRow_ == 1) {
            if (this.stmt_.columnTypes_[n - 1] == 4) {
                return (Integer)this.modifiedRowBuffer_[n - 1];
            }
            return Integer.parseInt(this.modifiedRowBuffer_[n - 1].toString());
        }
        if (this.stmt_.columnTypes_[n - 1] == 4) {
            return (Integer)this.currentRow_[n - 1];
        }
        return Integer.parseInt(this.currentRow_[n - 1].toString());
    }

    public void insertRow() throws JdbcMeException {
        this.insertOrUpdateRow(4739);
    }

    public void moveToInsertRow() throws JdbcMeException {
        if (this.modifiedRowBuffer_ == null || this.modifiedRowBuffer_.length != this.stmt_.numColumns_) {
            this.modifiedRowBuffer_ = new Object[this.stmt_.numColumns_];
        } else if (this.onWhichRow_ != 1) {
            for (int i = 0; i < this.modifiedRowBuffer_.length; ++i) {
                this.modifiedRowBuffer_[i] = null;
            }
        }
        this.onWhichRow_ = 1;
    }

    public void moveToCurrentRow() throws JdbcMeException {
        if (this.currentRow_ == null || this.currentRow_.length != this.stmt_.numColumns_) {
            this.currentRow_ = new Object[this.stmt_.numColumns_];
        }
        this.onWhichRow_ = 0;
    }

    private void readRow() throws IOException {
        if (this.currentRow_ == null || this.currentRow_.length != this.stmt_.numColumns_) {
            this.currentRow_ = new Object[this.stmt_.numColumns_];
        }
        block4: for (int i = 0; i < this.stmt_.numColumns_; ++i) {
            switch (this.stmt_.columnTypes_[i]) {
                case 1: 
                case 12: {
                    this.currentRow_[i] = this.connection_.system_.fromServer_.readUTF();
                    continue block4;
                }
                case 4: {
                    this.currentRow_[i] = new Integer(this.connection_.system_.fromServer_.readInt());
                    continue block4;
                }
                default: {
                    this.currentRow_[i] = this.connection_.system_.fromServer_.readUTF();
                }
            }
        }
    }

    public boolean next() throws JdbcMeException {
        return this.positioningMethod(4740, -1);
    }

    public boolean previous() throws JdbcMeException {
        return this.positioningMethod(4741, -1);
    }

    public boolean relative(int n) throws JdbcMeException {
        return this.positioningMethod(4758, n);
    }

    public boolean first() throws JdbcMeException {
        return this.positioningMethod(4752, -1);
    }

    public boolean last() throws JdbcMeException {
        return this.positioningMethod(4757, -1);
    }

    public boolean absolute(int n) throws JdbcMeException {
        return this.positioningMethod(4743, n);
    }

    private boolean positioningMethod(int n, int n2) throws JdbcMeException {
        try {
            this.onWhichRow_ = 0;
            this.connection_.system_.toServer_.writeInt(n);
            this.connection_.system_.toServer_.writeInt(this.rsId_);
            if (n2 != -1) {
                this.connection_.system_.toServer_.writeInt(n2);
            }
            this.connection_.system_.toServer_.flush();
            int n3 = this.connection_.system_.fromServer_.readInt();
            if (n3 == -1) {
                JdbcMeDriver.processException(this.connection_);
            }
            if (n3 == 0) {
                return false;
            }
            this.readRow();
            return true;
        }
        catch (IOException iOException) {
            this.connection_.disconnected();
            throw new JdbcMeException(iOException.toString(), null);
        }
    }

    public void updateString(int n, String string) throws JdbcMeException {
        if (this.stmt_.getResultSetConcurrency() != 1008) {
            throw new JdbcMeException("Cursor state invalid", null);
        }
        if (this.currentRow_ == null || this.currentRow_.length != this.stmt_.numColumns_) {
            this.currentRow_ = new Object[this.stmt_.numColumns_];
        }
        if (this.modifiedRowBuffer_ == null || this.modifiedRowBuffer_.length != this.currentRow_.length) {
            this.modifiedRowBuffer_ = new Object[this.currentRow_.length];
        }
        if (this.onWhichRow_ != 1) {
            System.arraycopy(this.currentRow_, 0, this.modifiedRowBuffer_, 0, this.currentRow_.length);
            this.onWhichRow_ = (byte)2;
            this.currentRow_[n - 1] = string;
        }
        if (n < 1 || n > this.modifiedRowBuffer_.length) {
            throw new JdbcMeException("RS Column " + n, null);
        }
        switch (this.stmt_.columnTypes_[n - 1]) {
            case 1: 
            case 12: {
                this.modifiedRowBuffer_[n - 1] = string;
                break;
            }
            case 4: {
                this.modifiedRowBuffer_[n - 1] = new Integer(Integer.parseInt(string));
                break;
            }
            default: {
                this.modifiedRowBuffer_[n - 1] = string;
            }
        }
    }

    public void updateInt(int n, int n2) throws JdbcMeException {
        if (this.stmt_.getResultSetConcurrency() != 1008) {
            throw new JdbcMeException("Cursor state invalid", null);
        }
        if (this.currentRow_ == null || this.currentRow_.length != this.stmt_.numColumns_) {
            this.currentRow_ = new Object[this.stmt_.numColumns_];
        }
        if (this.modifiedRowBuffer_ == null || this.modifiedRowBuffer_.length != this.currentRow_.length) {
            this.modifiedRowBuffer_ = new Object[this.currentRow_.length];
        }
        if (this.onWhichRow_ != 1) {
            System.arraycopy(this.currentRow_, 0, this.modifiedRowBuffer_, 0, this.currentRow_.length);
            this.onWhichRow_ = (byte)2;
            this.currentRow_[n - 1] = new Integer(n2);
        }
        if (n < 1 || n > this.modifiedRowBuffer_.length) {
            throw new JdbcMeException("RS Column " + n, null);
        }
        switch (this.stmt_.columnTypes_[n - 1]) {
            case 1: 
            case 12: {
                this.modifiedRowBuffer_[n - 1] = Integer.toString(n2);
                break;
            }
            case 4: {
                this.modifiedRowBuffer_[n - 1] = new Integer(n2);
                break;
            }
            default: {
                this.modifiedRowBuffer_[n - 1] = Integer.toString(n2);
            }
        }
    }

    public void updateRow() throws JdbcMeException {
        this.insertOrUpdateRow(4742);
    }

    public ResultSetMetaData getMetaData() throws JdbcMeException {
        return new JdbcMeResultSetMetaData(this.stmt_.numColumns_, this.stmt_.columnTypes_);
    }

    public Statement getStatement() throws JdbcMeException {
        return this.stmt_;
    }

    private void insertOrUpdateRow(int n) throws JdbcMeException {
        try {
            int n2;
            byte by = 1;
            if (n == 4742) {
                by = 2;
            }
            if (this.modifiedRowBuffer_ == null || this.onWhichRow_ != by) {
                throw new IllegalArgumentException("RS no in/upd row");
            }
            for (n2 = 0; n2 < this.stmt_.numColumns_; ++n2) {
                if (this.modifiedRowBuffer_[n2] != null) continue;
                throw new IllegalArgumentException("RS col not set: " + n2);
            }
            this.connection_.system_.toServer_.writeInt(n);
            this.connection_.system_.toServer_.writeInt(this.rsId_);
            block7: for (n2 = 0; n2 < this.stmt_.numColumns_; ++n2) {
                switch (this.stmt_.columnTypes_[n2]) {
                    case 1: 
                    case 12: {
                        this.connection_.system_.toServer_.writeUTF((String)this.modifiedRowBuffer_[n2]);
                        continue block7;
                    }
                    case 4: {
                        this.connection_.system_.toServer_.writeInt((Integer)this.modifiedRowBuffer_[n2]);
                        continue block7;
                    }
                    default: {
                        this.connection_.system_.toServer_.writeUTF(this.modifiedRowBuffer_[n2].toString());
                    }
                }
            }
            this.connection_.system_.toServer_.flush();
            n2 = this.connection_.system_.fromServer_.readInt();
            if (n2 == -1) {
                JdbcMeDriver.processException(this.connection_);
            }
            return;
        }
        catch (IOException iOException) {
            this.connection_.disconnected();
            throw new JdbcMeException(iOException.toString(), null);
        }
    }

    public int getType() throws JdbcMeException {
        return this.stmt_.type_;
    }

    public int getConcurrency() throws JdbcMeException {
        return this.stmt_.concurrency_;
    }
}

