/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.micro;

import com.ibm.as400.micro.AS400;
import com.ibm.as400.micro.JdbcMeDriver;
import com.ibm.as400.micro.JdbcMeException;
import com.ibm.as400.micro.JdbcMeStatement;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Statement;

public class JdbcMeConnection
implements Connection {
    AS400 system_;
    int connectionId_ = -1;
    boolean closed_ = true;
    boolean autoCommit_ = true;
    int isolation_ = 1;

    private JdbcMeConnection() {
    }

    JdbcMeConnection(String string, AS400 aS400) throws JdbcMeException {
        this.system_ = aS400;
        try {
            this.system_.toServer_.writeInt(4688);
            this.system_.toServer_.writeUTF(string);
            this.system_.toServer_.flush();
            this.connectionId_ = this.system_.fromServer_.readInt();
            if (this.connectionId_ == -1) {
                JdbcMeDriver.processException(this);
            }
            this.closed_ = false;
        }
        catch (IOException iOException) {
            this.disconnected();
            throw new JdbcMeException(iOException.toString(), null);
        }
    }

    public void close() throws JdbcMeException {
        if (!this.closed_) {
            try {
                this.system_.toServer_.writeInt(4689);
                this.system_.toServer_.writeInt(this.connectionId_);
                this.system_.toServer_.flush();
            }
            catch (IOException iOException) {
                throw new JdbcMeException(iOException.toString(), null);
            }
            finally {
                this.disconnected();
            }
        }
    }

    void disconnected() {
        this.closed_ = true;
        this.connectionId_ = -1;
        try {
            this.system_.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Statement createStatement() throws JdbcMeException {
        try {
            this.system_.toServer_.writeInt(4690);
            this.system_.toServer_.writeInt(this.connectionId_);
            this.system_.toServer_.flush();
            int n = this.system_.fromServer_.readInt();
            if (n == -1) {
                JdbcMeDriver.processException(this);
            }
            return new JdbcMeStatement(this, n);
        }
        catch (IOException iOException) {
            this.disconnected();
            throw new JdbcMeException(iOException.toString(), null);
        }
    }

    public Statement createStatement(int n, int n2) throws JdbcMeException {
        try {
            this.system_.toServer_.writeInt(4691);
            this.system_.toServer_.writeInt(this.connectionId_);
            this.system_.toServer_.writeInt(n);
            this.system_.toServer_.writeInt(n2);
            this.system_.toServer_.flush();
            int n3 = this.system_.fromServer_.readInt();
            if (n3 == -1) {
                JdbcMeDriver.processException(this);
            }
            JdbcMeStatement jdbcMeStatement = new JdbcMeStatement(this, n3);
            jdbcMeStatement.concurrency_ = n2;
            jdbcMeStatement.type_ = n;
            return jdbcMeStatement;
        }
        catch (IOException iOException) {
            this.disconnected();
            throw new JdbcMeException(iOException.toString(), null);
        }
    }

    public boolean isClosed() throws JdbcMeException {
        return this.closed_;
    }

    public void setAutoCommit(boolean bl) throws JdbcMeException {
        try {
            this.system_.toServer_.writeInt(4693);
            this.system_.toServer_.writeInt(this.connectionId_);
            this.system_.toServer_.writeBoolean(bl);
            this.system_.toServer_.flush();
            int n = this.system_.fromServer_.readInt();
            if (n == -1) {
                JdbcMeDriver.processException(this);
            }
            this.autoCommit_ = bl;
        }
        catch (IOException iOException) {
            this.disconnected();
            throw new JdbcMeException(iOException.toString(), null);
        }
    }

    public boolean getAutoCommit() throws JdbcMeException {
        return this.autoCommit_;
    }

    public void commit() throws JdbcMeException {
        try {
            this.system_.toServer_.writeInt(4695);
            this.system_.toServer_.writeInt(this.connectionId_);
            this.system_.toServer_.flush();
            int n = this.system_.fromServer_.readInt();
            if (n == -1) {
                JdbcMeDriver.processException(this);
            }
        }
        catch (IOException iOException) {
            this.disconnected();
            throw new JdbcMeException(iOException.toString(), null);
        }
    }

    public void rollback() throws JdbcMeException {
        try {
            this.system_.toServer_.writeInt(4696);
            this.system_.toServer_.writeInt(this.connectionId_);
            this.system_.toServer_.flush();
            int n = this.system_.fromServer_.readInt();
            if (n == -1) {
                JdbcMeDriver.processException(this);
            }
        }
        catch (IOException iOException) {
            this.disconnected();
            throw new JdbcMeException(iOException.toString(), null);
        }
    }

    public int getTransactionIsolation() throws JdbcMeException {
        return this.isolation_;
    }

    public void setTransactionIsolation(int n) throws JdbcMeException {
        try {
            this.system_.toServer_.writeInt(4694);
            this.system_.toServer_.writeInt(this.connectionId_);
            this.system_.toServer_.writeInt(this.isolation_);
            this.system_.toServer_.flush();
            int n2 = this.system_.fromServer_.readInt();
            if (n2 == -1) {
                JdbcMeDriver.processException(this);
            }
            this.isolation_ = n;
        }
        catch (IOException iOException) {
            this.disconnected();
            throw new JdbcMeException(iOException.toString(), null);
        }
    }
}

