/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.servlet;

import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.servlet.RowData;
import com.ibm.as400.util.servlet.RowDataException;
import com.ibm.as400.util.servlet.RowMetaData;
import com.ibm.as400.util.servlet.SQLResultSetMetaData;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class SQLResultSetRowData
extends RowData {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 1069177903929009287L;
    private static final String CHK_POSITION = "Attempting to check the list position";
    private static final String SET_POSITION = "Attempting to set the list position";
    protected transient ResultSet resultSet_;
    private SQLResultSetMetaData metadata_;

    public SQLResultSetRowData() {
    }

    public SQLResultSetRowData(ResultSet resultSet) throws RowDataException {
        this();
        try {
            this.setResultSet(resultSet);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void close() throws RowDataException {
        if (this.resultSet_ == null) {
            Trace.log(2, "Attempting to close the result set before setting the result set.");
            throw new ExtendedIllegalStateException("resultSet", 4);
        }
        try {
            this.resultSet_.close();
        }
        catch (SQLException sQLException) {
            Trace.log(3, "Rethrowing SQLException.");
            throw new RowDataException(sQLException);
        }
    }

    public RowMetaData getMetaData() throws RowDataException {
        try {
            if (this.resultSet_ != null & this.metadata_ == null) {
                this.metadata_ = new SQLResultSetMetaData(this.resultSet_.getMetaData());
            }
            return this.metadata_;
        }
        catch (SQLException sQLException) {
            throw new RowDataException(sQLException);
        }
    }

    public ResultSet getResultSet() {
        return this.resultSet_;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.resultSet_ = null;
    }

    public void setResultSet(ResultSet resultSet) throws RowDataException, PropertyVetoException {
        if (resultSet == null) {
            throw new NullPointerException("resultSet");
        }
        ResultSet resultSet2 = this.resultSet_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("resultSet", resultSet2, resultSet);
        }
        this.resultSet_ = resultSet;
        this.rows_ = new Vector();
        this.rowProperties_ = new Vector();
        try {
            int n = resultSet.getMetaData().getColumnCount();
            while (resultSet.next()) {
                Object[] objectArray = new Object[n];
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = resultSet.getString(i + 1);
                }
                this.rows_.addElement(objectArray);
                this.rowProperties_.addElement(new Vector[n]);
            }
            if (this.changes_ != null) {
                this.changes_.firePropertyChange("resultSet", resultSet2, resultSet);
            }
            this.beforeFirst();
        }
        catch (SQLException sQLException) {
            Trace.log(3, "Rethrowing SQLException.");
            throw new RowDataException(sQLException);
        }
    }
}

