/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.servlet;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceList;
import com.ibm.as400.resource.ResourceMetaData;
import com.ibm.as400.util.servlet.ResourceListMetaData;
import com.ibm.as400.util.servlet.RowData;
import com.ibm.as400.util.servlet.RowDataException;
import com.ibm.as400.util.servlet.RowMetaData;
import java.io.Serializable;
import java.util.Vector;

public class ResourceListRowData
extends RowData
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 1081925300369525536L;
    private ResourceListMetaData metadata_;
    private ResourceList resourceList_;
    private Object[] columnAttributeIDs_;
    private Exception lastException_;
    private boolean refreshed_;

    public ResourceListRowData() {
        this.setColumnAttributeIDs(new Object[0]);
    }

    public ResourceListRowData(ResourceList resourceList, Object[] objectArray) {
        this();
        this.setMetaData(resourceList, objectArray);
        this.setResourceList(resourceList);
        this.setColumnAttributeIDs(objectArray);
    }

    public Object[] getColumnAttributeIDs() {
        return this.columnAttributeIDs_;
    }

    int getListLength() {
        try {
            if (this.resourceList_ == null) {
                return 0;
            }
            if (!this.refreshed_) {
                this.resourceList_.refreshStatus();
                this.refreshed_ = true;
            }
            return (int)this.resourceList_.getListLength();
        }
        catch (ResourceException resourceException) {
            Trace.log(2, "Error getting resource length.", (Throwable)resourceException);
            this.lastException_ = resourceException;
            return 0;
        }
    }

    public RowMetaData getMetaData() {
        return this.metadata_;
    }

    public Object getObject(int n) throws RowDataException {
        try {
            Object object;
            if (this.lastException_ != null) {
                throw new RowDataException(this.lastException_);
            }
            if (this.columnAttributeIDs_ == null) {
                throw new NullPointerException("columnAttributeIDs");
            }
            if (this.columnAttributeIDs_.length == 0) {
                Trace.log(2, "Attempting to get the column object before setting the column attribute IDs.");
                throw new ExtendedIllegalStateException("columnAttributeIDs", 4);
            }
            this.validateRowList("Attempting to get the column object");
            this.validateListPosition("Attempting to get the current object");
            if (n < 0 || n >= this.columnAttributeIDs_.length) {
                throw new ExtendedIllegalArgumentException("columnIndex", 4);
            }
            this.resourceList_.open();
            if (!this.resourceList_.isResourceAvailable((long)n)) {
                this.resourceList_.waitForResource((long)n);
            }
            if (this.columnAttributeIDs_[n] == null) {
                return this.resourceList_.resourceAt((long)this.position_).getPresentation().getName();
            }
            ResourceMetaData resourceMetaData = this.resourceList_.getAttributeMetaData(this.columnAttributeIDs_[n]);
            if (resourceMetaData.getPossibleValuePresentation(object = this.resourceList_.resourceAt((long)this.position_).getAttributeValue(this.columnAttributeIDs_[n])) != null) {
                return resourceMetaData.getPossibleValuePresentation(object).getName();
            }
            return object;
        }
        catch (ResourceException resourceException) {
            throw new RowDataException((Exception)((Object)resourceException));
        }
    }

    public Vector getObjectProperties(int n) {
        this.validateRowList("Attempting to get the column object's properties");
        this.validateListPosition("Attempting to get the current object's properties");
        if (n < 0 || n >= this.columnAttributeIDs_.length) {
            throw new ExtendedIllegalArgumentException("columnIndex", 4);
        }
        return new Vector();
    }

    public ResourceList getResourceList() {
        return this.resourceList_;
    }

    public int length() {
        return this.getListLength();
    }

    public void setColumnAttributeIDs(Object[] objectArray) {
        if (Trace.isTraceOn()) {
            Trace.log(3, "Setting the column attribute IDs.");
        }
        if (objectArray == null) {
            throw new NullPointerException("columnAttributeIDs");
        }
        Object[] objectArray2 = this.columnAttributeIDs_;
        this.columnAttributeIDs_ = objectArray;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("columnAttributeIDs", objectArray2, objectArray);
        }
        if (this.metadata_ == null) {
            this.metadata_ = new ResourceListMetaData();
        }
        this.metadata_.setColumnAttributeIDs(objectArray);
    }

    void setMetaData(ResourceList resourceList, Object[] objectArray) {
        if (resourceList == null) {
            throw new NullPointerException("resourceList");
        }
        if (objectArray == null) {
            throw new NullPointerException("columnAttributeIDs");
        }
        if (objectArray.length == 0) {
            throw new ExtendedIllegalArgumentException("columnAttributeIDs", 4);
        }
        ResourceListMetaData resourceListMetaData = this.metadata_;
        this.metadata_ = new ResourceListMetaData(resourceList, objectArray);
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("metadata", resourceListMetaData, this.metadata_);
        }
    }

    public void setResourceList(ResourceList resourceList) {
        if (Trace.isTraceOn()) {
            Trace.log(3, "Setting the resource list.");
        }
        if (resourceList == null) {
            throw new NullPointerException("resourceList");
        }
        ResourceList resourceList2 = this.resourceList_;
        this.resourceList_ = resourceList;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("resourceList", resourceList2, resourceList);
        }
        if (this.metadata_ == null) {
            this.metadata_ = new ResourceListMetaData();
        }
        this.metadata_.setResourceList(resourceList);
    }
}

