/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.servlet;

import com.ibm.as400.access.ActionCompletedEvent;
import com.ibm.as400.access.ActionCompletedListener;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.HTMLHyperlink;
import com.ibm.as400.util.html.HTMLTable;
import com.ibm.as400.util.html.HTMLTableCell;
import com.ibm.as400.util.html.HTMLTableHeader;
import com.ibm.as400.util.html.HTMLTableRow;
import com.ibm.as400.util.html.HTMLTagAttributes;
import com.ibm.as400.util.html.HTMLTagElement;
import com.ibm.as400.util.html.HTMLText;
import com.ibm.as400.util.html.LineLayoutFormPanel;
import com.ibm.as400.util.servlet.RowData;
import com.ibm.as400.util.servlet.RowDataException;
import com.ibm.as400.util.servlet.RowMetaData;
import com.ibm.as400.util.servlet.SectionCompletedListener;
import com.ibm.as400.util.servlet.SectionCompletedSupport;
import com.ibm.as400.util.servlet.StringConverter;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class HTMLTableConverter
extends StringConverter
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 9154342923705960360L;
    private HTMLTable htmlTable_;
    private HTMLHyperlink[] links_;
    private int maxTableSize_ = 0;
    private boolean useMetaData_ = false;
    private transient Vector completedListeners_;
    private transient PropertyChangeSupport changes_;
    private transient VetoableChangeSupport vetos_;
    private transient SectionCompletedSupport sectionCompletedSupport_;

    public void addActionCompletedListener(ActionCompletedListener actionCompletedListener) {
        if (actionCompletedListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.completedListeners_ == null) {
            this.completedListeners_ = new Vector();
        }
        this.completedListeners_.addElement(actionCompletedListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ == null) {
            this.changes_ = new PropertyChangeSupport(this);
        }
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addSectionCompletedListener(SectionCompletedListener sectionCompletedListener) {
        if (this.sectionCompletedSupport_ == null) {
            this.sectionCompletedSupport_ = new SectionCompletedSupport(this);
        }
        this.sectionCompletedSupport_.addSectionCompletedListener(sectionCompletedListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(vetoableChangeListener);
    }

    private HTMLTable[] calculateNumberOfTables(int n) {
        int n2 = 1;
        if (this.maxTableSize_ > 0 && n > 0) {
            n2 = n / this.maxTableSize_;
            if (n % this.maxTableSize_ != 0) {
                ++n2;
            }
        }
        return new HTMLTable[n2];
    }

    private HTMLTable[] convertRowData(RowData rowData, RowMetaData rowMetaData) throws PropertyVetoException, RowDataException {
        HTMLTable[] hTMLTableArray = this.calculateNumberOfTables(rowData.length());
        for (int i = 0; i < hTMLTableArray.length; ++i) {
            hTMLTableArray[i] = this.convertRowData(rowData, rowMetaData, i);
        }
        return hTMLTableArray;
    }

    private HTMLTable convertRowData(RowData rowData, RowMetaData rowMetaData, int n) throws PropertyVetoException, RowDataException {
        if (rowMetaData == null) {
            Trace.log(2, "The rowdata's metadata attribute is invalid.");
            throw new ExtendedIllegalStateException("rowdata metadata", 4);
        }
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("page", 4);
        }
        if (this.htmlTable_ == null) {
            this.setUseMetaData(true);
            try {
                this.htmlTable_ = new HTMLTable();
                this.htmlTable_.setHeaderInUse(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (this.isUseMetaData()) {
            this.setTableHeader(rowMetaData);
        }
        HTMLTable hTMLTable = this.createDefaultTable();
        if (rowData.length() == 0) {
            return hTMLTable;
        }
        long l = 1L;
        int n2 = rowMetaData.getColumnCount();
        if (n == 0) {
            rowData.beforeFirst();
        } else {
            rowData.absolute(this.maxTableSize_ * n - 1);
        }
        int n3 = 0;
        if (this.maxTableSize_ == 0) {
            this.maxTableSize_ = rowData.length();
        }
        while (rowData.next() && this.maxTableSize_ > n3) {
            if (this.maxTableSize_ > 0 && l > 1L && l % (long)this.maxTableSize_ == 1L && this.sectionCompletedSupport_ != null) {
                this.sectionCompletedSupport_.fireSectionCompleted(hTMLTable.getTag());
            }
            HTMLTableRow hTMLTableRow = new HTMLTableRow();
            for (int i = 0; i < n2; ++i) {
                Object object;
                Vector vector;
                HTMLTableCell hTMLTableCell = new HTMLTableCell();
                if (rowMetaData.isNumericData(i)) {
                    hTMLTableCell.setHorizontalAlignment("right");
                }
                if ((vector = rowData.getObjectProperties(i)) != null) {
                    int n4 = vector.size();
                    for (int j = 0; j < n4; ++j) {
                        if (!(vector.elementAt(j) instanceof HTMLTableCell)) continue;
                        hTMLTableCell = (HTMLTableCell)vector.elementAt(j);
                    }
                }
                if ((object = rowData.getObject(i)) == null) {
                    object = new LineLayoutFormPanel();
                }
                try {
                    hTMLTableCell.setElement((HTMLTagElement)object);
                }
                catch (ClassCastException classCastException) {
                    hTMLTableCell.setElement(new HTMLText(object.toString()));
                }
                if (rowMetaData.getColumnAlignment(i) != null) {
                    hTMLTableCell.setHorizontalAlignment(rowMetaData.getColumnAlignment(i));
                }
                if (rowMetaData.getColumnDirection(i) != null) {
                    hTMLTableCell.setDirection(rowMetaData.getColumnDirection(i));
                }
                hTMLTableRow.addColumn(hTMLTableCell);
            }
            hTMLTable.addRow(hTMLTableRow);
            ++l;
            ++n3;
        }
        if (this.sectionCompletedSupport_ != null) {
            this.sectionCompletedSupport_.fireSectionCompleted(hTMLTable.getTag());
        }
        this.fireCompleted();
        return hTMLTable;
    }

    public HTMLTable[] convertToTables(RowData rowData) throws PropertyVetoException, RowDataException {
        if (rowData == null) {
            throw new NullPointerException("rowdata");
        }
        HTMLTable[] hTMLTableArray = this.convertRowData(rowData, rowData.getMetaData());
        return hTMLTableArray;
    }

    public HTMLTable convertToTable(RowData rowData, int n) throws PropertyVetoException, RowDataException {
        if (rowData == null) {
            throw new NullPointerException("rowdata");
        }
        HTMLTable hTMLTable = this.convertRowData(rowData, rowData.getMetaData(), n);
        return hTMLTable;
    }

    private HTMLTable createDefaultTable() {
        HTMLTable hTMLTable = new HTMLTable();
        try {
            if (this.htmlTable_.getHeader() != null) {
                hTMLTable.setHeader(this.htmlTable_.getHeader());
            }
            if (this.htmlTable_.getCaption() != null) {
                hTMLTable.setCaption(this.htmlTable_.getCaption());
            }
            if (this.htmlTable_.getAlignment() != null) {
                hTMLTable.setAlignment(this.htmlTable_.getAlignment());
            }
            hTMLTable.setBorderWidth(this.htmlTable_.getBorderWidth());
            hTMLTable.setCellPadding(this.htmlTable_.getCellPadding());
            hTMLTable.setCellSpacing(this.htmlTable_.getCellSpacing());
            hTMLTable.setWidth(this.htmlTable_.getWidth(), this.htmlTable_.isWidthInPercent());
            hTMLTable.setHeaderInUse(this.htmlTable_.isHeaderInUse());
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return hTMLTable;
    }

    String[] doConvert(RowData rowData, RowMetaData rowMetaData) throws PropertyVetoException, RowDataException {
        HTMLTable[] hTMLTableArray = this.convertRowData(rowData, rowMetaData);
        String[] stringArray = new String[hTMLTableArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = hTMLTableArray[i].getTag();
        }
        return stringArray;
    }

    private void fireCompleted() {
        if (this.completedListeners_ == null) {
            return;
        }
        Vector vector = (Vector)this.completedListeners_.clone();
        ActionCompletedEvent actionCompletedEvent = new ActionCompletedEvent((Object)this);
        for (int i = 0; i < vector.size(); ++i) {
            ActionCompletedListener actionCompletedListener = (ActionCompletedListener)vector.elementAt(i);
            actionCompletedListener.actionCompleted(actionCompletedEvent);
        }
    }

    public HTMLHyperlink[] getHeaderHyperlinks() {
        return this.links_;
    }

    public int getMaximumTableSize() {
        return this.maxTableSize_;
    }

    public HTMLHyperlink getObjectHyperlink(RowData rowData, int n) {
        if (rowData == null) {
            throw new NullPointerException("rowdata");
        }
        return this.getObjectHyperlink(rowData, rowData.getCurrentPosition(), n);
    }

    public HTMLHyperlink getObjectHyperlink(RowData rowData, int n, int n2) {
        if (rowData == null) {
            throw new NullPointerException("rowdata");
        }
        if (!rowData.absolute(n)) {
            throw new ExtendedIllegalArgumentException("row", 4);
        }
        Vector vector = rowData.getObjectProperties(n2);
        HTMLHyperlink hTMLHyperlink = null;
        if (vector != null) {
            int n3 = vector.size();
            for (int i = 0; i < n3; ++i) {
                if (!(vector.elementAt(i) instanceof HTMLHyperlink)) continue;
                hTMLHyperlink = (HTMLHyperlink)vector.elementAt(i);
                break;
            }
        }
        return hTMLHyperlink;
    }

    public HTMLTable getTable() {
        return this.htmlTable_;
    }

    public boolean isUseMetaData() {
        return this.useMetaData_;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public void removeActionCompletedListener(ActionCompletedListener actionCompletedListener) {
        if (actionCompletedListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.completedListeners_ != null) {
            this.completedListeners_.removeElement(actionCompletedListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ != null) {
            this.changes_.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void removeSectionCompletedListener(SectionCompletedListener sectionCompletedListener) {
        if (sectionCompletedListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.sectionCompletedSupport_ != null) {
            this.sectionCompletedSupport_.removeSectionCompletedListener(sectionCompletedListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public void setHeaderHyperlinks(HTMLHyperlink[] hTMLHyperlinkArray) throws PropertyVetoException {
        if (hTMLHyperlinkArray == null) {
            throw new NullPointerException("links");
        }
        HTMLHyperlink[] hTMLHyperlinkArray2 = this.links_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("links", hTMLHyperlinkArray2, hTMLHyperlinkArray);
        }
        this.links_ = hTMLHyperlinkArray;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("links", hTMLHyperlinkArray2, hTMLHyperlinkArray);
        }
    }

    public void setMaximumTableSize(int n) throws PropertyVetoException {
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("size", 4);
        }
        int n2 = this.maxTableSize_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("size", new Integer(n2), new Integer(n));
        }
        this.maxTableSize_ = n;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("size", new Integer(n2), new Integer(n));
        }
    }

    public void setObjectHyperlink(RowData rowData, HTMLHyperlink hTMLHyperlink, int n) throws RowDataException {
        if (rowData == null) {
            throw new NullPointerException("rowdata");
        }
        this.setObjectHyperlink(rowData, hTMLHyperlink, rowData.getCurrentPosition(), n);
    }

    public void setObjectHyperlink(RowData rowData, HTMLHyperlink hTMLHyperlink, int n, int n2) throws RowDataException {
        if (rowData == null) {
            throw new NullPointerException("rowdata");
        }
        if (hTMLHyperlink == null) {
            throw new NullPointerException("link");
        }
        if (!rowData.absolute(n)) {
            throw new ExtendedIllegalArgumentException("row", 4);
        }
        Vector<HTMLHyperlink> vector = rowData.getObjectProperties(n2);
        if (vector == null) {
            vector = new Vector<HTMLHyperlink>();
            vector.addElement(hTMLHyperlink);
        } else {
            HTMLHyperlink hTMLHyperlink2 = null;
            int n3 = -1;
            int n4 = vector.size();
            for (int i = 0; i < n4; ++i) {
                if (!(vector.elementAt(i) instanceof HTMLHyperlink)) continue;
                hTMLHyperlink2 = (HTMLHyperlink)vector.elementAt(i);
                n3 = i;
                break;
            }
            if (hTMLHyperlink2 == null) {
                vector.addElement(hTMLHyperlink);
            } else {
                vector.setElementAt(hTMLHyperlink, n3);
            }
        }
        rowData.setObjectProperties(vector, n2);
    }

    public void setTable(HTMLTable hTMLTable) throws PropertyVetoException {
        if (hTMLTable == null) {
            throw new NullPointerException("table");
        }
        HTMLTable hTMLTable2 = this.htmlTable_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("table", hTMLTable2, hTMLTable);
        }
        this.htmlTable_ = hTMLTable;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("table", hTMLTable2, hTMLTable);
        }
    }

    private void setTableHeader(RowMetaData rowMetaData) throws RowDataException, PropertyVetoException {
        int n = rowMetaData.getColumnCount();
        HTMLTableHeader[] hTMLTableHeaderArray = new HTMLTableHeader[n];
        String string = "";
        for (int i = 0; i < n; ++i) {
            HTMLTagAttributes hTMLTagAttributes;
            try {
                string = rowMetaData.getColumnLabel(i);
            }
            catch (NullPointerException nullPointerException) {
                string = rowMetaData.getColumnName(i);
            }
            if (this.links_ != null && this.links_[i] != null) {
                HTMLHyperlink hTMLHyperlink = this.links_[i];
                hTMLHyperlink.setText(string);
                hTMLTagAttributes = hTMLHyperlink;
            } else {
                hTMLTagAttributes = new HTMLText(string);
            }
            hTMLTableHeaderArray[i] = new HTMLTableHeader(hTMLTagAttributes);
        }
        this.htmlTable_.setHeader(hTMLTableHeaderArray);
        if (!this.htmlTable_.isHeaderInUse()) {
            this.htmlTable_.setHeaderInUse(true);
        }
    }

    public void setUseMetaData(boolean bl) {
        this.useMetaData_ = bl;
    }
}

