/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.util.html.HTMLHyperlink;
import com.ibm.as400.util.servlet.ServletHyperlink;
import java.beans.PropertyVetoException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class URLParser {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private String url_;
    private String uri_;
    private String reference_;
    private Properties parameters_;

    public URLParser(String string) {
        if (string == null) {
            throw new NullPointerException("url");
        }
        this.url_ = string;
        this.parse(string);
    }

    public String getURL() {
        return this.url_;
    }

    public String getURI() {
        return this.uri_;
    }

    public static String getURI(HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null) {
            throw new NullPointerException("request");
        }
        String string = httpServletRequest.getRequestURI();
        String string2 = httpServletRequest.getPathInfo();
        if (string2 != null) {
            string = string.substring(0, string.lastIndexOf(string2));
        }
        return string;
    }

    public String getReference() {
        return this.reference_;
    }

    public Properties getParameters() {
        return this.parameters_;
    }

    public HTMLHyperlink getHTMLHyperlink(String string) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        return this.fillHyperlink(new HTMLHyperlink(), string);
    }

    public ServletHyperlink getServletHyperlink(String string) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        return (ServletHyperlink)this.fillHyperlink(new ServletHyperlink(), string);
    }

    private HTMLHyperlink fillHyperlink(HTMLHyperlink hTMLHyperlink, String string) {
        try {
            if (this.reference_ == null) {
                hTMLHyperlink.setLink(this.uri_);
            } else {
                hTMLHyperlink.setLink(this.uri_ + "#" + this.reference_);
            }
            if (this.parameters_ != null) {
                hTMLHyperlink.setProperties(this.parameters_);
            }
            hTMLHyperlink.setText(string);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return hTMLHyperlink;
    }

    private void parse(String string) {
        String string2;
        int n = string.indexOf("?");
        if (n != -1) {
            this.uri_ = string.substring(0, n);
            string2 = string.substring(n + 1);
        } else {
            this.uri_ = string;
            string2 = null;
        }
        n = this.uri_.indexOf("#");
        if (n != -1) {
            this.reference_ = this.uri_.substring(n + 1);
            this.uri_ = this.uri_.substring(0, n);
        } else {
            this.reference_ = null;
        }
        if (string2 != null) {
            this.parameters_ = new Properties();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "&");
            while (stringTokenizer.hasMoreTokens()) {
                String string3;
                String string4;
                String string5 = stringTokenizer.nextToken();
                n = string5.indexOf("=");
                if (n != -1) {
                    string4 = string5.substring(0, n);
                    string3 = string5.substring(n + 1);
                } else {
                    string4 = string5;
                    string3 = "";
                }
                ((Hashtable)this.parameters_).put(string4, string3);
            }
        }
    }
}

