/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.HTMLTagAttributes;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class TextAreaFormElement
extends HTMLTagAttributes
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = -1548160614340950478L;
    private String name_;
    private int rows_;
    private int cols_;
    private String text_;
    private String lang_;
    private String dir_;
    private transient VetoableChangeSupport vetos_;

    public TextAreaFormElement() {
        this.rows_ = 0;
        this.cols_ = 0;
    }

    public TextAreaFormElement(String string) {
        this();
        try {
            this.setName(string);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public TextAreaFormElement(String string, int n, int n2) {
        try {
            this.setName(string);
            this.setRows(n);
            this.setColumns(n2);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(vetoableChangeListener);
    }

    public int getColumns() {
        return this.cols_;
    }

    public String getDirection() {
        return this.dir_;
    }

    String getDirectionAttributeTag() {
        if (this.dir_ != null && this.dir_.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer(" dir=\"");
            stringBuffer.append(this.dir_);
            stringBuffer.append("\"");
            return stringBuffer.toString();
        }
        return "";
    }

    public String getLanguage() {
        return this.lang_;
    }

    String getLanguageAttributeTag() {
        if (this.lang_ != null && this.lang_.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer(" lang=\"");
            stringBuffer.append(this.lang_);
            stringBuffer.append("\"");
            return stringBuffer.toString();
        }
        return "";
    }

    public String getName() {
        return this.name_;
    }

    public int getRows() {
        return this.rows_;
    }

    public String getFOTag() {
        Trace.log(2, "Attempting to getFOTag() for an object that doesn't support it.");
        return "<!-- A TextAreaFormElement was here -->";
    }

    public String getTag() {
        if (this.name_ == null) {
            Trace.log(2, "Attempting to get tag before setting name.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        StringBuffer stringBuffer = new StringBuffer("<textarea");
        stringBuffer.append(" name=\"");
        stringBuffer.append(this.name_);
        stringBuffer.append("\"");
        stringBuffer.append(" rows=\"");
        stringBuffer.append(this.rows_);
        stringBuffer.append("\"");
        stringBuffer.append(" cols=\"");
        stringBuffer.append(this.cols_);
        stringBuffer.append("\"");
        stringBuffer.append(this.getLanguageAttributeTag());
        stringBuffer.append(this.getDirectionAttributeTag());
        stringBuffer.append(this.getAttributeString());
        stringBuffer.append(">\n");
        if (this.text_ != null) {
            stringBuffer.append(this.text_);
        }
        stringBuffer.append("</textarea>");
        return stringBuffer.toString();
    }

    public String getText() {
        return this.text_;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public void setColumns(int n) throws PropertyVetoException {
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("cols", 4);
        }
        int n2 = this.cols_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("cols", new Integer(n2), new Integer(n));
        }
        this.cols_ = n;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("cols", new Integer(n2), new Integer(n));
        }
    }

    public void setDirection(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("dir");
        }
        if (!string.equals("ltr") && !string.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        String string2 = this.dir_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("dir", string2, string);
        }
        this.dir_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dir", string2, string);
        }
    }

    public void setLanguage(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("lang");
        }
        String string2 = this.lang_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("lang", string2, string);
        }
        this.lang_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("lang", string2, string);
        }
    }

    public void setName(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("name");
        }
        String string2 = this.name_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("name", string2, string);
        }
        this.name_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("name", string2, string);
        }
    }

    public void setRows(int n) throws PropertyVetoException {
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("rows", 4);
        }
        int n2 = this.rows_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("rows", new Integer(n2), new Integer(n));
        }
        this.rows_ = n;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("rows", new Integer(n2), new Integer(n));
        }
    }

    public void setText(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("text");
        }
        String string2 = this.text_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("text", string2, string);
        }
        this.text_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("text", string2, string);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

