/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.ElementEvent;
import com.ibm.as400.util.html.ElementListener;
import com.ibm.as400.util.html.HTMLTagAttributes;
import com.ibm.as400.util.html.SelectOption;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class SelectFormElement
extends HTMLTagAttributes
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = -5409799783351050576L;
    private String name_;
    private int size_ = 0;
    private boolean multiple_ = false;
    private boolean optionSelected_;
    private String lang_;
    private String dir_;
    private Vector list_ = new Vector();
    private transient VetoableChangeSupport vetos_;
    private transient Vector elementListeners;

    public SelectFormElement() {
    }

    public SelectFormElement(String string) {
        this();
        try {
            this.setName(string);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void addElementListener(ElementListener elementListener) {
        if (elementListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners == null) {
            this.elementListeners = new Vector();
        }
        this.elementListeners.addElement(elementListener);
    }

    public void addOption(SelectOption selectOption) {
        if (selectOption == null) {
            throw new NullPointerException("option");
        }
        if (selectOption.isSelected() && this.optionSelected_ && !this.multiple_) {
            Trace.log(2, "Multiple options marked as 'selected' but multiple attribute not set.");
            throw new ExtendedIllegalArgumentException("selected", 2);
        }
        if (selectOption.isSelected() && !this.optionSelected_) {
            this.optionSelected_ = true;
        }
        this.list_.addElement(selectOption);
        this.fireElementEvent(0);
    }

    public SelectOption addOption(String string, String string2) {
        return this.addOption(string, string2, false);
    }

    public SelectOption addOption(String string, String string2, boolean bl) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        if (string2 == null) {
            throw new NullPointerException("value");
        }
        if (bl && this.optionSelected_ && !this.multiple_) {
            Trace.log(2, "Multiple options marked as 'selected' but multiple attribute not set.");
            throw new ExtendedIllegalArgumentException("selected", 2);
        }
        if (bl && !this.optionSelected_) {
            this.optionSelected_ = true;
        }
        SelectOption selectOption = new SelectOption(string, string2, bl);
        this.list_.addElement(selectOption);
        this.fireElementEvent(0);
        return selectOption;
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(vetoableChangeListener);
    }

    private void fireElementEvent(int n) {
        if (this.elementListeners == null) {
            return;
        }
        Vector vector = (Vector)this.elementListeners.clone();
        ElementEvent elementEvent = new ElementEvent(this, n);
        for (int i = 0; i < vector.size(); ++i) {
            ElementListener elementListener = (ElementListener)vector.elementAt(i);
            if (n == 0) {
                elementListener.elementAdded(elementEvent);
                continue;
            }
            if (n != 2) continue;
            elementListener.elementRemoved(elementEvent);
        }
    }

    public String getDirection() {
        return this.dir_;
    }

    public String getLanguage() {
        return this.lang_;
    }

    public String getName() {
        return this.name_;
    }

    public int getOptionCount() {
        return this.list_.size();
    }

    public int getSize() {
        return this.size_;
    }

    public String getFOTag() {
        Trace.log(2, "Attempting to getFOTag() for an object that doesn't support it.");
        return "<!-- A SelectFormElement was here -->";
    }

    public String getTag() {
        if (this.name_ == null) {
            Trace.log(2, "Attempting to get tag before setting name.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        StringBuffer stringBuffer = new StringBuffer("<select");
        stringBuffer.append(" name=\"");
        stringBuffer.append(this.name_);
        stringBuffer.append("\"");
        if (this.size_ > 0) {
            stringBuffer.append(" size=\"");
            stringBuffer.append(this.size_);
            stringBuffer.append("\"");
        }
        if (this.multiple_) {
            stringBuffer.append(" multiple=\"multiple\"");
        }
        if (this.lang_ != null && this.lang_.length() > 0) {
            if (Trace.isTraceOn()) {
                Trace.log(3, "   Using language attribute.");
            }
            stringBuffer.append(" lang=\"");
            stringBuffer.append(this.lang_);
            stringBuffer.append("\"");
        }
        if (this.dir_ != null && this.dir_.length() > 0) {
            if (Trace.isTraceOn()) {
                Trace.log(3, "   Using direction attribute.");
            }
            stringBuffer.append(" dir=\"");
            stringBuffer.append(this.dir_);
            stringBuffer.append("\"");
        }
        stringBuffer.append(this.getAttributeString());
        stringBuffer.append(">\n");
        this.optionSelected_ = false;
        for (int i = 0; i < this.getOptionCount(); ++i) {
            SelectOption selectOption = (SelectOption)this.list_.elementAt(i);
            stringBuffer.append(selectOption.getTag());
            stringBuffer.append("\n");
        }
        stringBuffer.append("</select>");
        return stringBuffer.toString();
    }

    public boolean isMultiple() {
        return this.multiple_;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public void removeOption(SelectOption selectOption) {
        if (selectOption == null) {
            throw new NullPointerException("option");
        }
        if (selectOption.isSelected()) {
            if (this.multiple_) {
                boolean bl = false;
                for (int i = 0; !bl && i < this.list_.size(); ++i) {
                    SelectOption selectOption2 = (SelectOption)this.list_.elementAt(i);
                    if (selectOption2 == selectOption || !selectOption2.isSelected()) continue;
                    bl = true;
                }
                if (!bl) {
                    this.optionSelected_ = false;
                }
            } else {
                this.optionSelected_ = false;
            }
        }
        if (this.list_.removeElement(selectOption)) {
            this.fireElementEvent(2);
        }
    }

    public void removeElementListener(ElementListener elementListener) {
        if (elementListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners != null) {
            this.elementListeners.removeElement(elementListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public void setDirection(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("dir");
        }
        if (!string.equals("ltr") && !string.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        String string2 = this.dir_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("dir", string2, string);
        }
        this.dir_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dir", string2, string);
        }
    }

    public void setLanguage(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("lang");
        }
        String string2 = this.lang_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("lang", string2, string);
        }
        this.lang_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("lang", string2, string);
        }
    }

    public void setMultiple(boolean bl) throws PropertyVetoException {
        boolean bl2 = this.multiple_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("multiple", new Boolean(bl2), new Boolean(bl));
        }
        this.multiple_ = bl;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("multiple", new Boolean(bl2), new Boolean(bl));
        }
    }

    public void setName(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("name");
        }
        String string2 = this.name_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("name", string2, string);
        }
        this.name_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("name", string2, string);
        }
    }

    public void setSize(int n) throws PropertyVetoException {
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("size", 4);
        }
        int n2 = this.size_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("size", new Integer(n2), new Integer(n));
        }
        this.size_ = n;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("size", new Integer(n2), new Integer(n));
        }
    }

    public String toString() {
        return this.getTag();
    }
}

