/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.Trace;

public class HTMLTransform {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";

    public static String encode(String string) {
        if (string == null) {
            throw new NullPointerException("source");
        }
        if (Trace.isTraceOn()) {
            Trace.log(3, "Encoding HTML string...");
        }
        StringBuffer stringBuffer = new StringBuffer();
        block6: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block6;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block6;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block6;
                }
                default: {
                    stringBuffer.append(string.charAt(i));
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String decode(String string) {
        if (string == null) {
            throw new NullPointerException("source");
        }
        if (Trace.isTraceOn()) {
            Trace.log(3, "Decoding HTML string...");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.indexOf("&");
        int n2 = 0;
        while (n >= 0) {
            if (n == 0) {
                if (string.indexOf("&quot;") == 0) {
                    stringBuffer.append("\"");
                    n2 = 6;
                } else if (string.indexOf("&amp;") == 0) {
                    stringBuffer.append("&");
                    n2 = 5;
                } else if (string.indexOf("&lt;") == 0) {
                    stringBuffer.append("<");
                    n2 = 4;
                } else if (string.indexOf("&gt;") == 0) {
                    stringBuffer.append(">");
                    n2 = 4;
                }
            } else {
                int n3 = string.indexOf(";", n2);
                if (string.substring(n, n3).equals("&quot")) {
                    stringBuffer.append(string.substring(n2, n));
                    stringBuffer.append("\"");
                } else if (string.substring(n, n3).equals("&amp")) {
                    stringBuffer.append(string.substring(n2, n));
                    stringBuffer.append("&");
                } else if (string.substring(n, n3).equals("&lt")) {
                    stringBuffer.append(string.substring(n2, n));
                    stringBuffer.append("<");
                } else if (string.substring(n, n3).equals("&gt")) {
                    stringBuffer.append(string.substring(n2, n));
                    stringBuffer.append(">");
                }
                n2 = n3 + 1;
            }
            n = string.indexOf("&", n2);
        }
        if (n == -1) {
            stringBuffer.append(string.substring(n2, string.length()));
        }
        return stringBuffer.toString();
    }
}

