/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.util.html.HTMLConstants;
import com.ibm.as400.util.html.HTMLTagAttributes;
import java.awt.Color;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class HTMLText
extends HTMLTagAttributes
implements HTMLConstants,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = 8640694441108878894L;
    private String text_;
    private String alignment_;
    private Color color_;
    private int size_ = 0;
    private boolean bold_ = false;
    private boolean fixed_ = false;
    private boolean italic_ = false;
    private boolean underscore_ = false;
    private String lang_;
    private String dir_;
    private boolean useFO_;
    private transient VetoableChangeSupport vetos_;

    public HTMLText() {
    }

    public HTMLText(String string) {
        this();
        try {
            this.setText(string);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(vetoableChangeListener);
    }

    public String getAlignment() {
        return this.alignment_;
    }

    public Color getColor() {
        return this.color_;
    }

    public String getDirection() {
        return this.dir_;
    }

    String getDirectionAttributeTag() {
        if (this.useFO_) {
            if (this.dir_ != null && this.dir_.length() > 0) {
                if (this.dir_.equals("rtl")) {
                    return " writing-mode='rl'";
                }
                return " writing-mode='lr'";
            }
            return "";
        }
        if (this.dir_ != null && this.dir_.length() > 0) {
            return " dir=\"" + this.dir_ + "\"";
        }
        return "";
    }

    String getEndTextAlignmentTag() {
        if (this.alignment_ != null) {
            return "</div>";
        }
        return "";
    }

    String getEndTextFontTag() {
        if (this.size_ != 0 || this.color_ != null || this.getAttributeString().length() != 0) {
            return "</font>";
        }
        return "";
    }

    String getEndTextStyleTag() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.fixed_ && !this.useFO_) {
            stringBuffer.append("</tt>");
        }
        if (this.underscore_) {
            if (!this.useFO_) {
                stringBuffer.append("</u>");
            } else {
                stringBuffer.append("</fo:inline>\n");
            }
        }
        if (this.italic_ && !this.useFO_) {
            stringBuffer.append("</i>");
        }
        if (this.bold_ && !this.useFO_) {
            stringBuffer.append("</b>");
        }
        return stringBuffer.toString();
    }

    String getFontColorAttribute() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.color_ != null) {
            stringBuffer.append(" color=\"#");
            String string = Integer.toHexString(this.color_.getRGB());
            stringBuffer.append(new String(string.substring(2)));
            stringBuffer.append("\"");
        }
        return new String(stringBuffer);
    }

    String getFontSizeAttribute() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.size_ != 0) {
            if (!this.useFO_) {
                stringBuffer.append(" size=\"");
                stringBuffer.append(this.size_);
                stringBuffer.append("\"");
            } else {
                stringBuffer.append(" font-size='");
                stringBuffer.append(this.size_ * 3);
                stringBuffer.append("pt'");
            }
        }
        return stringBuffer.toString();
    }

    public String getLanguage() {
        return this.lang_;
    }

    String getLanguageAttributeTag() {
        if (this.lang_ != null && this.lang_.length() > 0) {
            return " lang=\"" + this.lang_ + "\"";
        }
        return "";
    }

    public int getSize() {
        return this.size_;
    }

    public String getTag() {
        return this.getTag(this.text_, false);
    }

    public String getFOTag() {
        return this.getFOTag(this.text_, false);
    }

    public String getTag(boolean bl) {
        return this.getTag(this.text_, bl);
    }

    public String getFOTag(boolean bl) {
        return this.getFOTag(this.text_, bl);
    }

    public String getTag(String string) {
        return this.getTag(string, false);
    }

    public String getFOTag(String string) {
        return this.getFOTag(string, false);
    }

    public String getTag(String string, boolean bl) {
        if (this.useFO_) {
            return this.getFOTag(string, bl);
        }
        if (string == null) {
            throw new NullPointerException("text");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(this.getTextAlignmentTag());
        }
        stringBuffer.append(this.getTextFontTag());
        if (this.lang_ != null || this.dir_ != null) {
            stringBuffer.append("\n<bdo");
            stringBuffer.append(this.getLanguageAttributeTag());
            stringBuffer.append(this.getDirectionAttributeTag());
            stringBuffer.append(">\n");
            stringBuffer.append(this.getTextStyleTag());
            stringBuffer.append(string);
            stringBuffer.append(this.getEndTextStyleTag());
            stringBuffer.append("\n</bdo>\n");
        } else {
            stringBuffer.append(this.getTextStyleTag());
            stringBuffer.append(string);
            stringBuffer.append(this.getEndTextStyleTag());
        }
        stringBuffer.append(this.getEndTextFontTag());
        if (bl) {
            stringBuffer.append(this.getEndTextAlignmentTag());
        }
        return stringBuffer.toString();
    }

    public String getFOTag(String string, boolean bl) {
        boolean bl2 = this.useFO_;
        this.setUseFO(true);
        if (string == null) {
            throw new NullPointerException("text");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.dir_ != null) {
            stringBuffer.append("<fo:block-container");
            stringBuffer.append(this.getDirectionAttributeTag());
            stringBuffer.append(">\n");
        }
        stringBuffer.append("<fo:block");
        if (bl) {
            stringBuffer.append(this.getTextAlignmentTag());
        }
        stringBuffer.append(this.getTextFontTag());
        stringBuffer.append(this.getTextStyleTag());
        stringBuffer.append(">");
        stringBuffer.append(string);
        stringBuffer.append(this.getEndTextStyleTag());
        stringBuffer.append("</fo:block>\n");
        if (this.dir_ != null) {
            stringBuffer.append("</fo:block-container>\n");
        }
        this.setUseFO(bl2);
        return stringBuffer.toString();
    }

    public String getText() {
        return this.text_;
    }

    String getTextAlignmentTag() {
        if (!this.useFO_) {
            if (this.alignment_ != null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<div align=\"");
                stringBuffer.append(this.alignment_);
                stringBuffer.append("\">");
                return stringBuffer.toString();
            }
            return "";
        }
        if (this.alignment_ != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(" text-align='");
            if (this.alignment_.equals("center")) {
                stringBuffer.append("center'");
            } else if (this.alignment_.equals("right")) {
                stringBuffer.append("end'");
            } else if (this.alignment_.equals("left")) {
                stringBuffer.append("start'");
            } else if (this.alignment_.equals("justify")) {
                stringBuffer.append("justify'");
            }
            return stringBuffer.toString();
        }
        return "";
    }

    String getTextFontTag() {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = this.getAttributeString();
        if (this.size_ != 0 || this.color_ != null || string.length() != 0) {
            if (!this.useFO_) {
                stringBuffer.append("<font");
                stringBuffer.append(this.getFontSizeAttribute());
                stringBuffer.append(this.getFontColorAttribute());
                stringBuffer.append(string);
                stringBuffer.append(">");
            } else {
                stringBuffer.append(this.getFontSizeAttribute());
                stringBuffer.append(this.getFontColorAttribute());
            }
        }
        return stringBuffer.toString();
    }

    String getTextStyleTag() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.bold_) {
            if (!this.useFO_) {
                stringBuffer.append("<b>");
            } else {
                stringBuffer.append(" font-weight='bold'");
            }
        }
        if (this.italic_) {
            if (!this.useFO_) {
                stringBuffer.append("<i>");
            } else {
                stringBuffer.append(" font-style='italic'");
            }
        }
        if (this.underscore_) {
            if (!this.useFO_) {
                stringBuffer.append("<u>");
            } else {
                stringBuffer.append(">\n<fo:inline text-decoration='underline'");
            }
        }
        if (this.fixed_ && !this.useFO_) {
            stringBuffer.append("<tt>");
        }
        return stringBuffer.toString();
    }

    public boolean isBold() {
        return this.bold_;
    }

    public boolean isFixed() {
        return this.fixed_;
    }

    public boolean isItalic() {
        return this.italic_;
    }

    public boolean isUnderscore() {
        return this.underscore_;
    }

    public boolean isUseFO() {
        return this.useFO_;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public void setAlignment(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("alignment");
        }
        if (string.equalsIgnoreCase("left") || string.equalsIgnoreCase("center") || string.equalsIgnoreCase("right") || string.equalsIgnoreCase("justify")) {
            String string2 = this.alignment_;
            if (this.vetos_ != null) {
                this.vetos_.fireVetoableChange("alignment", string2, string);
            }
            this.alignment_ = string;
            if (this.changes_ != null) {
                this.changes_.firePropertyChange("alignment", string2, string);
            }
        } else {
            throw new ExtendedIllegalArgumentException("alignment", 2);
        }
    }

    public void setBold(boolean bl) throws PropertyVetoException {
        boolean bl2 = this.bold_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("bold", new Boolean(bl2), new Boolean(bl));
        }
        this.bold_ = bl;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("bold", new Boolean(bl2), new Boolean(bl));
        }
    }

    public void setColor(Color color) throws PropertyVetoException {
        Color color2 = this.color_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("color", color2, color);
        }
        this.color_ = color;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("color", color2, color);
        }
    }

    public void setDirection(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("dir");
        }
        if (!string.equals("ltr") && !string.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        String string2 = this.dir_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("dir", string2, string);
        }
        this.dir_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dir", string2, string);
        }
    }

    public void setFixed(boolean bl) throws PropertyVetoException {
        boolean bl2 = this.fixed_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("fixed", new Boolean(bl2), new Boolean(bl));
        }
        this.fixed_ = bl;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("fixed", new Boolean(bl2), new Boolean(bl));
        }
    }

    public void setItalic(boolean bl) throws PropertyVetoException {
        boolean bl2 = this.italic_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("italic", new Boolean(bl2), new Boolean(bl));
        }
        this.italic_ = bl;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("italic", new Boolean(bl2), new Boolean(bl));
        }
    }

    public void setLanguage(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("lang");
        }
        String string2 = this.lang_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("lang", string2, string);
        }
        this.lang_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("lang", string2, string);
        }
    }

    public void setSize(int n) throws PropertyVetoException {
        if (n < 0 || n > 7) {
            throw new ExtendedIllegalArgumentException("size", 4);
        }
        int n2 = this.size_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("size", new Integer(n2), new Integer(n));
        }
        this.size_ = n;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("size", new Integer(n2), new Integer(n));
        }
    }

    public void setText(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("text");
        }
        String string2 = this.text_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("text", string2, string);
        }
        this.text_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("text", string2, string);
        }
    }

    public void setUnderscore(boolean bl) throws PropertyVetoException {
        boolean bl2 = this.underscore_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("underscore", new Boolean(bl2), new Boolean(bl));
        }
        this.underscore_ = bl;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("underscore", new Boolean(bl2), new Boolean(bl));
        }
    }

    public void setUseFO(boolean bl) {
        boolean bl2 = this.useFO_;
        this.useFO_ = bl;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("useFO", bl2, bl);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

