/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.util.html.ElementEvent;
import com.ibm.as400.util.html.ElementListener;
import com.ibm.as400.util.html.HTMLListItem;
import com.ibm.as400.util.html.HTMLTagAttributes;
import com.ibm.as400.util.html.HTMLTagElement;
import com.ibm.as400.util.html.OrderedListItem;
import com.ibm.as400.util.html.UnorderedListItem;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public abstract class HTMLList
extends HTMLTagAttributes
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = -3017041765887905594L;
    private boolean compact_ = false;
    private Vector listItems_;
    private String lang_;
    private String dir_;
    private boolean useFO_ = false;
    private int value_ = -1;
    private transient Vector elementListeners;

    public HTMLList() {
        this.listItems_ = new Vector();
    }

    public HTMLList(Vector vector) {
        this.setItems(vector);
    }

    public void addListItem(HTMLListItem hTMLListItem) {
        if (hTMLListItem == null) {
            throw new NullPointerException("item");
        }
        this.listItems_.addElement(hTMLListItem);
        this.fireElementEvent(0);
    }

    public void addList(HTMLList hTMLList) {
        if (hTMLList == null) {
            throw new NullPointerException("list");
        }
        this.listItems_.addElement(hTMLList);
        this.fireElementEvent(0);
    }

    public void addListItemElementListener(ElementListener elementListener) {
        if (elementListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners == null) {
            this.elementListeners = new Vector();
        }
        this.elementListeners.addElement(elementListener);
    }

    private void fireElementEvent(int n) {
        if (this.elementListeners == null) {
            return;
        }
        Vector vector = (Vector)this.elementListeners.clone();
        ElementEvent elementEvent = new ElementEvent(this, n);
        for (int i = 0; i < vector.size(); ++i) {
            ElementListener elementListener = (ElementListener)vector.elementAt(i);
            if (n == 0) {
                elementListener.elementAdded(elementEvent);
                continue;
            }
            if (n != 2) continue;
            elementListener.elementRemoved(elementEvent);
        }
    }

    public String getDirection() {
        return this.dir_;
    }

    String getDirectionAttributeTag() {
        if (this.useFO_) {
            if (this.dir_ != null && this.dir_.length() > 0) {
                if (this.dir_.equals("rtl")) {
                    return " writing-mode='rl'";
                }
                return " writing-mode='lr'";
            }
            return "";
        }
        if (this.dir_ != null && this.dir_.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer(" dir=\"");
            stringBuffer.append(this.dir_);
            stringBuffer.append("\"");
            return stringBuffer.toString();
        }
        return "";
    }

    public int getItemCount() {
        return this.listItems_.size();
    }

    public Vector getItems() {
        return this.listItems_;
    }

    String getItemAttributeTag() {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < this.listItems_.size(); ++i) {
            HTMLTagElement hTMLTagElement = (HTMLTagElement)this.listItems_.elementAt(i);
            stringBuffer.append(hTMLTagElement.getTag());
        }
        return stringBuffer.toString();
    }

    String getItemAttributeFOTag(String string) {
        String string2 = null;
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = this.listItems_.size();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append("<fo:list-item>\n<fo:list-item-label>");
            HTMLTagElement hTMLTagElement = (HTMLTagElement)this.listItems_.elementAt(i);
            if (this.listItems_.elementAt(i) instanceof HTMLListItem) {
                HTMLListItem hTMLListItem;
                ++n;
                if (this.listItems_.elementAt(i) instanceof OrderedListItem) {
                    hTMLListItem = (OrderedListItem)this.listItems_.elementAt(i);
                    this.value_ = ((OrderedListItem)hTMLListItem).getValue();
                    if (this.value_ > 0) {
                        n = this.value_;
                    }
                    string2 = ((OrderedListItem)hTMLListItem).getType();
                } else {
                    hTMLListItem = (UnorderedListItem)this.listItems_.elementAt(i);
                    string2 = ((UnorderedListItem)hTMLListItem).getType();
                }
                if (string2 == null) {
                    string2 = string;
                }
                hTMLListItem = (HTMLListItem)this.listItems_.elementAt(i);
                stringBuffer.append(hTMLListItem.getTypeAttributeFO(string2, n));
            }
            stringBuffer.append("</fo:list-item-label>\n<fo:list-item-body>");
            stringBuffer.append(hTMLTagElement.getFOTag());
            stringBuffer.append("</fo:list-item-body>\n</fo:list-item>\n");
        }
        return stringBuffer.toString();
    }

    public String getLanguage() {
        return this.lang_;
    }

    String getLanguageAttributeTag() {
        if (this.lang_ != null && this.lang_.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer(" lang=\"");
            stringBuffer.append(this.lang_);
            stringBuffer.append("\"");
            return stringBuffer.toString();
        }
        return "";
    }

    public boolean isCompact() {
        return this.compact_;
    }

    public boolean isUseFO() {
        return this.useFO_;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public void removeListItem(HTMLListItem hTMLListItem) {
        if (hTMLListItem == null) {
            throw new NullPointerException("item");
        }
        if (this.listItems_.removeElement(hTMLListItem)) {
            this.fireElementEvent(2);
        }
    }

    public void removeList(HTMLList hTMLList) {
        if (hTMLList == null) {
            throw new NullPointerException("list");
        }
        if (this.listItems_.removeElement(hTMLList)) {
            this.fireElementEvent(2);
        }
    }

    public void removeListItemElementListener(ElementListener elementListener) {
        if (elementListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners != null) {
            this.elementListeners.removeElement(elementListener);
        }
    }

    public void setCompact(boolean bl) {
        boolean bl2 = this.compact_;
        this.compact_ = bl;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("compact", new Boolean(bl2), new Boolean(bl));
        }
    }

    public void setDirection(String string) {
        if (string == null) {
            throw new NullPointerException("dir");
        }
        if (!string.equals("ltr") && !string.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        String string2 = this.dir_;
        this.dir_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dir", string2, string);
        }
    }

    public void setItems(Vector vector) {
        if (vector == null) {
            throw new NullPointerException("items");
        }
        Vector vector2 = this.listItems_;
        this.listItems_ = vector;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("items", vector2, vector);
        }
    }

    public void setLanguage(String string) {
        if (string == null) {
            throw new NullPointerException("lang");
        }
        String string2 = this.lang_;
        this.lang_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("lang", string2, string);
        }
    }

    public void setUseFO(boolean bl) {
        boolean bl2 = this.useFO_;
        this.useFO_ = bl;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("useFO", bl2, bl);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

