/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.HTMLTagAttributes;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class HTMLHeading
extends HTMLTagAttributes
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4715727576328707163L;
    private int level_;
    private String text_;
    private String align_;
    private String lang_;
    private String dir_;
    private boolean useFO_ = false;

    public HTMLHeading() {
        this.setLevel(1);
    }

    public HTMLHeading(int n) {
        this.setLevel(n);
    }

    public HTMLHeading(int n, String string) {
        this.setLevel(n);
        this.setText(string);
    }

    public HTMLHeading(int n, String string, String string2) {
        this.setLevel(n);
        this.setText(string);
        this.setAlign(string2);
    }

    public String getAlign() {
        return this.align_;
    }

    public String getDirection() {
        return this.dir_;
    }

    String getDirectionAttributeTag() {
        if (this.useFO_) {
            if (this.dir_ != null && this.dir_.length() > 0) {
                if (this.dir_.equals("rtl")) {
                    return " writing-mode='rl'";
                }
                return " writing-mode='lr'";
            }
            return "";
        }
        if (this.dir_ != null && this.dir_.length() > 0) {
            return " dir=\"" + this.dir_ + "\"";
        }
        return "";
    }

    public String getLanguage() {
        return this.lang_;
    }

    String getLanguageAttributeTag() {
        if (this.lang_ != null && this.lang_.length() > 0) {
            return " lang=\"" + this.lang_ + "\"";
        }
        return "";
    }

    public int getLevel() {
        return this.level_;
    }

    public String getText() {
        return this.text_;
    }

    public String getTag() {
        if (this.useFO_) {
            return this.getFOTag();
        }
        if (this.text_ == null) {
            Trace.log(2, "Attempting to get tag before setting heading text.");
            throw new ExtendedIllegalStateException("text", 4);
        }
        StringBuffer stringBuffer = new StringBuffer("<h" + Integer.toString(this.level_));
        if (this.align_ != null) {
            if (this.align_.equals("left")) {
                stringBuffer.append(" align=\"left\"");
            } else if (this.align_.equals("right")) {
                stringBuffer.append(" align=\"right\"");
            } else if (this.align_.equals("center")) {
                stringBuffer.append(" align=\"center\"");
            }
        }
        stringBuffer.append(this.getLanguageAttributeTag());
        stringBuffer.append(this.getDirectionAttributeTag());
        stringBuffer.append(this.getAttributeString());
        stringBuffer.append(">" + this.text_ + "</h");
        if (this.level_ > 0) {
            stringBuffer.append(Integer.toString(this.level_));
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public String getFOTag() {
        boolean bl = this.useFO_;
        this.setUseFO(true);
        if (this.text_ == null) {
            Trace.log(2, "Attempting to get XSL-FO tag before setting heading text.");
            throw new ExtendedIllegalStateException("text", 4);
        }
        StringBuffer stringBuffer = new StringBuffer("<fo:block-container");
        stringBuffer.append(this.getDirectionAttributeTag());
        stringBuffer.append(">\n");
        stringBuffer.append("<fo:block");
        switch (this.level_) {
            case 1: {
                stringBuffer.append(" font-size='25pt'");
                break;
            }
            case 2: {
                stringBuffer.append(" font-size='20pt'");
                break;
            }
            case 3: {
                stringBuffer.append(" font-size='15pt'");
                break;
            }
            case 4: {
                stringBuffer.append(" font-size='13pt'");
                break;
            }
            case 5: {
                stringBuffer.append(" font-size='11pt'");
                break;
            }
            case 6: {
                stringBuffer.append(" font-size='9pt'");
            }
        }
        if (this.align_ != null) {
            if (this.align_.equals("left")) {
                stringBuffer.append(" text-align='start'");
            } else if (this.align_.equals("right")) {
                stringBuffer.append(" text-align='end'");
            } else if (this.align_.equals("center")) {
                stringBuffer.append(" text-align='center'");
            }
        }
        stringBuffer.append(">");
        stringBuffer.append(this.text_);
        stringBuffer.append("</fo:block>\n");
        stringBuffer.append("</fo:block-container>\n");
        this.setUseFO(bl);
        return stringBuffer.toString();
    }

    public boolean isUseFO() {
        return this.useFO_;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public void setAlign(String string) {
        if (string == null) {
            throw new NullPointerException("align");
        }
        if (!(string.equals("left") || string.equals("right") || string.equals("center"))) {
            throw new ExtendedIllegalArgumentException("align", 2);
        }
        String string2 = this.align_;
        this.align_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("align", string2, string);
        }
    }

    public void setDirection(String string) {
        if (string == null) {
            throw new NullPointerException("dir");
        }
        if (!string.equals("ltr") && !string.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        String string2 = this.dir_;
        this.dir_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dir", string2, string);
        }
    }

    public void setLanguage(String string) {
        if (string == null) {
            throw new NullPointerException("lang");
        }
        String string2 = this.lang_;
        this.lang_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("lang", string2, string);
        }
    }

    public void setLevel(int n) {
        if (n < 1 || n > 6) {
            throw new ExtendedIllegalArgumentException("level", 4);
        }
        int n2 = this.level_;
        this.level_ = n;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("level", new Integer(n2), new Integer(n));
        }
    }

    public void setText(String string) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        if (string.length() == 0) {
            throw new ExtendedIllegalArgumentException("text", 1);
        }
        String string2 = this.text_;
        this.text_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("text", string2, string);
        }
    }

    public void setUseFO(boolean bl) {
        boolean bl2 = this.useFO_;
        this.useFO_ = bl;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("useFO", bl2, bl);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

