/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.IFSJavaFile;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.DirFilter;
import com.ibm.as400.util.html.HTMLFileFilter;
import com.ibm.as400.util.html.HTMLTree;
import com.ibm.as400.util.html.ResourceBundleLoader_h;
import com.ibm.as400.util.html.URLEncoder;
import com.ibm.as400.util.servlet.ListMetaData;
import com.ibm.as400.util.servlet.ListRowData;
import com.ibm.as400.util.servlet.RowDataException;
import java.beans.PropertyVetoException;
import java.io.File;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class FileListRenderer {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private HttpServletRequest request_;
    private String uri_;
    private String reqPath_;
    private StringBuffer sharePath_;
    private StringBuffer shareName_;
    private SimpleDateFormat formatter_ = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss a");
    private static ResourceBundleLoader_h loader_;
    private static String name;
    private static String size;
    private static String type;
    private static String modified;

    public FileListRenderer(HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null) {
            throw new NullPointerException("request");
        }
        this.uri_ = httpServletRequest.getRequestURI();
        String string = httpServletRequest.getServletPath();
        int n = this.uri_.indexOf(string);
        this.uri_ = this.uri_.substring(0, n + string.length());
        this.reqPath_ = httpServletRequest.getPathInfo();
    }

    public FileListRenderer(HttpServletRequest httpServletRequest, String string, String string2) {
        this(httpServletRequest);
        if (string2 == null) {
            throw new NullPointerException("sharePath");
        }
        if (string == null) {
            throw new NullPointerException("shareName");
        }
        this.sharePath_ = new StringBuffer(string2);
        this.shareName_ = new StringBuffer(string);
        if (Trace.isTraceOn()) {
            Trace.log(3, "Renderer sharePath: " + this.shareName_);
            Trace.log(3, "Renderer shareName: " + this.sharePath_);
        }
    }

    public String getDirectoryName(File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        String string = file.getName();
        StringBuffer stringBuffer = new StringBuffer("<a href=\"");
        stringBuffer.append(this.uri_);
        stringBuffer.append(URLEncoder.encode(this.reqPath_.replace('\\', '/'), false));
        stringBuffer.append(this.reqPath_.endsWith("/") ? "" : "/");
        stringBuffer.append(URLEncoder.encode(string, false));
        stringBuffer.append("\">");
        stringBuffer.append(string);
        stringBuffer.append("</a>");
        return stringBuffer.toString();
    }

    public String getFileName(File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        return file.getName();
    }

    public String getParentName(File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        String string = file.getParent();
        if (string != null) {
            block6: {
                if (this.sharePath_ != null) {
                    try {
                        string = this.shareName_.append(string.substring(this.sharePath_.length(), string.length())).toString();
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        if (string.length() >= this.sharePath_.length()) break block6;
                        return null;
                    }
                }
            }
            if (Trace.isTraceOn()) {
                Trace.log(3, "Renderer parent: " + string);
            }
            StringBuffer stringBuffer = new StringBuffer("<a href=\"");
            stringBuffer.append(this.uri_);
            stringBuffer.append(string.startsWith("\\") || string.startsWith("/") ? "" : "/");
            stringBuffer.append(string != null ? URLEncoder.encode(string.replace('\\', '/'), false) : "");
            stringBuffer.append("\">../ (Parent Directory)</a>");
            return stringBuffer.toString();
        }
        return null;
    }

    public ListRowData getRowData(File file, boolean bl, Collator collator) throws RowDataException {
        Date date;
        Object object;
        String[] stringArray;
        Object object2;
        Object[] objectArray;
        ListMetaData listMetaData = new ListMetaData(4);
        listMetaData.setColumnName(0, "Name");
        listMetaData.setColumnLabel(0, name);
        listMetaData.setColumnType(0, 8);
        listMetaData.setColumnName(1, "Size");
        listMetaData.setColumnLabel(1, size);
        listMetaData.setColumnType(1, 5);
        listMetaData.setColumnName(2, "Type");
        listMetaData.setColumnLabel(2, type);
        listMetaData.setColumnType(2, 8);
        listMetaData.setColumnName(3, "Modified");
        listMetaData.setColumnLabel(3, modified);
        listMetaData.setColumnType(3, 8);
        ListRowData listRowData = new ListRowData();
        try {
            listRowData.setMetaData(listMetaData);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        String string = this.getParentName(file);
        if (string != null) {
            objectArray = new Object[]{string.replace('\\', '/'), "", "", ""};
            listRowData.addRow(objectArray);
        }
        objectArray = null;
        Object[] objectArray2 = null;
        if (file instanceof IFSJavaFile) {
            object2 = ((IFSJavaFile)file).listFiles();
            stringArray = new Vector();
            object = new Vector<Object>();
            for (int i = 0; i < ((Object[])object2).length; ++i) {
                if (((File)object2[i]).isDirectory()) {
                    stringArray.addElement(object2[i]);
                    continue;
                }
                ((Vector)object).addElement(object2[i]);
            }
            objectArray = new File[stringArray.size()];
            objectArray2 = new File[((Vector)object).size()];
            stringArray.copyInto(objectArray);
            ((Vector)object).copyInto(objectArray2);
        } else {
            object2 = file.list(new DirFilter());
            objectArray = new File[((Object[])object2).length];
            for (int i = 0; i < ((Object[])object2).length; ++i) {
                objectArray[i] = new File(file, (String)object2[i]);
            }
            stringArray = file.list(new HTMLFileFilter());
            objectArray2 = new File[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                objectArray2[i] = new File(file, stringArray[i]);
            }
        }
        if (objectArray != null) {
            if (bl) {
                object2 = new Vector();
                for (int i = 0; i < objectArray.length; ++i) {
                    ((Vector)object2).addElement(objectArray[i]);
                }
                HTMLTree.sort(collator, (Vector)object2);
                ((Vector)object2).copyInto(objectArray);
            }
            for (int i = 0; i < objectArray.length; ++i) {
                object = this.getDirectoryName((File)objectArray[i]);
                if (object == null) continue;
                Object[] objectArray3 = new Object[4];
                date = new Date(((File)objectArray[i]).lastModified());
                objectArray3[0] = ((String)object).replace('\\', '/');
                objectArray3[1] = "";
                objectArray3[2] = "Directory";
                objectArray3[3] = this.formatter_.format(date);
                listRowData.addRow(objectArray3);
            }
        }
        if (objectArray2 != null) {
            if (bl) {
                object2 = new Vector();
                for (int i = 0; i < objectArray2.length; ++i) {
                    ((Vector)object2).addElement(objectArray2[i]);
                }
                HTMLTree.sort(collator, (Vector)object2);
                ((Vector)object2).copyInto(objectArray2);
            }
            for (int i = 0; i < objectArray2.length; ++i) {
                object = this.getFileName((File)objectArray2[i]);
                if (object == null) continue;
                Object[] objectArray4 = new Object[4];
                date = new Date(((File)objectArray2[i]).lastModified());
                objectArray4[0] = ((String)object).replace('\\', '/');
                objectArray4[1] = new Long(((File)objectArray2[i]).length());
                objectArray4[2] = "File";
                objectArray4[3] = this.formatter_.format(date);
                listRowData.addRow(objectArray4);
            }
        }
        return listRowData;
    }

    static {
        name = ResourceBundleLoader_h.getText("PROP_FLE_NAME_NAME");
        size = ResourceBundleLoader_h.getText("PROP_FLE_NAME_SIZE");
        type = ResourceBundleLoader_h.getText("PROP_FLE_NAME_TYPE");
        modified = ResourceBundleLoader_h.getText("PROP_FLE_NAME_MODIFIED");
    }
}

