/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.IFSDataStream;
import com.ibm.as400.access.IFSFileDescriptorImpl;
import com.ibm.as400.access.IFSFileDescriptorImplRemote;
import com.ibm.as400.access.IFSFileOutputStreamImpl;
import com.ibm.as400.access.IFSKey;
import com.ibm.as400.access.IFSListAttrsRep;
import com.ibm.as400.access.IFSListAttrsReq;
import com.ibm.as400.access.IFSOpenRep;
import com.ibm.as400.access.IFSOpenReq;
import com.ibm.as400.access.IFSReturnCodeRep;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;

class IFSFileOutputStreamImplRemote
extends OutputStream
implements IFSFileOutputStreamImpl {
    private boolean append_ = false;
    private IFSFileDescriptorImplRemote fd_;
    private transient ConverterImplRemote converter_;
    private static final boolean DEBUG = false;

    IFSFileOutputStreamImplRemote() {
    }

    public void close() throws IOException {
        this.fd_.close0();
    }

    public void connectAndOpen(int n) throws AS400SecurityException, IOException {
        this.fd_.connect();
        if (n == -1) {
            this.open(this.fd_.getPreferredCCSID());
        } else {
            this.open(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.fd_ != null) {
                this.fd_.finalize0();
            }
        }
        catch (Throwable throwable) {
            Trace.log(2, "Error during finalization.", throwable);
        }
        finally {
            super.finalize();
        }
    }

    public void flush() throws IOException {
        this.open(this.fd_.getPreferredCCSID());
        try {
            this.fd_.flush();
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw new IOException(aS400SecurityException.getMessage());
        }
    }

    public IFSKey lock(int n) throws IOException {
        this.open(this.fd_.getPreferredCCSID());
        try {
            return this.fd_.lock(n);
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw new IOException(aS400SecurityException.getMessage());
        }
    }

    public void open(int n) throws IOException {
        if (this.fd_.isOpen_) {
            return;
        }
        if (!this.fd_.isOpenAllowed_) {
            throw new ConnectionDroppedException(3);
        }
        String string = this.fd_.getPath();
        if (string.length() == 0) {
            throw new ExtendedIllegalStateException("path", 4);
        }
        try {
            this.fd_.connect();
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, "Security exception", (Throwable)aS400SecurityException);
            throw new ExtendedIOException(5);
        }
        byte[] byArray = this.fd_.getConverter().stringToByteArray(string);
        if (n == -1) {
            n = this.fd_.getPreferredCCSID();
        }
        IFSOpenReq iFSOpenReq = new IFSOpenReq(byArray, this.fd_.getPreferredCCSID(), n, 2, ~this.fd_.getShareOption(), 0, this.append_ ? 1 : 2, this.fd_.serverDatastreamLevel_);
        ClientAccessDataStream clientAccessDataStream = null;
        try {
            clientAccessDataStream = (ClientAccessDataStream)this.fd_.getServer().sendAndReceive(iFSOpenReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream server connection lost");
            this.fd_.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted", (Throwable)interruptedException);
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        if (clientAccessDataStream instanceof IFSOpenRep) {
            IFSOpenRep iFSOpenRep = (IFSOpenRep)clientAccessDataStream;
            this.fd_.setOpen(true, iFSOpenRep.getFileHandle());
            this.fd_.setOpenAllowed(false);
            if (this.append_) {
                this.fd_.setFileOffset(iFSOpenRep.getFileSize(this.fd_.serverDatastreamLevel_));
            }
        } else {
            if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                int n2 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                if (n2 == 1) {
                    Trace.log(2, "IFSReturnCodeRep return code ", n2);
                    throw new ExtendedIOException(32);
                }
                Trace.log(2, "IFSReturnCodeRep return code ", n2);
                throw new ExtendedIOException(n2);
            }
            Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
            throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
        }
    }

    public void setAppend(boolean bl) {
        this.append_ = bl;
    }

    public void setFD(IFSFileDescriptorImpl iFSFileDescriptorImpl) {
        this.fd_ = IFSFileDescriptorImplRemote.castImplToImplRemote(iFSFileDescriptorImpl);
    }

    public void unlock(IFSKey iFSKey) throws IOException {
        this.open(this.fd_.getPreferredCCSID());
        try {
            this.fd_.unlock(iFSKey);
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw new IOException(aS400SecurityException.getMessage());
        }
    }

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.open(this.fd_.getPreferredCCSID());
        int n3 = this.fd_.getFileHandle();
        if (this.append_) {
            IFSListAttrsReq iFSListAttrsReq = new IFSListAttrsReq(n3);
            ClientAccessDataStream clientAccessDataStream = null;
            try {
                clientAccessDataStream = (ClientAccessDataStream)this.fd_.getServer().sendAndReceive(iFSListAttrsReq);
            }
            catch (ConnectionDroppedException connectionDroppedException) {
                Trace.log(2, "Byte stream server connection lost");
                this.fd_.connectionDropped(connectionDroppedException);
            }
            catch (InterruptedException interruptedException) {
                Trace.log(2, "Interrupted", (Throwable)interruptedException);
                throw new InterruptedIOException(interruptedException.getMessage());
            }
            if (clientAccessDataStream instanceof IFSListAttrsRep) {
                IFSListAttrsRep iFSListAttrsRep = (IFSListAttrsRep)clientAccessDataStream;
                this.fd_.setFileOffset(iFSListAttrsRep.getSize(this.fd_.serverDatastreamLevel_));
            } else if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                int n4 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                if (n4 != 0) {
                    Trace.log(2, "IFSReturnCodeRep return code ", n4);
                    throw new ExtendedIOException(n4);
                }
            } else {
                Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
                throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
            }
        }
        try {
            this.fd_.writeBytes(byArray, n, n2);
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw new IOException(aS400SecurityException.getMessage());
        }
    }

    public void writeText(String string, int n) throws IOException {
        this.open(n);
        if (this.converter_ == null) {
            int n2 = 0;
            if (n == -1) {
                try {
                    ClientAccessDataStream clientAccessDataStream = null;
                    byte[] byArray = this.fd_.getConverter().stringToByteArray(this.fd_.getPath());
                    IFSListAttrsReq iFSListAttrsReq = new IFSListAttrsReq(this.fd_.getFileHandle(), 2, 0, 0);
                    clientAccessDataStream = (ClientAccessDataStream)this.fd_.getServer().sendAndReceive(iFSListAttrsReq);
                    boolean bl = false;
                    boolean bl2 = false;
                    do {
                        if (clientAccessDataStream instanceof IFSListAttrsRep) {
                            if (Trace.traceOn_ && bl2) {
                                Trace.log(1, "Received multiple replies from ListAttributes request.");
                            }
                            n2 = ((IFSListAttrsRep)clientAccessDataStream).getCCSID(this.fd_.serverDatastreamLevel_);
                            bl2 = true;
                        } else if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                            int n3 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                            if (n3 != 18 && n3 != 0) {
                                Trace.log(2, "IFSReturnCodeRep return code = ", n3);
                                throw new ExtendedIOException(n3);
                            }
                        } else {
                            Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
                            throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
                        }
                        bl = ((IFSDataStream)clientAccessDataStream).isEndOfChain();
                        if (bl) continue;
                        try {
                            clientAccessDataStream = (ClientAccessDataStream)this.fd_.getServer().receive(iFSListAttrsReq.getCorrelation());
                        }
                        catch (ConnectionDroppedException connectionDroppedException) {
                            Trace.log(2, "Byte stream server connection lost.");
                            this.fd_.connectionDropped(connectionDroppedException);
                        }
                        catch (InterruptedException interruptedException) {
                            Trace.log(2, "Interrupted");
                            throw new InterruptedIOException(interruptedException.getMessage());
                        }
                    } while (!bl);
                    if (!bl2 || n2 == 0) {
                        Trace.log(2, "Unable to determine CCSID of file " + this.fd_.path_);
                        throw new ExtendedIOException(25);
                    }
                }
                catch (ConnectionDroppedException connectionDroppedException) {
                    this.fd_.connectionDropped(connectionDroppedException);
                }
                catch (InterruptedException interruptedException) {
                    Trace.log(2, "Interrupted", (Throwable)interruptedException);
                    throw new InterruptedIOException(interruptedException.getMessage());
                }
                n = n2;
            }
            this.converter_ = ConverterImplRemote.getConverter(n, this.fd_.getSystem());
        }
        this.write(this.converter_.stringToByteArray(string));
    }

    static {
        AS400Server.addReplyStream((DataStream)new IFSListAttrsRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSOpenRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSReturnCodeRep(), 0);
    }
}

