/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.spinner;

import com.ibm.spinner.ArrowButtonThread;
import com.ibm.spinner.BasicArrowButton;
import com.ibm.spinner.SpinnerErrorMessageSource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SpinnerGUI
extends JPanel
implements SwingConstants,
KeyListener,
ChangeListener,
FocusListener,
MouseListener {
    public static final int SPIN_VERTICAL = 0;
    public static final int SPIN_HORIZONTAL = 1;
    private int columns = 20;
    private int orientation = 0;
    private Color incrButtonArrowColor = Color.black;
    private Color decrButtonArrowColor = Color.black;
    private boolean editable = true;
    private boolean spinnable = true;
    protected BasicArrowButton incrButton = new BasicArrowButton();
    protected BasicArrowButton decrButton = new BasicArrowButton();
    protected JTextField textField = new JTextField();
    private JPanel jpanel = new JPanel();
    protected static ArrowButtonThread contSpinThread = new ArrowButtonThread("ArrowButtonThread");

    public SpinnerGUI() {
        this.setLayout(new BorderLayout());
        this.setOpaque(true);
        this.textField.setColumns(this.columns);
        this.add((Component)this.textField, "Center");
        this.jpanel.setLayout(new GridLayout(2, 1, 0, 0));
        this.incrButton.setArrowColor(Color.black);
        this.decrButton.setArrowColor(Color.black);
        this.incrButton.setArrowDirection(1);
        this.decrButton.setArrowDirection(5);
        this.add((Component)this.jpanel, "East");
        this.addButtons();
        this.incrButton.addMouseListener(this);
        this.decrButton.addMouseListener(this);
        this.textField.addMouseListener(this);
        this.incrButton.addFocusListener(this);
        this.decrButton.addFocusListener(this);
        this.textField.addFocusListener(this);
        this.incrButton.addKeyListener(this);
        this.decrButton.addKeyListener(this);
        this.textField.addKeyListener(this);
        this.incrButton.addChangeListener(this);
        this.decrButton.addChangeListener(this);
    }

    protected boolean acceptInput() {
        return true;
    }

    protected void addButtons() {
        this.incrButton.setOpaque(super.isOpaque());
        this.decrButton.setOpaque(super.isOpaque());
        this.incrButton.setArrowColor(this.getIncrButtonArrowColor());
        this.decrButton.setArrowColor(this.getDecrButtonArrowColor());
        if (this.orientation == 0) {
            this.incrButton.setArrowDirection(1);
            this.decrButton.setArrowDirection(5);
            this.jpanel.remove(this.incrButton);
            this.jpanel.remove(this.decrButton);
            this.jpanel.setLayout(new GridLayout(2, 1, 0, 0));
            this.jpanel.add(this.incrButton);
            this.jpanel.add(this.decrButton);
        }
        if (this.orientation == 1) {
            this.incrButton.setArrowDirection(3);
            this.decrButton.setArrowDirection(7);
            this.jpanel.remove(this.incrButton);
            this.jpanel.remove(this.decrButton);
            this.jpanel.setLayout(new GridLayout(1, 2, 0, 0));
            this.jpanel.add(this.decrButton);
            this.jpanel.add(this.incrButton);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public int getColumns() {
        return this.columns;
    }

    public Color getDecrButtonArrowColor() {
        return this.decrButtonArrowColor;
    }

    public boolean getEditable() {
        return this.editable;
    }

    public Color getIncrButtonArrowColor() {
        return this.incrButtonArrowColor;
    }

    public Dimension getMaximumSize() {
        Dimension dimension = this.getPreferredSize();
        dimension.width = Short.MAX_VALUE;
        return dimension;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.textField.getPreferredSize();
        Insets insets = this.getInsets();
        int n = dimension.height;
        dimension.height += insets.top + insets.bottom;
        dimension.width = this.orientation == 0 ? (dimension.width += n + insets.left + insets.right) : (dimension.width += 2 * n + insets.left + insets.right);
        return dimension;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getMinimumSize();
        dimension.width += 4;
        return dimension;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isEnabled() {
        return super.isEnabled();
    }

    public boolean isSpinnable() {
        return this.spinnable;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        MouseEvent mouseEvent2 = new MouseEvent(this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
        this.dispatchEvent(mouseEvent2);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        MouseEvent mouseEvent2 = new MouseEvent(this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
        this.dispatchEvent(mouseEvent2);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        MouseEvent mouseEvent2 = new MouseEvent(this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
        this.dispatchEvent(mouseEvent2);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        MouseEvent mouseEvent2 = new MouseEvent(this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
        this.dispatchEvent(mouseEvent2);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        MouseEvent mouseEvent2 = new MouseEvent(this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
        this.dispatchEvent(mouseEvent2);
    }

    public void scrollDown() {
        this.acceptInput();
    }

    public void scrollUp() {
        this.acceptInput();
    }

    public void setBackground(Color color) {
        if (color == null) {
            throw new IllegalArgumentException(SpinnerErrorMessageSource.getStringBy("NullPointerParameter"));
        }
        if (this.textField != null && super.getBackground() != color) {
            Color color2 = super.getBackground();
            super.setBackground(color);
            this.textField.setBackground(color);
            this.firePropertyChange("background", color2, color);
        }
    }

    public void setColumns(int n) {
        if (n > 0) {
            if (this.columns != n) {
                int n2 = this.columns;
                this.columns = n;
                this.textField.setColumns(n);
                this.repaint();
                this.firePropertyChange("columns", n2, n);
            }
        } else {
            throw new IllegalArgumentException(SpinnerErrorMessageSource.getStringBy("ColumnsOutOfRange"));
        }
    }

    public void setDecrButtonArrowColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException(SpinnerErrorMessageSource.getStringBy("NullPointerParameter"));
        }
        if (this.decrButtonArrowColor != color) {
            Color color2 = this.decrButtonArrowColor;
            this.decrButtonArrowColor = color;
            this.decrButton.setArrowColor(color);
            this.firePropertyChange("decrButtonArrowColor", color2, color);
        }
    }

    public void setEditable(boolean bl) {
        if (this.editable != bl) {
            boolean bl2 = this.editable;
            this.editable = bl;
            this.textField.setEditable(bl);
            this.firePropertyChange("editable", bl2, bl);
        }
    }

    public void setEnabled(boolean bl) {
        boolean bl2 = this.isEnabled();
        if (bl2 != bl) {
            super.setEnabled(bl);
            this.textField.setEnabled(bl);
            this.incrButton.setEnabled(bl);
            this.decrButton.setEnabled(bl);
            this.firePropertyChange("enabled", bl2, bl);
        }
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException(SpinnerErrorMessageSource.getStringBy("NullPointerParameter"));
        }
        if (this.textField != null && super.getFont() != font) {
            Font font2 = super.getFont();
            super.setFont(font);
            this.textField.setFont(font);
            this.firePropertyChange("font", font2, font);
        }
    }

    public void setForeground(Color color) {
        if (color == null) {
            throw new IllegalArgumentException(SpinnerErrorMessageSource.getStringBy("NullPointerParameter"));
        }
        if (this.textField != null && super.getForeground() != color) {
            Color color2 = super.getForeground();
            super.setForeground(color);
            this.textField.setForeground(color);
            this.firePropertyChange("foreground", color2, color);
        }
    }

    public void setIncrButtonArrowColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException(SpinnerErrorMessageSource.getStringBy("NullPointerParameter"));
        }
        if (this.incrButtonArrowColor != color) {
            Color color2 = this.incrButtonArrowColor;
            this.incrButtonArrowColor = color;
            this.incrButton.setArrowColor(color);
            this.firePropertyChange("incrButtonArrowColor", color2, color);
        }
    }

    public void setOpaque(boolean bl) {
        super.setOpaque(bl);
        boolean bl2 = super.isOpaque();
        if (this.textField != null && super.isOpaque() != bl) {
            this.textField.setOpaque(bl);
            this.incrButton.setOpaque(bl);
            this.decrButton.setOpaque(bl);
            this.repaint();
        }
        this.firePropertyChange("opaque", bl2, bl);
    }

    public void setOrientation(int n) {
        if (n == 0 || n == 1) {
            if (this.orientation != n) {
                int n2 = this.orientation;
                this.orientation = n;
                this.addButtons();
                this.validate();
                this.firePropertyChange("orientation", n2, n);
            }
        } else {
            throw new IllegalArgumentException(SpinnerErrorMessageSource.getStringBy("OutOfRange"));
        }
    }

    public void setSpinnable(boolean bl) {
        if (this.spinnable != bl) {
            boolean bl2 = this.spinnable;
            this.spinnable = bl;
            this.firePropertyChange("spinnable", bl2, bl);
        }
    }

    public void setToolTipText(String string) {
        String string2 = null;
        if (!string.equals("")) {
            string2 = string;
        }
        super.setToolTipText(string2);
        this.incrButton.setToolTipText(string2);
        this.decrButton.setToolTipText(string2);
        this.textField.setToolTipText(string2);
        this.jpanel.setToolTipText(string2);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (!this.isSpinnable()) {
            return;
        }
        if (changeEvent.getSource() == this.incrButton) {
            if (this.incrButton.getModel().isPressed()) {
                this.scrollUp();
                if (!contSpinThread.isRunning()) {
                    contSpinThread.setObject(this.incrButton);
                    contSpinThread.resumeIt();
                }
            } else {
                contSpinThread.setObject(null);
                contSpinThread.suspendIt();
            }
        }
        if (changeEvent.getSource() == this.decrButton) {
            if (this.decrButton.getModel().isPressed()) {
                this.scrollDown();
                if (!contSpinThread.isRunning()) {
                    contSpinThread.setObject(this.decrButton);
                    contSpinThread.resumeIt();
                }
            } else {
                contSpinThread.setObject(null);
                contSpinThread.suspendIt();
            }
        }
    }
}

