/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.spinner;

import com.ibm.spinner.DateChangedEvent;
import com.ibm.spinner.DateChangedListener;
import com.ibm.spinner.FormatStrings;
import com.ibm.spinner.Spinner;
import com.ibm.spinner.SpinnerErrorMessageSource;
import com.ibm.spinner.SpinnerGUI;
import com.ibm.spinner.SubField;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.Beans;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Date;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;

public class CalendarSpinner
extends Spinner
implements DateChangedListener {
    public static final int ERA = 0;
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int WEEK_OF_YEAR = 3;
    public static final int WEEK_OF_MONTH = 4;
    public static final int DATE = 5;
    public static final int DAY_OF_MONTH = 5;
    public static final int DAY_OF_YEAR = 6;
    public static final int DAY_OF_WEEK = 7;
    public static final int DAY_OF_WEEK_IN_MONTH = 8;
    public static final int AMPM = 9;
    public static final int AM_PM = 9;
    public static final int HOUR = 10;
    public static final int HOUR_OF_DAY = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final int MILLISECOND = 14;
    protected static final int HOUR_OF_DAY_1 = 17;
    protected static final int HOUR_1 = 18;
    protected FormatStrings FS = new FormatStrings("EEEE, MMMM d, yyyy h:mm:ss 'o''clock' a z", "MMMM d, yyyy h:mm:ss a z", "dd-MMM-yy h:mm:ss a", "M/d/yy h:mm a", 2);
    protected int textCaretPos = 0;
    protected int vCaretPos = 1;
    protected GregorianCalendar gCalendar = new GregorianCalendar();
    protected GregorianCalendar maximum = new GregorianCalendar(2019, 11, 31, 23, 59, 59);
    protected GregorianCalendar minimum = new GregorianCalendar(1920, 0, 1, 0, 0, 0);
    protected TimeZone timeZone = TimeZone.getDefault();
    protected GregorianCalendar oldCalendar = null;
    protected boolean wrapAssociated = true;
    protected DateFormat dateFormat = this.createDateFormatByStyle(2, 2);
    protected SubField[] subFormats = new SubField[100];
    protected int formatCount = 0;
    protected int[] DEFAULTFORMAT = new int[]{0, 1, 2, 3};
    protected static final int MAXNUMOFSUBFORMATS = 100;
    protected String bakDateString = null;
    protected String dateString = "";
    protected boolean bTypeMode = false;
    protected int iTypedChar = 0;
    protected int iTypedField = 0;
    protected int iTypedFieldWidth = 0;
    protected int iTypedFieldStart = 0;
    protected StringBuffer sTypedString = null;
    protected int iTypedPatternLength = 0;
    protected boolean bExitingTyping = false;
    protected String sTypeBakString = null;
    protected boolean bLazyChecking = false;
    protected int iInitOldStyle = -1;
    protected String sInitOldString = null;
    protected boolean bInitStyleCalledFirst = false;
    protected boolean bHasFocus = false;
    private String fieldAboutThisBean = new String();
    protected boolean bFormatStringsCalled = false;
    private boolean fieldValidateMonthFirst = false;
    private static final Object[] NULL_ARRAY = new Object[0];
    protected transient EventListenerList listenerList = new EventListenerList();
    static Class class$com$ibm$spinner$DateChangedListener;

    public CalendarSpinner() {
        this.addDateChangedListener(this);
        this.textField.addMouseListener(this);
        this.incrButton.addMouseListener(this);
        this.decrButton.addMouseListener(this);
        int n = 0;
        while (n < 100) {
            this.subFormats[n] = new SubField();
            ++n;
        }
        this.oldCalendar = (GregorianCalendar)((Calendar)this.gCalendar).clone();
        this.timeZone = TimeZone.getDefault();
        try {
            this.dateFormat = this.createDateFormatByStyle(this.FS.getFormatStyle(), this.FS.getFormatStyle());
            this.dateFormat.setTimeZone(this.timeZone);
            ((Calendar)this.gCalendar).setTimeZone(this.timeZone);
            this.gCalendar.setTime(this.gCalendar.getTime());
            StringBuffer stringBuffer = new StringBuffer();
            FieldPosition fieldPosition = new FieldPosition(0);
            this.dateFormat.format(this.gCalendar.getTime(), stringBuffer, fieldPosition);
            this.dateString = stringBuffer.toString();
            this.findSubFormats(this.FS.getFormatString());
            this.findParsePositions(this.dateString);
        }
        catch (Exception exception) {}
        this.textField.setText(this.getDateString());
        this.initialize();
        this.textField.repaint();
        this.highlightField();
    }

    protected boolean acceptInput() {
        boolean bl = false;
        if (!this.bTypeMode) {
            String string = null;
            string = !this.bExitingTyping ? this.getDateString() : new String(this.sTypeBakString);
            try {
                String string2 = this.textField.getText();
                String string3 = null;
                if (this.iTypedField == 2 & this.iTypedPatternLength > 3 & this.iTypedChar < this.iTypedFieldWidth) {
                    String string4 = new String(string2).substring(0, this.iTypedFieldStart + this.iTypedChar);
                    String string5 = String.valueOf(new String(string2).substring(this.iTypedFieldStart + this.iTypedFieldWidth)) + "          ";
                    string3 = String.valueOf(string4) + string5;
                } else {
                    string3 = String.valueOf(string2) + "          ";
                }
                this.setDateString(string3);
                this.textField.setText(this.getDateString());
                this.textField.setCaretPosition(this.monitorTextCaretPos(this.vCaretPos));
                this.oldCalendar = (GregorianCalendar)((Calendar)this.gCalendar).clone();
                bl = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                bl = false;
                this.textField.setText(string);
                try {
                    this.setDateString(string);
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    this.forceDateString(string);
                    this.bakDateString = null;
                    return false;
                }
                String string6 = illegalArgumentException.getMessage();
                if (string6.equals("Wrong data format")) {
                    this.fireSpinnerErrorEvent(this, 1, illegalArgumentException);
                } else if (string6.equals("Out of range")) {
                    this.fireSpinnerErrorEvent(this, 2, illegalArgumentException);
                }
                return false;
            }
        }
        this.bakDateString = null;
        return bl;
    }

    protected boolean acceptTypedInput() {
        boolean bl = false;
        String string = this.textField.getText();
        try {
            Object object;
            Object object2;
            String string2 = null;
            if (this.iTypedField == 2 & this.iTypedPatternLength > 3 & this.iTypedChar < this.iTypedFieldWidth) {
                object2 = new String(string).substring(0, this.iTypedFieldStart + this.iTypedChar);
                object = String.valueOf(new String(string).substring(this.iTypedFieldStart + this.iTypedFieldWidth)) + "          ";
                string2 = String.valueOf(object2) + (String)object;
            } else {
                string2 = String.valueOf(string) + "          ";
            }
            object2 = this.dateFormat.parse(string2);
            object = new GregorianCalendar();
            ((Calendar)object).setTime((java.util.Date)object2);
            if (((Calendar)object).before(this.minimum) || ((Calendar)object).after(this.maximum)) {
                this.fireSpinnerErrorEvent(this, 2, new Exception());
            } else {
                bl = true;
            }
        }
        catch (Exception exception) {
            this.fireSpinnerErrorEvent(this, 1, exception);
        }
        return bl;
    }

    public synchronized void addDateChangedListener(DateChangedListener dateChangedListener) {
        if (dateChangedListener == null) {
            throw new IllegalArgumentException(SpinnerErrorMessageSource.getStringBy("NullPointerParameter"));
        }
        Class<?> clazz = class$com$ibm$spinner$DateChangedListener;
        if (clazz == null) {
            try {
                clazz = class$com$ibm$spinner$DateChangedListener = Class.forName("com.ibm.spinner.DateChangedListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, dateChangedListener);
    }

    public void changeFormatStyle(int n, String string) {
        if (string == null) {
            throw new IllegalArgumentException(SpinnerErrorMessageSource.getStringBy("NullPointerParameter"));
        }
        String string2 = new String(this.FS.getFormatString());
        int n2 = this.getFormattingStyle();
        this.FS.changeFormatStyle(n, string);
        if (n == n2) {
            this.FS.iActive = n == 0 ? ++this.FS.iActive : --this.FS.iActive;
            this.setFormattingStyle(n);
            this.skipVCaretPos(false);
            this.firePropertyChange("formatString", string2, string);
        }
    }

    protected void checkDownRange() {
        if (this.isWrap()) {
            if (this.gCalendar.before(this.minimum)) {
                this.gCalendar.setTime(this.maximum.getTime());
            }
        } else if (this.gCalendar.before(this.minimum)) {
            this.gCalendar.setTime(this.minimum.getTime());
        }
    }

    protected void checkUpRange() {
        if (this.isWrap()) {
            if (this.gCalendar.after(this.maximum)) {
                this.gCalendar.setTime(this.minimum.getTime());
            }
        } else if (this.gCalendar.after(this.maximum)) {
            this.gCalendar.setTime(this.maximum.getTime());
        }
    }

    protected void checkVCaretPos() {
        int n = this.getFieldOrderByCaretPos(this.textField.getCaretPosition());
        int n2 = this.getFieldTypeByOrder(n);
        if (n2 >= 0 && n2 != 15) {
            this.setCurrentField(n2);
        }
    }

    protected void clearHighlighting() {
        this.textField.select(0, 0);
    }

    protected DateFormat createDateFormatByStyle(int n, int n2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.getFormatString());
        simpleDateFormat.setLenient(false);
        return simpleDateFormat;
    }

    public void dateChanged(DateChangedEvent dateChangedEvent) {
        this.textField.setText(this.getDateString());
        this.repaint();
        this.highlightField();
    }

    protected void enterTypeMode() {
        this.bTypeMode = true;
        this.iTypedChar = 0;
        this.iTypedField = this.getCurrentFieldType();
        this.iTypedFieldStart = this.getFieldBeginCaretPos(this.iTypedField);
        this.iTypedFieldWidth = this.getFieldEndCaretPos(this.iTypedField) - this.iTypedFieldStart;
        this.sTypedString = new StringBuffer(this.getDateString());
        this.iTypedPatternLength = this.subFormats[this.getFieldOrderByType(this.iTypedField)].getCharCount();
        this.bExitingTyping = false;
        this.sTypeBakString = new String(this.textField.getText());
    }

    protected boolean exitTypeMode() {
        boolean bl = false;
        if (this.bTypeMode) {
            this.bTypeMode = false;
            this.bExitingTyping = true;
            bl = this.acceptInput();
            this.bExitingTyping = false;
            this.sTypedString = null;
        }
        return bl;
    }

    protected void findParsePositions(String string) {
        ParsePosition parsePosition = new ParsePosition(0);
        int n = 0;
        while (n < this.formatCount) {
            SubField subField = this.subFormats[n];
            if (subField.isFormat()) {
                try {
                    subField.getSubFormat().parseObject(string, parsePosition);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    parsePosition.setIndex(string.length());
                }
            } else {
                parsePosition.setIndex(parsePosition.getIndex() + subField.getCharCount());
            }
            subField.setParsePosition(new ParsePosition(parsePosition.getIndex()));
            ++n;
        }
    }

    protected void findSubFormats(String string) {
        this.formatCount = 0;
        boolean bl = false;
        char c = '\u0000';
        int n = 0;
        int n2 = 1;
        int n3 = 0;
        while (n3 < string.length()) {
            char c2 = string.charAt(n3);
            if (bl) {
                if (c2 == '\'') {
                    bl = false;
                    if (n == 0) {
                        this.subFormats[this.formatCount++] = new SubField(false, c, 1);
                    } else {
                        this.subFormats[this.formatCount++] = new SubField(false, c, n);
                        n = 0;
                    }
                    n2 = 0;
                } else {
                    ++n;
                }
            } else {
                if (c2 == '\'') {
                    bl = true;
                    if (n > 0) {
                        this.subFormats[this.formatCount++] = new SubField(true, c, n);
                        n = 0;
                        c = '\u0000';
                    }
                    if (n2 == 0) {
                        n = 1;
                    }
                } else if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z') {
                    if (c2 != c && n > 0) {
                        this.subFormats[this.formatCount++] = new SubField(true, c, n);
                        c = c2;
                        n = 1;
                    } else {
                        if (c2 != c) {
                            c = c2;
                        }
                        ++n;
                    }
                } else if (n > 0) {
                    this.subFormats[this.formatCount++] = new SubField(true, c, n);
                    this.subFormats[this.formatCount++] = new SubField(false, c, 1);
                    c = '\u0000';
                    n = 0;
                } else {
                    this.subFormats[this.formatCount++] = new SubField(false, c, 1);
                }
                ++n2;
            }
            ++n3;
        }
        if (n > 0) {
            this.subFormats[this.formatCount++] = new SubField(true, c, n);
        }
    }

    protected void fireDateChangedEvent() {
        StringBuffer stringBuffer = new StringBuffer();
        FieldPosition fieldPosition = new FieldPosition(0);
        this.dateFormat.format(this.gCalendar.getTime(), stringBuffer, fieldPosition);
        DateChangedEvent dateChangedEvent = new DateChangedEvent(this, 20000, stringBuffer.toString(), this.getDate(), this.getSQLDate());
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            Object object = objectArray[n];
            Class<?> clazz = class$com$ibm$spinner$DateChangedListener;
            if (clazz == null) {
                try {
                    clazz = Class.forName("com.ibm.spinner.DateChangedListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                ((DateChangedListener)objectArray[n + 1]).dateChanged(dateChangedEvent);
            }
            n -= 2;
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.bHasFocus = true;
        this.highlightField();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.exitTypeMode();
        this.bHasFocus = false;
        this.textField.setCaretPosition(this.monitorTextCaretPos(this.vCaretPos));
        this.clearHighlighting();
    }

    protected void forceDateString(String string) {
        block7: {
            try {
                this.setDateString(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (this.gCalendar == null) break block7;
                try {
                    String string2 = String.valueOf(new String(string)) + "          ";
                    java.util.Date date = this.dateFormat.parse(string2);
                    GregorianCalendar gregorianCalendar = new GregorianCalendar();
                    gregorianCalendar.setTime(date);
                    if (gregorianCalendar.before(this.minimum)) {
                        this.setCalendar(this.minimum);
                    } else if (gregorianCalendar.after(this.maximum)) {
                        this.setCalendar(this.maximum);
                    }
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(SpinnerErrorMessageSource.getStringBy("WrongDataFormat"));
                }
            }
        }
    }

    public String getAboutThisBean() {
        return String.valueOf(this.getClass().getName()) + "^CalendarSpinner^4.0^" + "CalendarSpinner_About_Bean.gif^" + "Common_Spinner's_Features.gif^" + "CalendarSpinner_Other_Features_I.gif^" + "CalendarSpinner_Other_Features_II.gif^" + "CalendarSpinner_Wiring_Example.gif^" + "/spinner/docs/index.html";
    }

    public Color getBackground() {
        return super.getBackground();
    }

    public Calendar getCalendar() {
        return this.gCalendar;
    }

    public int getCaretPos() {
        return this.getCurrentFieldType();
    }

    protected int getCurrentFieldType() {
        return this.getFieldTypeByOrder(this.getFieldOrderByCaretPos(this.textField.getCaretPosition()));
    }

    public java.util.Date getDate() {
        return this.gCalendar.getTime();
    }

    public long getDatePartValue() {
        return this.gCalendar.getTime().getTime();
    }

    public String getDateString() {
        StringBuffer stringBuffer = new StringBuffer();
        FieldPosition fieldPosition = new FieldPosition(0);
        this.dateFormat.format(this.gCalendar.getTime(), stringBuffer, fieldPosition);
        this.dateString = stringBuffer.toString();
        return this.dateString;
    }

    public int getDay() {
        return this.gCalendar.get(5);
    }

    protected int getFieldBeginCaretPos(int n) {
        int n2 = 0;
        int n3 = this.getFieldOrderByType(n);
        if (n3 > 0) {
            SubField subField = this.subFormats[n3 - 1];
            n2 = subField.getParsePosition().getIndex();
        } else {
            n2 = 0;
        }
        return n2;
    }

    protected int getFieldEndCaretPos(int n) {
        int n2 = 0;
        int n3 = this.getFieldOrderByType(n);
        int n4 = this.textField.getText().length();
        if (n3 >= 0) {
            if (n3 < this.formatCount) {
                SubField subField = this.subFormats[n3];
                n2 = subField.getParsePosition().getIndex();
            } else {
                n2 = n4;
            }
        }
        if (n2 < 0) {
            return 0;
        }
        if (n2 < n4) {
            return n2;
        }
        return n4;
    }

    protected int getFieldIndex(char c) {
        switch (c) {
            case 'y': {
                return 1;
            }
            case 'M': {
                return 2;
            }
            case 'd': {
                return 5;
            }
            case 'h': {
                return 10;
            }
            case 'H': {
                return 11;
            }
            case 'm': {
                return 12;
            }
            case 's': {
                return 13;
            }
            case 'G': {
                return 0;
            }
            case 'w': {
                return 3;
            }
            case 'W': {
                return 4;
            }
            case 'k': {
                return 17;
            }
            case 'K': {
                return 18;
            }
            case 'D': {
                return 6;
            }
            case 'E': {
                return 7;
            }
            case 'F': {
                return 8;
            }
            case 'S': {
                return 14;
            }
            case 'a': {
                return 9;
            }
            case 'z': {
                return 15;
            }
        }
        return -1;
    }

    protected int getFieldOrderByCaretPos(int n) {
        if (n == 0) {
            return 0;
        }
        int n2 = 0;
        while (n2 < this.formatCount) {
            int n3 = this.subFormats[n2].getParsePosition().getIndex();
            if (n <= n3) {
                return n2;
            }
            ++n2;
        }
        if (n > this.subFormats[this.formatCount].getParsePosition().getIndex()) {
            return this.formatCount - 1;
        }
        return -1;
    }

    protected int getFieldOrderByType(int n) {
        if (n >= 0) {
            int n2 = 0;
            while (n2 < this.formatCount) {
                if (n == this.getFieldTypeByOrder(n2)) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }

    protected int getFieldTypeByOrder(int n) {
        SubField subField;
        String string;
        int n2 = -1;
        if (n >= 0 && n < this.formatCount && (string = (subField = this.subFormats[n]).getSubFormat().toPattern()).length() > 0) {
            n2 = this.getFieldIndex(string.charAt(0));
        }
        return n2;
    }

    public Font getFont() {
        return super.getFont();
    }

    public Color getForeground() {
        return super.getForeground();
    }

    public String getFormatString() {
        String string = this.getFormatStringByStyle(this.getFormattingStyle()).toString();
        return string;
    }

    public String getFormatStringByStyle(int n) {
        return this.FS.getFormatStringByStyle(n);
    }

    public FormatStrings getFormatStrings() {
        return (FormatStrings)this.FS.clone();
    }

    public int getFormattingStyle() {
        return this.FS.getFormatStyle();
    }

    public int getHour() {
        return this.gCalendar.get(11);
    }

    public Locale getLocale() {
        Locale locale = null;
        try {
            locale = super.getLocale();
        }
        catch (Exception exception) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    protected int getMaxField() {
        return this.formatCount;
    }

    public Calendar getMaximum() {
        return this.maximum;
    }

    public Calendar getMinimum() {
        return this.minimum;
    }

    public int getMinute() {
        return this.gCalendar.get(12);
    }

    public int getMonth() {
        return this.gCalendar.get(2);
    }

    public int getSecond() {
        return this.gCalendar.get(13);
    }

    public Date getSQLDate() {
        java.util.Date date = this.gCalendar.getTime();
        return new Date(date.getTime());
    }

    protected String getSubField(int n) {
        String string = "";
        int n2 = this.monitorTextCaretPos(n);
        int n3 = this.monitorTextCaretPos(this.rollVCaretPos(false, n));
        if (this.bakDateString == null) {
            this.bakDateString = this.getDateString();
        }
        if (n2 > this.bakDateString.length()) {
            n2 = this.bakDateString.length();
        }
        string = n != 9 ? (n3 == n2 ? this.bakDateString.substring(0, n2) : this.bakDateString.substring(n3 + 1, n2)) : this.bakDateString.substring(n2 - 2, n2);
        StringBuffer stringBuffer = new StringBuffer(string);
        if (!Character.isLetterOrDigit(string.charAt(0))) {
            stringBuffer.setCharAt(0, ' ');
        }
        if (!Character.isLetterOrDigit(string.charAt(string.length() - 1))) {
            stringBuffer.setCharAt(string.length() - 1, ' ');
        }
        string = stringBuffer.toString().trim();
        return string;
    }

    public long getTimePartValue() {
        return this.gCalendar.getTime().getTime();
    }

    public String getTimeZone() {
        return this.timeZone.getID();
    }

    public long getValue() {
        return this.getDate().getTime();
    }

    public int getYear() {
        return this.gCalendar.get(1);
    }

    protected void highlightField() {
        if (!this.getEditable()) {
            return;
        }
        if (this.bHasFocus) {
            if (this.vCaretPos >= 0) {
                int n = this.getFieldBeginCaretPos(this.vCaretPos);
                int n2 = this.getFieldEndCaretPos(this.vCaretPos);
                int n3 = this.textField.getText().length();
                if (n <= n3 && n2 <= n3) {
                    this.textCaretPos = n2;
                    this.textField.setCaretPosition(n2);
                    this.textField.setSelectionStart(n);
                    this.textField.setSelectionEnd(n2);
                } else {
                    System.out.println("Caret beyond text " + n + "/" + n2 + "/" + n3);
                }
            } else {
                this.clearHighlighting();
            }
        }
    }

    protected int indexOf(String string, char c, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if ((n2 = string.indexOf(c, n2 + 1)) < 0) {
                return 0;
            }
            ++n3;
        }
        return n2;
    }

    protected void initFormatString(String string) {
        if (!Beans.isDesignTime()) {
            if (!this.bInitStyleCalledFirst) {
                this.iInitOldStyle = this.getFormattingStyle();
                this.sInitOldString = new String(this.getFormatString());
            }
            this.setFormatString(string);
        } else {
            this.setFormatString(string);
        }
    }

    protected void initFormatStrings(String string, String string2, String string3, String string4, int n) {
        FormatStrings formatStrings = new FormatStrings(string, string2, string3, string4, n);
        this.setFormatStrings(formatStrings);
    }

    public void initFormatStyle(int n) {
        if (!Beans.isDesignTime()) {
            if (this.iInitOldStyle != -1) {
                String string = new String(this.getFormatString());
                this.changeFormatStyle(this.iInitOldStyle, this.sInitOldString);
                this.setFormattingStyle(n);
                this.setFormatString(string);
            } else {
                this.setFormattingStyle(n);
            }
            this.bInitStyleCalledFirst = true;
        } else {
            this.setFormattingStyle(n);
        }
    }

    protected void initialize() {
        this.initializeFormatStrings();
        this.skipVCaretPos(false);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(new java.util.Date());
        gregorianCalendar.add(1, 20);
        this.maximum = (GregorianCalendar)((Calendar)gregorianCalendar).clone();
        gregorianCalendar.add(1, -100);
        this.minimum = (GregorianCalendar)((Calendar)gregorianCalendar).clone();
    }

    protected void initializeFormatStrings() {
        Locale locale = this.getLocale();
        this.changeFormatStyle(0, ((SimpleDateFormat)DateFormat.getDateTimeInstance(0, 0, locale)).toPattern());
        this.changeFormatStyle(1, ((SimpleDateFormat)DateFormat.getDateTimeInstance(1, 1, locale)).toPattern());
        this.changeFormatStyle(2, ((SimpleDateFormat)DateFormat.getDateTimeInstance(2, 2, locale)).toPattern());
        this.changeFormatStyle(3, ((SimpleDateFormat)DateFormat.getDateTimeInstance(3, 3, locale)).toPattern());
    }

    public void initMaximum(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException(SpinnerErrorMessageSource.getStringBy("NullPointerParameter"));
        }
        if (calendar.before(this.minimum)) {
            this.setMinimum(calendar);
        }
        this.setMaximum(calendar);
    }

    public void initMinimum(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException(SpinnerErrorMessageSource.getStringBy("NullPointerParameter"));
        }
        if (calendar.after(this.maximum)) {
            this.setMaximum(calendar);
        }
        this.setMinimum(calendar);
    }

    public boolean isEditable() {
        return super.isEditable();
    }

    public boolean isEnabled() {
        return super.isEnabled();
    }

    public boolean isOpaque() {
        return super.isOpaque();
    }

    public boolean isSpinnable() {
        return super.isSpinnable();
    }

    protected boolean isTypeMode() {
        return this.bTypeMode;
    }

    public boolean isValidateMonthFirst() {
        return this.fieldValidateMonthFirst;
    }

    public boolean isWrapAssociated() {
        return this.wrapAssociated;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.isConsumed() || !this.getEditable()) {
            return;
        }
        if (this.bakDateString == null) {
            this.bakDateString = this.getDateString();
        }
        int n = keyEvent.getKeyCode();
        keyEvent.getKeyChar();
        switch (n) {
            case 37: {
                this.exitTypeMode();
                this.vCaretPos = this.rollVCaretPos(false, this.vCaretPos);
                this.textField.setCaretPosition(this.monitorTextCaretPos(this.vCaretPos));
                break;
            }
            case 39: {
                this.exitTypeMode();
                this.vCaretPos = this.rollVCaretPos(true, this.vCaretPos);
                this.textField.setCaretPosition(this.monitorTextCaretPos(this.vCaretPos));
                break;
            }
            case 36: {
                this.exitTypeMode();
                this.skipVCaretPos(false);
                this.textField.setCaretPosition(this.monitorTextCaretPos(this.vCaretPos));
                break;
            }
            case 35: {
                this.exitTypeMode();
                this.skipVCaretPos(true);
                this.textField.setCaretPosition(this.monitorTextCaretPos(this.vCaretPos));
                break;
            }
            case 38: {
                this.exitTypeMode();
                this.scrollUpByUI();
                break;
            }
            case 40: {
                this.exitTypeMode();
                this.scrollDownByUI();
                break;
            }
            case 10: {
                this.exitTypeMode();
                this.rollVCaretPos(true, this.iTypedField);
                this.highlightField();
                break;
            }
            case 8: {
                if (this.isTypeMode()) {
                    if (this.iTypedChar > 0) {
                        --this.iTypedChar;
                        this.sTypedString.setCharAt(this.iTypedFieldStart + this.iTypedChar, ' ');
                        this.textField.setText(this.sTypedString.toString());
                        this.textField.setCaretPosition(this.iTypedFieldStart + this.iTypedChar);
                        this.textField.setSelectionStart(this.iTypedFieldStart);
                        this.textField.setSelectionEnd(this.iTypedFieldStart + this.iTypedChar);
                        this.acceptTypedInput();
                    }
                } else {
                    this.enterTypeMode();
                    this.sTypedString.setCharAt(this.iTypedFieldStart + this.iTypedFieldWidth - 1, ' ');
                    this.iTypedChar = this.iTypedFieldWidth - 1;
                    this.textField.setText(this.sTypedString.toString());
                    this.textField.setCaretPosition(this.iTypedFieldStart + this.iTypedChar);
                    this.textField.setSelectionStart(this.iTypedFieldStart);
                    this.textField.setSelectionEnd(this.iTypedFieldStart + this.iTypedChar);
                    this.acceptTypedInput();
                }
                keyEvent.consume();
                return;
            }
        }
        keyEvent.consume();
        this.highlightField();
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.isConsumed() || !this.getEditable()) {
            return;
        }
        keyEvent.getKeyCode();
        char c = keyEvent.getKeyChar();
        boolean bl = false;
        if (!keyEvent.isActionKey() && (Character.isLetterOrDigit(c) || this.iTypedField == 15 && (c == '+' || c == '-' || c == ':'))) {
            if (!this.isTypeMode()) {
                this.enterTypeMode();
                int n = 0;
                while (n < this.iTypedFieldWidth) {
                    this.sTypedString.setCharAt(this.iTypedFieldStart + n, ' ');
                    ++n;
                }
            }
            if (this.iTypedChar < this.iTypedFieldWidth) {
                this.sTypedString.setCharAt(this.iTypedFieldStart + this.iTypedChar, c);
            } else {
                this.sTypedString.insert(this.iTypedFieldStart + this.iTypedChar, c);
            }
            this.textField.setText(this.sTypedString.toString());
            ++this.iTypedChar;
            switch (this.iTypedField) {
                case 0: {
                    break;
                }
                case 1: {
                    if (this.iTypedPatternLength >= 4) {
                        if (this.iTypedChar < 4) break;
                        bl = this.exitTypeMode();
                        break;
                    }
                    if (this.iTypedChar < 2) break;
                    bl = this.exitTypeMode();
                    break;
                }
                case 2: {
                    if (this.iTypedPatternLength > 2 || this.iTypedChar < 2) break;
                    bl = this.exitTypeMode();
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    if (this.iTypedChar < 2) break;
                    bl = this.exitTypeMode();
                    break;
                }
                case 6: {
                    if (this.iTypedChar < 3) break;
                    bl = this.exitTypeMode();
                    break;
                }
                case 7: 
                case 9: 
                case 15: {
                    break;
                }
                case 8: 
                case 14: {
                    if (this.iTypedPatternLength >= 3) {
                        if (this.iTypedChar < 3) break;
                        bl = this.exitTypeMode();
                        break;
                    }
                    if (this.iTypedPatternLength > this.iTypedChar) break;
                    bl = this.exitTypeMode();
                }
            }
            if (this.isTypeMode()) {
                this.textField.setCaretPosition(this.iTypedFieldStart + this.iTypedChar);
                this.textField.setSelectionStart(this.iTypedFieldStart);
                this.textField.setSelectionEnd(this.iTypedFieldStart + this.iTypedChar);
                this.acceptTypedInput();
            } else {
                if (bl) {
                    this.rollVCaretPos(true, this.iTypedField);
                }
                this.highlightField();
            }
        }
        keyEvent.consume();
    }

    protected int monitorTextCaretPos(int n) {
        return this.getFieldEndCaretPos(n);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        if (!this.getEditable()) {
            return;
        }
        if (this.isTypeMode()) {
            this.exitTypeMode();
        }
        if (mouseEvent.getSource() == this.textField) {
            this.checkVCaretPos();
            this.highlightField();
        }
    }

    protected void parseFormat() {
        this.findSubFormats(this.getFormatString());
        this.findParsePositions(this.getDateString());
    }

    private void read_init() {
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        objectInputStream.defaultReadObject();
        this.listenerList = new EventListenerList();
        while ((object = objectInputStream.readObject()) != null) {
            DateChangedListener dateChangedListener = (DateChangedListener)objectInputStream.readObject();
            this.listenerList.add(Class.forName((String)object), dateChangedListener);
        }
    }

    public synchronized void removeDateChangedListener(DateChangedListener dateChangedListener) {
        Class<?> clazz = class$com$ibm$spinner$DateChangedListener;
        if (clazz == null) {
            try {
                clazz = class$com$ibm$spinner$DateChangedListener = Class.forName("com.ibm.spinner.DateChangedListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, dateChangedListener);
    }

    protected int rollVCaretPos(boolean bl, int n) {
        int n2;
        int n3 = n2 = this.getCurrentFieldType();
        SubField subField = null;
        int n4 = 0;
        if (bl) {
            int n5 = this.getFieldOrderByType(n2) + 1;
            while (n5 < this.formatCount) {
                subField = this.subFormats[n5];
                if (subField.isFormat() && (n4 = this.getFieldTypeByOrder(n5)) != 15) {
                    n3 = n4;
                    this.setCurrentField(n3);
                    break;
                }
                ++n5;
            }
        } else {
            int n6 = this.getFieldOrderByType(n2) - 1;
            while (n6 >= 0) {
                subField = this.subFormats[n6];
                if (subField.isFormat()) {
                    n4 = this.getFieldTypeByOrder(n6);
                    if (n3 != 15) {
                        n3 = n4;
                        this.setCurrentField(n3);
                        break;
                    }
                }
                --n6;
            }
        }
        return n3;
    }

    public void scrollDown() {
        super.scrollDown();
        if (this.vCaretPos == 15 || this.vCaretPos == 16) {
            return;
        }
        if (this.isWrapAssociated()) {
            this.gCalendar.add(this.vCaretPos, -1);
        } else {
            this.gCalendar.roll(this.vCaretPos, false);
        }
        if (this.isWrap()) {
            if (this.gCalendar.before(this.minimum)) {
                this.gCalendar.setTime(this.maximum.getTime());
            }
        } else if (this.gCalendar.before(this.minimum)) {
            this.gCalendar.setTime(this.minimum.getTime());
        }
        this.gCalendar.setTime(this.gCalendar.getTime());
        try {
            this.setCalendar(this.gCalendar);
        }
        catch (Exception exception) {
            this.textField.setText(this.getDateString());
            this.textField.setCaretPosition(this.monitorTextCaretPos(this.vCaretPos));
        }
    }

    protected void scrollDownByUI() {
        this.acceptInput();
        if (this.vCaretPos == 15 || this.vCaretPos == 16) {
            return;
        }
        if (this.isWrapAssociated()) {
            this.gCalendar.add(this.vCaretPos, -1);
        } else {
            this.gCalendar.roll(this.vCaretPos, false);
        }
        this.checkDownRange();
        this.gCalendar.setTime(this.gCalendar.getTime());
        try {
            this.setCalendar(this.gCalendar);
        }
        catch (Exception exception) {
            this.textField.setText(this.getDateString());
            this.textField.setCaretPosition(this.monitorTextCaretPos(this.vCaretPos));
        }
        this.getDateString();
    }

    public void scrollUp() {
        super.scrollUp();
        if (this.vCaretPos == 15 || this.vCaretPos == 16) {
            return;
        }
        if (this.isWrapAssociated()) {
            this.gCalendar.add(this.vCaretPos, 1);
        } else {
            this.gCalendar.roll(this.vCaretPos, true);
        }
        if (this.isWrap()) {
            if (this.gCalendar.after(this.maximum)) {
                this.gCalendar.setTime(this.minimum.getTime());
            }
        } else if (this.gCalendar.after(this.maximum)) {
            this.gCalendar.setTime(this.maximum.getTime());
        }
        this.gCalendar.setTime(this.gCalendar.getTime());
        try {
            this.setCalendar(this.gCalendar);
        }
        catch (Exception exception) {
            this.textField.setText(this.getDateString());
            this.textField.setCaretPosition(this.monitorTextCaretPos(this.vCaretPos));
        }
        this.getDateString();
    }

    protected void scrollUpByUI() {
        this.acceptInput();
        if (this.vCaretPos == 15 || this.vCaretPos == 16) {
            return;
        }
        if (this.isWrapAssociated()) {
            this.gCalendar.add(this.vCaretPos, 1);
        } else {
            this.gCalendar.roll(this.vCaretPos, true);
        }
        this.checkUpRange();
        this.gCalendar.setTime(this.gCalendar.getTime());
        try {
            this.setCalendar(this.gCalendar);
        }
        catch (Exception exception) {
            this.textField.setText(this.getDateString());
            this.textField.setCaretPosition(this.monitorTextCaretPos(this.vCaretPos));
        }
        this.getDateString();
    }

    public void setAboutThisBean(String string) {
        this.fieldAboutThisBean = string;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
    }

    public void setCalendar(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException(SpinnerErrorMessageSource.getStringBy("NullPointerParameter"));
        }
        if (calendar.before(this.minimum) || calendar.after(this.maximum)) {
            throw new IllegalArgumentException(SpinnerErrorMessageSource.getStringBy("OutOfRange"));
        }
        this.gCalendar = (GregorianCalendar)calendar.clone();
        java.util.Date date = this.oldCalendar.getTime();
        StringBuffer stringBuffer = new StringBuffer();
        FieldPosition fieldPosition = new FieldPosition(0);
        this.dateFormat.format(this.oldCalendar.getTime(), stringBuffer, fieldPosition);
        String string = stringBuffer.toString();
        long l = this.oldCalendar.getTime().getTime();
        GregorianCalendar gregorianCalendar = (GregorianCalendar)((Calendar)this.oldCalendar).clone();
        gregorianCalendar.set(this.getYear(), this.getMonth(), this.getDay(), 0, 0, 0);
        long l2 = gregorianCalendar.getTime().getTime();
        GregorianCalendar gregorianCalendar2 = (GregorianCalendar)((Calendar)this.oldCalendar).clone();
        gregorianCalendar2.set(0, 0, 0, this.getHour(), this.getMinute(), this.getSecond());
        long l3 = -1L;
        int n = this.oldCalendar.get(1);
        int n2 = this.oldCalendar.get(2);
        int n3 = this.oldCalendar.get(5);
        int n4 = this.oldCalendar.get(11);
        int n5 = this.oldCalendar.get(12);
        int n6 = this.oldCalendar.get(13);
        java.util.Date date2 = this.getDate();
        String string2 = this.getDateString();
        long l4 = this.getValue();
        long l5 = this.getDatePartValue();
        long l6 = this.getTimePartValue();
        int n7 = this.getYear();
        int n8 = this.getMonth();
        int n9 = this.getDay();
        int n10 = this.getHour();
        int n11 = this.getMinute();
        int n12 = this.getSecond();
        StringBuffer stringBuffer2 = new StringBuffer();
        FieldPosition fieldPosition2 = new FieldPosition(0);
        this.dateFormat.format(this.gCalendar.getTime(), stringBuffer2, fieldPosition2);
        this.dateString = stringBuffer.toString();
        this.findParsePositions(this.getDateString());
        this.fireDateChangedEvent();
        if (l == l4) {
            this.fireValueChangedEvent(0);
        } else if (l < l4) {
            this.fireValueChangedEvent(1);
        } else if (l > l4) {
            this.fireValueChangedEvent(2);
        }
        this.firePropertyChange("date", date, date2);
        this.firePropertyChange("calendar", null, calendar);
        this.firePropertyChange("dateString", string, string2);
        this.firePropertyChange("value", l, l4);
        this.firePropertyChange("datePartValue", l2, l5);
        this.firePropertyChange("timePartValue", l3, l6);
        this.firePropertyChange("year", n, n7);
        this.firePropertyChange("month", n2, n8);
        this.firePropertyChange("day", n3, n9);
        this.firePropertyChange("hour", n4, n10);
        this.firePropertyChange("minute", n5, n11);
        this.firePropertyChange("second", n6, n12);
    }

    public void setCaretPos(int n) {
        this.setCurrentField(n);
    }

    protected void setCurrentField(int n) {
        int n2 = this.getFieldOrderByType(n);
        if (n2 < 0) {
            throw new IllegalArgumentException(SpinnerErrorMessageSource.getStringBy("OutOfRange"));
        }
        int n3 = this.getCaretPos();
        this.vCaretPos = n;
        this.highlightField();
        this.firePropertyChange("caretPos", n3, n);
    }

    public void setDate(java.util.Date date) {
        if (date == null) {
            throw new IllegalArgumentException(SpinnerErrorMessageSource.getStringBy("NullPointerParameter"));
        }
        this.oldCalendar = (GregorianCalendar)((Calendar)this.gCalendar).clone();
        this.gCalendar.setTime(date);
        this.setCalendar(this.gCalendar);
    }

    public void setDateByFields(int n, int n2, int n3, int n4, int n5, int n6) {
        this.oldCalendar = (GregorianCalendar)((Calendar)this.gCalendar).clone();
        this.gCalendar.set(n, n2, n3, n4, n5, n6);
        this.setCalendar(this.gCalendar);
    }

    public void setDatePartValue(long l) {
        this.oldCalendar = (GregorianCalendar)((Calendar)this.gCalendar).clone();
        java.util.Date date = new java.util.Date(l);
        GregorianCalendar gregorianCalendar = (GregorianCalendar)((Calendar)this.gCalendar).clone();
        gregorianCalendar.setTime(date);
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2);
        int n3 = gregorianCalendar.get(5);
        this.gCalendar.set(1, n);
        this.gCalendar.set(2, n2);
        this.gCalendar.set(5, n3);
        this.setCalendar(this.gCalendar);
    }

    public void setDateString(String string) {
        if (string == null) {
            throw new IllegalArgumentException(SpinnerErrorMessageSource.getStringBy("NullPointerParameter"));
        }
        boolean bl = this.dateFormat.isLenient();
        try {
            String string2 = String.valueOf(new String(string)) + "          ";
            java.util.Date date = null;
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            if (this.isValidateMonthFirst() && this.iTypedField == 2) {
                this.dateFormat.setLenient(true);
                date = this.dateFormat.parse(string2);
                gregorianCalendar.setTime(date);
                if (gregorianCalendar.get(5) <= 3 && gregorianCalendar.get(5) != this.getDay()) {
                    gregorianCalendar.set(5, this.getDay());
                    gregorianCalendar.add(2, -1);
                }
                this.dateFormat.setLenient(bl);
            } else {
                date = this.dateFormat.parse(string2);
                gregorianCalendar.setTime(date);
            }
            this.setCalendar(gregorianCalendar);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(SpinnerErrorMessageSource.getStringBy("WrongDataFormat"));
        }
    }

    public void setDay(int n) {
        GregorianCalendar gregorianCalendar = (GregorianCalendar)((Calendar)this.gCalendar).clone();
        gregorianCalendar.set(5, n);
        if (gregorianCalendar.get(0) != this.gCalendar.get(0) || gregorianCalendar.get(1) != this.gCalendar.get(1) || gregorianCalendar.get(2) != this.gCalendar.get(2) || gregorianCalendar.get(11) != this.gCalendar.get(11) || gregorianCalendar.get(12) != this.gCalendar.get(12) || gregorianCalendar.get(13) != this.gCalendar.get(13)) {
            throw new IllegalArgumentException(SpinnerErrorMessageSource.getStringBy("OutOfRange"));
        }
        this.oldCalendar = (GregorianCalendar)((Calendar)this.gCalendar).clone();
        this.gCalendar.set(5, n);
        this.setCalendar(this.gCalendar);
    }

    public void setEditable(boolean bl) {
        super.setEditable(bl);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
    }

    public void setFont(Font font) {
        super.setFont(font);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
    }

    public void setFormatString(String string) {
        if (!Beans.isDesignTime()) {
            if (string == null) {
                throw new IllegalArgumentException(SpinnerErrorMessageSource.getStringBy("NullPointerParameter"));
            }
            if (string.equals("")) {
                return;
            }
            String string2 = this.getFormatString();
            if (!string2.equals(string)) {
                this.FS.setFormatString(new String(string));
                this.dateFormat = new SimpleDateFormat(string);
                this.dateFormat.setTimeZone(this.timeZone);
                this.dateString = this.getDateString();
                this.parseFormat();
                this.textField.setText(this.getDateString());
                this.skipVCaretPos(false);
                this.textField.setCaretPosition(this.monitorTextCaretPos(this.vCaretPos));
                this.firePropertyChange("formatString", string2, string);
                this.firePropertyChange("formattingStyle", -1, this.getFormattingStyle());
            }
        }
    }

    public void setFormatStrings(FormatStrings formatStrings) {
        if (!Beans.isDesignTime()) {
            this.bFormatStringsCalled = true;
        }
        this.setFormattingStyle(formatStrings.getFormatStyle());
        this.changeFormatStyle(0, formatStrings.getFormatStringByStyle(0));
        this.changeFormatStyle(1, formatStrings.getFormatStringByStyle(1));
        this.changeFormatStyle(2, formatStrings.getFormatStringByStyle(2));
        this.changeFormatStyle(3, formatStrings.getFormatStringByStyle(3));
    }

    public void setFormattingStyle(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException(SpinnerErrorMessageSource.getStringBy("OutOfRange"));
        }
        int n2 = this.getFormattingStyle();
        if (n2 != n) {
            String string = this.getFormatString();
            this.FS.setFormatStyle(n);
            String string2 = this.getFormatString();
            try {
                this.dateFormat = this.createDateFormatByStyle(n, n);
            }
            catch (Exception exception) {
                return;
            }
            this.dateFormat.setTimeZone(this.timeZone);
            this.parseFormat();
            this.textField.setText(this.getDateString());
            this.skipVCaretPos(false);
            this.textField.setCaretPosition(this.monitorTextCaretPos(this.vCaretPos));
            this.firePropertyChange("formattingStyle", n2, n);
            this.firePropertyChange("formatString", string, string2);
        }
    }

    public void setHour(int n) {
        GregorianCalendar gregorianCalendar = (GregorianCalendar)((Calendar)this.gCalendar).clone();
        gregorianCalendar.set(11, n);
        if (gregorianCalendar.get(0) != this.gCalendar.get(0) || gregorianCalendar.get(1) != this.gCalendar.get(1) || gregorianCalendar.get(2) != this.gCalendar.get(2) || gregorianCalendar.get(5) != this.gCalendar.get(5) || gregorianCalendar.get(12) != this.gCalendar.get(12) || gregorianCalendar.get(13) != this.gCalendar.get(13)) {
            throw new IllegalArgumentException(SpinnerErrorMessageSource.getStringBy("OutOfRange"));
        }
        this.oldCalendar = (GregorianCalendar)((Calendar)this.gCalendar).clone();
        this.gCalendar.set(11, n);
        this.setCalendar(this.gCalendar);
    }

    public void setLocale(Locale locale) {
        Locale locale2 = this.getLocale();
        super.setLocale(locale);
        if (Beans.isDesignTime() || !this.bFormatStringsCalled) {
            this.initializeFormatStrings();
        }
        this.firePropertyChange("dateLocale", locale2, locale);
    }

    public void setMaximum(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException(SpinnerErrorMessageSource.getStringBy("NullPointerParameter"));
        }
        if (this.maximum != (GregorianCalendar)calendar) {
            GregorianCalendar gregorianCalendar = this.maximum;
            this.maximum = (GregorianCalendar)calendar.clone();
            if (this.gCalendar.after(this.maximum)) {
                this.setCalendar(this.maximum);
            }
            this.firePropertyChange("maximum", gregorianCalendar, calendar);
        }
    }

    public void setMinimum(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException(SpinnerErrorMessageSource.getStringBy("NullPointerParameter"));
        }
        if (this.minimum != (GregorianCalendar)calendar) {
            GregorianCalendar gregorianCalendar = this.minimum;
            this.minimum = (GregorianCalendar)calendar.clone();
            if (this.gCalendar.before(this.minimum)) {
                this.setCalendar(this.minimum);
            }
            this.firePropertyChange("minimum", gregorianCalendar, calendar);
        }
    }

    public void setMinute(int n) {
        GregorianCalendar gregorianCalendar = (GregorianCalendar)((Calendar)this.gCalendar).clone();
        gregorianCalendar.set(12, n);
        if (gregorianCalendar.get(0) != this.gCalendar.get(0) || gregorianCalendar.get(1) != this.gCalendar.get(1) || gregorianCalendar.get(2) != this.gCalendar.get(2) || gregorianCalendar.get(5) != this.gCalendar.get(5) || gregorianCalendar.get(11) != this.gCalendar.get(11) || gregorianCalendar.get(13) != this.gCalendar.get(13)) {
            throw new IllegalArgumentException(SpinnerErrorMessageSource.getStringBy("OutOfRange"));
        }
        this.oldCalendar = (GregorianCalendar)((Calendar)this.gCalendar).clone();
        this.gCalendar.set(12, n);
        this.setCalendar(this.gCalendar);
    }

    public void setMonth(int n) {
        GregorianCalendar gregorianCalendar = (GregorianCalendar)((Calendar)this.gCalendar).clone();
        gregorianCalendar.set(2, n);
        if (gregorianCalendar.get(0) != this.gCalendar.get(0) || gregorianCalendar.get(1) != this.gCalendar.get(1) || gregorianCalendar.get(5) != this.gCalendar.get(5) || gregorianCalendar.get(11) != this.gCalendar.get(11) || gregorianCalendar.get(12) != this.gCalendar.get(12) || gregorianCalendar.get(13) != this.gCalendar.get(13)) {
            throw new IllegalArgumentException(SpinnerErrorMessageSource.getStringBy("OutOfRange"));
        }
        this.oldCalendar = (GregorianCalendar)((Calendar)this.gCalendar).clone();
        this.gCalendar.set(2, n);
        this.setCalendar(this.gCalendar);
    }

    public void setSecond(int n) {
        GregorianCalendar gregorianCalendar = (GregorianCalendar)((Calendar)this.gCalendar).clone();
        gregorianCalendar.set(13, n);
        if (gregorianCalendar.get(0) != this.gCalendar.get(0) || gregorianCalendar.get(1) != this.gCalendar.get(1) || gregorianCalendar.get(2) != this.gCalendar.get(2) || gregorianCalendar.get(5) != this.gCalendar.get(5) || gregorianCalendar.get(11) != this.gCalendar.get(11) || gregorianCalendar.get(12) != this.gCalendar.get(12)) {
            throw new IllegalArgumentException(SpinnerErrorMessageSource.getStringBy("OutOfRange"));
        }
        this.oldCalendar = (GregorianCalendar)((Calendar)this.gCalendar).clone();
        this.gCalendar.set(13, n);
        this.setCalendar(this.gCalendar);
    }

    public void setSpinnable(boolean bl) {
        super.setSpinnable(bl);
    }

    public void setTimePartValue(long l) {
        this.oldCalendar = (GregorianCalendar)((Calendar)this.gCalendar).clone();
        java.util.Date date = new java.util.Date(l);
        GregorianCalendar gregorianCalendar = (GregorianCalendar)((Calendar)this.gCalendar).clone();
        gregorianCalendar.setTime(date);
        int n = gregorianCalendar.get(11);
        int n2 = gregorianCalendar.get(12);
        int n3 = gregorianCalendar.get(13);
        this.gCalendar.set(11, n);
        this.gCalendar.set(12, n2);
        this.gCalendar.set(13, n3);
        this.setCalendar(this.gCalendar);
    }

    public void setTimeZone(String string) {
        if (string == null) {
            throw new IllegalArgumentException(SpinnerErrorMessageSource.getStringBy("NullPointerParameter"));
        }
        boolean bl = false;
        String[] stringArray = TimeZone.getAvailableIDs();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            throw new IllegalArgumentException(SpinnerErrorMessageSource.getStringBy("OutOfRange"));
        }
        if (!this.timeZone.getID().equals(string)) {
            TimeZone timeZone;
            TimeZone timeZone2 = this.timeZone;
            this.timeZone = timeZone = TimeZone.getTimeZone(string);
            this.firePropertyChange("timeZone", timeZone2, timeZone);
            this.dateFormat.setTimeZone(this.timeZone);
            this.oldCalendar = (GregorianCalendar)((Calendar)this.gCalendar).clone();
            ((Calendar)this.gCalendar).setTimeZone(this.timeZone);
            this.gCalendar.setTime(this.gCalendar.getTime());
            this.setCalendar(this.gCalendar);
        }
    }

    public void setValidateMonthFirst(boolean bl) {
        this.fieldValidateMonthFirst = bl;
    }

    public void setValue(long l) {
        java.util.Date date = new java.util.Date(l);
        this.oldCalendar = (GregorianCalendar)((Calendar)this.gCalendar).clone();
        this.gCalendar.setTime(date);
        this.setCalendar(this.gCalendar);
    }

    public void setWrapAssociated(boolean bl) {
        if (this.wrapAssociated != bl) {
            boolean bl2 = this.wrapAssociated;
            this.wrapAssociated = bl;
            this.firePropertyChange("wrapAssociated", bl2, this.wrapAssociated);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setYear(int n) {
        GregorianCalendar gregorianCalendar = (GregorianCalendar)((Calendar)this.gCalendar).clone();
        gregorianCalendar.set(1, n);
        if (gregorianCalendar.get(0) != this.gCalendar.get(0) || gregorianCalendar.get(2) != this.gCalendar.get(2) || gregorianCalendar.get(5) != this.gCalendar.get(5) || gregorianCalendar.get(11) != this.gCalendar.get(11) || gregorianCalendar.get(12) != this.gCalendar.get(12) || gregorianCalendar.get(13) != this.gCalendar.get(13)) {
            throw new IllegalArgumentException(SpinnerErrorMessageSource.getStringBy("OutOfRange"));
        }
        if (n > this.maximum.get(1) || n < this.minimum.get(1)) throw new IllegalArgumentException(SpinnerErrorMessageSource.getStringBy("OutOfRange"));
        this.oldCalendar = (GregorianCalendar)((Calendar)this.gCalendar).clone();
        this.gCalendar.set(1, n);
        try {
            this.setCalendar(this.gCalendar);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = illegalArgumentException.getMessage();
            if (string == null) return;
            throw illegalArgumentException;
        }
    }

    protected void skipVCaretPos(boolean bl) {
        SubField subField = null;
        int n = 0;
        if (bl) {
            int n2 = this.formatCount - 1;
            while (n2 >= 0) {
                subField = this.subFormats[n2];
                if (subField.isFormat() && (n = this.getFieldTypeByOrder(n2)) != 15) {
                    this.vCaretPos = n;
                    break;
                }
                --n2;
            }
        } else {
            int n3 = 0;
            while (n3 < this.formatCount) {
                subField = this.subFormats[n3];
                if (subField.isFormat() && (n = this.getFieldTypeByOrder(n3)) != 15) {
                    this.vCaretPos = this.getFieldTypeByOrder(n3);
                    break;
                }
                ++n3;
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.getEditable()) {
            if (!this.isSpinnable()) {
                return;
            }
        } else {
            return;
        }
        if (changeEvent.getSource() == this.incrButton) {
            if (this.incrButton.getModel().isPressed()) {
                this.scrollUpByUI();
                if (!SpinnerGUI.contSpinThread.isRunning()) {
                    SpinnerGUI.contSpinThread.setObject(this.incrButton);
                    SpinnerGUI.contSpinThread.resumeIt();
                }
            } else {
                SpinnerGUI.contSpinThread.setObject(null);
                SpinnerGUI.contSpinThread.suspendIt();
                this.highlightField();
            }
        }
        if (changeEvent.getSource() == this.decrButton) {
            if (this.decrButton.getModel().isPressed()) {
                this.scrollDownByUI();
                if (!SpinnerGUI.contSpinThread.isRunning()) {
                    SpinnerGUI.contSpinThread.setObject(this.decrButton);
                    SpinnerGUI.contSpinThread.resumeIt();
                }
            } else {
                SpinnerGUI.contSpinThread.setObject(null);
                SpinnerGUI.contSpinThread.suspendIt();
                this.highlightField();
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws ClassNotFoundException, IOException {
        objectOutputStream.defaultWriteObject();
        Object[] objectArray = null;
        CalendarSpinner calendarSpinner = this;
        synchronized (calendarSpinner) {
            if (this.listenerList != null) {
                objectArray = this.listenerList.getListenerList();
            }
        }
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                Class clazz = (Class)objectArray[n];
                DateChangedListener dateChangedListener = (DateChangedListener)objectArray[n + 1];
                if (dateChangedListener != null && dateChangedListener instanceof Serializable) {
                    objectOutputStream.writeObject(clazz.getName());
                    objectOutputStream.writeObject(dateChangedListener);
                }
                n += 2;
            }
        }
        objectOutputStream.writeObject(null);
    }
}

