/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.framework.java;

import com.ibm.as400.ui.framework.ContextButtonHelpHandler;
import com.ibm.as400.ui.framework.PDMLSpecificationException;
import com.ibm.as400.ui.framework.ParseException;
import com.ibm.as400.ui.framework.PropertyPageDescriptor;
import com.ibm.as400.ui.framework.SystemResourceFinder;
import com.ibm.as400.ui.framework.XMLPropertySheetDefinition;
import com.ibm.as400.ui.framework.java.ArrowKeyListener;
import com.ibm.as400.ui.framework.java.ConditionalBlock;
import com.ibm.as400.ui.framework.java.DataBean;
import com.ibm.as400.ui.framework.java.DataFormatter;
import com.ibm.as400.ui.framework.java.DisplayManagerException;
import com.ibm.as400.ui.framework.java.DynamicPanelManager;
import com.ibm.as400.ui.framework.java.HelpViewer;
import com.ibm.as400.ui.framework.java.IllegalUserDataException;
import com.ibm.as400.ui.framework.java.JavaComponentDescriptor;
import com.ibm.as400.ui.framework.java.LookAndFeelManager;
import com.ibm.as400.ui.framework.java.MessageLog;
import com.ibm.as400.ui.framework.java.MessagePump;
import com.ibm.as400.ui.framework.java.PaneManager;
import com.ibm.as400.ui.framework.java.PanelFocusManager;
import com.ibm.as400.ui.framework.java.PanelManager;
import com.ibm.as400.ui.framework.java.PreChangeEvent;
import com.ibm.as400.ui.framework.java.PreChangeListener;
import com.ibm.as400.ui.framework.java.PropertySheetManager;
import com.ibm.as400.ui.framework.java.UIFramework;
import com.ibm.as400.ui.framework.java.VerifyingTabbedPane;
import com.ibm.as400.ui.framework.java.WindowManager;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TaskActionListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PropertySheetManager
implements PaneManager,
WindowManager {
    public static final int OK_BUTTON = 1;
    public static final int CANCEL_BUTTON = 2;
    public static final int HELP_BUTTON = 4;
    public static final int APPLY_BUTTON = 8;
    private Locale m_locale;
    private XMLPropertySheetDefinition m_psd;
    private DataBean[] m_dataBeans;
    private Window m_owner;
    private Window m_window;
    private VerifyingTabbedPane m_tabbedPane;
    private JPanel m_buttonPanel;
    private Container m_container;
    protected JButton m_buttonOK;
    protected JButton m_buttonCancel;
    protected JButton m_buttonHelp;
    protected JButton m_buttonApply;
    private JToggleButton m_contextHelp;
    private JPanel m_helpButtonPanel;
    private Dimension m_maxButtonSize;
    private Vector m_userButtons = new Vector();
    private Vector m_visibleButtons = null;
    private ArrowKeyListener m_arrowKeyListener = null;
    private Vector m_pages = new Vector();
    private Hashtable m_pageTable = new Hashtable();
    private HelpViewer m_helpViewer;
    private boolean m_exitOnClose = false;
    private boolean m_initialDisplay = true;
    private WindowManager m_ownerManager;
    private Point m_location;
    protected int m_windowMinWidth = 0;
    protected int m_windowMinHeight = 0;
    private Vector m_commitListeners = new Vector();
    private Vector m_cancelListeners = new Vector();
    private Vector m_applyListeners = new Vector();
    private ActionListener m_cancelHandler = null;
    private boolean m_pageSwitchValidation = false;
    private PreChangeListener m_preChangeListener = null;
    private boolean m_saveOnThread = false;
    private boolean m_loadOnThread = false;
    private Vector threads = new Vector();
    private boolean m_blocking = false;
    static final int MARGIN_WIDTH = 4;
    private static final boolean m_descriptorTrace = false;
    private PanelManager.ContextHelpHandler m_contextHelpHandler = null;

    public static void main(String[] stringArray) {
        System.setErr(System.out);
        String string = SystemResourceFinder.format("propertySheetManagerArguments");
        if (stringArray.length == 2) {
            PropertySheetManager propertySheetManager = null;
            try {
                propertySheetManager = new PropertySheetManager(stringArray[0], stringArray[1], null);
            }
            catch (DisplayManagerException displayManagerException) {
                System.exit(-1);
            }
            propertySheetManager.setExitOnClose(true);
            propertySheetManager.setVisible(true);
        } else if (stringArray.length == 3) {
            if (stringArray[0].equalsIgnoreCase("-SERIALIZE")) {
                try {
                    new PropertySheetManager(stringArray[1], null, stringArray[2]);
                }
                catch (DisplayManagerException displayManagerException) {
                    System.exit(-1);
                }
            } else if (stringArray[0].equalsIgnoreCase("-DYNAMIC")) {
                PropertySheetManager propertySheetManager = null;
                try {
                    propertySheetManager = new PropertySheetManager(stringArray[1], null, stringArray[2], null, null, true);
                }
                catch (DisplayManagerException displayManagerException) {
                    System.exit(-1);
                }
                propertySheetManager.setExitOnClose(true);
                propertySheetManager.setVisible(true);
            } else {
                System.err.println(string);
                System.exit(0);
            }
        } else if (stringArray.length == 4) {
            if (stringArray[0].equalsIgnoreCase("-LOCALE")) {
                String string2;
                String string3 = stringArray[1];
                String string4 = null;
                int n = string3.indexOf("_");
                if (n == -1) {
                    System.err.println(string);
                    System.exit(0);
                }
                String string5 = string3.substring(0, n);
                if ((n = (string3 = string3.substring(n + 1)).indexOf("_")) == -1) {
                    string2 = string3;
                } else {
                    string2 = string3.substring(0, n);
                    string4 = string3.substring(n + 1);
                }
                Locale locale = string4 == null ? new Locale(string5, string2) : new Locale(string5, string2, string4);
                PropertySheetManager propertySheetManager = null;
                try {
                    propertySheetManager = new PropertySheetManager(stringArray[2], locale, stringArray[3], null);
                }
                catch (DisplayManagerException displayManagerException) {
                    System.exit(-1);
                }
                propertySheetManager.setExitOnClose(true);
                propertySheetManager.setVisible(true);
            }
        } else if (stringArray.length == 5) {
            if (stringArray[0].equalsIgnoreCase("-SERIALIZE") && stringArray[1].equalsIgnoreCase("-LOCALE")) {
                String string6;
                String string7 = stringArray[2];
                String string8 = null;
                int n = string7.indexOf("_");
                if (n == -1) {
                    System.err.println(string);
                    System.exit(0);
                }
                String string9 = string7.substring(0, n);
                if ((n = (string7 = string7.substring(n + 1)).indexOf("_")) == -1) {
                    string6 = string7;
                } else {
                    string6 = string7.substring(0, n);
                    string8 = string7.substring(n + 1);
                }
                Locale locale = string8 == null ? new Locale(string9, string6) : new Locale(string9, string6, string8);
                try {
                    new PropertySheetManager(stringArray[3], locale, stringArray[4]);
                }
                catch (DisplayManagerException displayManagerException) {
                    System.exit(-1);
                }
            } else {
                System.err.println(string);
                System.exit(0);
            }
        } else {
            System.err.println(string);
            System.exit(0);
        }
    }

    public PropertySheetManager(String string, String string2, DataBean[] dataBeanArray) throws DisplayManagerException {
        this(string, (Locale)null, string2, dataBeanArray, (Frame)null);
    }

    public PropertySheetManager(String string, String string2, DataBean[] dataBeanArray, boolean bl) throws DisplayManagerException {
        this(string, (Locale)null, string2, dataBeanArray, (Frame)null, bl);
    }

    public PropertySheetManager(String string, Locale locale, String string2, DataBean[] dataBeanArray) throws DisplayManagerException {
        this(string, locale, string2, dataBeanArray, (Frame)null);
    }

    public PropertySheetManager(String string, Locale locale, String string2, DataBean[] dataBeanArray, boolean bl) throws DisplayManagerException {
        this(string, locale, string2, dataBeanArray, (Frame)null, bl);
    }

    public PropertySheetManager(String string, String string2, DataBean[] dataBeanArray, Frame frame) throws DisplayManagerException {
        this(string, null, string2, dataBeanArray, frame);
    }

    public PropertySheetManager(String string, String string2, DataBean[] dataBeanArray, Frame frame, boolean bl) throws DisplayManagerException {
        this(string, null, string2, dataBeanArray, frame, bl);
    }

    public PropertySheetManager(String string, Locale locale, String string2, DataBean[] dataBeanArray, Frame frame) throws DisplayManagerException {
        this(string, locale, string2, dataBeanArray, frame, false);
    }

    public PropertySheetManager(String string, Locale locale, String string2, DataBean[] dataBeanArray, Frame frame, boolean bl) throws DisplayManagerException {
        UIFramework.setDynamicResizingEnabled(bl);
        this.m_psd = this.constructPropertySheetDefinition(string, locale, string2);
        this.m_locale = locale;
        this.m_dataBeans = dataBeanArray;
        this.m_owner = frame;
        this.constructUI();
    }

    public PropertySheetManager(String string, String string2, DataBean[] dataBeanArray, Container container) throws DisplayManagerException {
        this(string, null, string2, dataBeanArray, container);
    }

    public PropertySheetManager(String string, String string2, DataBean[] dataBeanArray, Container container, boolean bl) throws DisplayManagerException {
        this(string, null, string2, dataBeanArray, container, bl);
    }

    public PropertySheetManager(String string, Locale locale, String string2, DataBean[] dataBeanArray, Container container) throws DisplayManagerException {
        this(string, locale, string2, dataBeanArray, container, false);
    }

    public PropertySheetManager(String string, Locale locale, String string2, DataBean[] dataBeanArray, Container container, boolean bl) throws DisplayManagerException {
        UIFramework.setDynamicResizingEnabled(bl);
        if (container == null) {
            throw new IllegalArgumentException(SystemResourceFinder.format("nullContainerArgument"));
        }
        this.m_psd = this.constructPropertySheetDefinition(string, locale, string2);
        this.m_locale = locale;
        this.m_dataBeans = dataBeanArray;
        this.m_container = container;
        this.constructUI();
    }

    public PropertySheetManager(String string, Locale locale, String string2) throws DisplayManagerException {
        if (string == null) {
            throw new IllegalArgumentException(SystemResourceFinder.format("nullBaseNameArgument"));
        }
        if (string2 == null) {
            throw new IllegalArgumentException(SystemResourceFinder.format("nullPropertySheetNameArgument"));
        }
        try {
            this.m_psd = new XMLPropertySheetDefinition(string, locale, string2);
        }
        catch (ParseException parseException) {
            parseException.reportErrors();
            throw new DisplayManagerException(parseException.getClass().getName());
        }
        catch (MissingResourceException missingResourceException) {
            MessageLog.logError(missingResourceException);
            throw new DisplayManagerException(missingResourceException.getClass().getName());
        }
        catch (PDMLSpecificationException pDMLSpecificationException) {
            pDMLSpecificationException.reportErrors();
            throw new DisplayManagerException(pDMLSpecificationException.getClass().getName());
        }
        catch (IOException iOException) {
            MessageLog.printStackTrace(iOException);
            throw new DisplayManagerException(iOException.getClass().getName());
        }
        try {
            this.serialize();
        }
        catch (IOException iOException) {
            MessageLog.printStackTrace(iOException);
            throw new DisplayManagerException(iOException.getClass().getName());
        }
    }

    public void serialize() throws IOException {
        this.savePropertySheetDefinition(this.m_psd.getPropertySheet().m_name + this.m_psd.getPropertySheetDefinitions().m_localeString + ".pdml.ser");
    }

    public JTabbedPane getTabbedPane() {
        return this.m_tabbedPane;
    }

    public PanelManager getPage(int n) {
        return (PanelManager)this.m_pages.elementAt(n);
    }

    public PanelManager getPage(String string) {
        return (PanelManager)this.m_pageTable.get(string);
    }

    public void showPage(int n) {
        Thread thread;
        if (this.threads.size() > 0 && (thread = (Thread)this.threads.elementAt(n)) != null && thread.isAlive()) {
            PropertySheetManager.debug("Attempt to show page, but thread is alive. Will wait. Thread: " + n);
            ((PanelManager)this.m_pages.elementAt(n)).setWaitCursor(true);
            try {
                thread.setPriority(8);
                thread.join();
                PropertySheetManager.debug("Thread complete. Thread: " + n);
            }
            catch (InterruptedException interruptedException) {
                PropertySheetManager.debug("Thread never completed.  Just interrupted. Thread: " + n);
            }
            ((PanelManager)this.m_pages.elementAt(n)).setWaitCursor(false);
        }
        this.removeHelpHandlers();
        this.addHelpHandlerToButtons(n);
        this.m_tabbedPane.setSelectedIndex(n);
    }

    public void showPage(String string) {
        PanelManager panelManager = this.getPage(string);
        if (panelManager == null) {
            return;
        }
        int n = this.m_tabbedPane.indexOfTab(panelManager.getTitle());
        if (n != -1) {
            this.removeHelpHandlers();
            this.addHelpHandlerToButtons(n);
            this.m_tabbedPane.setSelectedIndex(n);
        }
    }

    public void setExitOnClose(boolean bl) {
        this.m_exitOnClose = bl;
    }

    public boolean getExitOnClose() {
        return this.m_exitOnClose;
    }

    public void setTitle(String string) {
        if (this.m_window != null) {
            if (this.m_window instanceof JFrame) {
                ((JFrame)this.m_window).setTitle(string);
            } else if (this.m_window instanceof JDialog) {
                ((JDialog)this.m_window).setTitle(string);
            }
        }
    }

    public void setHelpPath(String string) {
        Enumeration enumeration = this.m_pageTable.elements();
        while (enumeration.hasMoreElements()) {
            PanelManager panelManager = (PanelManager)enumeration.nextElement();
            panelManager.setHelpPath(string);
        }
    }

    protected void loadPagesData() {
        int n = 0;
        while (n < this.m_pages.size()) {
            PanelManager panelManager = (PanelManager)this.m_pages.elementAt(n);
            DataLoader dataLoader = new DataLoader(panelManager);
            if (!this.m_loadOnThread || n == 0) {
                PropertySheetManager.debug("setVisible loading page " + n + " directly");
                dataLoader.run();
                this.threads.addElement(null);
            } else {
                PropertySheetManager.debug("setVisible loading page " + n + " on a thread");
                Thread thread = new Thread(dataLoader);
                this.threads.addElement(thread);
                thread.setPriority(4);
                thread.start();
            }
            ++n;
        }
    }

    public void setVisible(boolean bl) {
        final boolean bl2 = bl;
        if (SwingUtilities.isEventDispatchThread()) {
            this.setVisible0(bl2);
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    PropertySheetManager.this.setVisible0(bl2);
                }
            };
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setVisible0(boolean bl) {
        if (bl) {
            if (this.m_initialDisplay && this.m_container != null) {
                this.loadPagesData();
            }
            if (this.m_window != null) {
                Object object;
                if (this.m_window instanceof Dialog && ((Dialog)this.m_window).isModal()) {
                    HelpViewer.setActivationWindow(this.m_window);
                }
                if (this.m_initialDisplay) {
                    this.m_window.pack();
                    if (this.m_window instanceof JFrame) {
                        ((JFrame)this.m_window).setResizable(UIFramework.isDynamicResizingEnabled());
                    } else if (this.m_window instanceof JDialog) {
                        ((JDialog)this.m_window).setResizable(UIFramework.isDynamicResizingEnabled());
                    }
                    object = this.m_window.getToolkit().getScreenSize();
                    Dimension dimension = this.m_window.getPreferredSize();
                    if (this.m_window instanceof JFrame || this.m_location == null) {
                        ((Component)this.m_window).setLocation(((Dimension)object).width / 2 - dimension.width / 2, ((Dimension)object).height / 2 - dimension.height / 2);
                    } else {
                        if (this.m_location.x < 0 || this.m_location.y < 0 || this.m_location.x + dimension.width > ((Dimension)object).width || this.m_location.y + dimension.height > ((Dimension)object).height) {
                            this.m_location = new Point(((Dimension)object).width / 2 - dimension.width / 2, ((Dimension)object).height / 2 - dimension.height / 2);
                        }
                        ((Component)this.m_window).setLocation(this.m_location);
                    }
                }
                this.setDefaultButton();
                UIFramework.notifyGlobalRegisteredListeners(this.m_window, bl);
                if (UIFramework.isApplet()) {
                    if (this.m_window instanceof JDialog) {
                        ((JDialog)this.m_window).setModal(true);
                    }
                    ((Component)this.m_window).setVisible(true);
                } else {
                    ((Component)this.m_window).setVisible(true);
                    PropertySheetManager.debug("** setvisible");
                    if (this.m_window instanceof JDialog && this.m_owner.isVisible() && (this.m_owner instanceof Frame && ((Frame)this.m_owner).getState() != 1 || this.m_owner instanceof Dialog)) {
                        this.m_blocking = true;
                        if (SwingUtilities.isEventDispatchThread()) {
                            object = new MessagePump(PanelManager.getRealSystemEventQueue());
                            ((MessagePump)object).pumpEvents(new ConditionalBlock(){

                                public boolean evaluate() {
                                    return PropertySheetManager.this.m_blocking;
                                }
                            });
                        } else {
                            object = this.m_window.getTreeLock();
                            synchronized (object) {
                                while (this.m_blocking) {
                                    try {
                                        this.m_window.getTreeLock().wait(250L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            this.m_initialDisplay = false;
        } else if (this.m_window != null) {
            UIFramework.notifyGlobalRegisteredListeners(this.m_window, false);
            ((Component)this.m_window).setVisible(false);
        }
    }

    public boolean isVisible() {
        return this.m_window != null ? this.m_window.isVisible() : false;
    }

    public Dimension getPreferredSize() {
        if (this.m_window != null) {
            this.m_window.pack();
            return this.m_window.getPreferredSize();
        }
        if (this.m_container != null) {
            return this.m_container.getPreferredSize();
        }
        return new Dimension(0, 0);
    }

    public void setPageSwitchValidation(boolean bl) {
        if (!this.m_pageSwitchValidation && bl) {
            if (this.m_preChangeListener == null) {
                this.m_preChangeListener = new PreChangeListener(){

                    public void preStateChanged(PreChangeEvent preChangeEvent) throws Exception {
                        VerifyingTabbedPane verifyingTabbedPane = (VerifyingTabbedPane)preChangeEvent.getSource();
                        PropertySheetManager.this.validatePage(verifyingTabbedPane.getSelectedIndex());
                    }
                };
            }
            this.m_tabbedPane.addPreChangeListener(this.m_preChangeListener);
        } else if (this.m_pageSwitchValidation && !bl) {
            this.m_tabbedPane.removePreChangeListener(this.m_preChangeListener);
        }
        this.m_pageSwitchValidation = bl;
    }

    public boolean isPageSwitchValidation() {
        return this.m_pageSwitchValidation;
    }

    public void setLoadOnThread(boolean bl) {
        this.m_loadOnThread = bl;
    }

    public boolean isLoadOnThread() {
        return this.m_loadOnThread;
    }

    public boolean getSaveOnThread() {
        return this.m_saveOnThread;
    }

    public void setSaveOnThread(boolean bl) {
        this.m_saveOnThread = bl;
    }

    public String getTitle() {
        if (this.m_window != null) {
            if (this.m_window instanceof JFrame) {
                return ((JFrame)this.m_window).getTitle();
            }
            if (this.m_window instanceof JDialog) {
                return ((JDialog)this.m_window).getTitle();
            }
        }
        return this.m_psd.getPropertySheet().m_title;
    }

    public void loadData() {
    }

    public void activatePanel() {
    }

    public void showPane(String string) {
    }

    public Component getComponent(String string) {
        int n = string.indexOf(46);
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        PanelManager panelManager = (PanelManager)this.m_pageTable.get(string2);
        return panelManager != null ? panelManager.getComponent(string3) : null;
    }

    public void refreshComponent(String string) {
        int n = string.indexOf(46);
        if (n == -1) {
            return;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        PanelManager panelManager = null;
        if (this.getDelegateManager(string2) instanceof PanelManager) {
            panelManager = (PanelManager)this.getDelegateManager(string2);
        }
        if (panelManager != null) {
            panelManager.refreshComponent(string3);
        }
    }

    public JavaComponentDescriptor getComponentDescriptor(String string) {
        int n = string.indexOf(46);
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        PanelManager panelManager = (PanelManager)this.m_pageTable.get(string2);
        return panelManager != null ? panelManager.getComponentDescriptor(string3) : null;
    }

    public PaneManager getDelegateManager(String string) {
        return (PaneManager)this.m_pageTable.get(string);
    }

    public void setAggregateManager(PaneManager paneManager) {
    }

    public PaneManager getAggregateManager() {
        return null;
    }

    public PaneManager getRootManager() {
        return null;
    }

    public void applyChanges() {
    }

    public void prepareToCommit(Vector vector) {
    }

    public void commit(Vector vector) {
    }

    public void validatePage(int n) throws IllegalUserDataException {
        PanelManager panelManager = (PanelManager)this.m_pages.elementAt(n);
        PropertySheetManager.debug("validating page " + n + ".");
        try {
            panelManager.applyChanges();
        }
        catch (IllegalUserDataException illegalUserDataException) {
            this.handleDataException(illegalUserDataException);
            throw illegalUserDataException;
        }
        Vector vector = new Vector();
        vector.removeAllElements();
        try {
            panelManager.prepareToCommit(vector);
        }
        catch (IllegalUserDataException illegalUserDataException) {
            this.handleDataException(illegalUserDataException);
            throw illegalUserDataException;
        }
    }

    public void setFormatter(String string, DataFormatter dataFormatter, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException(SystemResourceFinder.format("nullComponentNameArgument"));
        }
        if (dataFormatter == null) {
            throw new IllegalArgumentException(SystemResourceFinder.format("nullFormatterArgument"));
        }
        int n = string.indexOf(46);
        if (n == -1) {
            Object[] objectArray = new Object[]{string};
            throw new IllegalArgumentException(SystemResourceFinder.format("invalidComponentNameArgument", objectArray));
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        PanelManager panelManager = (PanelManager)this.m_pageTable.get(string2);
        if (panelManager == null) {
            Object[] objectArray = new Object[]{string2, new String(this.m_psd.getPropertySheetDefinitions().m_baseName + this.m_psd.getPropertySheetDefinitions().m_localeString)};
            throw new IllegalArgumentException(SystemResourceFinder.format("panelNotFound", objectArray));
        }
        panelManager.setFormatter(string3, dataFormatter, bl);
    }

    public DataFormatter getFormatter(String string) {
        if (string == null) {
            throw new IllegalArgumentException(SystemResourceFinder.format("nullComponentNameArgument"));
        }
        int n = string.indexOf(46);
        if (n == -1) {
            Object[] objectArray = new Object[]{string};
            throw new IllegalArgumentException(SystemResourceFinder.format("invalidComponentNameArgument", objectArray));
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        PanelManager panelManager = (PanelManager)this.m_pageTable.get(string2);
        if (panelManager == null) {
            return null;
        }
        return panelManager.getFormatter(string3);
    }

    public Window getWindow() {
        return this.m_window;
    }

    public void setModalRelativeTo(WindowManager windowManager) {
        if (!this.isVisible()) {
            this.m_ownerManager = windowManager;
            this.m_owner = this.m_ownerManager.getWindow();
            this.buildDialog();
        }
    }

    public WindowManager getOwnerManager() {
        return this.m_ownerManager;
    }

    public void addCommitListener(ActionListener actionListener) {
        this.m_commitListeners.addElement(actionListener);
    }

    public void addCommitListener(Object object) {
        this.m_commitListeners.addElement(object);
    }

    public void addCancelListener(ActionListener actionListener) {
        this.m_cancelListeners.addElement(actionListener);
    }

    public void addCancelListener(Object object) {
        this.m_cancelListeners.addElement(object);
    }

    public void dispose() {
        if (this.getWindow() != null) {
            if (this.m_owner != null && this.m_owner.isVisible() && (this.m_owner instanceof Frame && ((Frame)this.m_owner).getState() != 1 || this.m_owner instanceof Dialog)) {
                this.m_blocking = false;
                this.m_owner.setEnabled(true);
                this.m_owner.toFront();
            }
            this.getWindow().dispose();
        }
    }

    public void handleDataException(IllegalUserDataException illegalUserDataException) {
        ((PanelManager)this.m_pages.elementAt(this.m_tabbedPane.getSelectedIndex())).handleDataException(illegalUserDataException);
    }

    public void addPage(PanelManager panelManager, int n) {
        if (!this.isVisible()) {
            panelManager.setAggregateManager(this);
            panelManager.setFocusPolicy(false);
            this.m_pages.insertElementAt(panelManager, n);
            this.m_pageTable.put(panelManager.getName(), panelManager);
            this.m_tabbedPane.insertTab(panelManager.getTitle(), null, panelManager.getContainer(), null, n);
        }
    }

    public void removePage(String string) {
        PanelManager panelManager = this.getPage(string);
        int n = this.m_pages.indexOf(panelManager);
        if (n != -1) {
            this.removePage(n);
        }
    }

    public void removePage(int n) {
        if (!this.isVisible()) {
            this.m_tabbedPane.removeTabAt(n);
            PanelManager panelManager = (PanelManager)this.m_pages.elementAt(n);
            this.m_pages.removeElement(panelManager);
            this.m_pageTable.remove(panelManager.getName());
            panelManager.setAggregateManager(null);
        }
    }

    public void addButtons(int n) {
        int n2 = this.determineButtonVisibility(n);
        this.populateButtonPanel(n2);
    }

    public void removeButtons(int n) {
        int n2 = this.determineButtonVisibility(0);
        this.populateButtonPanel(n2 &= ~n);
    }

    public void enableButtons(int n) {
        this.setButtonsEnablement(n, true);
    }

    public void pressButton(int n) {
        if (n == 1) {
            this.m_buttonOK.doClick();
        } else if (n == 2) {
            this.m_buttonCancel.doClick();
        } else if (n == 8) {
            this.m_buttonApply.doClick();
        } else if (n == 4) {
            this.m_buttonHelp.doClick();
        }
    }

    public void disableButtons(int n) {
        this.setButtonsEnablement(n, false);
    }

    public void addUserButton(String string, String string2, ActionListener actionListener) throws IllegalArgumentException {
        if (actionListener == null || string == null || string2 == null) {
            throw new IllegalArgumentException();
        }
        if (this.findUserButtonIndex(string) != -1) {
            throw new IllegalArgumentException();
        }
        JButton jButton = new JButton(string2);
        jButton.setName(string);
        jButton.addActionListener(actionListener);
        Dimension dimension = jButton.getPreferredSize();
        dimension.height = this.m_maxButtonSize.height;
        if (this.m_maxButtonSize.width > dimension.width) {
            dimension.width = this.m_maxButtonSize.width;
        }
        jButton.setPreferredSize(dimension);
        this.m_userButtons.addElement(jButton);
        if (this.m_arrowKeyListener == null) {
            this.m_arrowKeyListener = new ArrowKeyListener();
        }
        jButton.addKeyListener(this.m_arrowKeyListener);
        int n = this.determineButtonVisibility(0);
        this.populateButtonPanel(n);
    }

    public void removeUserButton(String string) throws IllegalArgumentException {
        int n = this.findUserButtonIndex(string);
        if (n <= -1) {
            throw new IllegalArgumentException();
        }
        this.m_userButtons.removeElementAt(n);
        int n2 = this.determineButtonVisibility(0);
        this.populateButtonPanel(n2);
    }

    public JButton getUserButton(String string) throws IllegalArgumentException {
        int n = this.findUserButtonIndex(string);
        if (n > -1) {
            return (JButton)this.m_userButtons.elementAt(n);
        }
        throw new IllegalArgumentException();
    }

    public void enableUserButton(String string) throws IllegalArgumentException {
        this.setUserButtonEnablement(string, true);
    }

    public void disableUserButton(String string) throws IllegalArgumentException {
        this.setUserButtonEnablement(string, false);
    }

    public void setMinimumWindowSize(int n, int n2) {
        this.m_windowMinWidth = n;
        this.m_windowMinHeight = n2;
    }

    private XMLPropertySheetDefinition constructPropertySheetDefinition(String string, Locale locale, String objectArray) throws DisplayManagerException {
        Object object;
        XMLPropertySheetDefinition xMLPropertySheetDefinition;
        block15: {
            Locale locale2;
            if (string == null) {
                throw new IllegalArgumentException(SystemResourceFinder.format("nullBaseNameArgument"));
            }
            if (objectArray == null) {
                throw new IllegalArgumentException(SystemResourceFinder.format("nullPropertySheetNameArgument"));
            }
            xMLPropertySheetDefinition = null;
            Locale locale3 = locale2 = locale != null ? locale : Locale.getDefault();
            if (UIFramework.getSearchMode() != 3) {
                int n = string.lastIndexOf(46);
                object = n != -1 ? string.substring(0, n) + "/" + (String)objectArray : objectArray;
                try {
                    xMLPropertySheetDefinition = this.loadPropertySheetDefinition((String)object, locale);
                }
                catch (MissingResourceException missingResourceException) {
                    if (UIFramework.getSearchMode() == 1) {
                        Object[] objectArray2 = new Object[]{new String((String)objectArray + "_" + locale2)};
                        MessageLog.logError(SystemResourceFinder.format("serializedPropertySheetNotFound", objectArray2));
                        throw new DisplayManagerException(missingResourceException.getClass().getName());
                    }
                }
                catch (IOException iOException) {
                    MessageLog.printStackTrace(iOException);
                    if (UIFramework.getSearchMode() == 1) {
                        throw new DisplayManagerException(iOException.getClass().getName());
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    MessageLog.printStackTrace(classNotFoundException);
                    if (UIFramework.getSearchMode() != 1) break block15;
                    throw new DisplayManagerException(classNotFoundException.getClass().getName());
                }
            }
        }
        if (xMLPropertySheetDefinition != null) {
            object = new Object[]{new String((String)objectArray + SystemResourceFinder.getLastDocumentLocale() + ".pdml.ser")};
            MessageLog.traceOut(SystemResourceFinder.format("propertySheetLoaded", object));
            return xMLPropertySheetDefinition;
        }
        try {
            xMLPropertySheetDefinition = new XMLPropertySheetDefinition(string, locale, (String)objectArray);
        }
        catch (ParseException parseException) {
            parseException.reportErrors();
            throw new DisplayManagerException(parseException.getClass().getName());
        }
        catch (MissingResourceException missingResourceException) {
            MessageLog.logError(missingResourceException);
            throw new DisplayManagerException(missingResourceException.getClass().getName());
        }
        catch (PDMLSpecificationException pDMLSpecificationException) {
            pDMLSpecificationException.reportErrors();
            throw new DisplayManagerException(pDMLSpecificationException.getClass().getName());
        }
        catch (IOException iOException) {
            MessageLog.printStackTrace(iOException);
            throw new DisplayManagerException(iOException.getClass().getName());
        }
        object = new Object[]{objectArray, new String(xMLPropertySheetDefinition.getPropertySheetDefinitions().m_baseName + xMLPropertySheetDefinition.getPropertySheetDefinitions().m_localeString)};
        MessageLog.traceOut(SystemResourceFinder.format("propertySheetParsed", object));
        return xMLPropertySheetDefinition;
    }

    private XMLPropertySheetDefinition loadPropertySheetDefinition(String string, Locale locale) throws IOException, ClassNotFoundException {
        InputStream inputStream = SystemResourceFinder.getSerializedPDMLDocument(string, locale);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(inputStream);
        ObjectInputStream objectInputStream = new ObjectInputStream(gZIPInputStream);
        XMLPropertySheetDefinition xMLPropertySheetDefinition = (XMLPropertySheetDefinition)objectInputStream.readObject();
        objectInputStream.close();
        return xMLPropertySheetDefinition;
    }

    private void savePropertySheetDefinition(String string) throws IOException {
        Object[] objectArray = new Object[]{string};
        MessageLog.traceOut(SystemResourceFinder.format("propertySheetSaved", objectArray));
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(fileOutputStream);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
        objectOutputStream.writeObject(this.m_psd);
        objectOutputStream.flush();
        objectOutputStream.close();
    }

    private void constructUI() throws DisplayManagerException {
        LookAndFeelManager.setLookAndFeel();
        boolean bl = false;
        if (this.m_container == null) {
            this.m_container = new JPanel();
            bl = true;
        }
        this.m_container.setLayout(new BorderLayout(1, 0));
        this.m_tabbedPane = new VerifyingTabbedPane();
        this.m_tabbedPane.setOpaque(true);
        this.m_container.add((Component)this.m_tabbedPane, "Center");
        this.m_tabbedPane.addChangeListener(new TabbedPaneListener());
        this.m_tabbedPane.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    CancelHandler cancelHandler = new CancelHandler();
                    cancelHandler.actionPerformed(new ActionEvent(PropertySheetManager.this, 1001, "Cancel"));
                }
            }
        });
        this.buildButtons();
        this.m_buttonPanel.setBorder(new EmptyBorder(6, 0, 7, 0));
        this.m_container.add((Component)this.m_buttonPanel, "South");
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(5, 0));
        this.m_container.add((Component)jPanel, "East");
        jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(5, 0));
        this.m_container.add((Component)jPanel, "West");
        jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(0, 6));
        this.m_container.add((Component)jPanel, "North");
        Vector vector = this.m_psd.getPropertySheetPages();
        int n = 0;
        while (n < vector.size()) {
            PropertyPageDescriptor propertyPageDescriptor = (PropertyPageDescriptor)vector.elementAt(n);
            JPanel jPanel2 = new JPanel();
            PanelManager panelManager = UIFramework.isDynamicResizingEnabled() ? new DynamicPanelManager(propertyPageDescriptor.m_baseName, this.m_locale, propertyPageDescriptor.m_pageName, this.m_dataBeans, (Container)jPanel2) : new PanelManager(propertyPageDescriptor.m_baseName, this.m_locale, propertyPageDescriptor.m_pageName, this.m_dataBeans, jPanel2);
            panelManager.setAggregateManager(this);
            panelManager.setFocusPolicy(false);
            this.m_pages.addElement(panelManager);
            this.m_pageTable.put(propertyPageDescriptor.m_pageName, panelManager);
            if (panelManager.isContainerScrollable()) {
                JScrollPane jScrollPane = new JScrollPane(jPanel2);
                jScrollPane.setBorder(null);
                this.m_tabbedPane.addTab(panelManager.getTitle(), jScrollPane);
            } else {
                this.m_tabbedPane.addTab(panelManager.getTitle(), jPanel2);
            }
            ++n;
        }
        this.addHelpHandlerToButtons(0);
        if (bl) {
            if (this.m_owner != null || this.m_ownerManager != null) {
                this.buildDialog();
            } else {
                this.buildFrame();
            }
        }
        this.setDefaultButton();
        this.m_window.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 9 && keyEvent.isControlDown()) {
                    if (keyEvent.isShiftDown()) {
                        if (PropertySheetManager.this.m_tabbedPane.getSelectedIndex() - 1 > -1) {
                            PropertySheetManager.this.showPage(PropertySheetManager.this.m_tabbedPane.getSelectedIndex() - 1);
                        } else {
                            PropertySheetManager.this.showPage(PropertySheetManager.this.m_tabbedPane.getTabCount() - 1);
                        }
                    } else if (PropertySheetManager.this.m_tabbedPane.getSelectedIndex() + 1 < PropertySheetManager.this.m_tabbedPane.getTabCount()) {
                        PropertySheetManager.this.showPage(PropertySheetManager.this.m_tabbedPane.getSelectedIndex() + 1);
                    } else {
                        PropertySheetManager.this.showPage(0);
                    }
                    keyEvent.consume();
                }
            }
        });
    }

    private void setButtonsEnablement(int n, boolean bl) {
        if ((n & 1) == 1) {
            this.m_buttonOK.setEnabled(bl);
        }
        if ((n & 2) == 2) {
            this.m_buttonCancel.setEnabled(bl);
        }
        if ((n & 8) == 8) {
            this.m_buttonHelp.setEnabled(bl);
        }
        if ((n & 4) == 4) {
            this.m_buttonHelp.setEnabled(bl);
            this.m_contextHelp.setEnabled(bl);
        }
    }

    private void setUserButtonEnablement(String string, boolean bl) throws IllegalArgumentException {
        int n = this.findUserButtonIndex(string);
        if (n <= -1) {
            throw new IllegalArgumentException();
        }
        JButton jButton = (JButton)this.m_userButtons.elementAt(n);
        jButton.setEnabled(bl);
    }

    private int findUserButtonIndex(String string) {
        int n = -1;
        if (!this.m_userButtons.isEmpty() && string != null) {
            int n2 = 0;
            while (n2 < this.m_userButtons.size()) {
                if (((JButton)this.m_userButtons.elementAt(n2)).getName().equals(string)) {
                    n = n2;
                    break;
                }
                ++n2;
            }
        }
        return n;
    }

    private int determineButtonVisibility(int n) {
        Component[] componentArray = this.m_buttonPanel.getComponents();
        int n2 = n;
        int n3 = 0;
        while (n3 < componentArray.length) {
            if (componentArray[n3] instanceof JButton) {
                JButton jButton = (JButton)componentArray[n3];
                if (jButton.equals(this.m_buttonOK)) {
                    n2 |= 1;
                } else if (jButton.equals(this.m_buttonCancel)) {
                    n2 |= 2;
                } else if (jButton.equals(this.m_buttonApply)) {
                    n2 |= 8;
                }
            } else {
                n2 |= 4;
            }
            ++n3;
        }
        return n2;
    }

    private void populateButtonPanel(int n) {
        this.m_buttonPanel.removeAll();
        if (this.m_visibleButtons == null) {
            this.m_visibleButtons = new Vector(5 + this.m_userButtons.size());
        }
        this.m_visibleButtons.clear();
        if ((n & 1) == 1) {
            this.m_buttonPanel.add(this.m_buttonOK);
            this.m_visibleButtons.add(this.m_buttonOK);
        }
        if ((n & 2) == 2) {
            this.m_buttonPanel.add(this.m_buttonCancel);
            this.m_visibleButtons.add(this.m_buttonCancel);
        }
        if ((n & 8) == 8) {
            this.m_buttonPanel.add(this.m_buttonApply);
            this.m_visibleButtons.add(this.m_buttonApply);
        }
        if (!this.m_userButtons.isEmpty()) {
            int n2 = 0;
            while (n2 < this.m_userButtons.size()) {
                this.m_buttonPanel.add((JButton)this.m_userButtons.elementAt(n2));
                this.m_visibleButtons.add((JButton)this.m_userButtons.elementAt(n2));
                ++n2;
            }
        }
        if ((n & 4) == 4) {
            this.m_buttonPanel.add(this.m_helpButtonPanel);
            this.m_visibleButtons.add(this.m_buttonHelp);
        }
        this.m_arrowKeyListener.setButtonVector(this.m_visibleButtons);
        this.m_buttonPanel.validate();
        this.m_buttonPanel.repaint();
    }

    private void buildButtons() {
        this.m_buttonOK = new JButton(SystemResourceFinder.format("ok"));
        this.m_buttonCancel = new JButton(SystemResourceFinder.format("cancel"));
        this.m_buttonApply = new JButton(SystemResourceFinder.format("apply"));
        this.m_buttonHelp = new JButton(SystemResourceFinder.format("help"));
        this.m_contextHelp = new JToggleButton("?"){

            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.m_contextHelp.setFocusPainted(false);
        Font font = this.m_contextHelp.getFont();
        Font font2 = new Font(font.getName(), 1, font.getSize());
        this.m_contextHelp.setFont(font2);
        int n = this.m_buttonOK.getToolkit().getFontMetrics(font2).stringWidth("?") + 4;
        if (n < 15) {
            n = 15;
        }
        ContextButtonHelpHandler contextButtonHelpHandler = new ContextButtonHelpHandler(this.m_container, this.m_contextHelp);
        this.m_contextHelp.addActionListener(contextButtonHelpHandler);
        this.m_buttonPanel = new JPanel(true);
        this.m_buttonPanel.setLayout(new FlowLayout(2, 5, 0));
        this.m_helpButtonPanel = new JPanel();
        this.m_helpButtonPanel.setLayout(new GridBagLayout());
        this.m_helpButtonPanel.add(this.m_buttonHelp);
        this.m_helpButtonPanel.add(this.m_contextHelp);
        this.m_buttonPanel.add(this.m_buttonOK);
        this.m_buttonPanel.add(this.m_buttonCancel);
        this.m_buttonPanel.add(this.m_buttonApply);
        this.m_buttonPanel.add(this.m_helpButtonPanel);
        this.m_maxButtonSize = new Dimension(80, 25);
        int n2 = Toolkit.getDefaultToolkit().getScreenSize().width;
        Dimension dimension = this.m_buttonOK.getPreferredSize();
        if (dimension.width > this.m_maxButtonSize.width) {
            this.m_maxButtonSize.width = dimension.width;
        }
        dimension = this.m_buttonCancel.getPreferredSize();
        if (dimension.width > this.m_maxButtonSize.width) {
            this.m_maxButtonSize.width = dimension.width;
        }
        dimension = this.m_buttonApply.getPreferredSize();
        if (dimension.width > this.m_maxButtonSize.width) {
            this.m_maxButtonSize.width = dimension.width;
        }
        dimension = this.m_buttonHelp.getPreferredSize();
        if (dimension.width > this.m_maxButtonSize.width) {
            this.m_maxButtonSize.width = dimension.width;
        }
        this.m_maxButtonSize.width -= 4;
        this.m_maxButtonSize.height -= 2;
        this.m_buttonOK.setPreferredSize(this.m_maxButtonSize);
        this.m_buttonCancel.setPreferredSize(this.m_maxButtonSize);
        this.m_buttonApply.setPreferredSize(this.m_maxButtonSize);
        this.m_buttonHelp.setPreferredSize(this.m_maxButtonSize);
        Dimension dimension2 = this.m_buttonHelp.getPreferredSize();
        this.m_buttonHelp.setPreferredSize(new Dimension(dimension2.width - n, dimension2.height));
        this.m_contextHelp.setMargin(new Insets(2, 0, 2, 0));
        this.m_buttonHelp.setMargin(new Insets(2, 0, 2, 0));
        this.m_contextHelp.setPreferredSize(new Dimension(n, dimension2.height));
        this.m_buttonOK.setMargin(new Insets(2, 0, 2, 0));
        this.m_buttonCancel.setMargin(new Insets(2, 0, 2, 0));
        this.m_buttonOK.addActionListener(new CommitHandler());
        this.m_buttonCancel.addActionListener(new CancelHandler());
        this.m_buttonApply.addActionListener(new ApplyHandler());
        this.m_buttonHelp.addActionListener(new HelpHandler());
        if (this.m_arrowKeyListener == null) {
            this.m_arrowKeyListener = new ArrowKeyListener();
        }
        this.m_buttonOK.addKeyListener(this.m_arrowKeyListener);
        this.m_buttonCancel.addKeyListener(this.m_arrowKeyListener);
        this.m_buttonApply.addKeyListener(this.m_arrowKeyListener);
        this.m_buttonHelp.addKeyListener(this.m_arrowKeyListener);
        this.removeButtons(8);
        int n3 = this.determineButtonVisibility(0);
        this.populateButtonPanel(n3);
    }

    private void addHelpHandlerToButtons(int n) {
        PanelManager panelManager = null;
        if (this.m_pages != null) {
            panelManager = (PanelManager)this.m_pages.elementAt(n);
            if (panelManager != null) {
                this.m_contextHelpHandler = panelManager.new PanelManager.ContextHelpHandler();
            }
            if (this.m_contextHelpHandler != null) {
                this.m_buttonOK.addKeyListener(this.m_contextHelpHandler);
                this.m_buttonCancel.addKeyListener(this.m_contextHelpHandler);
                this.m_buttonApply.addKeyListener(this.m_contextHelpHandler);
                this.m_buttonHelp.addKeyListener(this.m_contextHelpHandler);
                this.m_contextHelp.addKeyListener(this.m_contextHelpHandler);
                if (this.m_userButtons != null) {
                    int n2 = 0;
                    while (n2 < this.m_userButtons.size()) {
                        ((JButton)this.m_userButtons.get(n2)).addKeyListener(this.m_contextHelpHandler);
                        ++n2;
                    }
                }
            }
        }
    }

    private void removeHelpHandlers() {
        if (this.m_contextHelpHandler != null) {
            this.m_buttonOK.removeKeyListener(this.m_contextHelpHandler);
            this.m_buttonCancel.removeKeyListener(this.m_contextHelpHandler);
            this.m_buttonApply.removeKeyListener(this.m_contextHelpHandler);
            this.m_buttonHelp.removeKeyListener(this.m_contextHelpHandler);
            this.m_contextHelp.removeKeyListener(this.m_contextHelpHandler);
            if (this.m_userButtons != null) {
                int n = 0;
                while (n < this.m_userButtons.size()) {
                    ((JButton)this.m_userButtons.get(n)).removeKeyListener(this.m_contextHelpHandler);
                    ++n;
                }
            }
        }
    }

    private void buildDialog() {
        JDialog jDialog = this.m_owner.isVisible() ? (this.m_owner instanceof Frame && ((Frame)this.m_owner).getState() != 1 ? new JDialog((Frame)this.m_owner, this.getTitle(), false) : (this.m_owner instanceof JDialog ? new JDialog((JDialog)this.m_owner, this.getTitle(), false) : new JDialog((Frame)this.m_owner, this.getTitle(), false))) : (this.m_owner instanceof Frame && ((Frame)this.m_owner).getState() != 1 ? new JDialog((Frame)this.m_owner, this.getTitle(), true) : (this.m_owner instanceof JDialog ? new JDialog((JDialog)this.m_owner, this.getTitle(), true) : new JDialog((Frame)this.m_owner, this.getTitle(), true)));
        if (this.m_owner != null) {
            if (this.m_owner.isVisible() && (this.m_owner instanceof Frame && ((Frame)this.m_owner).getState() != 1 || this.m_owner instanceof Dialog)) {
                Point point = this.m_owner.getLocationOnScreen();
                this.m_location = new Point(point.x + 50, point.y + 50);
            }
        } else {
            Window window = this.m_ownerManager.getWindow();
            if (window != null && window.isVisible()) {
                Point point = window.getLocationOnScreen();
                this.m_location = new Point(point.x + 50, point.y + 50);
            }
        }
        if (this.m_window != null) {
            this.m_window.dispose();
        }
        this.m_window = jDialog;
        jDialog.setFocusTraversalPolicy(new PanelFocusManager());
        jDialog.getContentPane().setLayout(new BorderLayout());
        jDialog.getContentPane().add((Component)this.m_container, "Center");
        jDialog.setDefaultCloseOperation(0);
        jDialog.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                ((PanelManager)PropertySheetManager.this.m_pages.elementAt(0)).activatePanel();
            }

            public void windowClosing(WindowEvent windowEvent) {
                CancelHandler cancelHandler = new CancelHandler();
                cancelHandler.actionPerformed(new ActionEvent(PropertySheetManager.this, 1001, "Cancel"));
            }

            public void windowActivated(WindowEvent windowEvent) {
                PanelManager.windowActivatedActions(windowEvent, PropertySheetManager.this.m_owner);
            }
        });
        jDialog.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (componentEvent.getComponent().getSize().width < PropertySheetManager.this.m_windowMinWidth) {
                    componentEvent.getComponent().setSize(new Dimension(PropertySheetManager.this.m_windowMinWidth, componentEvent.getComponent().getSize().height));
                }
                if (componentEvent.getComponent().getSize().height < PropertySheetManager.this.m_windowMinHeight) {
                    componentEvent.getComponent().setSize(new Dimension(componentEvent.getComponent().getSize().width, PropertySheetManager.this.m_windowMinHeight));
                }
            }
        });
    }

    private void buildFrame() {
        JFrame jFrame = new JFrame(this.m_psd.getPropertySheet().m_title);
        jFrame.setFocusTraversalPolicy(new PanelFocusManager());
        this.m_window = jFrame;
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)this.m_container, "Center");
        if (this.m_psd.getPropertySheet().m_icon != null) {
            ImageIcon imageIcon = null;
            try {
                imageIcon = SystemResourceFinder.getImageResource(this.m_psd.getPropertySheet().m_icon);
            }
            catch (MissingResourceException missingResourceException) {
                MessageLog.logError(missingResourceException);
            }
            if (imageIcon != null) {
                ((Frame)jFrame).setIconImage(imageIcon.getImage());
            }
        }
        jFrame.setDefaultCloseOperation(0);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                ((PanelManager)PropertySheetManager.this.m_pages.elementAt(0)).activatePanel();
            }

            public void windowClosing(WindowEvent windowEvent) {
                CancelHandler cancelHandler = new CancelHandler();
                cancelHandler.actionPerformed(new ActionEvent(PropertySheetManager.this, 1001, "Cancel"));
            }
        });
        jFrame.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (componentEvent.getComponent().getSize().width < PropertySheetManager.this.m_windowMinWidth) {
                    componentEvent.getComponent().setSize(new Dimension(PropertySheetManager.this.m_windowMinWidth, componentEvent.getComponent().getSize().height));
                }
                if (componentEvent.getComponent().getSize().height < PropertySheetManager.this.m_windowMinHeight) {
                    componentEvent.getComponent().setSize(new Dimension(componentEvent.getComponent().getSize().width, PropertySheetManager.this.m_windowMinHeight));
                }
            }
        });
    }

    private void commitBeans(Vector vector) {
        int n = 0;
        while (n < this.m_pages.size()) {
            PanelManager panelManager = (PanelManager)this.m_pages.elementAt(n);
            panelManager.commit(vector);
            ++n;
        }
    }

    public final void fireCommitListeners() {
        int n = 0;
        while (n < this.m_commitListeners.size()) {
            EventListener eventListener;
            Object e = this.m_commitListeners.elementAt(n);
            if (e instanceof ActionListener) {
                eventListener = (ActionListener)e;
                eventListener.actionPerformed(new ActionEvent(this.m_window, 1001, "COMMIT"));
            } else if (e instanceof TaskActionListener) {
                eventListener = (TaskActionListener)e;
                eventListener.actionPerformed(new TaskActionEvent(this, this.m_psd.getPropertySheet().m_name, "COMMIT"));
            }
            ++n;
        }
    }

    public final boolean fireCancelListeners() {
        int n = 0;
        while (n < this.m_cancelListeners.size()) {
            try {
                EventListener eventListener;
                Object e = this.m_cancelListeners.elementAt(n);
                if (e instanceof ActionListener) {
                    eventListener = (ActionListener)e;
                    eventListener.actionPerformed(new ActionEvent(this.m_window, 1001, "CANCEL"));
                } else if (e instanceof TaskActionListener) {
                    eventListener = (TaskActionListener)e;
                    eventListener.actionPerformed(new TaskActionEvent(this, this.m_psd.getPropertySheet().m_name, "CANCEL"));
                }
            }
            catch (RuntimeException runtimeException) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void setCancelHandler(ActionListener actionListener) {
        this.m_cancelHandler = actionListener;
    }

    public ActionListener getCancelHandler() {
        return this.m_cancelHandler;
    }

    private void disposeAfterCommit() {
        if (this.m_window != null) {
            this.fireCommitListeners();
            this.dispose();
        }
        if (this.m_exitOnClose) {
            System.exit(0);
        }
    }

    private void setDefaultButton() {
        Container container = this.m_container.getParent();
        while (!(container instanceof JRootPane) && container != null) {
            container = container.getParent();
        }
        if (container != null) {
            ((JRootPane)container).setDefaultButton(null);
            ((JRootPane)container).setDefaultButton(this.m_buttonOK);
        }
    }

    private static final void debug(String string) {
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 2000";
    }

    private class HelpHandler
    implements ActionListener {
        private HelpHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PropertySheetManager.this.m_container.setCursor(new Cursor(3));
            PanelManager panelManager = (PanelManager)PropertySheetManager.this.m_pages.elementAt(PropertySheetManager.this.m_tabbedPane.getSelectedIndex());
            panelManager.displayHelp(((PropertySheetManager)PropertySheetManager.this).m_psd.getPropertySheet().m_icon);
            PropertySheetManager.this.m_container.setCursor(new Cursor(0));
        }
    }

    private class CancelHandler
    implements ActionListener {
        private CancelHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MessageLog.traceOut(SystemResourceFinder.format("actionCancelled"));
            if (PropertySheetManager.this.m_cancelHandler != null) {
                MessageLog.traceOut("Cancel Handler override");
                PropertySheetManager.this.m_cancelHandler.actionPerformed(actionEvent);
                return;
            }
            if (PropertySheetManager.this.m_window != null) {
                if (!PropertySheetManager.this.fireCancelListeners()) {
                    return;
                }
                PropertySheetManager.this.dispose();
            }
            if (PropertySheetManager.this.m_exitOnClose) {
                System.exit(0);
            }
        }
    }

    private class ApplyHandler
    implements ActionListener {
        private ApplyHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PanelManager panelManager;
            MessageLog.traceOut(SystemResourceFinder.format("actionPerformed"));
            Vector vector = new Vector();
            int n = 0;
            while (n < PropertySheetManager.this.m_pages.size()) {
                panelManager = (PanelManager)PropertySheetManager.this.m_pages.elementAt(n);
                try {
                    panelManager.applyChanges();
                }
                catch (IllegalUserDataException illegalUserDataException) {
                    PropertySheetManager.this.m_tabbedPane.setSelectedIndex(n);
                    PropertySheetManager.this.handleDataException(illegalUserDataException);
                    return;
                }
                ++n;
            }
            vector.removeAllElements();
            int n2 = 0;
            while (n2 < PropertySheetManager.this.m_pages.size()) {
                panelManager = (PanelManager)PropertySheetManager.this.m_pages.elementAt(n2);
                try {
                    panelManager.prepareToCommit(vector);
                }
                catch (IllegalUserDataException illegalUserDataException) {
                    PropertySheetManager.this.handleDataException(illegalUserDataException);
                    return;
                }
                ++n2;
            }
            vector.removeAllElements();
            int n3 = 0;
            while (n3 < PropertySheetManager.this.m_pages.size()) {
                panelManager = (PanelManager)PropertySheetManager.this.m_pages.elementAt(n3);
                panelManager.commit(vector);
                ++n3;
            }
            if (PropertySheetManager.this.m_window != null) {
                int n4 = 0;
                while (n4 < PropertySheetManager.this.m_applyListeners.size()) {
                    ActionListener actionListener = (ActionListener)PropertySheetManager.this.m_applyListeners.elementAt(n4);
                    actionListener.actionPerformed(new ActionEvent(PropertySheetManager.this.m_window, 1001, "APPLY"));
                    ++n4;
                }
            }
        }
    }

    private class CommitHandler
    implements ActionListener {
        private CommitHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PanelManager panelManager;
            MessageLog.traceOut(SystemResourceFinder.format("actionPerformed"));
            Vector vector = new Vector();
            int n = 0;
            while (n < PropertySheetManager.this.m_pages.size()) {
                panelManager = (PanelManager)PropertySheetManager.this.m_pages.elementAt(n);
                try {
                    panelManager.applyChanges();
                }
                catch (IllegalUserDataException illegalUserDataException) {
                    PropertySheetManager.this.m_tabbedPane.setSelectedIndex(n);
                    PropertySheetManager.this.handleDataException(illegalUserDataException);
                    return;
                }
                ++n;
            }
            vector.removeAllElements();
            int n2 = 0;
            while (n2 < PropertySheetManager.this.m_pages.size()) {
                panelManager = (PanelManager)PropertySheetManager.this.m_pages.elementAt(n2);
                try {
                    panelManager.prepareToCommit(vector);
                }
                catch (IllegalUserDataException illegalUserDataException) {
                    PropertySheetManager.this.handleDataException(illegalUserDataException);
                    return;
                }
                ++n2;
            }
            vector.removeAllElements();
            try {
                if (PropertySheetManager.this.m_saveOnThread) {
                    if (PropertySheetManager.this.getWindow() != null) {
                        PropertySheetManager.this.getWindow().setEnabled(false);
                    }
                    Vector vector2 = vector;
                    Thread thread = new Thread(this, vector2){
                        private final /* synthetic */ Vector val$threadProcessedBeans;
                        private final /* synthetic */ CommitHandler this$1;
                        {
                            this.this$1 = commitHandler;
                            this.val$threadProcessedBeans = vector;
                        }

                        public void run() {
                            PropertySheetManager.access$000("Commit processing threaded!");
                            try {
                                PropertySheetManager.access$1700(CommitHandler.access$1600(this.this$1), this.val$threadProcessedBeans);
                            }
                            catch (IllegalUserDataException illegalUserDataException) {
                                SwingUtilities.invokeLater(new Thread(this, illegalUserDataException){
                                    private final /* synthetic */ IllegalUserDataException val$iude;
                                    private final /* synthetic */ 11 this$2;
                                    {
                                        this.this$2 = var1_1;
                                        this.val$iude = illegalUserDataException;
                                    }

                                    public void run() {
                                        if (CommitHandler.access$1600(11.access$1800(this.this$2)).getWindow() != null) {
                                            CommitHandler.access$1600(11.access$1800(this.this$2)).getWindow().setEnabled(true);
                                        }
                                        CommitHandler.access$1600(11.access$1800(this.this$2)).handleDataException(this.val$iude);
                                    }
                                });
                                return;
                            }
                            SwingUtilities.invokeLater(new Thread(this){
                                private final /* synthetic */ 11 this$2;
                                {
                                    this.this$2 = var1_1;
                                }

                                public void run() {
                                    if (CommitHandler.access$1600(11.access$1800(this.this$2)).getWindow() != null) {
                                        CommitHandler.access$1600(11.access$1800(this.this$2)).getWindow().setEnabled(true);
                                    }
                                    PropertySheetManager.access$1900(CommitHandler.access$1600(11.access$1800(this.this$2)));
                                }
                            });
                        }

                        static /* synthetic */ CommitHandler access$1800(11 var0) {
                            return var0.this$1;
                        }
                    };
                    thread.setDaemon(false);
                    thread.start();
                } else {
                    PropertySheetManager.this.commitBeans(vector);
                    PropertySheetManager.this.disposeAfterCommit();
                }
            }
            catch (IllegalUserDataException illegalUserDataException) {
                PropertySheetManager.this.handleDataException(illegalUserDataException);
                return;
            }
        }

        static /* synthetic */ PropertySheetManager access$1600(CommitHandler commitHandler) {
            return commitHandler.PropertySheetManager.this;
        }
    }

    private class TabbedPaneListener
    implements ChangeListener {
        private TabbedPaneListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Thread thread;
            int n = PropertySheetManager.this.m_tabbedPane.getSelectedIndex();
            if (PropertySheetManager.this.threads.size() > 0 && (thread = (Thread)PropertySheetManager.this.threads.elementAt(n)) != null && thread.isAlive()) {
                PropertySheetManager.debug("Attempt to show page, but thread is alive. Will wait. Thread: " + n);
                ((PanelManager)PropertySheetManager.this.m_pages.elementAt(n)).setWaitCursor(true);
                try {
                    thread.setPriority(8);
                    thread.join();
                    PropertySheetManager.debug("Thread complete. Thread: " + n);
                }
                catch (InterruptedException interruptedException) {
                    PropertySheetManager.debug("Thread never completed.  Just interrupted. Thread: " + n);
                }
                ((PanelManager)PropertySheetManager.this.m_pages.elementAt(n)).setWaitCursor(false);
            }
            PropertySheetManager.this.setDefaultButton();
            PropertySheetManager.this.removeHelpHandlers();
            PropertySheetManager.this.addHelpHandlerToButtons(n);
            ((PanelManager)PropertySheetManager.this.m_pages.elementAt(n)).activatePanel();
        }
    }

    private class DataLoader
    implements Runnable {
        PanelManager m_page;

        public DataLoader(PanelManager panelManager) {
            this.m_page = panelManager;
        }

        public void run() {
            PropertySheetManager.debug("starting loadData of page " + this.m_page);
            this.m_page.loadData();
            PropertySheetManager.debug("ending loadData of page " + this.m_page);
        }
    }
}

