/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.framework.java;

import com.ibm.as400.ui.framework.SystemResourceFinder;
import com.ibm.as400.ui.framework.java.MessageLog;
import com.ibm.as400.ui.framework.java.NodeDescriptor;
import com.ibm.as400.ui.framework.java.PanelTreeTableModel;
import com.ibm.as400.ui.framework.java.PanelTreeTableNode;
import com.ibm.as400.ui.framework.java.PanelTreeTableSelectionModel;
import com.ibm.as400.ui.framework.java.PanelTreeTableTreeSelectionModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.MissingResourceException;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class PanelTreeTable
extends JTable
implements ActionListener {
    private TreeTableCellRenderer m_primaryTree = new TreeTableCellRenderer();
    protected PanelTreeTableModel m_tblModel = null;
    private TreeRenderer m_treeRenderer = null;
    static /* synthetic */ Class class$javax$swing$event$CellEditorListener;

    public PanelTreeTable() {
        PanelTreeTableSelectionModel panelTreeTableSelectionModel = new PanelTreeTableSelectionModel(this);
        PanelTreeTableTreeSelectionModel panelTreeTableTreeSelectionModel = new PanelTreeTableTreeSelectionModel(this, panelTreeTableSelectionModel);
        this.m_primaryTree.setSelectionModel(panelTreeTableTreeSelectionModel);
        this.setSelectionModel(panelTreeTableTreeSelectionModel.getListSelectionModel());
        this.addFocusListener(new FocusAdapter(){
            boolean m_firstTime = true;

            public void focusGained(FocusEvent focusEvent) {
                if (this.m_firstTime) {
                    if (PanelTreeTable.this.getSelectedRowCount() == 0) {
                        PanelTreeTable.this.setRowSelectionInterval(0, 0);
                        PanelTreeTable.this.clearSelection();
                    }
                    this.m_firstTime = false;
                }
            }
        });
    }

    public void loadTreeTableModel(PanelTreeTableModel panelTreeTableModel) {
        this.m_tblModel = panelTreeTableModel;
        super.setModel(this.m_tblModel);
        this.m_tblModel.setTable(this);
        this.m_tblModel.setRendererTree(this.m_primaryTree);
        this.initialize();
    }

    public void initialize() {
        this.m_primaryTree.setRowHeight(this.getRowHeight());
        this.m_treeRenderer = new TreeRenderer(this.m_primaryTree);
        this.m_primaryTree.setCellRenderer(this.m_treeRenderer);
        this.m_primaryTree.setShowsRootHandles(true);
        this.getColumnModel().getColumn(0).setCellRenderer(this.m_primaryTree);
        this.getColumnModel().getColumn(0).setCellEditor(new TreeColumnEditor(this.m_primaryTree));
        this.setIntercellSpacing(new Dimension(0, 0));
    }

    public void updateUI() {
        super.updateUI();
        if (this.m_primaryTree != null) {
            this.m_primaryTree.updateUI();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
    }

    public int getEditingRow() {
        return this.editingColumn == 0 ? -1 : this.editingRow;
    }

    public JTree getTree() {
        return this.m_primaryTree;
    }

    public int getTopRow() {
        Rectangle rectangle = this.getVisibleRect();
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = this.m_primaryTree.getClosestRowForLocation(n + 5, n2 + 5);
        if (++n3 == 0) {
            ++n3;
        }
        return n3;
    }

    public int getBottomRow() {
        Rectangle rectangle = this.getVisibleRect();
        int n = rectangle.x;
        int n2 = rectangle.y + rectangle.height;
        int n3 = this.m_primaryTree.getClosestRowForLocation(n + 1, n2 + 1);
        n3 = n3 == -1 ? this.getRowCount() : ++n3;
        return n3;
    }

    public int getTreeRowCount() {
        int n = this.m_primaryTree.getRowCount();
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class TreeColumnEditor
    implements TableCellEditor {
        JTree m_editorTree = null;
        private EventListenerList listenerList = new EventListenerList();

        public TreeColumnEditor(JTree jTree) {
            this.m_editorTree = jTree;
        }

        public Object getCellEditorValue() {
            return null;
        }

        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)eventObject;
                MouseEvent mouseEvent2 = new MouseEvent(this.m_editorTree, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - PanelTreeTable.this.getCellRect((int)0, (int)0, (boolean)true).x, mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                this.m_editorTree.dispatchEvent(mouseEvent2);
            }
            return false;
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        public boolean stopCellEditing() {
            return true;
        }

        public void cancelCellEditing() {
        }

        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.listenerList.add(class$javax$swing$event$CellEditorListener == null ? (class$javax$swing$event$CellEditorListener = PanelTreeTable.class$("javax.swing.event.CellEditorListener")) : class$javax$swing$event$CellEditorListener, cellEditorListener);
        }

        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.listenerList.remove(class$javax$swing$event$CellEditorListener == null ? (class$javax$swing$event$CellEditorListener = PanelTreeTable.class$("javax.swing.event.CellEditorListener")) : class$javax$swing$event$CellEditorListener, cellEditorListener);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return this.m_editorTree;
        }
    }

    public class TreeRenderer
    extends JLabel
    implements TreeCellRenderer {
        private boolean m_bSelected;
        private boolean m_bHasFocus;
        private JTree m_tree;
        private Vector m_errorList = new Vector();

        public TreeRenderer(JTree jTree) {
            this.m_tree = jTree;
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Icon icon = null;
            String string = "";
            NodeDescriptor nodeDescriptor = null;
            if (object instanceof PanelTreeTableNode) {
                PanelTreeTableNode panelTreeTableNode = (PanelTreeTableNode)object;
                nodeDescriptor = (NodeDescriptor)panelTreeTableNode.getUserObject();
                if (nodeDescriptor != null) {
                    string = nodeDescriptor.getTitle();
                    String string2 = !bl3 && bl2 ? nodeDescriptor.getExpandedImageFile() : nodeDescriptor.getImageFile();
                    if (string2 != null) {
                        try {
                            icon = SystemResourceFinder.getImageResource(string2);
                        }
                        catch (MissingResourceException missingResourceException) {
                            if (!this.m_errorList.contains(string2)) {
                                MessageLog.logError(missingResourceException);
                                this.m_errorList.addElement(string2);
                            }
                        }
                    }
                } else {
                    string = jTree.convertValueToText(object, bl, bl2, bl3, n, bl4);
                }
            } else {
                string = jTree.convertValueToText(object, bl, bl2, bl3, n, bl4);
            }
            if (icon == null) {
                icon = bl3 ? UIManager.getIcon("Tree.leafIcon") : (bl2 ? UIManager.getIcon("Tree.openIcon") : UIManager.getIcon("Tree.closedIcon"));
            }
            this.setText(string);
            this.setIcon(icon);
            this.setFont(jTree.getFont());
            this.m_bSelected = bl;
            this.m_bHasFocus = bl4;
            return this;
        }

        public void paint(Graphics graphics) {
            Color color;
            Icon icon = this.getIcon();
            if (this.m_bSelected) {
                color = UIManager.getColor("Tree.selectionBackground");
                this.setForeground(UIManager.getColor("Tree.selectionForeground"));
            } else {
                color = this.m_tree.getBackground();
                this.setForeground(UIManager.getColor("Tree.textForeground"));
            }
            graphics.setColor(color);
            if (icon != null && this.getText() != null) {
                int n = icon.getIconWidth() + this.getIconTextGap();
                graphics.fillRect(n, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
            } else {
                graphics.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
            if (this.m_bHasFocus) {
                graphics.setColor(UIManager.getColor("Tree.selectionBorderColor"));
                graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
            super.paint(graphics);
        }
    }

    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        protected boolean m_hasFocus = false;
        private int visibleRow;
        protected int m_column = 0;
        protected Color m_color = ((LineBorder)UIManager.get("Table.focusCellHighlightBorder")).getLineColor();

        public TreeTableCellRenderer() {
            this.addMyKeyListener();
        }

        public void addMyKeyListener() {
            this.addKeyListener(new KeyListener(this){
                int selRow;
                private final /* synthetic */ TreeTableCellRenderer this$1;
                {
                    this.this$1 = treeTableCellRenderer;
                    this.selRow = 0;
                }

                public void keyPressed(KeyEvent keyEvent) {
                    switch (keyEvent.getKeyCode()) {
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: {
                            this.selRow = this.this$1.getMinSelectionRow();
                            if (this.selRow == -1) break;
                            this.this$1.setSelectionRow(this.selRow);
                            break;
                        }
                        case 33: 
                        case 34: {
                            this.selRow = this.this$1.getMinSelectionRow();
                            if (this.selRow != -1) {
                                this.this$1.setSelectionRow(this.selRow);
                            }
                            TreeTableCellRenderer.access$000(this.this$1).dispatchEvent(keyEvent);
                        }
                    }
                }

                public void keyReleased(KeyEvent keyEvent) {
                    int n = 0;
                    Rectangle rectangle = null;
                    switch (keyEvent.getKeyCode()) {
                        case 33: 
                        case 34: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: {
                            n = this.this$1.getMinSelectionRow();
                            if (n == -1) break;
                            rectangle = TreeTableCellRenderer.access$000(this.this$1).getCellRect(n, 0, true);
                            TreeTableCellRenderer.access$000(this.this$1).scrollRectToVisible(rectangle);
                        }
                    }
                }

                public void keyTyped(KeyEvent keyEvent) {
                }
            });
        }

        public void expandPath(TreePath treePath) {
            super.expandPath(treePath);
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, 0, n3, PanelTreeTable.this.getHeight());
        }

        public void paint(Graphics graphics) {
            graphics.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(graphics);
            if (this.m_hasFocus) {
                graphics.setColor(this.m_color);
                Rectangle rectangle = PanelTreeTable.this.getCellRect(this.visibleRow, this.m_column, false);
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            }
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            this.m_hasFocus = bl2;
            this.visibleRow = n;
            this.m_column = n2;
            return this;
        }

        static /* synthetic */ PanelTreeTable access$000(TreeTableCellRenderer treeTableCellRenderer) {
            return treeTableCellRenderer.PanelTreeTable.this;
        }
    }
}

