/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.framework.java;

import com.ibm.as400.ui.framework.TableInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.Enumeration;
import java.util.Hashtable;

class FormattedTableLayout
implements LayoutManager2 {
    Hashtable m_comptable;
    GridBagLayout m_gridbag = new GridBagLayout();
    Insets m_insets = new Insets(0, 0, 0, 0);
    int m_defaultRowSpace = 10;
    int m_defaultColSpace = 10;
    boolean m_defaultRowExpand = true;
    boolean m_defaultColExpand = true;
    int m_rowCount = 0;
    int m_colCount = 0;
    TableInfo[] m_cols;
    TableInfo[] m_rows;

    public FormattedTableLayout(int n, int n2) {
        this.m_rowCount = n;
        this.m_colCount = n2;
        this.m_rows = new TableInfo[this.m_rowCount];
        this.m_cols = new TableInfo[this.m_colCount];
        this.m_comptable = new Hashtable();
    }

    public void setInsets(Insets insets) {
        this.m_insets = insets;
        this.resetConstraints();
    }

    public Insets getInsets() {
        return new Insets(this.m_insets.top, this.m_insets.left, this.m_insets.bottom, this.m_insets.right);
    }

    public void setDefaultRowSpacing(int n) {
        this.m_defaultRowSpace = n;
        this.resetConstraints();
    }

    public int getDefaultRowSpacing() {
        return this.m_defaultRowSpace;
    }

    public void setDefaultColumnSpacing(int n) {
        this.m_defaultColSpace = n;
        this.resetConstraints();
    }

    public int getDefaultColumnSpacing() {
        return this.m_defaultColSpace;
    }

    public void setRowExpandable(int n, boolean bl) {
        TableInfo tableInfo;
        if (this.m_rows[n] == null) {
            this.m_rows[n] = tableInfo = new TableInfo();
            tableInfo.m_space = this.m_defaultRowSpace;
        } else {
            tableInfo = this.m_rows[n];
        }
        tableInfo.m_expand = bl;
        this.resetConstraints();
    }

    public boolean isRowExpandable(int n) {
        if (this.m_rows[n] == null) {
            return this.m_defaultRowExpand;
        }
        return this.m_rows[n].m_expand;
    }

    public void setColumnExpandable(int n, boolean bl) {
        TableInfo tableInfo;
        if (this.m_cols[n] == null) {
            this.m_cols[n] = tableInfo = new TableInfo();
            tableInfo.m_space = this.m_defaultColSpace;
        } else {
            tableInfo = this.m_cols[n];
        }
        tableInfo.m_expand = bl;
        this.resetConstraints();
    }

    public boolean isColumnExpandable(int n) {
        if (this.m_cols[n] == null) {
            return this.m_defaultColExpand;
        }
        return this.m_cols[n].m_expand;
    }

    public void setRowSpacing(int n, int n2) {
        TableInfo tableInfo;
        if (this.m_rows[n] == null) {
            this.m_rows[n] = tableInfo = new TableInfo();
            tableInfo.m_expand = this.m_defaultRowExpand;
        } else {
            tableInfo = this.m_rows[n];
        }
        tableInfo.m_space = n2;
        this.resetConstraints();
    }

    public int getRowSpacing(int n) {
        if (this.m_rows[n] == null) {
            return this.m_defaultRowSpace;
        }
        return this.m_rows[n].m_space;
    }

    public void setColumnSpacing(int n, int n2) {
        TableInfo tableInfo;
        if (this.m_cols[n] == null) {
            this.m_cols[n] = tableInfo = new TableInfo();
            tableInfo.m_expand = this.m_defaultColExpand;
        } else {
            tableInfo = this.m_cols[n];
        }
        tableInfo.m_space = n2;
        this.resetConstraints();
    }

    public int getColumnSpacing(int n) {
        if (this.m_cols[n] == null) {
            return this.m_defaultColSpace;
        }
        return this.m_cols[n].m_space;
    }

    public void setConstraints(Component component, GridBagConstraints gridBagConstraints) {
        this.m_comptable.put(component, gridBagConstraints.clone());
        GridBagConstraints gridBagConstraints2 = this.getFormattedConstraints(gridBagConstraints);
        this.m_gridbag.setConstraints(component, gridBagConstraints2);
    }

    protected void resetConstraints() {
        Enumeration enumeration = this.m_comptable.keys();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            GridBagConstraints gridBagConstraints = (GridBagConstraints)this.m_comptable.get(component);
            this.m_gridbag.setConstraints(component, this.getFormattedConstraints(gridBagConstraints));
        }
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof GridBagConstraints) {
            this.setConstraints(component, (GridBagConstraints)object);
        } else if (!(object instanceof String) && object != null) {
            throw new IllegalArgumentException("cannot add to layout: constraint must be a TableConstraint");
        }
    }

    public float getLayoutAlignmentX(Container container) {
        return this.m_gridbag.getLayoutAlignmentX(container);
    }

    public float getLayoutAlignmentY(Container container) {
        return this.m_gridbag.getLayoutAlignmentY(container);
    }

    public void invalidateLayout(Container container) {
        this.m_gridbag.invalidateLayout(container);
    }

    public Dimension maximumLayoutSize(Container container) {
        return this.m_gridbag.maximumLayoutSize(container);
    }

    public void addLayoutComponent(String string, Component component) {
        this.m_gridbag.addLayoutComponent(string, component);
    }

    public Dimension minimumLayoutSize(Container container) {
        return new Dimension(0, 0);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.m_gridbag.preferredLayoutSize(container);
    }

    public void removeLayoutComponent(Component component) {
        this.m_gridbag.removeLayoutComponent(component);
    }

    public void layoutContainer(Container container) {
        this.m_gridbag.layoutContainer(container);
    }

    protected GridBagConstraints getFormattedConstraints(GridBagConstraints gridBagConstraints) {
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = gridBagConstraints.gridx;
        gridBagConstraints2.gridy = gridBagConstraints.gridy;
        gridBagConstraints2.gridwidth = gridBagConstraints.gridwidth;
        gridBagConstraints2.gridheight = gridBagConstraints.gridheight;
        gridBagConstraints2.fill = gridBagConstraints.fill;
        gridBagConstraints2.anchor = gridBagConstraints.anchor;
        gridBagConstraints2.weightx = this.isColumnExpandable(gridBagConstraints.gridx) ? 1.0 : 0.0;
        gridBagConstraints2.weighty = this.isRowExpandable(gridBagConstraints.gridy) ? 1.0 : 0.0;
        int n = gridBagConstraints.gridy;
        int n2 = gridBagConstraints.gridx;
        int n3 = gridBagConstraints.gridwidth;
        int n4 = gridBagConstraints.gridheight;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if (n == 0) {
            if (this.m_insets != null) {
                n8 += this.m_insets.top;
            }
        } else if (n > 0) {
            n8 += this.getRowSpacing(n - 1);
        }
        if (n2 == 0) {
            if (this.m_insets != null) {
                n6 += this.m_insets.left;
            }
        } else if (n2 > 0) {
            n6 += this.getColumnSpacing(n2 - 1);
        }
        if ((n == this.m_rowCount - 1 || n + gridBagConstraints.gridheight == this.m_rowCount) && this.m_insets != null) {
            n7 += this.m_insets.bottom;
        }
        if ((n2 == this.m_colCount - 1 || n2 + gridBagConstraints.gridwidth == this.m_colCount) && this.m_insets != null) {
            n5 += this.m_insets.right;
        }
        if (gridBagConstraints.insets != null) {
            n8 += gridBagConstraints.insets.top;
            n6 += gridBagConstraints.insets.left;
            n7 += gridBagConstraints.insets.bottom;
            n5 += gridBagConstraints.insets.right;
        }
        gridBagConstraints2.insets = new Insets(n8, n6, n7, n5);
        return gridBagConstraints2;
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 2000";
    }
}

