/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.framework.java;

import com.ibm.as400.ui.framework.ResourceLoader;
import com.ibm.as400.ui.framework.SystemResourceFinder;
import com.ibm.as400.ui.framework.java.LookAndFeelManager;
import com.ibm.as400.ui.framework.java.MessageBoxDialog;
import com.ibm.as400.ui.framework.java.MessageLog;
import java.awt.Component;

public class DisplayManagerException
extends Exception {
    private String m_localizedMessage;
    private static ResourceLoader m_loader = new ResourceLoader();
    private static String m_title;

    DisplayManagerException() {
    }

    DisplayManagerException(String string) {
        super(string);
        this.m_localizedMessage = m_loader.getString(string);
        if (this.m_localizedMessage.equals("RESOURCEMISSING")) {
            Object[] objectArray = new Object[]{string};
            this.m_localizedMessage = SystemResourceFinder.format("unknownError", objectArray);
        }
    }

    public void displayUserMessage(Component component) {
        if (this.getMessage() != null) {
            boolean bl = MessageLog.isTraceEnabled();
            MessageLog.setTraceEnabled(false);
            LookAndFeelManager.setLookAndFeel();
            MessageLog.setTraceEnabled(bl);
            String string = this.getLocalizedMessage();
            MessageBoxDialog.showMessageDialog(component, string, m_title, 0);
        }
    }

    public String getLocalizedMessage() {
        if (this.m_localizedMessage != null) {
            return this.m_localizedMessage;
        }
        return super.getLocalizedMessage();
    }

    public String getExceptionClassName() {
        return this.getMessage();
    }

    public static void setAppTitle(String string) {
        m_title = string;
    }

    public static String getAppTitle() {
        return m_title;
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 2000";
    }

    static {
        m_loader.setResourceName("com.ibm.as400.ui.framework.FRMRI");
        m_title = m_loader.getString("appTitle");
    }
}

