/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.util;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.Job;
import com.ibm.as400.access.MessageFile;
import com.ibm.as400.ui.framework.java.Capabilities;
import com.ibm.as400.ui.framework.java.DataBean;
import com.ibm.as400.ui.framework.java.ItemDescriptor;
import com.ibm.as400.ui.framework.java.MessageLog;
import com.ibm.as400.ui.util.ResourceLoader;
import java.beans.PropertyVetoException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Vector;

public class MessagesBean
implements DataBean {
    static ResourceLoader m_loader = new ResourceLoader();
    static final int NO_MESSAGE_SELECTED = -1;
    static Hashtable messageFiles;
    Vector m_messageVector = new Vector();
    int m_iSelection = -1;
    AS400 m_as400 = null;
    Job m_job = null;
    String m_helpSet = null;
    public static final int DETAIL_NONE = 0;
    public static final int DETAIL_TEXT = 1;
    public static final int DETAIL_URL = 2;
    public static final int DETAIL_HTML = 3;
    public static final int DETAIL_AS400MESSAGE = 4;

    public void load() {
        this.m_iSelection = -1;
    }

    public void verifyChanges() {
    }

    public void save() {
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void setSelection(int n) {
        this.m_iSelection = n;
    }

    public int getSelection() {
        return this.m_iSelection;
    }

    public void setSystem(AS400 aS400) {
        this.m_as400 = aS400;
    }

    public AS400 getSystem() {
        return this.m_as400;
    }

    public ItemDescriptor[] getMessagesList() {
        Object object;
        Vector<ItemDescriptor> vector = new Vector<ItemDescriptor>();
        int n = 0;
        while (n < this.m_messageVector.size()) {
            object = (MessageRecord)this.m_messageVector.elementAt(n);
            vector.addElement(new ItemDescriptor(object.mrID, object.mrDesc));
            ++n;
        }
        object = new ItemDescriptor[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public void setMessagesList(ItemDescriptor[] itemDescriptorArray) {
    }

    public String[] getMessagesSelection() {
        if (this.m_iSelection == -1) {
            return null;
        }
        if (this.m_iSelection >= this.m_messageVector.size()) {
            return null;
        }
        MessageRecord messageRecord = (MessageRecord)this.m_messageVector.elementAt(this.m_iSelection);
        String[] stringArray = new String[]{messageRecord.mrID};
        return stringArray;
    }

    public void setMessagesSelection(String[] stringArray) {
    }

    public String getSelectedMessage() {
        if (this.m_iSelection == -1) {
            return null;
        }
        if (this.m_iSelection >= this.m_messageVector.size()) {
            return null;
        }
        MessageRecord messageRecord = (MessageRecord)this.m_messageVector.elementAt(this.m_iSelection);
        return messageRecord.mrDesc;
    }

    public void setSelectedMessage(String string) {
        if (this.m_iSelection == -1) {
            return;
        }
        if (this.m_iSelection >= this.m_messageVector.size()) {
            return;
        }
        MessageRecord messageRecord = (MessageRecord)this.m_messageVector.elementAt(this.m_iSelection);
        messageRecord.mrDesc = string;
    }

    public String getSelectedMessageID() {
        if (this.m_iSelection == -1) {
            return null;
        }
        if (this.m_iSelection >= this.m_messageVector.size()) {
            return null;
        }
        MessageRecord messageRecord = (MessageRecord)this.m_messageVector.elementAt(this.m_iSelection);
        return messageRecord.mrID;
    }

    public boolean isSelectedMessageAS400() {
        if (this.m_iSelection == -1) {
            return false;
        }
        if (this.m_iSelection >= this.m_messageVector.size()) {
            return false;
        }
        MessageRecord messageRecord = (MessageRecord)this.m_messageVector.elementAt(this.m_iSelection);
        return messageRecord.isAS400Message();
    }

    public boolean selectedMessageHasDetail() {
        if (this.m_iSelection == -1) {
            return false;
        }
        if (this.m_iSelection >= this.m_messageVector.size()) {
            return false;
        }
        MessageRecord messageRecord = (MessageRecord)this.m_messageVector.elementAt(this.m_iSelection);
        return messageRecord.mrDetailType == 1 || messageRecord.mrDetailType == 2 || messageRecord.mrDetailType == 3 || messageRecord.mrDetailType == 4;
    }

    public void setSelectedMessageID(String string) {
    }

    public String getSelectedMessageDetail() {
        if (this.m_iSelection == -1) {
            return null;
        }
        if (this.m_iSelection >= this.m_messageVector.size()) {
            return null;
        }
        MessageRecord messageRecord = (MessageRecord)this.m_messageVector.elementAt(this.m_iSelection);
        if (messageRecord.isDetailEmpty() && messageRecord.mrAS400Message != null && this.m_as400 != null) {
            String string;
            MessageFile messageFile;
            messageRecord.mrDetail = m_loader.getString("messagesBeanError_NotAvailable");
            String string2 = messageRecord.mrAS400Message.getPath();
            if (string2 == null || string2.trim().length() <= 0) {
                string2 = "/QSYS.LIB/QCPFMSG.MSGF";
            }
            if ((messageFile = (MessageFile)messageFiles.get(string2)) == null) {
                messageFile = new MessageFile(this.m_as400, string2);
                try {
                    messageFile.setHelpTextFormatting(2);
                }
                catch (PropertyVetoException propertyVetoException) {
                    string = m_loader.getString("messagesBeanError_messageFileSetFormatFailed");
                    MessageLog.logError((Object)string, (Throwable)propertyVetoException);
                }
                messageFiles.put(string2, messageFile);
            }
            if (messageFile != null) {
                messageRecord.mrDetail = m_loader.getString("messagesBeanError_NotAvailable");
                try {
                    messageRecord.mrAS400Message = messageFile.getMessage(messageRecord.mrAS400Message.getID(), messageRecord.mrAS400Message.getSubstitutionData());
                    messageRecord.mrDetail = messageRecord.mrAS400Message.getHelp();
                }
                catch (Exception exception) {
                    messageRecord.mrDetail = m_loader.getString("messagesBeanError_NotAvailable");
                    string = m_loader.getString("messagesBeanError_messageNotFound");
                    Object[] objectArray = new Object[]{messageRecord.mrAS400Message.getID()};
                    String string3 = MessageFormat.format(string, objectArray);
                    MessageLog.logError((Object)string3, (Throwable)exception);
                }
            }
        }
        return messageRecord.mrDetail;
    }

    public URL getSelectedMessageURL() {
        if (this.m_iSelection == -1) {
            return null;
        }
        if (this.m_iSelection >= this.m_messageVector.size()) {
            return null;
        }
        MessageRecord messageRecord = (MessageRecord)this.m_messageVector.elementAt(this.m_iSelection);
        return messageRecord.mrURL;
    }

    public String getSelectedMessageAnchor() {
        if (this.m_iSelection == -1) {
            return null;
        }
        if (this.m_iSelection >= this.m_messageVector.size()) {
            return null;
        }
        MessageRecord messageRecord = (MessageRecord)this.m_messageVector.elementAt(this.m_iSelection);
        return messageRecord.mrAnchor;
    }

    public int getSelectedMessageDetailType() {
        if (this.m_iSelection == -1) {
            return -1;
        }
        if (this.m_iSelection >= this.m_messageVector.size()) {
            return -1;
        }
        MessageRecord messageRecord = (MessageRecord)this.m_messageVector.elementAt(this.m_iSelection);
        return messageRecord.mrDetailType;
    }

    public int getMessageCount() {
        return this.m_messageVector.size();
    }

    public String getMessage() {
        MessageRecord messageRecord = (MessageRecord)this.m_messageVector.elementAt(this.m_iSelection);
        if (messageRecord != null) {
            return messageRecord.mrDesc;
        }
        return "";
    }

    public void setMessage(String string) {
        MessageRecord messageRecord = (MessageRecord)this.m_messageVector.elementAt(this.m_iSelection);
        if (messageRecord != null) {
            messageRecord.mrDesc = string;
        }
    }

    public void setJob(Job job) {
        this.m_job = job;
    }

    public Job getJob() {
        return this.m_job;
    }

    public void setHelpSet(String string) {
        this.m_helpSet = string;
    }

    public String getHelpSet() {
        return this.m_helpSet;
    }

    public void addMessage(String string, String string2, String string3, String string4) {
        int n = 3;
        if (string3 == null || string3.trim().length() <= 0) {
            n = 0;
        }
        this.m_messageVector.addElement(new MessageRecord(string, string2, n, string3, string4, null, null));
    }

    public void addMessage(String string, String string2, URL uRL) {
        int n = 2;
        if (uRL == null) {
            n = 0;
        }
        this.m_messageVector.addElement(new MessageRecord(string, string2, n, null, null, uRL, null));
    }

    public void addMessage(String string, String string2, String string3) {
        int n = 1;
        if (string3 == null || string3.trim().length() <= 0) {
            n = 0;
        }
        this.m_messageVector.addElement(new MessageRecord(string, string2, n, string3, null, null, null));
        if (this.m_iSelection == -1) {
            this.m_iSelection = 0;
        }
    }

    public void addMessage(AS400Message aS400Message) {
        this.m_messageVector.addElement(new MessageRecord(aS400Message.getText(), aS400Message.getID(), 4, aS400Message.getHelp(), null, null, aS400Message));
        if (this.m_iSelection == -1) {
            this.m_iSelection = 0;
        }
    }

    public void addMessages(AS400Message[] aS400MessageArray) {
        int n = 0;
        while (n < aS400MessageArray.length) {
            this.addMessage(aS400MessageArray[n]);
            ++n;
        }
    }

    public boolean hasAnyMessageDetail() {
        boolean bl = false;
        int n = 0;
        while (n < this.m_messageVector.size()) {
            if (((MessageRecord)this.m_messageVector.elementAt(n)).hasMessageDetail()) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    static {
        m_loader.setResourceName("com.ibm.as400.ui.util.UTMRI");
        messageFiles = new Hashtable();
    }

    class MessageRecord {
        String mrDesc;
        String mrID;
        int mrDetailType;
        String mrDetail;
        String mrAnchor;
        URL mrURL;
        AS400Message mrAS400Message = null;

        public MessageRecord(String string, String string2, int n, String string3, String string4, URL uRL, AS400Message aS400Message) {
            this.mrDesc = string;
            this.mrID = string2;
            this.mrDetailType = n;
            this.mrDetail = string3;
            this.mrAnchor = string4;
            this.mrURL = uRL;
            this.mrAS400Message = aS400Message;
        }

        public String toString() {
            return this.mrDesc;
        }

        public boolean isAS400Message() {
            return this.mrAS400Message != null;
        }

        public boolean isDetailEmpty() {
            boolean bl = false;
            if (this.mrDetail == null) {
                bl = true;
            } else if (this.mrDetail.trim().length() <= 0) {
                bl = true;
            }
            return bl;
        }

        public AS400Message getAS400Message() {
            return this.mrAS400Message;
        }

        public boolean hasMessageDetail() {
            return this.mrDetailType != 0;
        }
    }
}

