/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.util;

import com.ibm.as400.access.AS400;
import com.ibm.as400.ui.framework.java.UIFramework;
import com.ibm.as400.ui.util.ClCommandException;
import com.ibm.as400.ui.util.ClCommandLineDialog;
import com.ibm.as400.ui.util.ClPanel;
import com.ibm.as400.ui.util.ClParseException;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;

public class CommandPrompter {
    private Window m_parent;
    private String m_commandString;
    private String m_startingString;
    private AS400 m_system;
    private int m_dateFormat;
    private boolean m_usePromptPrograms;
    private boolean m_promptInteractiveCommands;
    private boolean m_wasBatchCommand;
    private transient PropertyChangeSupport m_changes;
    private transient VetoableChangeSupport m_vetos;
    public static final int OK = 0;
    public static final int CANCEL = 1;
    public static final int ERROR = 2;
    public static final int PTF_REQUIRED = 3;
    public static final int DATE_NONE = 0;
    public static final int DATE_DAY_MONTH_YEAR = 1;
    public static final int DATE_JULIAN = 2;
    public static final int DATE_MONTH_DAY_YEAR = 3;
    public static final int DATE_YEAR_MONTH_DAY = 4;

    public CommandPrompter() {
        this((Frame)null, (AS400)null, (String)null, true, true);
    }

    public CommandPrompter(Frame frame, AS400 aS400, String string) {
        this(frame, aS400, string, true, true);
    }

    public CommandPrompter(Frame frame, AS400 aS400, String string, boolean bl, boolean bl2) {
        this.m_parent = frame;
        this.m_startingString = this.m_commandString = string;
        this.m_system = aS400;
        this.m_dateFormat = 0;
        this.m_usePromptPrograms = bl;
        this.m_promptInteractiveCommands = bl2;
        this.m_wasBatchCommand = true;
        this.m_vetos = new VetoableChangeSupport(this);
        this.m_changes = new PropertyChangeSupport(this);
    }

    public CommandPrompter(Window window, AS400 aS400, String string) {
        this(window, aS400, string, true, true);
    }

    public CommandPrompter(Window window, AS400 aS400, String string, boolean bl, boolean bl2) {
        this.m_parent = window;
        this.m_startingString = this.m_commandString = string;
        this.m_system = aS400;
        this.m_dateFormat = 0;
        this.m_usePromptPrograms = bl;
        this.m_promptInteractiveCommands = bl2;
        this.m_wasBatchCommand = true;
        this.m_vetos = new VetoableChangeSupport(this);
        this.m_changes = new PropertyChangeSupport(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.m_changes.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.m_vetos.addVetoableChangeListener(vetoableChangeListener);
    }

    public String getCommandString() {
        return this.m_commandString;
    }

    public int getDateFormat() {
        return this.m_dateFormat;
    }

    public Window getParent() {
        return this.m_parent;
    }

    public boolean getPromptInteractiveCommands() {
        return this.m_promptInteractiveCommands;
    }

    public AS400 getSystem() {
        return this.m_system;
    }

    public boolean getUsePromptPrograms() {
        return this.m_usePromptPrograms;
    }

    public boolean isBatch() {
        return this.m_wasBatchCommand;
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.m_changes.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.m_vetos.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void setCommandString(String string) {
        this.m_commandString = this.m_startingString = string;
    }

    public void setParent(Window window) {
        this.m_parent = window;
    }

    public void setPromptInteractiveCommands(boolean bl) throws PropertyVetoException {
        this.m_vetos.fireVetoableChange("promptInteractiveCommands", new Boolean(this.m_promptInteractiveCommands), new Boolean(bl));
        Boolean bl2 = new Boolean(this.m_promptInteractiveCommands);
        this.m_promptInteractiveCommands = bl;
        this.m_changes.firePropertyChange("promptInteractiveCommands", bl2, new Boolean(this.m_promptInteractiveCommands));
    }

    public void setSystem(AS400 aS400) {
        this.m_system = aS400;
    }

    public void setUsePromptPrograms(boolean bl) throws PropertyVetoException {
        this.m_vetos.fireVetoableChange("usePromptPrograms", new Boolean(this.m_usePromptPrograms), new Boolean(bl));
        Boolean bl2 = new Boolean(this.m_usePromptPrograms);
        this.m_usePromptPrograms = bl;
        this.m_changes.firePropertyChange("usePromptPrograms", bl2, new Boolean(this.m_usePromptPrograms));
    }

    public int showDialog() {
        ClCommandLineDialog clCommandLineDialog = null;
        clCommandLineDialog = this.m_parent instanceof Dialog ? new ClCommandLineDialog((Dialog)this.m_parent, this.m_system, this.m_startingString, this.m_usePromptPrograms, this.m_promptInteractiveCommands) : new ClCommandLineDialog((Frame)this.m_parent, this.m_system, this.m_startingString, this.m_usePromptPrograms, this.m_promptInteractiveCommands);
        try {
            UIFramework.notifyGlobalRegisteredListeners((Window)clCommandLineDialog, (boolean)true);
            boolean bl = clCommandLineDialog.prompt();
            UIFramework.notifyGlobalRegisteredListeners((Window)clCommandLineDialog, (boolean)false);
            if (bl) {
                this.m_wasBatchCommand = clCommandLineDialog.isBatchCommand();
                this.m_dateFormat = clCommandLineDialog.getDateFormat();
                this.m_commandString = clCommandLineDialog.getCommandLine();
                clCommandLineDialog = null;
                ClPanel.m_dateFormat = null;
                System.gc();
                return 0;
            }
            clCommandLineDialog = null;
            ClPanel.m_dateFormat = null;
            System.gc();
            return 1;
        }
        catch (ClParseException clParseException) {
            ClPanel.m_dateFormat = null;
            System.gc();
            clParseException.printStackTrace();
            return 2;
        }
        catch (ClCommandException clCommandException) {
            ClPanel.m_dateFormat = null;
            System.gc();
            if (clCommandException.getType() == 1) {
                this.m_wasBatchCommand = false;
                return 2;
            }
            if (clCommandException.getType() == 3) {
                return 3;
            }
            if (clCommandException.getType() == 4) {
                return 2;
            }
            clCommandException.printStackTrace();
            return 2;
        }
    }

    public int showHelp() {
        String string = this.m_startingString;
        int n = this.m_startingString.indexOf(" ");
        if (n != -1) {
            string = this.m_startingString.substring(0, n);
        }
        ClCommandLineDialog clCommandLineDialog = null;
        clCommandLineDialog = this.m_parent instanceof Dialog ? new ClCommandLineDialog((Dialog)this.m_parent, this.m_system, string, false, true) : new ClCommandLineDialog((Frame)this.m_parent, this.m_system, string, false, true);
        try {
            clCommandLineDialog.showHelp();
            clCommandLineDialog = null;
            ClPanel.m_dateFormat = null;
            System.gc();
            return 0;
        }
        catch (ClParseException clParseException) {
            ClPanel.m_dateFormat = null;
            System.gc();
            clParseException.printStackTrace();
            return 2;
        }
        catch (ClCommandException clCommandException) {
            ClPanel.m_dateFormat = null;
            System.gc();
            if (clCommandException.getType() == 1) {
                this.m_wasBatchCommand = false;
                return 2;
            }
            if (clCommandException.getType() == 3) {
                return 3;
            }
            if (clCommandException.getType() == 4) {
                return 2;
            }
            clCommandException.printStackTrace();
            return 2;
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.m_commandString + "]";
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }
}

