/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.util;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.ui.framework.java.Capabilities;
import com.ibm.as400.ui.framework.java.DataBean;
import com.ibm.as400.ui.framework.java.ItemDescriptor;
import com.ibm.as400.ui.framework.java.MessageLog;
import com.ibm.as400.ui.util.ClPanel;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;

public class ClSelectCommandBean
implements DataBean {
    private String m_command;
    private Vector m_columnData;
    private String m_selectedCommand;
    private String m_selectedLib;
    private String m_selectedDescription;

    ClSelectCommandBean() {
        this.m_command = "*";
    }

    ClSelectCommandBean(String string) {
        this.m_command = string;
        this.m_columnData = new Vector(10);
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() {
    }

    public void save() {
    }

    public void load() {
        AS400 aS400 = ClPanel.m_system;
        boolean bl = false;
        int[] nArray = new int[1];
        byte[] byArray = new byte[4];
        try {
            MessageLog.logError((Object)"CP:  Constructing ProgramCallDocument for QGYOLOBJ API...");
            ProgramCallDocument programCallDocument = new ProgramCallDocument(aS400, "com.ibm.as400.ui.util.qgyolobj");
            this.m_command = this.m_command.toUpperCase(Locale.ENGLISH);
            programCallDocument.setValue("qgyolobj.typeFilter", (Object)"*CMD");
            programCallDocument.setValue("qgyolobj.nameFilter.name", (Object)this.m_command);
            programCallDocument.setValue("qgyolobj.nameFilter.lib", (Object)"*LIBL");
            MessageLog.logError((Object)"CP:  Calling QGYOLOBJ API requesting list of objects.");
            bl = programCallDocument.callProgram("qgyolobj");
            if (!bl) {
                AS400Message[] aS400MessageArray = programCallDocument.getMessageList("qgyolobj");
                int n = 0;
                while (n < aS400MessageArray.length) {
                    String string = aS400MessageArray[n].getID();
                    String string2 = aS400MessageArray[n].getText();
                    MessageLog.logError((Object)("CP:  " + string + " - " + string2));
                    ++n;
                }
                MessageLog.logError((Object)"** Call to QGYOLOBJ failed. See messages above **");
                return;
            }
            boolean bl2 = false;
            String string = "qgyolobj";
            int n = 0;
            while (!bl2) {
                Object[] objectArray;
                int n2 = programCallDocument.getIntValue(string + ".listInfo.rcdsReturned");
                byArray = (byte[])programCallDocument.getValue(string + ".listInfo.rqsHandle");
                nArray[0] = 0;
                while (nArray[0] < n2) {
                    String string3 = (String)programCallDocument.getValue(string + ".receiver.name", nArray);
                    String string4 = (String)programCallDocument.getValue(string + ".receiver.lib", nArray);
                    String string5 = (String)programCallDocument.getValue(string + ".receiver.text.data", nArray);
                    objectArray = new String[]{string3, string4, string5};
                    this.m_columnData.addElement(objectArray);
                    nArray[0] = nArray[0] + 1;
                }
                n += n2;
                String string6 = (String)programCallDocument.getValue(string + ".listInfo.listStatus");
                if (string6.equals("2") || string6.equals("3")) {
                    bl2 = true;
                    continue;
                }
                MessageLog.logError((Object)"Calling QGYGTLE...");
                string = "qgygtle";
                programCallDocument.setValue("qgygtle.requestHandle", (Object)byArray);
                programCallDocument.setIntValue("qgygtle.startingRcd", n + 1);
                bl = programCallDocument.callProgram("qgygtle");
                if (bl) continue;
                objectArray = programCallDocument.getMessageList("qgygtle");
                int n3 = 0;
                while (n3 < objectArray.length) {
                    String string7 = objectArray[n3].getID();
                    String string8 = objectArray[n3].getText();
                    MessageLog.logError((Object)("    " + string7 + " - " + string8));
                    ++n3;
                }
                MessageLog.logError((Object)"** Call to QGYGTLE failed. See messages above **");
                return;
            }
            MessageLog.logError((Object)("CP: Number of list entries returned:  " + n));
            programCallDocument.setValue("qgyclst.requestHandle", (Object)byArray);
            bl = programCallDocument.callProgram("qgyclst");
        }
        catch (PcmlException pcmlException) {
            MessageLog.logError((Object)("CP: " + pcmlException.getLocalizedMessage()));
            pcmlException.printStackTrace();
            MessageLog.logError((Object)"CP: *** Call to QGYOLOBJ failed. ***");
            return;
        }
    }

    public ItemDescriptor[] getCommandNameList() {
        Object[] objectArray;
        Vector<ItemDescriptor> vector = new Vector<ItemDescriptor>();
        if (this.m_columnData != null) {
            String[] stringArray;
            objectArray = this.m_columnData.elements();
            while (objectArray.hasMoreElements()) {
                stringArray = (String[])objectArray.nextElement();
                String string = stringArray[0];
                vector.addElement(new ItemDescriptor(string + stringArray[1], string));
            }
            if (this.m_columnData.size() > 0) {
                stringArray = (String[])this.m_columnData.firstElement();
            }
        }
        objectArray = new ItemDescriptor[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void setCommandNameSelection(String[] stringArray) {
        if (stringArray.length > 0) {
            Enumeration enumeration = this.m_columnData.elements();
            while (enumeration.hasMoreElements()) {
                String[] stringArray2 = (String[])enumeration.nextElement();
                String string = stringArray2[0] + stringArray2[1];
                if (!string.equals(stringArray[0])) continue;
                String[] stringArray3 = new String[]{stringArray2[1]};
                this.setCommandLibSelection(stringArray3);
                this.m_selectedCommand = stringArray2[0];
            }
        }
    }

    public String[] getCommandNameSelection() {
        return new String[]{this.m_selectedCommand};
    }

    public void setCommandNameList(ItemDescriptor[] itemDescriptorArray) {
    }

    public ItemDescriptor[] getCommandLibList() {
        Object[] objectArray;
        Vector<ItemDescriptor> vector = new Vector<ItemDescriptor>();
        if (this.m_columnData != null) {
            String[] stringArray;
            objectArray = this.m_columnData.elements();
            while (objectArray.hasMoreElements()) {
                stringArray = (String[])objectArray.nextElement();
                String string = stringArray[1];
                vector.addElement(new ItemDescriptor(stringArray[0] + string, string));
            }
            if (this.m_columnData.size() > 0) {
                stringArray = (String[])this.m_columnData.firstElement();
            }
        }
        objectArray = new ItemDescriptor[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void setCommandLibSelection(String[] stringArray) {
        if (stringArray.length > 0) {
            this.m_selectedLib = stringArray[0];
        }
    }

    public String[] getCommandLibSelection() {
        return new String[]{this.m_selectedLib};
    }

    public void setCommandLibList(ItemDescriptor[] itemDescriptorArray) {
    }

    public ItemDescriptor[] getCommandDescriptionList() {
        Object[] objectArray;
        Vector<ItemDescriptor> vector = new Vector<ItemDescriptor>();
        if (this.m_columnData != null) {
            String[] stringArray;
            objectArray = this.m_columnData.elements();
            while (objectArray.hasMoreElements()) {
                stringArray = (String[])objectArray.nextElement();
                String string = stringArray[2];
                vector.addElement(new ItemDescriptor(string, string));
            }
            if (this.m_columnData.size() > 0 && (stringArray = (String[])this.m_columnData.firstElement()) != null) {
                this.m_selectedDescription = stringArray[2];
            }
        }
        objectArray = new ItemDescriptor[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void setCommandDescriptionSelection(String[] stringArray) {
        if (stringArray.length > 0) {
            this.m_selectedDescription = stringArray[0];
        }
    }

    public String[] getCommandDescriptionSelection() {
        return new String[]{this.m_selectedDescription};
    }

    public void setCommandDescriptionList(ItemDescriptor[] itemDescriptorArray) {
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }
}

