/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.util;

import com.ibm.as400.ui.framework.java.MessageLog;
import com.ibm.as400.ui.util.ClAttributeList;
import com.ibm.as400.ui.util.ClCmd;
import com.ibm.as400.ui.util.ClDepParm;
import com.ibm.as400.ui.util.ClDocNode;
import com.ibm.as400.ui.util.ClPanel;
import com.ibm.as400.ui.util.ClSyntax;
import com.ibm.as400.ui.util.ClTypes;
import java.util.Enumeration;

class ClDep
extends ClDocNode {
    private String m_MsgId;
    private String m_NbrTrue;
    private int m_NbrTrueRel;
    private String m_CtlKwd;
    private int m_CtlKwdRel;
    private String m_CtlKwdVal;

    ClDep() {
    }

    ClDep(ClAttributeList clAttributeList) {
        super(clAttributeList);
        this.setNodeType(13);
        this.setMsgId(this.getAttributeValue("MsgID"));
        this.setNbrTrue(this.getAttributeValue("NbrTrue"));
        this.setNbrTrueRel(this.getAttributeValue("NbrTrueRel"));
        this.setCtlKwd(this.getAttributeValue("CtlKwd"));
        this.setCtlKwdRel(this.getAttributeValue("CtlKwdRel"));
        this.setCtlKwdVal(this.getAttributeValue("CmpVal"));
        this.setName("dep." + this.m_MsgId);
    }

    void setMsgId(String string) {
        this.m_MsgId = string == null || string.equals("") ? null : string;
    }

    String getMsgId() {
        return this.m_MsgId;
    }

    void setNbrTrue(String string) {
        this.m_NbrTrue = string == null || string.equals("") ? null : string;
    }

    String getNbrTrue() {
        return this.m_NbrTrue;
    }

    void setNbrTrueRel(String string) {
        this.m_NbrTrueRel = ClTypes.getType(string);
    }

    int getNbrTrueRel() {
        return this.m_NbrTrueRel;
    }

    void setCtlKwd(String string) {
        this.m_CtlKwd = string == null || string.equals("") ? null : string;
    }

    String getCtlKwd() {
        return this.m_CtlKwd;
    }

    void setCtlKwdRel(String string) {
        this.m_CtlKwdRel = ClTypes.getType(string);
    }

    int getCtlKwdRel() {
        return this.m_CtlKwdRel;
    }

    void setCtlKwdVal(String string) {
        if (string == null || string.equals("")) {
            this.m_CtlKwdVal = null;
        } else {
            this.m_CtlKwdVal = string;
            String string2 = ClSyntax.convertHex(this.m_CtlKwdVal.trim());
            if (!string2.trim().equals("")) {
                this.m_CtlKwdVal = string2;
            }
        }
    }

    String getCtlKwdVal() {
        return this.m_CtlKwdVal;
    }

    boolean verify() {
        String string = null;
        int n = 8;
        String string2 = null;
        if (this.getCtlKwd() != null) {
            string = ((ClCmd)this.getParent()).getParmCompareValue(this.getCtlKwd());
            n = ((ClCmd)this.getParent()).getParmType(this.getCtlKwd());
            string2 = ((ClCmd)this.getParent()).getParmDft(this.getCtlKwd());
        }
        if (string != null && string.equals("*N") && string2 == null) {
            string = "";
        }
        if (!ClTypes.compare(n, this.getCtlKwdRel(), string, this.getCtlKwdVal(), string2)) {
            return true;
        }
        int n2 = 0;
        Enumeration enumeration = this.getChildren();
        ClDepParm clDepParm = null;
        while (enumeration.hasMoreElements()) {
            clDepParm = (ClDepParm)enumeration.nextElement();
            if (!clDepParm.verify()) continue;
            ++n2;
        }
        if (!ClTypes.compareLong(this.getNbrTrueRel(), String.valueOf(n2), this.getNbrTrue())) {
            MessageLog.logError((Object)("CP: CtlKwdVal: " + this.m_CtlKwdVal));
            MessageLog.logError((Object)("CtlKwd: " + this.m_CtlKwd + " NumberTrue: " + n2 + " Required: " + this.getNbrTrue()));
            ClPanel clPanel = ((ClCmd)this.getParent()).getPanel();
            clPanel.displayAS400Message(this.getMsgId(), (ClCmd)this.getParent());
            return false;
        }
        return true;
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }
}

