/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.reportwriter.pdfwriter;

import com.ibm.as400.util.reportwriter.pdfwriter.PDFExtendedFont;
import com.ibm.as400.util.reportwriter.pdfwriter.PDFFontCharWidthArray;
import com.ibm.as400.util.reportwriter.pdfwriter.PDFFontDescriptor;
import com.ibm.as400.util.reportwriter.pdfwriter.PDFObject;

public class PDFFont
extends PDFObject {
    private PDFExtendedFont font_ = null;
    private String subType_ = null;
    private String name_ = null;
    private String baseFont_ = null;
    private String encoding_ = null;
    private PDFFontCharWidthArray chararray;
    private PDFFontDescriptor fontdesc;

    public PDFFont(int n) {
        super(n);
    }

    public PDFFont(String string, PDFExtendedFont pDFExtendedFont, int n) {
        super(n);
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (pDFExtendedFont == null) {
            throw new NullPointerException("font");
        }
        this.subType_ = "Type1";
        this.name_ = string;
        this.font_ = pDFExtendedFont;
        this.baseFont_ = pDFExtendedFont.getFaceName();
        this.encoding_ = "WinAnsiEncoding";
        this.chararray = new PDFFontCharWidthArray(n + 1);
        this.setArrayContents();
        this.fontdesc = new PDFFontDescriptor(n + 2, pDFExtendedFont);
    }

    public PDFFont(String string, String string2, PDFExtendedFont pDFExtendedFont, String string3, String string4, int n) {
        super(n);
        if (string == null) {
            throw new NullPointerException("subType");
        }
        if (string2 == null) {
            throw new NullPointerException("name");
        }
        if (pDFExtendedFont == null) {
            throw new NullPointerException("font");
        }
        if (string3 == null) {
            throw new NullPointerException("basefont");
        }
        if (string4 == null) {
            throw new NullPointerException("encoding");
        }
        this.subType_ = string;
        this.name_ = string2;
        this.font_ = pDFExtendedFont;
        this.baseFont_ = string3;
        this.encoding_ = string4;
        this.chararray = new PDFFontCharWidthArray(n + 1);
        this.setArrayContents();
        this.fontdesc = new PDFFontDescriptor(n + 2, pDFExtendedFont);
    }

    public String getName() {
        return this.name_;
    }

    public void setArrayContents() {
        boolean bl = false;
        int n = 32;
        while (n <= 255) {
            char c = (char)n;
            this.chararray.addElement(new String(this.font_.getCharacterWidthMetric(c)));
            ++n;
        }
    }

    public PDFExtendedFont getFont() {
        return this.font_;
    }

    public PDFFontDescriptor getFontDescriptor() {
        return this.fontdesc;
    }

    public PDFFontCharWidthArray getFontCharWidthArray() {
        return this.chararray;
    }

    public String toPDF() {
        String string = new String();
        string = this.getNumber() + " 0 obj\r\n<<\r\n/Type /Font\r\n" + "/Subtype /" + this.subType_ + "\r\n" + "/Name /" + this.name_ + "\r\n" + "/BaseFont /" + this.baseFont_ + "\r\n" + "/FirstChar 32 \r\n" + "/LastChar 255 \r\n" + "/Widths " + this.chararray.getNumber() + " 0 R \r\n" + "/FontDescriptor " + this.fontdesc.getNumber() + " 0 R\r\n" + ">>\r\nendobj\r\n";
        this.setByteCount(string.length());
        return string;
    }
}

