/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.reportwriter.pclwriter;

import com.ibm.xsl.composer.csstypes.BorderStyle;
import com.ibm.xsl.composer.csstypes.CSSColor;
import com.ibm.xsl.composer.java2d.TBRL;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;

public abstract class PCLFourEdgeBorder {
    public final int BUTT = 1;
    public final int MITER = 2;
    protected final short TOP_EDGE = 1;
    protected final short BOTTOM_EDGE = (short)2;
    protected final short RIGHT_EDGE = (short)3;
    protected final short LEFT_EDGE = (short)4;
    protected final short TOP_DEPENDANCY = 1;
    protected final short BOTTOM_DEPENDANCY = (short)2;
    protected final short RIGHT_DEPENDANCY = (short)3;
    protected final short LEFT_DEPENDANCY = (short)4;
    int borderWidth;
    Color color;
    boolean all = true;
    protected boolean topEdge;
    protected int topWidth;
    protected Color topColor;
    protected boolean bottomEdge;
    protected int bottomWidth;
    protected Color bottomColor;
    protected boolean rightEdge;
    protected int rightWidth;
    protected Color rightColor;
    protected boolean leftEdge;
    protected int leftWidth;
    protected Color leftColor;
    protected int dependantTopStyle;
    protected int dependantBottomStyle;
    protected int dependantRightStyle;
    protected int dependantLeftStyle;

    public PCLFourEdgeBorder() {
        this.resetAllEdges();
    }

    public PCLFourEdgeBorder(int n, CSSColor cSSColor) {
        this.resetAllEdges();
        this.borderWidth = n;
        CSSColor cSSColor2 = new CSSColor();
        this.color = new Color(cSSColor2.red, cSSColor2.green, cSSColor2.blue);
        this.all = true;
    }

    public void resetAllEdges() {
        this.borderWidth = 0;
        CSSColor cSSColor = new CSSColor();
        this.color = new Color(cSSColor.red, cSSColor.green, cSSColor.blue);
        this.all = false;
        this.dependantTopStyle = 0;
        this.dependantBottomStyle = 0;
        this.dependantRightStyle = 0;
        this.dependantLeftStyle = 0;
        this.resetTopEdge();
        this.resetBottomEdge();
        this.resetRightEdge();
        this.resetLeftEdge();
    }

    public void resetTopEdge() {
        this.topEdge = false;
        this.topWidth = 0;
        CSSColor cSSColor = new CSSColor();
        this.topColor = new Color(cSSColor.red, cSSColor.green, cSSColor.blue);
    }

    public void resetBottomEdge() {
        this.bottomEdge = false;
        this.bottomWidth = 0;
        CSSColor cSSColor = new CSSColor();
        this.bottomColor = new Color(cSSColor.red, cSSColor.green, cSSColor.blue);
    }

    public void resetRightEdge() {
        this.rightEdge = false;
        this.rightWidth = 0;
        CSSColor cSSColor = new CSSColor();
        this.rightColor = new Color(cSSColor.red, cSSColor.green, cSSColor.blue);
    }

    public void resetLeftEdge() {
        this.leftEdge = false;
        this.leftWidth = 0;
        CSSColor cSSColor = new CSSColor();
        this.leftColor = new Color(cSSColor.red, cSSColor.green, cSSColor.blue);
    }

    public Insets getBorderWidths() {
        return new Insets(this.topWidth, this.leftWidth, this.bottomWidth, this.rightWidth);
    }

    public void setRightEdge(CSSColor cSSColor, int n) {
        this.rightEdge = true;
        this.rightColor = new Color(cSSColor.red, cSSColor.green, cSSColor.blue);
        this.rightWidth = n;
    }

    public void setLeftEdge(CSSColor cSSColor, int n) {
        this.leftEdge = true;
        this.leftColor = new Color(cSSColor.red, cSSColor.green, cSSColor.blue);
        this.leftWidth = n;
    }

    public void setTopEdge(CSSColor cSSColor, int n) {
        this.topEdge = true;
        this.topColor = new Color(cSSColor.red, cSSColor.green, cSSColor.blue);
        this.topWidth = n;
    }

    public void setBottomEdge(CSSColor cSSColor, int n) {
        this.bottomEdge = true;
        this.bottomColor = new Color(cSSColor.red, cSSColor.green, cSSColor.blue);
        this.bottomWidth = n;
    }

    protected abstract void paintBorder(Graphics2D var1, int var2, int var3, int var4, int var5);

    public void setDependancies(TBRL tBRL) {
        if (tBRL.isTopSet()) {
            this.topWidth = tBRL.getTopWidth();
            this.dependantTopStyle = tBRL.getTopStyle();
        }
        if (tBRL.isBottomSet()) {
            this.bottomWidth = tBRL.getBottomWidth();
            this.dependantBottomStyle = tBRL.getBottomStyle();
        }
        if (tBRL.isRightSet()) {
            this.rightWidth = tBRL.getRightWidth();
            this.dependantRightStyle = tBRL.getRightStyle();
        }
        if (tBRL.isLeftSet()) {
            this.leftWidth = tBRL.getLeftWidth();
            this.dependantLeftStyle = tBRL.getLeftStyle();
        }
    }

    public int determineLineWidth(int n) {
        return n;
    }

    public int determineCornerStyle(int n, int n2) {
        if (n == 1 || n == 2 ? (n2 == 3 ? this.isMiter(this.dependantRightStyle) : n2 == 4 && this.isMiter(this.dependantLeftStyle)) : (n == 4 || n == 3) && (n2 == 1 ? this.isMiter(this.dependantTopStyle) : n2 == 2 && this.isMiter(this.dependantBottomStyle))) {
            return 2;
        }
        return 1;
    }

    public String printCornerStyle(int n) {
        switch (n) {
            case 1: {
                return "butt";
            }
            case 2: {
                return "miter";
            }
        }
        return "corner style " + n + " is not a valid style";
    }

    public boolean isMiter(int n) {
        return n == 9 || n == 8 || n == 6 || n == 7;
    }

    public boolean isEdgeExists(int n) {
        boolean bl = false;
        switch (n) {
            case 1: {
                if (this.dependantTopStyle != 0 && this.topWidth > 0) {
                    bl = true;
                }
            }
            case 2: {
                if (this.dependantBottomStyle != 0 && this.bottomWidth > 0) {
                    bl = true;
                }
            }
            case 3: {
                if (this.dependantRightStyle != 0 && this.rightWidth > 0) {
                    bl = true;
                }
            }
            case 4: {
                if (this.dependantLeftStyle == 0 || this.leftWidth <= 0) break;
                bl = true;
            }
        }
        return bl;
    }

    public String toString() {
        return "dependantTopStyle:" + BorderStyle.getStyleName((int)this.dependantTopStyle) + " dependantBottomStyle:" + BorderStyle.getStyleName((int)this.dependantBottomStyle) + " dependantRightStyle:" + BorderStyle.getStyleName((int)this.dependantRightStyle) + " dependantLeftStyle:" + BorderStyle.getStyleName((int)this.dependantLeftStyle);
    }
}

