/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.properties.parser;

public class EvaluationResult {
    public static final int TYPE_UNASSIGNED = 0;
    public static final int TYPE_NUMERIC = 1;
    public static final int TYPE_LITERAL = 2;
    public static final int TYPE_COLOR = 3;
    public static final int TYPE_ENUMERATION = 4;
    public static final int TYPE_KEYWORD = 5;
    public static final int TYPE_NCNAME = 6;
    public static final int TYPE_OTHER_CLASS = 7;
    private double doubleValue = 0.0;
    private int intValue = 0;
    private Object objectValue = null;
    private int valueType = 0;

    public EvaluationResult(double newValue) {
        this.setDoubleValue(newValue, 1);
    }

    public EvaluationResult(int newValue, int newType) {
        this.setIntValue(newValue, newType);
    }

    public EvaluationResult(Object newValue, int newType) {
        this.setObjectValue(newValue, newType);
    }

    public EvaluationResult(String newValue) {
        this.setObjectValue(newValue, 2);
    }

    public EvaluationResult div(EvaluationResult otherResult) throws ArithmeticException {
        EvaluationResult result = null;
        if (this.getValueType() != 1) {
            throw new ArithmeticException("can't perform division using first operand type of " + this.nameForType());
        }
        if (otherResult.getValueType() != 1) {
            throw new ArithmeticException("can't perform division using second operand type of " + otherResult.nameForType());
        }
        result = new EvaluationResult(this.getAsDouble() / otherResult.getAsDouble());
        return result;
    }

    public int getAsColor() throws ArithmeticException {
        if (this.valueType != 3) {
            throw new ArithmeticException("Wrong kind of result -- not color");
        }
        return this.intValue;
    }

    public double getAsDouble() throws ArithmeticException {
        if (this.valueType != 1) {
            throw new ArithmeticException("Wrong kind of result -- not numeric");
        }
        return this.doubleValue;
    }

    public String getAsLiteral() throws ArithmeticException {
        if (this.valueType != 2) {
            throw new ArithmeticException("Wrong kind of result -- not literal");
        }
        return (String)this.objectValue;
    }

    public double getAsRoundedInteger() throws ArithmeticException {
        if (this.valueType != 1) {
            throw new ArithmeticException("Wrong kind of result -- not numeric");
        }
        return Math.round(this.doubleValue);
    }

    public int getValueType() {
        return this.valueType;
    }

    public EvaluationResult minus(EvaluationResult otherResult) throws ArithmeticException {
        EvaluationResult result = null;
        if (this.getValueType() != 1) {
            throw new ArithmeticException("can't perform subtraction using first operand type of " + this.nameForType());
        }
        if (otherResult.getValueType() != 1) {
            throw new ArithmeticException("can't perform subtraction using second operand type of " + otherResult.nameForType());
        }
        result = new EvaluationResult(this.getAsDouble() - otherResult.getAsDouble());
        return result;
    }

    public EvaluationResult mod(EvaluationResult otherResult) throws ArithmeticException {
        EvaluationResult result = null;
        if (this.getValueType() != 1) {
            throw new ArithmeticException("can't perform mod using first operand type of " + this.nameForType());
        }
        if (otherResult.getValueType() != 1) {
            throw new ArithmeticException("can't perform mod using second operand type of " + otherResult.nameForType());
        }
        result = new EvaluationResult(this.getAsDouble() % otherResult.getAsDouble());
        return result;
    }

    public EvaluationResult multiply(EvaluationResult otherResult) throws ArithmeticException {
        EvaluationResult result = null;
        if (this.getValueType() != 1) {
            throw new ArithmeticException("can't perform multiplicaion using first operand type of " + this.nameForType());
        }
        if (otherResult.getValueType() != 1) {
            throw new ArithmeticException("can't perform multiplicaion using second operand type of " + otherResult.nameForType());
        }
        result = new EvaluationResult(this.getAsDouble() * otherResult.getAsDouble());
        return result;
    }

    String nameForType() {
        return this.nameForType(this.valueType);
    }

    String nameForType(int theType) {
        String result;
        switch (theType) {
            case 0: {
                result = "TYPE_UNASSIGNED";
                break;
            }
            case 1: {
                result = "TYPE_NUMERIC";
                break;
            }
            case 2: {
                result = "TYPE_LITERAL";
                break;
            }
            case 3: {
                result = "TYPE_COLOR";
                break;
            }
            case 4: {
                result = "TYPE_ENUMERATION";
                break;
            }
            case 5: {
                result = "TYPE_KEYWORD";
                break;
            }
            case 6: {
                result = "TYPE_NCNAME";
                break;
            }
            case 7: {
                result = "TYPE_OTHER_CLASS";
                break;
            }
            default: {
                result = "Unknown";
            }
        }
        return result;
    }

    public EvaluationResult negate(EvaluationResult otherResult) throws ArithmeticException {
        EvaluationResult result = null;
        if (this.getValueType() != 1) {
            throw new ArithmeticException("can't perform negate using first operand type of " + this.nameForType());
        }
        result = new EvaluationResult(-this.getAsDouble());
        return result;
    }

    public EvaluationResult plus(EvaluationResult otherResult) throws ArithmeticException {
        EvaluationResult result = null;
        if (this.getValueType() != 1) {
            throw new ArithmeticException("can't perform addition using first operand type of " + this.nameForType());
        }
        if (otherResult.getValueType() != 1) {
            throw new ArithmeticException("can't perform addition using second operand type of " + otherResult.nameForType());
        }
        result = new EvaluationResult(this.getAsDouble() + otherResult.getAsDouble());
        return result;
    }

    public void setDoubleValue(double newValue, int newType) {
        this.doubleValue = newValue;
        this.valueType = newType;
    }

    public void setIntValue(int newValue, int newType) {
        this.intValue = newValue;
        this.valueType = newType;
    }

    public void setObjectValue(Object newValue, int newType) {
        this.objectValue = newValue;
        this.valueType = newType;
    }

    public String toString() {
        String result;
        switch (this.valueType) {
            case 0: {
                result = "TYPE_UNASSIGNED";
                break;
            }
            case 1: {
                result = "TYPE_NUMERIC " + Double.toString(this.doubleValue);
                break;
            }
            case 2: {
                result = "TYPE_LITERAL " + (String)this.objectValue;
                break;
            }
            case 3: {
                result = "TYPE_COLOR " + Integer.toString(this.intValue);
                break;
            }
            case 4: {
                result = "TYPE_ENUMERATION " + Integer.toString(this.intValue);
                break;
            }
            case 5: {
                result = "TYPE_KEYWORD " + Integer.toString(this.intValue);
                break;
            }
            case 6: {
                result = "TYPE_NCNAME " + (String)this.objectValue;
                break;
            }
            case 7: {
                result = "TYPE_OTHER_CLASS";
                break;
            }
            default: {
                result = "Unknown";
            }
        }
        return result;
    }
}

