/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.properties.parse;

import com.ibm.xsl.composer.csstypes.CSSLength;
import java.net.URL;

public class SPUtility {
    protected static final String TOP = "top";
    protected static final String CENTER = "center";
    protected static final String BOTTOM = "bottom";
    protected static final String LEFT = "left";
    protected static final String RIGHT = "right";
    protected static final String[] backgroundColorTokens = new String[]{"aqua", "black", "blue", "fushia", "gray", "green", "lime", "maroon", "navy", "olive", "purple", "red", "silver", "teal", "white", "yellow"};
    protected static final String[] backgroundPositionFirstTokens = new String[]{"top", "center", "bottom"};
    protected static final String[] backgroundPositionSecondTokens = new String[]{"left", "center", "right"};
    protected static final String[] backgroundRepeatTokens = new String[]{"repeat", "repeat-x", "repeat-y", "no-repeat"};
    protected static final String[] backgroundAttachmentTokens = new String[]{"scroll", "fixed"};
    protected static final String[] borderStyleTokens = new String[]{"none", "hidden", "dotted", "dashed", "solid", "double", "groove", "ridge", "inset", "outset"};
    protected static final String[] borderWidthTokens = new String[]{"thin", "medium", "thick"};
    protected static final String NORMAL = "normal";
    protected static final String[] fontStyleTokens = new String[]{"normal", "italic", "oblique"};
    protected static final String[] fontVariantTokens = new String[]{"normal", "small-caps"};
    protected static final String[] fontWeightTokens = new String[]{"normal", "bold", "bolder", "lighter", "100", "200", "300", "400", "500", "600", "700", "800", "900"};
    protected static final String[] fontAbsoluteSizeTokens = new String[]{"xx-small", "x-small", "small", "medium", "large", "x-large", "xx-large"};
    protected static final String[] fontRelativeSizeTokens = new String[]{"larger", "smaller"};
    protected static final String[] systemFontTokens = new String[]{"caption", "icon", "menu", "message-box", "small-caption", "status-bar"};
    protected static final String[] fontGenericFamilyTokens = new String[]{"serif", "sans-serif", "cursive", "fantasy", "monospace"};

    public static boolean isAbsoluteSize(String s) {
        return SPUtility.isOnList(s, fontAbsoluteSizeTokens);
    }

    public static boolean isAttachmentToken(String s) {
        return SPUtility.isOnList(s, backgroundAttachmentTokens);
    }

    public static boolean isBorderStyle(String s) {
        return SPUtility.isOnList(s, borderStyleTokens);
    }

    public static boolean isBorderWidth(String s) {
        return SPUtility.isOnList(s = s.toLowerCase(), borderWidthTokens) || CSSLength.isValid(s, 18);
    }

    public static boolean isColor(String s) {
        if (SPUtility.isOnList(s = s.toLowerCase().trim(), backgroundColorTokens)) {
            return true;
        }
        return s.startsWith("#") && (s.length() == 4 || s.length() == 7) && SPUtility.isHexString(s.substring(1));
    }

    public static boolean isFontFamily(String s) {
        return s != null && !s.equals("") && !s.equals("\"") && !SPUtility.trimWhitespace(s).equals("\"\"") && !SPUtility.trimWhitespace(s).equals("\" \"");
    }

    public static boolean isFontGenericFamily(String s) {
        return SPUtility.isOnList(s, fontGenericFamilyTokens);
    }

    public static boolean isFontSize(String s) {
        return SPUtility.isAbsoluteSize(s) || SPUtility.isRelativeSize(s) || CSSLength.isLengthPercent(s);
    }

    public static boolean isFontStyle(String s) {
        return SPUtility.isOnList(s, fontStyleTokens);
    }

    public static boolean isFontVariant(String s) {
        return SPUtility.isOnList(s, fontVariantTokens);
    }

    public static boolean isFontWeight(String s) {
        return SPUtility.isOnList(s, fontWeightTokens);
    }

    public static boolean isHexString(String s) {
        try {
            Long.parseLong(s, 16);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static boolean isInteger(String integer) {
        try {
            Integer.parseInt(integer);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static boolean isLineHeight(String s) {
        return s.toLowerCase().equals(NORMAL) || SPUtility.isPositiveNumber(s) || CSSLength.isLengthPercent(s);
    }

    public static boolean isMarginWidth(String s) {
        return s.toLowerCase().equals("auto") || CSSLength.isLengthPercent(s);
    }

    public static boolean isNegativeInteger(String number) {
        if (SPUtility.isInteger(number)) {
            return Integer.parseInt(number) <= 0;
        }
        return false;
    }

    public static boolean isNumber(String number) {
        try {
            Float.parseFloat(number);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static boolean isOnList(String s, String[] list) {
        int i = 0;
        while (i < list.length) {
            if (s.equals(list[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isPaddingWidth(String s) {
        return CSSLength.isLengthPercent(s);
    }

    public static boolean isPositiveInteger(String number) {
        if (SPUtility.isInteger(number)) {
            return Integer.parseInt(number) >= 0;
        }
        return false;
    }

    public static boolean isPositiveNumber(String s) {
        if (SPUtility.isNumber(s)) {
            return Float.parseFloat(s) >= 0.0f;
        }
        return false;
    }

    public static boolean isRelativeSize(String s) {
        return SPUtility.isOnList(s, fontRelativeSizeTokens);
    }

    public static boolean isRepeatToken(String s) {
        return SPUtility.isOnList(s, backgroundRepeatTokens);
    }

    public static boolean isSystemFont(String s) {
        return SPUtility.isOnList(s, systemFontTokens);
    }

    public static boolean isTCBLRFirstToken(String s) {
        return SPUtility.isOnList(s, backgroundPositionFirstTokens);
    }

    public static boolean isTCBLRSecondToken(String s) {
        return SPUtility.isOnList(s, backgroundPositionSecondTokens);
    }

    public static boolean isUri(String s) {
        try {
            new URL(s);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static String trimWhitespace(String s) {
        s = s.trim();
        int len = s.length();
        StringBuffer sb = new StringBuffer();
        int whiteSpace = 0;
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            whiteSpace = Character.isWhitespace(c) ? ++whiteSpace : 0;
            if (whiteSpace < 2) {
                if (whiteSpace == 1) {
                    c = ' ';
                }
                sb.append(c);
            }
            ++i;
        }
        return new String(sb.toString());
    }
}

