/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.properties.parse;

import com.ibm.xsl.composer.properties.FontProperty;
import com.ibm.xsl.composer.properties.parse.ParseBase;
import com.ibm.xsl.composer.properties.parse.ParseException;
import com.ibm.xsl.composer.properties.parse.SPUtility;
import java.util.StringTokenizer;
import java.util.Vector;

public class SPParseFont
extends ParseBase {
    private FontProperty f;
    protected boolean fontFound = false;

    public SPParseFont() {
        this(null);
    }

    public SPParseFont(FontProperty f) {
        this.f = f;
    }

    public boolean fontFamily(String fontValues) throws ParseException {
        this.setParseString(fontValues);
        this.scanAndTokenize(3);
        return this.fontFamilyService();
    }

    private boolean fontFamilyService() {
        Vector<String> fontSet = new Vector<String>();
        boolean fontFamilyFound = false;
        String s = "";
        while ((s = this.nextToken()) != null) {
            String compressed = SPUtility.trimWhitespace(s);
            if (SPUtility.isFontGenericFamily(compressed)) {
                this.fontFound = true;
                fontSet.add(compressed);
                fontFamilyFound = true;
                continue;
            }
            if (SPUtility.isFontFamily(s)) {
                this.fontFound = true;
                fontSet.add(compressed);
                fontFamilyFound = true;
                continue;
            }
            this.parseError("Illegal Font family name" + s);
        }
        if (!fontFamilyFound) {
            return this.parseError("Font family must be set");
        }
        this.f.setFontFamily(fontSet);
        return fontFamilyFound;
    }

    public boolean spFont(String string) throws ParseException {
        String property = "font";
        if (string.equals("inherit")) {
            this.fontFound = true;
            this.f.setAllPropertiesToInherit();
            return true;
        }
        if (SPUtility.isSystemFont(string)) {
            this.f.setSystemFontFamily(string);
            this.fontFound = true;
            return true;
        }
        this.setParseString(string);
        this.scanAndTokenize(1);
        String s = this.nextToken();
        boolean done = false;
        String fontStyle = null;
        String fontVariant = null;
        String fontWeight = null;
        while (!done && s != null) {
            if (fontStyle == null && SPUtility.isFontStyle(s)) {
                this.fontFound = true;
                fontStyle = s;
                s = this.nextToken();
                continue;
            }
            if (fontVariant == null && SPUtility.isFontVariant(s)) {
                this.fontFound = true;
                fontVariant = s;
                s = this.nextToken();
                continue;
            }
            if (fontWeight == null && SPUtility.isFontWeight(s)) {
                this.fontFound = true;
                fontWeight = s;
                s = this.nextToken();
                continue;
            }
            done = true;
        }
        int count = 0;
        if (fontStyle != null) {
            ++count;
        }
        if (fontVariant != null) {
            ++count;
        }
        if (fontWeight != null) {
            ++count;
        }
        if (count == 0 || count == 1 && (fontStyle != null && fontStyle.equals("normal") || fontVariant != null && fontVariant.equals("normal") || fontWeight != null && fontWeight.equals("normal"))) {
            this.f.setFontStyle("normal");
            this.f.setFontVariant("normal");
            this.f.setFontWeight("normal");
        } else {
            if (fontStyle != null) {
                this.f.setFontStyle(fontStyle);
            }
            if (fontVariant != null) {
                this.f.setFontVariant(fontVariant);
            }
            if (fontWeight != null) {
                this.f.setFontWeight(fontWeight);
            }
        }
        boolean fontSizeFound = false;
        if (s != null) {
            if (s.indexOf("/") >= 0) {
                if (s.endsWith("/")) {
                    s = s.substring(0, s.length() - 1);
                    this.stack.push("/");
                } else {
                    StringTokenizer st = new StringTokenizer(s, "/");
                    s = (String)st.nextElement();
                    this.stack.push("/");
                    this.stack.push((String)st.nextElement());
                }
            }
            if (SPUtility.isFontSize(s)) {
                this.fontFound = true;
                this.f.setFontSize(s);
                fontSizeFound = true;
            }
        }
        if (!fontSizeFound) {
            return this.parseError("font: token:" + s + " Font size must be set");
        }
        s = this.nextToken();
        if (s != null && (s.equals("/") || s.startsWith("/"))) {
            if (s.equals("/")) {
                s = this.nextToken();
                if (s == null) {
                    return this.parseError("missing \"line height\" term after /");
                }
            } else {
                s = s.substring(1);
            }
            if (s != null && SPUtility.isLineHeight(s)) {
                this.fontFound = true;
                s = this.nextToken();
            }
        }
        if (s == null) {
            return this.parseError("Font family must be set");
        }
        String fontValues = "";
        while (s != null) {
            fontValues = String.valueOf(fontValues) + s;
            s = this.nextToken();
        }
        if (!fontValues.equals("")) {
            this.scanAndTokenize(3, fontValues);
            return this.fontFamilyService();
        }
        return this.fontFound;
    }
}

